/*
 * Adyen Checkout API
 * Adyen Checkout API provides a simple and flexible way to initiate and authorise online payments. You can use the same integration for payments made with cards (including 3D Secure), mobile wallets, and local payment methods (for example, iDEAL and Sofort).  This API reference provides information on available endpoints and how to interact with them. To learn more about the API, visit [Checkout documentation](https://docs.adyen.com/online-payments).  ## Authentication Each request to the Checkout API must be signed with an API key. For this, obtain an API Key from your Customer Area, as described in [How to get the API key](https://docs.adyen.com/development-resources/api-credentials#generate-api-key). Then set this key to the `X-API-Key` header value, for example:  ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: Your_Checkout_API_key\" \\ ... ``` Note that when going live, you need to generate a new API Key to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning Checkout API supports versioning of its endpoints through a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://checkout-test.adyen.com/v68/payments ```
 *
 * The version of the OpenAPI document: 68
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;
import static com.adyen.util.Util.toIndentedString;

/**
 * PaymentMethodIssuer
 */
public class PaymentMethodIssuer {
  @SerializedName("disabled")
  private Boolean disabled = false;

  @SerializedName("id")
  private String id;

  @SerializedName("name")
  private String name;


  public PaymentMethodIssuer disabled(Boolean disabled) {

    this.disabled = disabled;
    return this;
  }

   /**
   * A boolean value indicating whether this issuer is unavailable. Can be &#x60;true&#x60; whenever the issuer is offline.
   * @return disabled
  **/
  public Boolean getDisabled() {
    return disabled;
  }


  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }


  public PaymentMethodIssuer id(String id) {

    this.id = id;
    return this;
  }

   /**
   * The unique identifier of this issuer, to submit in requests to /payments.
   * @return id
  **/
  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public PaymentMethodIssuer name(String name) {

    this.name = name;
    return this;
  }

   /**
   * A localized name of the issuer.
   * @return name
  **/
  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethodIssuer paymentMethodIssuer = (PaymentMethodIssuer) o;
    return Objects.equals(this.disabled, paymentMethodIssuer.disabled) &&
        Objects.equals(this.id, paymentMethodIssuer.id) &&
        Objects.equals(this.name, paymentMethodIssuer.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(disabled, id, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethodIssuer {\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
