/*
 *                       ######
 *                       ######
 * ############    ####( ######  #####. ######  ############   ############
 * #############  #####( ######  #####. ######  #############  #############
 *        ######  #####( ######  #####. ######  #####  ######  #####  ######
 * ###### ######  #####( ######  #####. ######  #####  #####   #####  ######
 * ###### ######  #####( ######  #####. ######  #####          #####  ######
 * #############  #############  #############  #############  #####  ######
 *  ############   ############  #############   ############  #####  ######
 *                                      ######
 *                               #############
 *                               ############
 *
 * Adyen Java API Library
 *
 * Copyright (c) 2017 Adyen B.V.
 * This file is open source and available under the MIT license.
 * See the LICENSE file for more info.
 */

package com.adyen.model.marketpay.notification;

import com.adyen.model.marketpay.AccountHolderStatus;
import com.google.gson.annotations.SerializedName;

public class AccountCreatedContent {
    @SerializedName("pspReference")
    private String pspReference;

    @SerializedName("accountHolderCode")
    private String accountHolderCode;

    @SerializedName("accountCode")
    private String accountCode;

    @SerializedName("status")
    private AccountHolderStatus.StatusEnum status;

    public String getPspReference() {
        return pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public String getAccountHolderCode() {
        return accountHolderCode;
    }

    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public AccountHolderStatus.StatusEnum getStatus() {
        return status;
    }

    public void setStatus(AccountHolderStatus.StatusEnum status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "AccountCreatedContent{"
                + "pspReference='"
                + pspReference
                + '\''
                + ", accountHolderCode='"
                + accountHolderCode
                + '\''
                + ", accountCode='"
                + accountCode
                + '\''
                + ", status="
                + status
                + '}';
    }
}
