/*
 *                       ######
 *                       ######
 * ############    ####( ######  #####. ######  ############   ############
 * #############  #####( ######  #####. ######  #############  #############
 *        ######  #####( ######  #####. ######  #####  ######  #####  ######
 * ###### ######  #####( ######  #####. ######  #####  #####   #####  ######
 * ###### ######  #####( ######  #####. ######  #####          #####  ######
 * #############  #############  #############  #############  #####  ######
 *  ############   ############  #############   ############  #####  ######
 *                                      ######
 *                               #############
 *                               ############
 *
 * Adyen Java API Library
 *
 * Copyright (c) 2017 Adyen B.V.
 * This file is open source and available under the MIT license.
 * See the LICENSE file for more info.
 */

package com.adyen.model.marketpay.notification;

import com.adyen.model.marketpay.CreateAccountHolderResponse;
import com.google.gson.annotations.SerializedName;

public class AccountHolderCreatedNotification extends GenericNotification {
    @SerializedName("content")
    private CreateAccountHolderResponse content;

    public CreateAccountHolderResponse getContent() {
        return content;
    }

    public void setContent(CreateAccountHolderResponse content) {
        this.content = content;
    }

    @Override
    public String toString() {
        return "AccountHolderCreatedNotification{" + "content=" + content + '}';
    }
}
