/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.balanceplatform.Amount;
import com.adyen.model.balanceplatform.Fee;
import com.adyen.model.balanceplatform.Repayment;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.balanceplatform.JSON;

/**
 * GrantOffer
 */

public class GrantOffer {
  public static final String SERIALIZED_NAME_ACCOUNT_HOLDER_ID = "accountHolderId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_HOLDER_ID)
  private String accountHolderId;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Amount amount;

  /**
   * The contract type of the grant offer. Possible value: **cashAdvance**, **loan**.
   */
  @JsonAdapter(ContractTypeEnum.Adapter.class)
  public enum ContractTypeEnum {
    CASHADVANCE("cashAdvance"),
    
    LOAN("loan");

    private String value;

    ContractTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ContractTypeEnum fromValue(String value) {
      for (ContractTypeEnum b : ContractTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ContractTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ContractTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ContractTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ContractTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CONTRACT_TYPE = "contractType";
  @SerializedName(SERIALIZED_NAME_CONTRACT_TYPE)
  private ContractTypeEnum contractType;

  public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
  @SerializedName(SERIALIZED_NAME_EXPIRES_AT)
  private Object expiresAt;

  public static final String SERIALIZED_NAME_FEE = "fee";
  @SerializedName(SERIALIZED_NAME_FEE)
  private Fee fee;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_REPAYMENT = "repayment";
  @SerializedName(SERIALIZED_NAME_REPAYMENT)
  private Repayment repayment;

  public static final String SERIALIZED_NAME_STARTS_AT = "startsAt";
  @SerializedName(SERIALIZED_NAME_STARTS_AT)
  private Object startsAt;

  public GrantOffer() { 
  }

  public GrantOffer accountHolderId(String accountHolderId) {
    
    this.accountHolderId = accountHolderId;
    return this;
  }

   /**
   * The identifier of the account holder to which the grant is offered.
   * @return accountHolderId
  **/
  @ApiModelProperty(required = true, value = "The identifier of the account holder to which the grant is offered.")

  public String getAccountHolderId() {
    return accountHolderId;
  }


  public void setAccountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
  }


  public GrantOffer amount(Amount amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(value = "")

  public Amount getAmount() {
    return amount;
  }


  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public GrantOffer contractType(ContractTypeEnum contractType) {
    
    this.contractType = contractType;
    return this;
  }

   /**
   * The contract type of the grant offer. Possible value: **cashAdvance**, **loan**.
   * @return contractType
  **/
  @ApiModelProperty(value = "The contract type of the grant offer. Possible value: **cashAdvance**, **loan**.")

  public ContractTypeEnum getContractType() {
    return contractType;
  }


  public void setContractType(ContractTypeEnum contractType) {
    this.contractType = contractType;
  }


  public GrantOffer expiresAt(Object expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * Get expiresAt
   * @return expiresAt
  **/
  @ApiModelProperty(value = "")

  public Object getExpiresAt() {
    return expiresAt;
  }


  public void setExpiresAt(Object expiresAt) {
    this.expiresAt = expiresAt;
  }


  public GrantOffer fee(Fee fee) {
    
    this.fee = fee;
    return this;
  }

   /**
   * Get fee
   * @return fee
  **/
  @ApiModelProperty(value = "")

  public Fee getFee() {
    return fee;
  }


  public void setFee(Fee fee) {
    this.fee = fee;
  }


  public GrantOffer id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the grant offer.
   * @return id
  **/
  @ApiModelProperty(value = "The unique identifier of the grant offer.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public GrantOffer repayment(Repayment repayment) {
    
    this.repayment = repayment;
    return this;
  }

   /**
   * Get repayment
   * @return repayment
  **/
  @ApiModelProperty(value = "")

  public Repayment getRepayment() {
    return repayment;
  }


  public void setRepayment(Repayment repayment) {
    this.repayment = repayment;
  }


  public GrantOffer startsAt(Object startsAt) {
    
    this.startsAt = startsAt;
    return this;
  }

   /**
   * Get startsAt
   * @return startsAt
  **/
  @ApiModelProperty(value = "")

  public Object getStartsAt() {
    return startsAt;
  }


  public void setStartsAt(Object startsAt) {
    this.startsAt = startsAt;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GrantOffer grantOffer = (GrantOffer) o;
    return Objects.equals(this.accountHolderId, grantOffer.accountHolderId) &&
        Objects.equals(this.amount, grantOffer.amount) &&
        Objects.equals(this.contractType, grantOffer.contractType) &&
        Objects.equals(this.expiresAt, grantOffer.expiresAt) &&
        Objects.equals(this.fee, grantOffer.fee) &&
        Objects.equals(this.id, grantOffer.id) &&
        Objects.equals(this.repayment, grantOffer.repayment) &&
        Objects.equals(this.startsAt, grantOffer.startsAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderId, amount, contractType, expiresAt, fee, id, repayment, startsAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GrantOffer {\n");
    sb.append("    accountHolderId: ").append(toIndentedString(accountHolderId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    contractType: ").append(toIndentedString(contractType)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    repayment: ").append(toIndentedString(repayment)).append("\n");
    sb.append("    startsAt: ").append(toIndentedString(startsAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("accountHolderId");
    openapiFields.add("amount");
    openapiFields.add("contractType");
    openapiFields.add("expiresAt");
    openapiFields.add("fee");
    openapiFields.add("id");
    openapiFields.add("repayment");
    openapiFields.add("startsAt");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("accountHolderId");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(GrantOffer.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to GrantOffer
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (GrantOffer.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in GrantOffer is not found in the empty JSON string", GrantOffer.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!GrantOffer.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `GrantOffer` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : GrantOffer.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field accountHolderId
      if (jsonObj.get("accountHolderId") != null && !jsonObj.get("accountHolderId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `accountHolderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("accountHolderId").toString()));
      }
      // validate the optional field `amount`
      if (jsonObj.getAsJsonObject("amount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("amount"));
      }
      // ensure the field contractType can be parsed to an enum value
      if (jsonObj.get("contractType") != null) {
        if(!jsonObj.get("contractType").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `contractType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("contractType").toString()));
        }
        ContractTypeEnum.fromValue(jsonObj.get("contractType").getAsString());
      }
      // validate the optional field `fee`
      if (jsonObj.getAsJsonObject("fee") != null) {
        Fee.validateJsonObject(jsonObj.getAsJsonObject("fee"));
      }
      // validate the optional field id
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the optional field `repayment`
      if (jsonObj.getAsJsonObject("repayment") != null) {
        Repayment.validateJsonObject(jsonObj.getAsJsonObject("repayment"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!GrantOffer.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'GrantOffer' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<GrantOffer> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(GrantOffer.class));

       return (TypeAdapter<T>) new TypeAdapter<GrantOffer>() {
           @Override
           public void write(JsonWriter out, GrantOffer value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public GrantOffer read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of GrantOffer given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of GrantOffer
  * @throws IOException if the JSON string is invalid with respect to GrantOffer
  */
  public static GrantOffer fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, GrantOffer.class);
  }

 /**
  * Convert an instance of GrantOffer to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

