/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.balanceplatform.PaymentInstrument;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.balanceplatform.JSON;

/**
 * PaginatedPaymentInstrumentsResponse
 */

public class PaginatedPaymentInstrumentsResponse {
  public static final String SERIALIZED_NAME_HAS_NEXT = "hasNext";
  @SerializedName(SERIALIZED_NAME_HAS_NEXT)
  private Boolean hasNext;

  public static final String SERIALIZED_NAME_HAS_PREVIOUS = "hasPrevious";
  @SerializedName(SERIALIZED_NAME_HAS_PREVIOUS)
  private Boolean hasPrevious;

  public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENTS = "paymentInstruments";
  @SerializedName(SERIALIZED_NAME_PAYMENT_INSTRUMENTS)
  private List<PaymentInstrument> paymentInstruments = new ArrayList<>();

  public PaginatedPaymentInstrumentsResponse() { 
  }

  public PaginatedPaymentInstrumentsResponse hasNext(Boolean hasNext) {
    
    this.hasNext = hasNext;
    return this;
  }

   /**
   * Indicates whether there are more items on the next page.
   * @return hasNext
  **/
  @ApiModelProperty(required = true, value = "Indicates whether there are more items on the next page.")

  public Boolean getHasNext() {
    return hasNext;
  }


  public void setHasNext(Boolean hasNext) {
    this.hasNext = hasNext;
  }


  public PaginatedPaymentInstrumentsResponse hasPrevious(Boolean hasPrevious) {
    
    this.hasPrevious = hasPrevious;
    return this;
  }

   /**
   * Indicates whether there are more items on the previous page.
   * @return hasPrevious
  **/
  @ApiModelProperty(required = true, value = "Indicates whether there are more items on the previous page.")

  public Boolean getHasPrevious() {
    return hasPrevious;
  }


  public void setHasPrevious(Boolean hasPrevious) {
    this.hasPrevious = hasPrevious;
  }


  public PaginatedPaymentInstrumentsResponse paymentInstruments(List<PaymentInstrument> paymentInstruments) {
    
    this.paymentInstruments = paymentInstruments;
    return this;
  }

  public PaginatedPaymentInstrumentsResponse addPaymentInstrumentsItem(PaymentInstrument paymentInstrumentsItem) {
    this.paymentInstruments.add(paymentInstrumentsItem);
    return this;
  }

   /**
   * List of payment instruments associated with the balance account.
   * @return paymentInstruments
  **/
  @ApiModelProperty(required = true, value = "List of payment instruments associated with the balance account.")

  public List<PaymentInstrument> getPaymentInstruments() {
    return paymentInstruments;
  }


  public void setPaymentInstruments(List<PaymentInstrument> paymentInstruments) {
    this.paymentInstruments = paymentInstruments;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaginatedPaymentInstrumentsResponse paginatedPaymentInstrumentsResponse = (PaginatedPaymentInstrumentsResponse) o;
    return Objects.equals(this.hasNext, paginatedPaymentInstrumentsResponse.hasNext) &&
        Objects.equals(this.hasPrevious, paginatedPaymentInstrumentsResponse.hasPrevious) &&
        Objects.equals(this.paymentInstruments, paginatedPaymentInstrumentsResponse.paymentInstruments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hasNext, hasPrevious, paymentInstruments);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaginatedPaymentInstrumentsResponse {\n");
    sb.append("    hasNext: ").append(toIndentedString(hasNext)).append("\n");
    sb.append("    hasPrevious: ").append(toIndentedString(hasPrevious)).append("\n");
    sb.append("    paymentInstruments: ").append(toIndentedString(paymentInstruments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("hasNext");
    openapiFields.add("hasPrevious");
    openapiFields.add("paymentInstruments");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("hasNext");
    openapiRequiredFields.add("hasPrevious");
    openapiRequiredFields.add("paymentInstruments");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(PaginatedPaymentInstrumentsResponse.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PaginatedPaymentInstrumentsResponse
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (PaginatedPaymentInstrumentsResponse.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PaginatedPaymentInstrumentsResponse is not found in the empty JSON string", PaginatedPaymentInstrumentsResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!PaginatedPaymentInstrumentsResponse.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PaginatedPaymentInstrumentsResponse` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : PaginatedPaymentInstrumentsResponse.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      JsonArray jsonArraypaymentInstruments = jsonObj.getAsJsonArray("paymentInstruments");
      if (jsonArraypaymentInstruments != null) {
        // ensure the json data is an array
        if (!jsonObj.get("paymentInstruments").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `paymentInstruments` to be an array in the JSON string but got `%s`", jsonObj.get("paymentInstruments").toString()));
        }

        // validate the optional field `paymentInstruments` (array)
        for (int i = 0; i < jsonArraypaymentInstruments.size(); i++) {
          PaymentInstrument.validateJsonObject(jsonArraypaymentInstruments.get(i).getAsJsonObject());
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PaginatedPaymentInstrumentsResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PaginatedPaymentInstrumentsResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PaginatedPaymentInstrumentsResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PaginatedPaymentInstrumentsResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<PaginatedPaymentInstrumentsResponse>() {
           @Override
           public void write(JsonWriter out, PaginatedPaymentInstrumentsResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PaginatedPaymentInstrumentsResponse read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PaginatedPaymentInstrumentsResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PaginatedPaymentInstrumentsResponse
  * @throws IOException if the JSON string is invalid with respect to PaginatedPaymentInstrumentsResponse
  */
  public static PaginatedPaymentInstrumentsResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PaginatedPaymentInstrumentsResponse.class);
  }

 /**
  * Convert an instance of PaginatedPaymentInstrumentsResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

