/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.balanceplatform.Duration;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.balanceplatform.JSON;

/**
 * TransactionRuleInterval
 */

public class TransactionRuleInterval {
  public static final String SERIALIZED_NAME_DAY_OF_MONTH = "dayOfMonth";
  @SerializedName(SERIALIZED_NAME_DAY_OF_MONTH)
  private Integer dayOfMonth;

  /**
   * The day of week, used when the &#x60;duration.unit&#x60; is **weeks**. If not provided, by default, this is set to **monday**.  Possible values: **sunday**, **monday**, **tuesday**, **wednesday**, **thursday**, **friday**.
   */
  @JsonAdapter(DayOfWeekEnum.Adapter.class)
  public enum DayOfWeekEnum {
    FRIDAY("friday"),
    
    MONDAY("monday"),
    
    SATURDAY("saturday"),
    
    SUNDAY("sunday"),
    
    THURSDAY("thursday"),
    
    TUESDAY("tuesday"),
    
    WEDNESDAY("wednesday");

    private String value;

    DayOfWeekEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DayOfWeekEnum fromValue(String value) {
      for (DayOfWeekEnum b : DayOfWeekEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DayOfWeekEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DayOfWeekEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DayOfWeekEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DayOfWeekEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DAY_OF_WEEK = "dayOfWeek";
  @SerializedName(SERIALIZED_NAME_DAY_OF_WEEK)
  private DayOfWeekEnum dayOfWeek;

  public static final String SERIALIZED_NAME_DURATION = "duration";
  @SerializedName(SERIALIZED_NAME_DURATION)
  private Duration duration;

  public static final String SERIALIZED_NAME_TIME_OF_DAY = "timeOfDay";
  @SerializedName(SERIALIZED_NAME_TIME_OF_DAY)
  private String timeOfDay;

  public static final String SERIALIZED_NAME_TIME_ZONE = "timeZone";
  @SerializedName(SERIALIZED_NAME_TIME_ZONE)
  private String timeZone;

  /**
   * The [type of interval](https://docs.adyen.com/issuing/transaction-rules#time-intervals) during which the rule conditions and limits apply, and how often counters are reset.  Possible values:   * **perTransaction**: conditions are evaluated and the counters are reset for every transaction.  * **daily**: the counters are reset daily at 00:00:00 UTC.  * **weekly**: the counters are reset every Monday at 00:00:00 UTC.   * **monthly**: the counters reset every first day of the month at 00:00:00 UTC.   * **lifetime**: conditions are applied to the lifetime of the payment instrument.  * **rolling**: conditions are applied and the counters are reset based on a &#x60;duration&#x60;. If the reset date and time are not provided, Adyen applies the default reset time similar to fixed intervals. For example, if the duration is every two weeks, the counter resets every third Monday at 00:00:00 UTC.  * **sliding**: conditions are applied and the counters are reset based on the current time and a &#x60;duration&#x60; that you specify.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    DAILY("daily"),
    
    LIFETIME("lifetime"),
    
    MONTHLY("monthly"),
    
    PERTRANSACTION("perTransaction"),
    
    ROLLING("rolling"),
    
    SLIDING("sliding"),
    
    WEEKLY("weekly");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public TransactionRuleInterval() { 
  }

  public TransactionRuleInterval dayOfMonth(Integer dayOfMonth) {
    
    this.dayOfMonth = dayOfMonth;
    return this;
  }

   /**
   * The day of month, used when the &#x60;duration.unit&#x60; is **months**. If not provided, by default, this is set to **1**, the first day of the month.
   * @return dayOfMonth
  **/
  @ApiModelProperty(value = "The day of month, used when the `duration.unit` is **months**. If not provided, by default, this is set to **1**, the first day of the month.")

  public Integer getDayOfMonth() {
    return dayOfMonth;
  }


  public void setDayOfMonth(Integer dayOfMonth) {
    this.dayOfMonth = dayOfMonth;
  }


  public TransactionRuleInterval dayOfWeek(DayOfWeekEnum dayOfWeek) {
    
    this.dayOfWeek = dayOfWeek;
    return this;
  }

   /**
   * The day of week, used when the &#x60;duration.unit&#x60; is **weeks**. If not provided, by default, this is set to **monday**.  Possible values: **sunday**, **monday**, **tuesday**, **wednesday**, **thursday**, **friday**.
   * @return dayOfWeek
  **/
  @ApiModelProperty(value = "The day of week, used when the `duration.unit` is **weeks**. If not provided, by default, this is set to **monday**.  Possible values: **sunday**, **monday**, **tuesday**, **wednesday**, **thursday**, **friday**.")

  public DayOfWeekEnum getDayOfWeek() {
    return dayOfWeek;
  }


  public void setDayOfWeek(DayOfWeekEnum dayOfWeek) {
    this.dayOfWeek = dayOfWeek;
  }


  public TransactionRuleInterval duration(Duration duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * Get duration
   * @return duration
  **/
  @ApiModelProperty(value = "")

  public Duration getDuration() {
    return duration;
  }


  public void setDuration(Duration duration) {
    this.duration = duration;
  }


  public TransactionRuleInterval timeOfDay(String timeOfDay) {
    
    this.timeOfDay = timeOfDay;
    return this;
  }

   /**
   * The time of day, in **hh:mm:ss** format, used when the &#x60;duration.unit&#x60; is **hours**. If not provided, by default, this is set to **00:00:00**.
   * @return timeOfDay
  **/
  @ApiModelProperty(value = "The time of day, in **hh:mm:ss** format, used when the `duration.unit` is **hours**. If not provided, by default, this is set to **00:00:00**.")

  public String getTimeOfDay() {
    return timeOfDay;
  }


  public void setTimeOfDay(String timeOfDay) {
    this.timeOfDay = timeOfDay;
  }


  public TransactionRuleInterval timeZone(String timeZone) {
    
    this.timeZone = timeZone;
    return this;
  }

   /**
   * The [time zone](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For example, **Europe/Amsterdam**. By default, this is set to **UTC**.
   * @return timeZone
  **/
  @ApiModelProperty(value = "The [time zone](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For example, **Europe/Amsterdam**. By default, this is set to **UTC**.")

  public String getTimeZone() {
    return timeZone;
  }


  public void setTimeZone(String timeZone) {
    this.timeZone = timeZone;
  }


  public TransactionRuleInterval type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The [type of interval](https://docs.adyen.com/issuing/transaction-rules#time-intervals) during which the rule conditions and limits apply, and how often counters are reset.  Possible values:   * **perTransaction**: conditions are evaluated and the counters are reset for every transaction.  * **daily**: the counters are reset daily at 00:00:00 UTC.  * **weekly**: the counters are reset every Monday at 00:00:00 UTC.   * **monthly**: the counters reset every first day of the month at 00:00:00 UTC.   * **lifetime**: conditions are applied to the lifetime of the payment instrument.  * **rolling**: conditions are applied and the counters are reset based on a &#x60;duration&#x60;. If the reset date and time are not provided, Adyen applies the default reset time similar to fixed intervals. For example, if the duration is every two weeks, the counter resets every third Monday at 00:00:00 UTC.  * **sliding**: conditions are applied and the counters are reset based on the current time and a &#x60;duration&#x60; that you specify.
   * @return type
  **/
  @ApiModelProperty(required = true, value = "The [type of interval](https://docs.adyen.com/issuing/transaction-rules#time-intervals) during which the rule conditions and limits apply, and how often counters are reset.  Possible values:   * **perTransaction**: conditions are evaluated and the counters are reset for every transaction.  * **daily**: the counters are reset daily at 00:00:00 UTC.  * **weekly**: the counters are reset every Monday at 00:00:00 UTC.   * **monthly**: the counters reset every first day of the month at 00:00:00 UTC.   * **lifetime**: conditions are applied to the lifetime of the payment instrument.  * **rolling**: conditions are applied and the counters are reset based on a `duration`. If the reset date and time are not provided, Adyen applies the default reset time similar to fixed intervals. For example, if the duration is every two weeks, the counter resets every third Monday at 00:00:00 UTC.  * **sliding**: conditions are applied and the counters are reset based on the current time and a `duration` that you specify.")

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransactionRuleInterval transactionRuleInterval = (TransactionRuleInterval) o;
    return Objects.equals(this.dayOfMonth, transactionRuleInterval.dayOfMonth) &&
        Objects.equals(this.dayOfWeek, transactionRuleInterval.dayOfWeek) &&
        Objects.equals(this.duration, transactionRuleInterval.duration) &&
        Objects.equals(this.timeOfDay, transactionRuleInterval.timeOfDay) &&
        Objects.equals(this.timeZone, transactionRuleInterval.timeZone) &&
        Objects.equals(this.type, transactionRuleInterval.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dayOfMonth, dayOfWeek, duration, timeOfDay, timeZone, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionRuleInterval {\n");
    sb.append("    dayOfMonth: ").append(toIndentedString(dayOfMonth)).append("\n");
    sb.append("    dayOfWeek: ").append(toIndentedString(dayOfWeek)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    timeOfDay: ").append(toIndentedString(timeOfDay)).append("\n");
    sb.append("    timeZone: ").append(toIndentedString(timeZone)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("dayOfMonth");
    openapiFields.add("dayOfWeek");
    openapiFields.add("duration");
    openapiFields.add("timeOfDay");
    openapiFields.add("timeZone");
    openapiFields.add("type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("type");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(TransactionRuleInterval.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TransactionRuleInterval
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TransactionRuleInterval.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TransactionRuleInterval is not found in the empty JSON string", TransactionRuleInterval.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!TransactionRuleInterval.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TransactionRuleInterval` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : TransactionRuleInterval.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // ensure the field dayOfWeek can be parsed to an enum value
      if (jsonObj.get("dayOfWeek") != null) {
        if(!jsonObj.get("dayOfWeek").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `dayOfWeek` to be a primitive type in the JSON string but got `%s`", jsonObj.get("dayOfWeek").toString()));
        }
        DayOfWeekEnum.fromValue(jsonObj.get("dayOfWeek").getAsString());
      }
      // validate the optional field `duration`
      if (jsonObj.getAsJsonObject("duration") != null) {
        Duration.validateJsonObject(jsonObj.getAsJsonObject("duration"));
      }
      // validate the optional field timeOfDay
      if (jsonObj.get("timeOfDay") != null && !jsonObj.get("timeOfDay").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `timeOfDay` to be a primitive type in the JSON string but got `%s`", jsonObj.get("timeOfDay").toString()));
      }
      // validate the optional field timeZone
      if (jsonObj.get("timeZone") != null && !jsonObj.get("timeZone").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `timeZone` to be a primitive type in the JSON string but got `%s`", jsonObj.get("timeZone").toString()));
      }
      // ensure the field type can be parsed to an enum value
      if (jsonObj.get("type") != null) {
        if(!jsonObj.get("type").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
        }
        TypeEnum.fromValue(jsonObj.get("type").getAsString());
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TransactionRuleInterval.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TransactionRuleInterval' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TransactionRuleInterval> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TransactionRuleInterval.class));

       return (TypeAdapter<T>) new TypeAdapter<TransactionRuleInterval>() {
           @Override
           public void write(JsonWriter out, TransactionRuleInterval value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TransactionRuleInterval read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TransactionRuleInterval given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TransactionRuleInterval
  * @throws IOException if the JSON string is invalid with respect to TransactionRuleInterval
  */
  public static TransactionRuleInterval fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TransactionRuleInterval.class);
  }

 /**
  * Convert an instance of TransactionRuleInterval to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

