/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * AdditionalDataCarRental
 */

public class AdditionalDataCarRental {
  public static final String SERIALIZED_NAME_CAR_RENTAL_CHECK_OUT_DATE = "carRental.checkOutDate";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_CHECK_OUT_DATE)
  private String carRentalCheckOutDate;

  public static final String SERIALIZED_NAME_CAR_RENTAL_CUSTOMER_SERVICE_TOLL_FREE_NUMBER = "carRental.customerServiceTollFreeNumber";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_CUSTOMER_SERVICE_TOLL_FREE_NUMBER)
  private String carRentalCustomerServiceTollFreeNumber;

  public static final String SERIALIZED_NAME_CAR_RENTAL_DAYS_RENTED = "carRental.daysRented";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_DAYS_RENTED)
  private String carRentalDaysRented;

  public static final String SERIALIZED_NAME_CAR_RENTAL_FUEL_CHARGES = "carRental.fuelCharges";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_FUEL_CHARGES)
  private String carRentalFuelCharges;

  public static final String SERIALIZED_NAME_CAR_RENTAL_INSURANCE_CHARGES = "carRental.insuranceCharges";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_INSURANCE_CHARGES)
  private String carRentalInsuranceCharges;

  public static final String SERIALIZED_NAME_CAR_RENTAL_LOCATION_CITY = "carRental.locationCity";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_LOCATION_CITY)
  private String carRentalLocationCity;

  public static final String SERIALIZED_NAME_CAR_RENTAL_LOCATION_COUNTRY = "carRental.locationCountry";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_LOCATION_COUNTRY)
  private String carRentalLocationCountry;

  public static final String SERIALIZED_NAME_CAR_RENTAL_LOCATION_STATE_PROVINCE = "carRental.locationStateProvince";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_LOCATION_STATE_PROVINCE)
  private String carRentalLocationStateProvince;

  public static final String SERIALIZED_NAME_CAR_RENTAL_NO_SHOW_INDICATOR = "carRental.noShowIndicator";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_NO_SHOW_INDICATOR)
  private String carRentalNoShowIndicator;

  public static final String SERIALIZED_NAME_CAR_RENTAL_ONE_WAY_DROP_OFF_CHARGES = "carRental.oneWayDropOffCharges";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_ONE_WAY_DROP_OFF_CHARGES)
  private String carRentalOneWayDropOffCharges;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RATE = "carRental.rate";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RATE)
  private String carRentalRate;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RATE_INDICATOR = "carRental.rateIndicator";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RATE_INDICATOR)
  private String carRentalRateIndicator;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RENTAL_AGREEMENT_NUMBER = "carRental.rentalAgreementNumber";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RENTAL_AGREEMENT_NUMBER)
  private String carRentalRentalAgreementNumber;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RENTAL_CLASS_ID = "carRental.rentalClassId";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RENTAL_CLASS_ID)
  private String carRentalRentalClassId;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RENTER_NAME = "carRental.renterName";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RENTER_NAME)
  private String carRentalRenterName;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RETURN_CITY = "carRental.returnCity";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RETURN_CITY)
  private String carRentalReturnCity;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RETURN_COUNTRY = "carRental.returnCountry";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RETURN_COUNTRY)
  private String carRentalReturnCountry;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RETURN_DATE = "carRental.returnDate";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RETURN_DATE)
  private String carRentalReturnDate;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RETURN_LOCATION_ID = "carRental.returnLocationId";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RETURN_LOCATION_ID)
  private String carRentalReturnLocationId;

  public static final String SERIALIZED_NAME_CAR_RENTAL_RETURN_STATE_PROVINCE = "carRental.returnStateProvince";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_RETURN_STATE_PROVINCE)
  private String carRentalReturnStateProvince;

  public static final String SERIALIZED_NAME_CAR_RENTAL_TAX_EXEMPT_INDICATOR = "carRental.taxExemptIndicator";
  @SerializedName(SERIALIZED_NAME_CAR_RENTAL_TAX_EXEMPT_INDICATOR)
  private String carRentalTaxExemptIndicator;

  public static final String SERIALIZED_NAME_TRAVEL_ENTERTAINMENT_AUTH_DATA_DURATION = "travelEntertainmentAuthData.duration";
  @SerializedName(SERIALIZED_NAME_TRAVEL_ENTERTAINMENT_AUTH_DATA_DURATION)
  private String travelEntertainmentAuthDataDuration;

  public static final String SERIALIZED_NAME_TRAVEL_ENTERTAINMENT_AUTH_DATA_MARKET = "travelEntertainmentAuthData.market";
  @SerializedName(SERIALIZED_NAME_TRAVEL_ENTERTAINMENT_AUTH_DATA_MARKET)
  private String travelEntertainmentAuthDataMarket;

  public AdditionalDataCarRental() { 
  }

  public AdditionalDataCarRental carRentalCheckOutDate(String carRentalCheckOutDate) {
    
    this.carRentalCheckOutDate = carRentalCheckOutDate;
    return this;
  }

   /**
   * The pick-up date. * Date format: &#x60;yyyyMMdd&#x60;
   * @return carRentalCheckOutDate
  **/
  @ApiModelProperty(value = "The pick-up date. * Date format: `yyyyMMdd`")

  public String getCarRentalCheckOutDate() {
    return carRentalCheckOutDate;
  }


  public void setCarRentalCheckOutDate(String carRentalCheckOutDate) {
    this.carRentalCheckOutDate = carRentalCheckOutDate;
  }


  public AdditionalDataCarRental carRentalCustomerServiceTollFreeNumber(String carRentalCustomerServiceTollFreeNumber) {
    
    this.carRentalCustomerServiceTollFreeNumber = carRentalCustomerServiceTollFreeNumber;
    return this;
  }

   /**
   * The customer service phone number of the car rental company. * Format: Alphanumeric * maxLength: 17 * For US and CA numbers must be 10 characters in length * Must not start with a space * Must not be all zeros * Must not contain any special characters such as + or -
   * @return carRentalCustomerServiceTollFreeNumber
  **/
  @ApiModelProperty(value = "The customer service phone number of the car rental company. * Format: Alphanumeric * maxLength: 17 * For US and CA numbers must be 10 characters in length * Must not start with a space * Must not be all zeros * Must not contain any special characters such as + or -")

  public String getCarRentalCustomerServiceTollFreeNumber() {
    return carRentalCustomerServiceTollFreeNumber;
  }


  public void setCarRentalCustomerServiceTollFreeNumber(String carRentalCustomerServiceTollFreeNumber) {
    this.carRentalCustomerServiceTollFreeNumber = carRentalCustomerServiceTollFreeNumber;
  }


  public AdditionalDataCarRental carRentalDaysRented(String carRentalDaysRented) {
    
    this.carRentalDaysRented = carRentalDaysRented;
    return this;
  }

   /**
   * Number of days for which the car is being rented. * Format: Numeric * maxLength: 2 * Must not be all spaces
   * @return carRentalDaysRented
  **/
  @ApiModelProperty(value = "Number of days for which the car is being rented. * Format: Numeric * maxLength: 2 * Must not be all spaces")

  public String getCarRentalDaysRented() {
    return carRentalDaysRented;
  }


  public void setCarRentalDaysRented(String carRentalDaysRented) {
    this.carRentalDaysRented = carRentalDaysRented;
  }


  public AdditionalDataCarRental carRentalFuelCharges(String carRentalFuelCharges) {
    
    this.carRentalFuelCharges = carRentalFuelCharges;
    return this;
  }

   /**
   * Any fuel charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12
   * @return carRentalFuelCharges
  **/
  @ApiModelProperty(value = "Any fuel charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12")

  public String getCarRentalFuelCharges() {
    return carRentalFuelCharges;
  }


  public void setCarRentalFuelCharges(String carRentalFuelCharges) {
    this.carRentalFuelCharges = carRentalFuelCharges;
  }


  public AdditionalDataCarRental carRentalInsuranceCharges(String carRentalInsuranceCharges) {
    
    this.carRentalInsuranceCharges = carRentalInsuranceCharges;
    return this;
  }

   /**
   * Any insurance charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12 * Must not be all spaces * Must not be all zeros
   * @return carRentalInsuranceCharges
  **/
  @ApiModelProperty(value = "Any insurance charges associated with the rental, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Numeric * maxLength: 12 * Must not be all spaces * Must not be all zeros")

  public String getCarRentalInsuranceCharges() {
    return carRentalInsuranceCharges;
  }


  public void setCarRentalInsuranceCharges(String carRentalInsuranceCharges) {
    this.carRentalInsuranceCharges = carRentalInsuranceCharges;
  }


  public AdditionalDataCarRental carRentalLocationCity(String carRentalLocationCity) {
    
    this.carRentalLocationCity = carRentalLocationCity;
    return this;
  }

   /**
   * The city where the car is rented. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces * Must not be all zeros
   * @return carRentalLocationCity
  **/
  @ApiModelProperty(value = "The city where the car is rented. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces * Must not be all zeros")

  public String getCarRentalLocationCity() {
    return carRentalLocationCity;
  }


  public void setCarRentalLocationCity(String carRentalLocationCity) {
    this.carRentalLocationCity = carRentalLocationCity;
  }


  public AdditionalDataCarRental carRentalLocationCountry(String carRentalLocationCountry) {
    
    this.carRentalLocationCountry = carRentalLocationCountry;
    return this;
  }

   /**
   * The country where the car is rented, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2
   * @return carRentalLocationCountry
  **/
  @ApiModelProperty(value = "The country where the car is rented, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2")

  public String getCarRentalLocationCountry() {
    return carRentalLocationCountry;
  }


  public void setCarRentalLocationCountry(String carRentalLocationCountry) {
    this.carRentalLocationCountry = carRentalLocationCountry;
  }


  public AdditionalDataCarRental carRentalLocationStateProvince(String carRentalLocationStateProvince) {
    
    this.carRentalLocationStateProvince = carRentalLocationStateProvince;
    return this;
  }

   /**
   * The state or province where the car is rented. * Format: Alphanumeric * maxLength: 2 * Must not start with a space or be all spaces * Must not be all zeros
   * @return carRentalLocationStateProvince
  **/
  @ApiModelProperty(value = "The state or province where the car is rented. * Format: Alphanumeric * maxLength: 2 * Must not start with a space or be all spaces * Must not be all zeros")

  public String getCarRentalLocationStateProvince() {
    return carRentalLocationStateProvince;
  }


  public void setCarRentalLocationStateProvince(String carRentalLocationStateProvince) {
    this.carRentalLocationStateProvince = carRentalLocationStateProvince;
  }


  public AdditionalDataCarRental carRentalNoShowIndicator(String carRentalNoShowIndicator) {
    
    this.carRentalNoShowIndicator = carRentalNoShowIndicator;
    return this;
  }

   /**
   * Indicates if the customer didn&#39;t pick up their rental car. * Y - Customer did not pick up their car * N - Not applicable
   * @return carRentalNoShowIndicator
  **/
  @ApiModelProperty(value = "Indicates if the customer didn't pick up their rental car. * Y - Customer did not pick up their car * N - Not applicable")

  public String getCarRentalNoShowIndicator() {
    return carRentalNoShowIndicator;
  }


  public void setCarRentalNoShowIndicator(String carRentalNoShowIndicator) {
    this.carRentalNoShowIndicator = carRentalNoShowIndicator;
  }


  public AdditionalDataCarRental carRentalOneWayDropOffCharges(String carRentalOneWayDropOffCharges) {
    
    this.carRentalOneWayDropOffCharges = carRentalOneWayDropOffCharges;
    return this;
  }

   /**
   * The charge for not returning a car to the original rental location, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * maxLength: 12
   * @return carRentalOneWayDropOffCharges
  **/
  @ApiModelProperty(value = "The charge for not returning a car to the original rental location, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * maxLength: 12")

  public String getCarRentalOneWayDropOffCharges() {
    return carRentalOneWayDropOffCharges;
  }


  public void setCarRentalOneWayDropOffCharges(String carRentalOneWayDropOffCharges) {
    this.carRentalOneWayDropOffCharges = carRentalOneWayDropOffCharges;
  }


  public AdditionalDataCarRental carRentalRate(String carRentalRate) {
    
    this.carRentalRate = carRentalRate;
    return this;
  }

   /**
   * The daily rental rate, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Alphanumeric * maxLength: 12
   * @return carRentalRate
  **/
  @ApiModelProperty(value = "The daily rental rate, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Format: Alphanumeric * maxLength: 12")

  public String getCarRentalRate() {
    return carRentalRate;
  }


  public void setCarRentalRate(String carRentalRate) {
    this.carRentalRate = carRentalRate;
  }


  public AdditionalDataCarRental carRentalRateIndicator(String carRentalRateIndicator) {
    
    this.carRentalRateIndicator = carRentalRateIndicator;
    return this;
  }

   /**
   * Specifies whether the given rate is applied daily or weekly. * D - Daily rate * W - Weekly rate
   * @return carRentalRateIndicator
  **/
  @ApiModelProperty(value = "Specifies whether the given rate is applied daily or weekly. * D - Daily rate * W - Weekly rate")

  public String getCarRentalRateIndicator() {
    return carRentalRateIndicator;
  }


  public void setCarRentalRateIndicator(String carRentalRateIndicator) {
    this.carRentalRateIndicator = carRentalRateIndicator;
  }


  public AdditionalDataCarRental carRentalRentalAgreementNumber(String carRentalRentalAgreementNumber) {
    
    this.carRentalRentalAgreementNumber = carRentalRentalAgreementNumber;
    return this;
  }

   /**
   * The rental agreement number for the car rental. * Format: Alphanumeric * maxLength: 9 * Must not start with a space or be all spaces * Must not be all zeros
   * @return carRentalRentalAgreementNumber
  **/
  @ApiModelProperty(value = "The rental agreement number for the car rental. * Format: Alphanumeric * maxLength: 9 * Must not start with a space or be all spaces * Must not be all zeros")

  public String getCarRentalRentalAgreementNumber() {
    return carRentalRentalAgreementNumber;
  }


  public void setCarRentalRentalAgreementNumber(String carRentalRentalAgreementNumber) {
    this.carRentalRentalAgreementNumber = carRentalRentalAgreementNumber;
  }


  public AdditionalDataCarRental carRentalRentalClassId(String carRentalRentalClassId) {
    
    this.carRentalRentalClassId = carRentalRentalClassId;
    return this;
  }

   /**
   * The classification of the rental car. * Format: Alphanumeric * maxLength: 4 * Must not start with a space or be all spaces * Must not be all zeros
   * @return carRentalRentalClassId
  **/
  @ApiModelProperty(value = "The classification of the rental car. * Format: Alphanumeric * maxLength: 4 * Must not start with a space or be all spaces * Must not be all zeros")

  public String getCarRentalRentalClassId() {
    return carRentalRentalClassId;
  }


  public void setCarRentalRentalClassId(String carRentalRentalClassId) {
    this.carRentalRentalClassId = carRentalRentalClassId;
  }


  public AdditionalDataCarRental carRentalRenterName(String carRentalRenterName) {
    
    this.carRentalRenterName = carRentalRenterName;
    return this;
  }

   /**
   * The name of the person renting the car. * Format: Alphanumeric * maxLength: 26 * If you send more than 26 characters, the name is truncated * Must not start with a space or be all spaces * Must not be all zeros
   * @return carRentalRenterName
  **/
  @ApiModelProperty(value = "The name of the person renting the car. * Format: Alphanumeric * maxLength: 26 * If you send more than 26 characters, the name is truncated * Must not start with a space or be all spaces * Must not be all zeros")

  public String getCarRentalRenterName() {
    return carRentalRenterName;
  }


  public void setCarRentalRenterName(String carRentalRenterName) {
    this.carRentalRenterName = carRentalRenterName;
  }


  public AdditionalDataCarRental carRentalReturnCity(String carRentalReturnCity) {
    
    this.carRentalReturnCity = carRentalReturnCity;
    return this;
  }

   /**
   * The city where the car must be returned. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces * Must not be all zeros
   * @return carRentalReturnCity
  **/
  @ApiModelProperty(value = "The city where the car must be returned. * Format: Alphanumeric * maxLength: 18 * Must not start with a space or be all spaces * Must not be all zeros")

  public String getCarRentalReturnCity() {
    return carRentalReturnCity;
  }


  public void setCarRentalReturnCity(String carRentalReturnCity) {
    this.carRentalReturnCity = carRentalReturnCity;
  }


  public AdditionalDataCarRental carRentalReturnCountry(String carRentalReturnCountry) {
    
    this.carRentalReturnCountry = carRentalReturnCountry;
    return this;
  }

   /**
   * The country where the car must be returned, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2
   * @return carRentalReturnCountry
  **/
  @ApiModelProperty(value = "The country where the car must be returned, in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. * Format: Alphanumeric * maxLength: 2")

  public String getCarRentalReturnCountry() {
    return carRentalReturnCountry;
  }


  public void setCarRentalReturnCountry(String carRentalReturnCountry) {
    this.carRentalReturnCountry = carRentalReturnCountry;
  }


  public AdditionalDataCarRental carRentalReturnDate(String carRentalReturnDate) {
    
    this.carRentalReturnDate = carRentalReturnDate;
    return this;
  }

   /**
   * The last date to return the car by. * Date format: &#x60;yyyyMMdd&#x60; * maxLength: 8
   * @return carRentalReturnDate
  **/
  @ApiModelProperty(value = "The last date to return the car by. * Date format: `yyyyMMdd` * maxLength: 8")

  public String getCarRentalReturnDate() {
    return carRentalReturnDate;
  }


  public void setCarRentalReturnDate(String carRentalReturnDate) {
    this.carRentalReturnDate = carRentalReturnDate;
  }


  public AdditionalDataCarRental carRentalReturnLocationId(String carRentalReturnLocationId) {
    
    this.carRentalReturnLocationId = carRentalReturnLocationId;
    return this;
  }

   /**
   * The agency code, phone number, or address abbreviation * Format: Alphanumeric * maxLength: 10 * Must not start with a space or be all spaces * Must not be all zeros
   * @return carRentalReturnLocationId
  **/
  @ApiModelProperty(value = "The agency code, phone number, or address abbreviation * Format: Alphanumeric * maxLength: 10 * Must not start with a space or be all spaces * Must not be all zeros")

  public String getCarRentalReturnLocationId() {
    return carRentalReturnLocationId;
  }


  public void setCarRentalReturnLocationId(String carRentalReturnLocationId) {
    this.carRentalReturnLocationId = carRentalReturnLocationId;
  }


  public AdditionalDataCarRental carRentalReturnStateProvince(String carRentalReturnStateProvince) {
    
    this.carRentalReturnStateProvince = carRentalReturnStateProvince;
    return this;
  }

   /**
   * The state or province where the car must be returned. * Format: Alphanumeric * maxLength: 3 * Must not start with a space or be all spaces * Must not be all zeros
   * @return carRentalReturnStateProvince
  **/
  @ApiModelProperty(value = "The state or province where the car must be returned. * Format: Alphanumeric * maxLength: 3 * Must not start with a space or be all spaces * Must not be all zeros")

  public String getCarRentalReturnStateProvince() {
    return carRentalReturnStateProvince;
  }


  public void setCarRentalReturnStateProvince(String carRentalReturnStateProvince) {
    this.carRentalReturnStateProvince = carRentalReturnStateProvince;
  }


  public AdditionalDataCarRental carRentalTaxExemptIndicator(String carRentalTaxExemptIndicator) {
    
    this.carRentalTaxExemptIndicator = carRentalTaxExemptIndicator;
    return this;
  }

   /**
   * Indicates if the goods or services were tax-exempt, or if tax was not paid on them.  Values: * Y - Goods or services were tax exempt * N - Tax was not collected
   * @return carRentalTaxExemptIndicator
  **/
  @ApiModelProperty(value = "Indicates if the goods or services were tax-exempt, or if tax was not paid on them.  Values: * Y - Goods or services were tax exempt * N - Tax was not collected")

  public String getCarRentalTaxExemptIndicator() {
    return carRentalTaxExemptIndicator;
  }


  public void setCarRentalTaxExemptIndicator(String carRentalTaxExemptIndicator) {
    this.carRentalTaxExemptIndicator = carRentalTaxExemptIndicator;
  }


  public AdditionalDataCarRental travelEntertainmentAuthDataDuration(String travelEntertainmentAuthDataDuration) {
    
    this.travelEntertainmentAuthDataDuration = travelEntertainmentAuthDataDuration;
    return this;
  }

   /**
   * Number of days the car is rented for. This should be included in the auth message. * Format: Numeric * maxLength: 2
   * @return travelEntertainmentAuthDataDuration
  **/
  @ApiModelProperty(value = "Number of days the car is rented for. This should be included in the auth message. * Format: Numeric * maxLength: 2")

  public String getTravelEntertainmentAuthDataDuration() {
    return travelEntertainmentAuthDataDuration;
  }


  public void setTravelEntertainmentAuthDataDuration(String travelEntertainmentAuthDataDuration) {
    this.travelEntertainmentAuthDataDuration = travelEntertainmentAuthDataDuration;
  }


  public AdditionalDataCarRental travelEntertainmentAuthDataMarket(String travelEntertainmentAuthDataMarket) {
    
    this.travelEntertainmentAuthDataMarket = travelEntertainmentAuthDataMarket;
    return this;
  }

   /**
   * Indicates what market-specific dataset will be submitted or is being submitted. Value should be &#39;A&#39; for car rental. This should be included in the auth message. * Format: Alphanumeric * maxLength: 1
   * @return travelEntertainmentAuthDataMarket
  **/
  @ApiModelProperty(value = "Indicates what market-specific dataset will be submitted or is being submitted. Value should be 'A' for car rental. This should be included in the auth message. * Format: Alphanumeric * maxLength: 1")

  public String getTravelEntertainmentAuthDataMarket() {
    return travelEntertainmentAuthDataMarket;
  }


  public void setTravelEntertainmentAuthDataMarket(String travelEntertainmentAuthDataMarket) {
    this.travelEntertainmentAuthDataMarket = travelEntertainmentAuthDataMarket;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdditionalDataCarRental additionalDataCarRental = (AdditionalDataCarRental) o;
    return Objects.equals(this.carRentalCheckOutDate, additionalDataCarRental.carRentalCheckOutDate) &&
        Objects.equals(this.carRentalCustomerServiceTollFreeNumber, additionalDataCarRental.carRentalCustomerServiceTollFreeNumber) &&
        Objects.equals(this.carRentalDaysRented, additionalDataCarRental.carRentalDaysRented) &&
        Objects.equals(this.carRentalFuelCharges, additionalDataCarRental.carRentalFuelCharges) &&
        Objects.equals(this.carRentalInsuranceCharges, additionalDataCarRental.carRentalInsuranceCharges) &&
        Objects.equals(this.carRentalLocationCity, additionalDataCarRental.carRentalLocationCity) &&
        Objects.equals(this.carRentalLocationCountry, additionalDataCarRental.carRentalLocationCountry) &&
        Objects.equals(this.carRentalLocationStateProvince, additionalDataCarRental.carRentalLocationStateProvince) &&
        Objects.equals(this.carRentalNoShowIndicator, additionalDataCarRental.carRentalNoShowIndicator) &&
        Objects.equals(this.carRentalOneWayDropOffCharges, additionalDataCarRental.carRentalOneWayDropOffCharges) &&
        Objects.equals(this.carRentalRate, additionalDataCarRental.carRentalRate) &&
        Objects.equals(this.carRentalRateIndicator, additionalDataCarRental.carRentalRateIndicator) &&
        Objects.equals(this.carRentalRentalAgreementNumber, additionalDataCarRental.carRentalRentalAgreementNumber) &&
        Objects.equals(this.carRentalRentalClassId, additionalDataCarRental.carRentalRentalClassId) &&
        Objects.equals(this.carRentalRenterName, additionalDataCarRental.carRentalRenterName) &&
        Objects.equals(this.carRentalReturnCity, additionalDataCarRental.carRentalReturnCity) &&
        Objects.equals(this.carRentalReturnCountry, additionalDataCarRental.carRentalReturnCountry) &&
        Objects.equals(this.carRentalReturnDate, additionalDataCarRental.carRentalReturnDate) &&
        Objects.equals(this.carRentalReturnLocationId, additionalDataCarRental.carRentalReturnLocationId) &&
        Objects.equals(this.carRentalReturnStateProvince, additionalDataCarRental.carRentalReturnStateProvince) &&
        Objects.equals(this.carRentalTaxExemptIndicator, additionalDataCarRental.carRentalTaxExemptIndicator) &&
        Objects.equals(this.travelEntertainmentAuthDataDuration, additionalDataCarRental.travelEntertainmentAuthDataDuration) &&
        Objects.equals(this.travelEntertainmentAuthDataMarket, additionalDataCarRental.travelEntertainmentAuthDataMarket);
  }

  @Override
  public int hashCode() {
    return Objects.hash(carRentalCheckOutDate, carRentalCustomerServiceTollFreeNumber, carRentalDaysRented, carRentalFuelCharges, carRentalInsuranceCharges, carRentalLocationCity, carRentalLocationCountry, carRentalLocationStateProvince, carRentalNoShowIndicator, carRentalOneWayDropOffCharges, carRentalRate, carRentalRateIndicator, carRentalRentalAgreementNumber, carRentalRentalClassId, carRentalRenterName, carRentalReturnCity, carRentalReturnCountry, carRentalReturnDate, carRentalReturnLocationId, carRentalReturnStateProvince, carRentalTaxExemptIndicator, travelEntertainmentAuthDataDuration, travelEntertainmentAuthDataMarket);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdditionalDataCarRental {\n");
    sb.append("    carRentalCheckOutDate: ").append(toIndentedString(carRentalCheckOutDate)).append("\n");
    sb.append("    carRentalCustomerServiceTollFreeNumber: ").append(toIndentedString(carRentalCustomerServiceTollFreeNumber)).append("\n");
    sb.append("    carRentalDaysRented: ").append(toIndentedString(carRentalDaysRented)).append("\n");
    sb.append("    carRentalFuelCharges: ").append(toIndentedString(carRentalFuelCharges)).append("\n");
    sb.append("    carRentalInsuranceCharges: ").append(toIndentedString(carRentalInsuranceCharges)).append("\n");
    sb.append("    carRentalLocationCity: ").append(toIndentedString(carRentalLocationCity)).append("\n");
    sb.append("    carRentalLocationCountry: ").append(toIndentedString(carRentalLocationCountry)).append("\n");
    sb.append("    carRentalLocationStateProvince: ").append(toIndentedString(carRentalLocationStateProvince)).append("\n");
    sb.append("    carRentalNoShowIndicator: ").append(toIndentedString(carRentalNoShowIndicator)).append("\n");
    sb.append("    carRentalOneWayDropOffCharges: ").append(toIndentedString(carRentalOneWayDropOffCharges)).append("\n");
    sb.append("    carRentalRate: ").append(toIndentedString(carRentalRate)).append("\n");
    sb.append("    carRentalRateIndicator: ").append(toIndentedString(carRentalRateIndicator)).append("\n");
    sb.append("    carRentalRentalAgreementNumber: ").append(toIndentedString(carRentalRentalAgreementNumber)).append("\n");
    sb.append("    carRentalRentalClassId: ").append(toIndentedString(carRentalRentalClassId)).append("\n");
    sb.append("    carRentalRenterName: ").append(toIndentedString(carRentalRenterName)).append("\n");
    sb.append("    carRentalReturnCity: ").append(toIndentedString(carRentalReturnCity)).append("\n");
    sb.append("    carRentalReturnCountry: ").append(toIndentedString(carRentalReturnCountry)).append("\n");
    sb.append("    carRentalReturnDate: ").append(toIndentedString(carRentalReturnDate)).append("\n");
    sb.append("    carRentalReturnLocationId: ").append(toIndentedString(carRentalReturnLocationId)).append("\n");
    sb.append("    carRentalReturnStateProvince: ").append(toIndentedString(carRentalReturnStateProvince)).append("\n");
    sb.append("    carRentalTaxExemptIndicator: ").append(toIndentedString(carRentalTaxExemptIndicator)).append("\n");
    sb.append("    travelEntertainmentAuthDataDuration: ").append(toIndentedString(travelEntertainmentAuthDataDuration)).append("\n");
    sb.append("    travelEntertainmentAuthDataMarket: ").append(toIndentedString(travelEntertainmentAuthDataMarket)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("carRental.checkOutDate");
    openapiFields.add("carRental.customerServiceTollFreeNumber");
    openapiFields.add("carRental.daysRented");
    openapiFields.add("carRental.fuelCharges");
    openapiFields.add("carRental.insuranceCharges");
    openapiFields.add("carRental.locationCity");
    openapiFields.add("carRental.locationCountry");
    openapiFields.add("carRental.locationStateProvince");
    openapiFields.add("carRental.noShowIndicator");
    openapiFields.add("carRental.oneWayDropOffCharges");
    openapiFields.add("carRental.rate");
    openapiFields.add("carRental.rateIndicator");
    openapiFields.add("carRental.rentalAgreementNumber");
    openapiFields.add("carRental.rentalClassId");
    openapiFields.add("carRental.renterName");
    openapiFields.add("carRental.returnCity");
    openapiFields.add("carRental.returnCountry");
    openapiFields.add("carRental.returnDate");
    openapiFields.add("carRental.returnLocationId");
    openapiFields.add("carRental.returnStateProvince");
    openapiFields.add("carRental.taxExemptIndicator");
    openapiFields.add("travelEntertainmentAuthData.duration");
    openapiFields.add("travelEntertainmentAuthData.market");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(AdditionalDataCarRental.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to AdditionalDataCarRental
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (AdditionalDataCarRental.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in AdditionalDataCarRental is not found in the empty JSON string", AdditionalDataCarRental.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!AdditionalDataCarRental.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `AdditionalDataCarRental` properties.", entry.getKey()));
        }
      }
      // validate the optional field carRental.checkOutDate
      if (jsonObj.get("carRental.checkOutDate") != null && !jsonObj.get("carRental.checkOutDate").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.checkOutDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.checkOutDate").toString()));
      }
      // validate the optional field carRental.customerServiceTollFreeNumber
      if (jsonObj.get("carRental.customerServiceTollFreeNumber") != null && !jsonObj.get("carRental.customerServiceTollFreeNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.customerServiceTollFreeNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.customerServiceTollFreeNumber").toString()));
      }
      // validate the optional field carRental.daysRented
      if (jsonObj.get("carRental.daysRented") != null && !jsonObj.get("carRental.daysRented").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.daysRented` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.daysRented").toString()));
      }
      // validate the optional field carRental.fuelCharges
      if (jsonObj.get("carRental.fuelCharges") != null && !jsonObj.get("carRental.fuelCharges").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.fuelCharges` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.fuelCharges").toString()));
      }
      // validate the optional field carRental.insuranceCharges
      if (jsonObj.get("carRental.insuranceCharges") != null && !jsonObj.get("carRental.insuranceCharges").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.insuranceCharges` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.insuranceCharges").toString()));
      }
      // validate the optional field carRental.locationCity
      if (jsonObj.get("carRental.locationCity") != null && !jsonObj.get("carRental.locationCity").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.locationCity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.locationCity").toString()));
      }
      // validate the optional field carRental.locationCountry
      if (jsonObj.get("carRental.locationCountry") != null && !jsonObj.get("carRental.locationCountry").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.locationCountry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.locationCountry").toString()));
      }
      // validate the optional field carRental.locationStateProvince
      if (jsonObj.get("carRental.locationStateProvince") != null && !jsonObj.get("carRental.locationStateProvince").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.locationStateProvince` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.locationStateProvince").toString()));
      }
      // validate the optional field carRental.noShowIndicator
      if (jsonObj.get("carRental.noShowIndicator") != null && !jsonObj.get("carRental.noShowIndicator").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.noShowIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.noShowIndicator").toString()));
      }
      // validate the optional field carRental.oneWayDropOffCharges
      if (jsonObj.get("carRental.oneWayDropOffCharges") != null && !jsonObj.get("carRental.oneWayDropOffCharges").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.oneWayDropOffCharges` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.oneWayDropOffCharges").toString()));
      }
      // validate the optional field carRental.rate
      if (jsonObj.get("carRental.rate") != null && !jsonObj.get("carRental.rate").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.rate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.rate").toString()));
      }
      // validate the optional field carRental.rateIndicator
      if (jsonObj.get("carRental.rateIndicator") != null && !jsonObj.get("carRental.rateIndicator").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.rateIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.rateIndicator").toString()));
      }
      // validate the optional field carRental.rentalAgreementNumber
      if (jsonObj.get("carRental.rentalAgreementNumber") != null && !jsonObj.get("carRental.rentalAgreementNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.rentalAgreementNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.rentalAgreementNumber").toString()));
      }
      // validate the optional field carRental.rentalClassId
      if (jsonObj.get("carRental.rentalClassId") != null && !jsonObj.get("carRental.rentalClassId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.rentalClassId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.rentalClassId").toString()));
      }
      // validate the optional field carRental.renterName
      if (jsonObj.get("carRental.renterName") != null && !jsonObj.get("carRental.renterName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.renterName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.renterName").toString()));
      }
      // validate the optional field carRental.returnCity
      if (jsonObj.get("carRental.returnCity") != null && !jsonObj.get("carRental.returnCity").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.returnCity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.returnCity").toString()));
      }
      // validate the optional field carRental.returnCountry
      if (jsonObj.get("carRental.returnCountry") != null && !jsonObj.get("carRental.returnCountry").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.returnCountry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.returnCountry").toString()));
      }
      // validate the optional field carRental.returnDate
      if (jsonObj.get("carRental.returnDate") != null && !jsonObj.get("carRental.returnDate").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.returnDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.returnDate").toString()));
      }
      // validate the optional field carRental.returnLocationId
      if (jsonObj.get("carRental.returnLocationId") != null && !jsonObj.get("carRental.returnLocationId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.returnLocationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.returnLocationId").toString()));
      }
      // validate the optional field carRental.returnStateProvince
      if (jsonObj.get("carRental.returnStateProvince") != null && !jsonObj.get("carRental.returnStateProvince").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.returnStateProvince` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.returnStateProvince").toString()));
      }
      // validate the optional field carRental.taxExemptIndicator
      if (jsonObj.get("carRental.taxExemptIndicator") != null && !jsonObj.get("carRental.taxExemptIndicator").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `carRental.taxExemptIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get("carRental.taxExemptIndicator").toString()));
      }
      // validate the optional field travelEntertainmentAuthData.duration
      if (jsonObj.get("travelEntertainmentAuthData.duration") != null && !jsonObj.get("travelEntertainmentAuthData.duration").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `travelEntertainmentAuthData.duration` to be a primitive type in the JSON string but got `%s`", jsonObj.get("travelEntertainmentAuthData.duration").toString()));
      }
      // validate the optional field travelEntertainmentAuthData.market
      if (jsonObj.get("travelEntertainmentAuthData.market") != null && !jsonObj.get("travelEntertainmentAuthData.market").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `travelEntertainmentAuthData.market` to be a primitive type in the JSON string but got `%s`", jsonObj.get("travelEntertainmentAuthData.market").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AdditionalDataCarRental.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AdditionalDataCarRental' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AdditionalDataCarRental> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AdditionalDataCarRental.class));

       return (TypeAdapter<T>) new TypeAdapter<AdditionalDataCarRental>() {
           @Override
           public void write(JsonWriter out, AdditionalDataCarRental value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AdditionalDataCarRental read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AdditionalDataCarRental given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AdditionalDataCarRental
  * @throws IOException if the JSON string is invalid with respect to AdditionalDataCarRental
  */
  public static AdditionalDataCarRental fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AdditionalDataCarRental.class);
  }

 /**
  * Convert an instance of AdditionalDataCarRental to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

