/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.CardDetails;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.SubMerchant;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * FundRecipient
 */

public class FundRecipient {
  public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
  @SerializedName(SERIALIZED_NAME_BILLING_ADDRESS)
  private Address billingAddress;

  public static final String SERIALIZED_NAME_PAYMENT_METHOD = "paymentMethod";
  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD)
  private CardDetails paymentMethod;

  public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
  @SerializedName(SERIALIZED_NAME_SHOPPER_EMAIL)
  private String shopperEmail;

  public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
  @SerializedName(SERIALIZED_NAME_SHOPPER_NAME)
  private Name shopperName;

  public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
  @SerializedName(SERIALIZED_NAME_SHOPPER_REFERENCE)
  private String shopperReference;

  public static final String SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
  @SerializedName(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID)
  private String storedPaymentMethodId;

  public static final String SERIALIZED_NAME_SUB_MERCHANT = "subMerchant";
  @SerializedName(SERIALIZED_NAME_SUB_MERCHANT)
  private SubMerchant subMerchant;

  public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
  @SerializedName(SERIALIZED_NAME_TELEPHONE_NUMBER)
  private String telephoneNumber;

  public static final String SERIALIZED_NAME_WALLET_IDENTIFIER = "walletIdentifier";
  @SerializedName(SERIALIZED_NAME_WALLET_IDENTIFIER)
  private String walletIdentifier;

  public static final String SERIALIZED_NAME_WALLET_OWNER_TAX_ID = "walletOwnerTaxId";
  @SerializedName(SERIALIZED_NAME_WALLET_OWNER_TAX_ID)
  private String walletOwnerTaxId;

  public FundRecipient() { 
  }

  public FundRecipient billingAddress(Address billingAddress) {
    
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @ApiModelProperty(value = "")

  public Address getBillingAddress() {
    return billingAddress;
  }


  public void setBillingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
  }


  public FundRecipient paymentMethod(CardDetails paymentMethod) {
    
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * Get paymentMethod
   * @return paymentMethod
  **/
  @ApiModelProperty(value = "")

  public CardDetails getPaymentMethod() {
    return paymentMethod;
  }


  public void setPaymentMethod(CardDetails paymentMethod) {
    this.paymentMethod = paymentMethod;
  }


  public FundRecipient shopperEmail(String shopperEmail) {
    
    this.shopperEmail = shopperEmail;
    return this;
  }

   /**
   * the email address of the person
   * @return shopperEmail
  **/
  @ApiModelProperty(value = "the email address of the person")

  public String getShopperEmail() {
    return shopperEmail;
  }


  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }


  public FundRecipient shopperName(Name shopperName) {
    
    this.shopperName = shopperName;
    return this;
  }

   /**
   * Get shopperName
   * @return shopperName
  **/
  @ApiModelProperty(value = "")

  public Name getShopperName() {
    return shopperName;
  }


  public void setShopperName(Name shopperName) {
    this.shopperName = shopperName;
  }


  public FundRecipient shopperReference(String shopperReference) {
    
    this.shopperReference = shopperReference;
    return this;
  }

   /**
   * Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
   * @return shopperReference
  **/
  @ApiModelProperty(value = "Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")

  public String getShopperReference() {
    return shopperReference;
  }


  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }


  public FundRecipient storedPaymentMethodId(String storedPaymentMethodId) {
    
    this.storedPaymentMethodId = storedPaymentMethodId;
    return this;
  }

   /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   * @return storedPaymentMethodId
  **/
  @ApiModelProperty(value = "This is the `recurringDetailReference` returned in the response when you created the token.")

  public String getStoredPaymentMethodId() {
    return storedPaymentMethodId;
  }


  public void setStoredPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
  }


  public FundRecipient subMerchant(SubMerchant subMerchant) {
    
    this.subMerchant = subMerchant;
    return this;
  }

   /**
   * Get subMerchant
   * @return subMerchant
  **/
  @ApiModelProperty(value = "")

  public SubMerchant getSubMerchant() {
    return subMerchant;
  }


  public void setSubMerchant(SubMerchant subMerchant) {
    this.subMerchant = subMerchant;
  }


  public FundRecipient telephoneNumber(String telephoneNumber) {
    
    this.telephoneNumber = telephoneNumber;
    return this;
  }

   /**
   * the telephone number of the person
   * @return telephoneNumber
  **/
  @ApiModelProperty(value = "the telephone number of the person")

  public String getTelephoneNumber() {
    return telephoneNumber;
  }


  public void setTelephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
  }


  public FundRecipient walletIdentifier(String walletIdentifier) {
    
    this.walletIdentifier = walletIdentifier;
    return this;
  }

   /**
   * indicates where the money is going
   * @return walletIdentifier
  **/
  @ApiModelProperty(value = "indicates where the money is going")

  public String getWalletIdentifier() {
    return walletIdentifier;
  }


  public void setWalletIdentifier(String walletIdentifier) {
    this.walletIdentifier = walletIdentifier;
  }


  public FundRecipient walletOwnerTaxId(String walletOwnerTaxId) {
    
    this.walletOwnerTaxId = walletOwnerTaxId;
    return this;
  }

   /**
   * indicates the tax identifier of the fund recepient
   * @return walletOwnerTaxId
  **/
  @ApiModelProperty(value = "indicates the tax identifier of the fund recepient")

  public String getWalletOwnerTaxId() {
    return walletOwnerTaxId;
  }


  public void setWalletOwnerTaxId(String walletOwnerTaxId) {
    this.walletOwnerTaxId = walletOwnerTaxId;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FundRecipient fundRecipient = (FundRecipient) o;
    return Objects.equals(this.billingAddress, fundRecipient.billingAddress) &&
        Objects.equals(this.paymentMethod, fundRecipient.paymentMethod) &&
        Objects.equals(this.shopperEmail, fundRecipient.shopperEmail) &&
        Objects.equals(this.shopperName, fundRecipient.shopperName) &&
        Objects.equals(this.shopperReference, fundRecipient.shopperReference) &&
        Objects.equals(this.storedPaymentMethodId, fundRecipient.storedPaymentMethodId) &&
        Objects.equals(this.subMerchant, fundRecipient.subMerchant) &&
        Objects.equals(this.telephoneNumber, fundRecipient.telephoneNumber) &&
        Objects.equals(this.walletIdentifier, fundRecipient.walletIdentifier) &&
        Objects.equals(this.walletOwnerTaxId, fundRecipient.walletOwnerTaxId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billingAddress, paymentMethod, shopperEmail, shopperName, shopperReference, storedPaymentMethodId, subMerchant, telephoneNumber, walletIdentifier, walletOwnerTaxId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FundRecipient {\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    storedPaymentMethodId: ").append(toIndentedString(storedPaymentMethodId)).append("\n");
    sb.append("    subMerchant: ").append(toIndentedString(subMerchant)).append("\n");
    sb.append("    telephoneNumber: ").append(toIndentedString(telephoneNumber)).append("\n");
    sb.append("    walletIdentifier: ").append(toIndentedString(walletIdentifier)).append("\n");
    sb.append("    walletOwnerTaxId: ").append(toIndentedString(walletOwnerTaxId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("billingAddress");
    openapiFields.add("paymentMethod");
    openapiFields.add("shopperEmail");
    openapiFields.add("shopperName");
    openapiFields.add("shopperReference");
    openapiFields.add("storedPaymentMethodId");
    openapiFields.add("subMerchant");
    openapiFields.add("telephoneNumber");
    openapiFields.add("walletIdentifier");
    openapiFields.add("walletOwnerTaxId");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(FundRecipient.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to FundRecipient
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (FundRecipient.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in FundRecipient is not found in the empty JSON string", FundRecipient.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!FundRecipient.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `FundRecipient` properties.", entry.getKey()));
        }
      }
      // validate the optional field `billingAddress`
      if (jsonObj.getAsJsonObject("billingAddress") != null) {
        Address.validateJsonObject(jsonObj.getAsJsonObject("billingAddress"));
      }
      // validate the optional field `paymentMethod`
      if (jsonObj.getAsJsonObject("paymentMethod") != null) {
        CardDetails.validateJsonObject(jsonObj.getAsJsonObject("paymentMethod"));
      }
      // validate the optional field shopperEmail
      if (jsonObj.get("shopperEmail") != null && !jsonObj.get("shopperEmail").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperEmail").toString()));
      }
      // validate the optional field `shopperName`
      if (jsonObj.getAsJsonObject("shopperName") != null) {
        Name.validateJsonObject(jsonObj.getAsJsonObject("shopperName"));
      }
      // validate the optional field shopperReference
      if (jsonObj.get("shopperReference") != null && !jsonObj.get("shopperReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperReference").toString()));
      }
      // validate the optional field storedPaymentMethodId
      if (jsonObj.get("storedPaymentMethodId") != null && !jsonObj.get("storedPaymentMethodId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `storedPaymentMethodId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("storedPaymentMethodId").toString()));
      }
      // validate the optional field `subMerchant`
      if (jsonObj.getAsJsonObject("subMerchant") != null) {
        SubMerchant.validateJsonObject(jsonObj.getAsJsonObject("subMerchant"));
      }
      // validate the optional field telephoneNumber
      if (jsonObj.get("telephoneNumber") != null && !jsonObj.get("telephoneNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("telephoneNumber").toString()));
      }
      // validate the optional field walletIdentifier
      if (jsonObj.get("walletIdentifier") != null && !jsonObj.get("walletIdentifier").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `walletIdentifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get("walletIdentifier").toString()));
      }
      // validate the optional field walletOwnerTaxId
      if (jsonObj.get("walletOwnerTaxId") != null && !jsonObj.get("walletOwnerTaxId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `walletOwnerTaxId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("walletOwnerTaxId").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FundRecipient.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FundRecipient' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FundRecipient> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FundRecipient.class));

       return (TypeAdapter<T>) new TypeAdapter<FundRecipient>() {
           @Override
           public void write(JsonWriter out, FundRecipient value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FundRecipient read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FundRecipient given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FundRecipient
  * @throws IOException if the JSON string is invalid with respect to FundRecipient
  */
  public static FundRecipient fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FundRecipient.class);
  }

 /**
  * Convert an instance of FundRecipient to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

