/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.checkout.StoredPaymentMethodResource;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * ListStoredPaymentMethodsResponse
 */

public class ListStoredPaymentMethodsResponse {
  public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ACCOUNT)
  private String merchantAccount;

  public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
  @SerializedName(SERIALIZED_NAME_SHOPPER_REFERENCE)
  private String shopperReference;

  public static final String SERIALIZED_NAME_STORED_PAYMENT_METHODS = "storedPaymentMethods";
  @SerializedName(SERIALIZED_NAME_STORED_PAYMENT_METHODS)
  private List<StoredPaymentMethodResource> storedPaymentMethods = null;

  public ListStoredPaymentMethodsResponse() { 
  }

  public ListStoredPaymentMethodsResponse merchantAccount(String merchantAccount) {
    
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * Your merchant account.
   * @return merchantAccount
  **/
  @ApiModelProperty(value = "Your merchant account.")

  public String getMerchantAccount() {
    return merchantAccount;
  }


  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public ListStoredPaymentMethodsResponse shopperReference(String shopperReference) {
    
    this.shopperReference = shopperReference;
    return this;
  }

   /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
   * @return shopperReference
  **/
  @ApiModelProperty(value = "Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")

  public String getShopperReference() {
    return shopperReference;
  }


  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }


  public ListStoredPaymentMethodsResponse storedPaymentMethods(List<StoredPaymentMethodResource> storedPaymentMethods) {
    
    this.storedPaymentMethods = storedPaymentMethods;
    return this;
  }

  public ListStoredPaymentMethodsResponse addStoredPaymentMethodsItem(StoredPaymentMethodResource storedPaymentMethodsItem) {
    if (this.storedPaymentMethods == null) {
      this.storedPaymentMethods = new ArrayList<>();
    }
    this.storedPaymentMethods.add(storedPaymentMethodsItem);
    return this;
  }

   /**
   * List of all stored payment methods.
   * @return storedPaymentMethods
  **/
  @ApiModelProperty(value = "List of all stored payment methods.")

  public List<StoredPaymentMethodResource> getStoredPaymentMethods() {
    return storedPaymentMethods;
  }


  public void setStoredPaymentMethods(List<StoredPaymentMethodResource> storedPaymentMethods) {
    this.storedPaymentMethods = storedPaymentMethods;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListStoredPaymentMethodsResponse listStoredPaymentMethodsResponse = (ListStoredPaymentMethodsResponse) o;
    return Objects.equals(this.merchantAccount, listStoredPaymentMethodsResponse.merchantAccount) &&
        Objects.equals(this.shopperReference, listStoredPaymentMethodsResponse.shopperReference) &&
        Objects.equals(this.storedPaymentMethods, listStoredPaymentMethodsResponse.storedPaymentMethods);
  }

  @Override
  public int hashCode() {
    return Objects.hash(merchantAccount, shopperReference, storedPaymentMethods);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListStoredPaymentMethodsResponse {\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    storedPaymentMethods: ").append(toIndentedString(storedPaymentMethods)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("merchantAccount");
    openapiFields.add("shopperReference");
    openapiFields.add("storedPaymentMethods");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(ListStoredPaymentMethodsResponse.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ListStoredPaymentMethodsResponse
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ListStoredPaymentMethodsResponse.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ListStoredPaymentMethodsResponse is not found in the empty JSON string", ListStoredPaymentMethodsResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ListStoredPaymentMethodsResponse.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ListStoredPaymentMethodsResponse` properties.", entry.getKey()));
        }
      }
      // validate the optional field merchantAccount
      if (jsonObj.get("merchantAccount") != null && !jsonObj.get("merchantAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantAccount").toString()));
      }
      // validate the optional field shopperReference
      if (jsonObj.get("shopperReference") != null && !jsonObj.get("shopperReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperReference").toString()));
      }
      JsonArray jsonArraystoredPaymentMethods = jsonObj.getAsJsonArray("storedPaymentMethods");
      if (jsonArraystoredPaymentMethods != null) {
        // ensure the json data is an array
        if (!jsonObj.get("storedPaymentMethods").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `storedPaymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get("storedPaymentMethods").toString()));
        }

        // validate the optional field `storedPaymentMethods` (array)
        for (int i = 0; i < jsonArraystoredPaymentMethods.size(); i++) {
          StoredPaymentMethodResource.validateJsonObject(jsonArraystoredPaymentMethods.get(i).getAsJsonObject());
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ListStoredPaymentMethodsResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ListStoredPaymentMethodsResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ListStoredPaymentMethodsResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ListStoredPaymentMethodsResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<ListStoredPaymentMethodsResponse>() {
           @Override
           public void write(JsonWriter out, ListStoredPaymentMethodsResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ListStoredPaymentMethodsResponse read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ListStoredPaymentMethodsResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ListStoredPaymentMethodsResponse
  * @throws IOException if the JSON string is invalid with respect to ListStoredPaymentMethodsResponse
  */
  public static ListStoredPaymentMethodsResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ListStoredPaymentMethodsResponse.class);
  }

 /**
  * Convert an instance of ListStoredPaymentMethodsResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

