/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * RiskData
 */

public class RiskData {
  public static final String SERIALIZED_NAME_CLIENT_DATA = "clientData";
  @SerializedName(SERIALIZED_NAME_CLIENT_DATA)
  private String clientData;

  public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "customFields";
  @SerializedName(SERIALIZED_NAME_CUSTOM_FIELDS)
  private Map<String, String> customFields = null;

  public static final String SERIALIZED_NAME_FRAUD_OFFSET = "fraudOffset";
  @SerializedName(SERIALIZED_NAME_FRAUD_OFFSET)
  private Integer fraudOffset;

  public static final String SERIALIZED_NAME_PROFILE_REFERENCE = "profileReference";
  @SerializedName(SERIALIZED_NAME_PROFILE_REFERENCE)
  private String profileReference;

  public RiskData() { 
  }

  public RiskData clientData(String clientData) {
    
    this.clientData = clientData;
    return this;
  }

   /**
   * Contains client-side data, like the device fingerprint, cookies, and specific browser settings.
   * @return clientData
  **/
  @ApiModelProperty(value = "Contains client-side data, like the device fingerprint, cookies, and specific browser settings.")

  public String getClientData() {
    return clientData;
  }


  public void setClientData(String clientData) {
    this.clientData = clientData;
  }


  public RiskData customFields(Map<String, String> customFields) {
    
    this.customFields = customFields;
    return this;
  }

  public RiskData putCustomFieldsItem(String key, String customFieldsItem) {
    if (this.customFields == null) {
      this.customFields = new HashMap<>();
    }
    this.customFields.put(key, customFieldsItem);
    return this;
  }

   /**
   * Any custom fields used as part of the input to configured risk rules.
   * @return customFields
  **/
  @ApiModelProperty(value = "Any custom fields used as part of the input to configured risk rules.")

  public Map<String, String> getCustomFields() {
    return customFields;
  }


  public void setCustomFields(Map<String, String> customFields) {
    this.customFields = customFields;
  }


  public RiskData fraudOffset(Integer fraudOffset) {
    
    this.fraudOffset = fraudOffset;
    return this;
  }

   /**
   * An integer value that is added to the normal fraud score. The value can be either positive or negative.
   * @return fraudOffset
  **/
  @ApiModelProperty(value = "An integer value that is added to the normal fraud score. The value can be either positive or negative.")

  public Integer getFraudOffset() {
    return fraudOffset;
  }


  public void setFraudOffset(Integer fraudOffset) {
    this.fraudOffset = fraudOffset;
  }


  public RiskData profileReference(String profileReference) {
    
    this.profileReference = profileReference;
    return this;
  }

   /**
   * The risk profile to assign to this payment. When left empty, the merchant-level account&#39;s default risk profile will be applied.
   * @return profileReference
  **/
  @ApiModelProperty(value = "The risk profile to assign to this payment. When left empty, the merchant-level account's default risk profile will be applied.")

  public String getProfileReference() {
    return profileReference;
  }


  public void setProfileReference(String profileReference) {
    this.profileReference = profileReference;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RiskData riskData = (RiskData) o;
    return Objects.equals(this.clientData, riskData.clientData) &&
        Objects.equals(this.customFields, riskData.customFields) &&
        Objects.equals(this.fraudOffset, riskData.fraudOffset) &&
        Objects.equals(this.profileReference, riskData.profileReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientData, customFields, fraudOffset, profileReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RiskData {\n");
    sb.append("    clientData: ").append(toIndentedString(clientData)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    fraudOffset: ").append(toIndentedString(fraudOffset)).append("\n");
    sb.append("    profileReference: ").append(toIndentedString(profileReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("clientData");
    openapiFields.add("customFields");
    openapiFields.add("fraudOffset");
    openapiFields.add("profileReference");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(RiskData.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to RiskData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (RiskData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in RiskData is not found in the empty JSON string", RiskData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!RiskData.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `RiskData` properties.", entry.getKey()));
        }
      }
      // validate the optional field clientData
      if (jsonObj.get("clientData") != null && !jsonObj.get("clientData").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `clientData` to be a primitive type in the JSON string but got `%s`", jsonObj.get("clientData").toString()));
      }
      // validate the optional field profileReference
      if (jsonObj.get("profileReference") != null && !jsonObj.get("profileReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `profileReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("profileReference").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RiskData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RiskData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RiskData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RiskData.class));

       return (TypeAdapter<T>) new TypeAdapter<RiskData>() {
           @Override
           public void write(JsonWriter out, RiskData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RiskData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RiskData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RiskData
  * @throws IOException if the JSON string is invalid with respect to RiskData
  */
  public static RiskData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RiskData.class);
  }

 /**
  * Convert an instance of RiskData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

