/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * ThreeDSRequestData
 */

public class ThreeDSRequestData {
  /**
   * Dimensions of the 3DS2 challenge window to be displayed to the cardholder.  Possible values:  * **01** - size of 250x400  * **02** - size of 390x400 * **03** - size of 500x600 * **04** - size of 600x400 * **05** - Fullscreen
   */
  @JsonAdapter(ChallengeWindowSizeEnum.Adapter.class)
  public enum ChallengeWindowSizeEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04"),
    
    _05("05");

    private String value;

    ChallengeWindowSizeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ChallengeWindowSizeEnum fromValue(String value) {
      for (ChallengeWindowSizeEnum b : ChallengeWindowSizeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ChallengeWindowSizeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ChallengeWindowSizeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ChallengeWindowSizeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ChallengeWindowSizeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CHALLENGE_WINDOW_SIZE = "challengeWindowSize";
  @SerializedName(SERIALIZED_NAME_CHALLENGE_WINDOW_SIZE)
  private ChallengeWindowSizeEnum challengeWindowSize;

  /**
   * Flag for data only flow.
   */
  @JsonAdapter(DataOnlyEnum.Adapter.class)
  public enum DataOnlyEnum {
    FALSE("false"),
    
    TRUE("true");

    private String value;

    DataOnlyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DataOnlyEnum fromValue(String value) {
      for (DataOnlyEnum b : DataOnlyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DataOnlyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DataOnlyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DataOnlyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DataOnlyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DATA_ONLY = "dataOnly";
  @SerializedName(SERIALIZED_NAME_DATA_ONLY)
  private DataOnlyEnum dataOnly;

  /**
   * Indicates if [native 3D Secure authentication](https://docs.adyen.com/online-payments/3d-secure/native-3ds2) should be used when available.  Possible values: * **preferred**: Use native 3D Secure authentication when available.
   */
  @JsonAdapter(NativeThreeDSEnum.Adapter.class)
  public enum NativeThreeDSEnum {
    PREFERRED("preferred");

    private String value;

    NativeThreeDSEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static NativeThreeDSEnum fromValue(String value) {
      for (NativeThreeDSEnum b : NativeThreeDSEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<NativeThreeDSEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final NativeThreeDSEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public NativeThreeDSEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return NativeThreeDSEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_NATIVE_THREE_D_S = "nativeThreeDS";
  @SerializedName(SERIALIZED_NAME_NATIVE_THREE_D_S)
  private NativeThreeDSEnum nativeThreeDS;

  /**
   * The version of 3D Secure to use.  Possible values:  * **2.1.0** * **2.2.0**
   */
  @JsonAdapter(ThreeDSVersionEnum.Adapter.class)
  public enum ThreeDSVersionEnum {
    _1_0("2.1.0"),
    
    _2_0("2.2.0");

    private String value;

    ThreeDSVersionEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ThreeDSVersionEnum fromValue(String value) {
      for (ThreeDSVersionEnum b : ThreeDSVersionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ThreeDSVersionEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ThreeDSVersionEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ThreeDSVersionEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ThreeDSVersionEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_THREE_D_S_VERSION = "threeDSVersion";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_VERSION)
  private ThreeDSVersionEnum threeDSVersion;

  public ThreeDSRequestData() { 
  }

  public ThreeDSRequestData challengeWindowSize(ChallengeWindowSizeEnum challengeWindowSize) {
    
    this.challengeWindowSize = challengeWindowSize;
    return this;
  }

   /**
   * Dimensions of the 3DS2 challenge window to be displayed to the cardholder.  Possible values:  * **01** - size of 250x400  * **02** - size of 390x400 * **03** - size of 500x600 * **04** - size of 600x400 * **05** - Fullscreen
   * @return challengeWindowSize
  **/
  @ApiModelProperty(value = "Dimensions of the 3DS2 challenge window to be displayed to the cardholder.  Possible values:  * **01** - size of 250x400  * **02** - size of 390x400 * **03** - size of 500x600 * **04** - size of 600x400 * **05** - Fullscreen")

  public ChallengeWindowSizeEnum getChallengeWindowSize() {
    return challengeWindowSize;
  }


  public void setChallengeWindowSize(ChallengeWindowSizeEnum challengeWindowSize) {
    this.challengeWindowSize = challengeWindowSize;
  }


  public ThreeDSRequestData dataOnly(DataOnlyEnum dataOnly) {
    
    this.dataOnly = dataOnly;
    return this;
  }

   /**
   * Flag for data only flow.
   * @return dataOnly
  **/
  @ApiModelProperty(value = "Flag for data only flow.")

  public DataOnlyEnum getDataOnly() {
    return dataOnly;
  }


  public void setDataOnly(DataOnlyEnum dataOnly) {
    this.dataOnly = dataOnly;
  }


  public ThreeDSRequestData nativeThreeDS(NativeThreeDSEnum nativeThreeDS) {
    
    this.nativeThreeDS = nativeThreeDS;
    return this;
  }

   /**
   * Indicates if [native 3D Secure authentication](https://docs.adyen.com/online-payments/3d-secure/native-3ds2) should be used when available.  Possible values: * **preferred**: Use native 3D Secure authentication when available.
   * @return nativeThreeDS
  **/
  @ApiModelProperty(value = "Indicates if [native 3D Secure authentication](https://docs.adyen.com/online-payments/3d-secure/native-3ds2) should be used when available.  Possible values: * **preferred**: Use native 3D Secure authentication when available.")

  public NativeThreeDSEnum getNativeThreeDS() {
    return nativeThreeDS;
  }


  public void setNativeThreeDS(NativeThreeDSEnum nativeThreeDS) {
    this.nativeThreeDS = nativeThreeDS;
  }


  public ThreeDSRequestData threeDSVersion(ThreeDSVersionEnum threeDSVersion) {
    
    this.threeDSVersion = threeDSVersion;
    return this;
  }

   /**
   * The version of 3D Secure to use.  Possible values:  * **2.1.0** * **2.2.0**
   * @return threeDSVersion
  **/
  @ApiModelProperty(value = "The version of 3D Secure to use.  Possible values:  * **2.1.0** * **2.2.0**")

  public ThreeDSVersionEnum getThreeDSVersion() {
    return threeDSVersion;
  }


  public void setThreeDSVersion(ThreeDSVersionEnum threeDSVersion) {
    this.threeDSVersion = threeDSVersion;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ThreeDSRequestData threeDSRequestData = (ThreeDSRequestData) o;
    return Objects.equals(this.challengeWindowSize, threeDSRequestData.challengeWindowSize) &&
        Objects.equals(this.dataOnly, threeDSRequestData.dataOnly) &&
        Objects.equals(this.nativeThreeDS, threeDSRequestData.nativeThreeDS) &&
        Objects.equals(this.threeDSVersion, threeDSRequestData.threeDSVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(challengeWindowSize, dataOnly, nativeThreeDS, threeDSVersion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ThreeDSRequestData {\n");
    sb.append("    challengeWindowSize: ").append(toIndentedString(challengeWindowSize)).append("\n");
    sb.append("    dataOnly: ").append(toIndentedString(dataOnly)).append("\n");
    sb.append("    nativeThreeDS: ").append(toIndentedString(nativeThreeDS)).append("\n");
    sb.append("    threeDSVersion: ").append(toIndentedString(threeDSVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("challengeWindowSize");
    openapiFields.add("dataOnly");
    openapiFields.add("nativeThreeDS");
    openapiFields.add("threeDSVersion");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(ThreeDSRequestData.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ThreeDSRequestData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ThreeDSRequestData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ThreeDSRequestData is not found in the empty JSON string", ThreeDSRequestData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ThreeDSRequestData.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ThreeDSRequestData` properties.", entry.getKey()));
        }
      }
      // ensure the field challengeWindowSize can be parsed to an enum value
      if (jsonObj.get("challengeWindowSize") != null) {
        if(!jsonObj.get("challengeWindowSize").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `challengeWindowSize` to be a primitive type in the JSON string but got `%s`", jsonObj.get("challengeWindowSize").toString()));
        }
        ChallengeWindowSizeEnum.fromValue(jsonObj.get("challengeWindowSize").getAsString());
      }
      // ensure the field dataOnly can be parsed to an enum value
      if (jsonObj.get("dataOnly") != null) {
        if(!jsonObj.get("dataOnly").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `dataOnly` to be a primitive type in the JSON string but got `%s`", jsonObj.get("dataOnly").toString()));
        }
        DataOnlyEnum.fromValue(jsonObj.get("dataOnly").getAsString());
      }
      // ensure the field nativeThreeDS can be parsed to an enum value
      if (jsonObj.get("nativeThreeDS") != null) {
        if(!jsonObj.get("nativeThreeDS").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `nativeThreeDS` to be a primitive type in the JSON string but got `%s`", jsonObj.get("nativeThreeDS").toString()));
        }
        NativeThreeDSEnum.fromValue(jsonObj.get("nativeThreeDS").getAsString());
      }
      // ensure the field threeDSVersion can be parsed to an enum value
      if (jsonObj.get("threeDSVersion") != null) {
        if(!jsonObj.get("threeDSVersion").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `threeDSVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDSVersion").toString()));
        }
        ThreeDSVersionEnum.fromValue(jsonObj.get("threeDSVersion").getAsString());
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ThreeDSRequestData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ThreeDSRequestData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ThreeDSRequestData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ThreeDSRequestData.class));

       return (TypeAdapter<T>) new TypeAdapter<ThreeDSRequestData>() {
           @Override
           public void write(JsonWriter out, ThreeDSRequestData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ThreeDSRequestData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ThreeDSRequestData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ThreeDSRequestData
  * @throws IOException if the JSON string is invalid with respect to ThreeDSRequestData
  */
  public static ThreeDSRequestData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ThreeDSRequestData.class);
  }

 /**
  * Convert an instance of ThreeDSRequestData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

