/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.legalentitymanagement.BankAccountInfoAccountIdentification;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.legalentitymanagement.JSON;

/**
 * BankAccountInfo
 */

public class BankAccountInfo {
  public static final String SERIALIZED_NAME_ACCOUNT_IDENTIFICATION = "accountIdentification";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_IDENTIFICATION)
  private BankAccountInfoAccountIdentification accountIdentification;

  public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "accountType";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_ACCOUNT_TYPE)
  private String accountType;

  public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
  @SerializedName(SERIALIZED_NAME_COUNTRY_CODE)
  private String countryCode;

  public static final String SERIALIZED_NAME_TRUSTED_SOURCE = "trustedSource";
  @SerializedName(SERIALIZED_NAME_TRUSTED_SOURCE)
  private Boolean trustedSource;

  public BankAccountInfo() { 
  }

  
  public BankAccountInfo(
     Boolean trustedSource
  ) {
    this();
    this.trustedSource = trustedSource;
  }

  public BankAccountInfo accountIdentification(BankAccountInfoAccountIdentification accountIdentification) {
    
    this.accountIdentification = accountIdentification;
    return this;
  }

   /**
   * Get accountIdentification
   * @return accountIdentification
  **/
  @ApiModelProperty(value = "")

  public BankAccountInfoAccountIdentification getAccountIdentification() {
    return accountIdentification;
  }


  public void setAccountIdentification(BankAccountInfoAccountIdentification accountIdentification) {
    this.accountIdentification = accountIdentification;
  }


  @Deprecated
  public BankAccountInfo accountType(String accountType) {
    
    this.accountType = accountType;
    return this;
  }

   /**
   * The type of bank account.
   * @return accountType
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The type of bank account.")

  public String getAccountType() {
    return accountType;
  }


  @Deprecated
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }


  public BankAccountInfo countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the bank account is registered. For example, **NL**.
   * @return countryCode
  **/
  @ApiModelProperty(value = "The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the bank account is registered. For example, **NL**.")

  public String getCountryCode() {
    return countryCode;
  }


  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


   /**
   * Identifies if the bank account was created through [instant bank verification](https://docs.adyen.com/release-notes/platforms-and-financial-products#releaseNote&#x3D;2023-05-08-hosted-onboarding).
   * @return trustedSource
  **/
  @ApiModelProperty(value = "Identifies if the bank account was created through [instant bank verification](https://docs.adyen.com/release-notes/platforms-and-financial-products#releaseNote=2023-05-08-hosted-onboarding).")

  public Boolean getTrustedSource() {
    return trustedSource;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankAccountInfo bankAccountInfo = (BankAccountInfo) o;
    return Objects.equals(this.accountIdentification, bankAccountInfo.accountIdentification) &&
        Objects.equals(this.accountType, bankAccountInfo.accountType) &&
        Objects.equals(this.countryCode, bankAccountInfo.countryCode) &&
        Objects.equals(this.trustedSource, bankAccountInfo.trustedSource);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountIdentification, accountType, countryCode, trustedSource);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankAccountInfo {\n");
    sb.append("    accountIdentification: ").append(toIndentedString(accountIdentification)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    trustedSource: ").append(toIndentedString(trustedSource)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("accountIdentification");
    openapiFields.add("accountType");
    openapiFields.add("countryCode");
    openapiFields.add("trustedSource");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(BankAccountInfo.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to BankAccountInfo
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (BankAccountInfo.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in BankAccountInfo is not found in the empty JSON string", BankAccountInfo.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!BankAccountInfo.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BankAccountInfo` properties.", entry.getKey()));
        }
      }
      // validate the optional field `accountIdentification`
      if (jsonObj.getAsJsonObject("accountIdentification") != null) {
        BankAccountInfoAccountIdentification.validateJsonObject(jsonObj.getAsJsonObject("accountIdentification"));
      }
      // validate the optional field accountType
      if (jsonObj.get("accountType") != null && !jsonObj.get("accountType").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `accountType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("accountType").toString()));
      }
      // validate the optional field countryCode
      if (jsonObj.get("countryCode") != null && !jsonObj.get("countryCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("countryCode").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BankAccountInfo.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BankAccountInfo' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BankAccountInfo> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BankAccountInfo.class));

       return (TypeAdapter<T>) new TypeAdapter<BankAccountInfo>() {
           @Override
           public void write(JsonWriter out, BankAccountInfo value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BankAccountInfo read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BankAccountInfo given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BankAccountInfo
  * @throws IOException if the JSON string is invalid with respect to BankAccountInfo
  */
  public static BankAccountInfo fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BankAccountInfo.class);
  }

 /**
  * Convert an instance of BankAccountInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

