/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.legalentitymanagement.Individual;
import com.adyen.model.legalentitymanagement.LegalEntityAssociation;
import com.adyen.model.legalentitymanagement.LegalEntityCapability;
import com.adyen.model.legalentitymanagement.Organization;
import com.adyen.model.legalentitymanagement.SoleProprietorship;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.legalentitymanagement.JSON;

/**
 * LegalEntityInfo
 */

public class LegalEntityInfo {
  public static final String SERIALIZED_NAME_CAPABILITIES = "capabilities";
  @SerializedName(SERIALIZED_NAME_CAPABILITIES)
  private Map<String, LegalEntityCapability> capabilities = null;

  public static final String SERIALIZED_NAME_ENTITY_ASSOCIATIONS = "entityAssociations";
  @SerializedName(SERIALIZED_NAME_ENTITY_ASSOCIATIONS)
  private List<LegalEntityAssociation> entityAssociations = null;

  public static final String SERIALIZED_NAME_INDIVIDUAL = "individual";
  @SerializedName(SERIALIZED_NAME_INDIVIDUAL)
  private Individual individual;

  public static final String SERIALIZED_NAME_ORGANIZATION = "organization";
  @SerializedName(SERIALIZED_NAME_ORGANIZATION)
  private Organization organization;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  public static final String SERIALIZED_NAME_SOLE_PROPRIETORSHIP = "soleProprietorship";
  @SerializedName(SERIALIZED_NAME_SOLE_PROPRIETORSHIP)
  private SoleProprietorship soleProprietorship;

  /**
   * The type of legal entity.   Possible values: **individual**, **organization**, or **soleProprietorship**.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    INDIVIDUAL("individual"),
    
    ORGANIZATION("organization"),
    
    SOLEPROPRIETORSHIP("soleProprietorship"),
    
    TRUST("trust"),
    
    UNINCORPORATEDPARTNERSHIP("unincorporatedPartnership");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public LegalEntityInfo() { 
  }

  
  public LegalEntityInfo(
     Map<String, LegalEntityCapability> capabilities
  ) {
    this();
    this.capabilities = capabilities;
  }

   /**
   * Contains key-value pairs that specify the actions that the legal entity can do in your platform.The key is a capability required for your integration. For example, **issueCard** for Issuing.The value is an object containing the settings for the capability.
   * @return capabilities
  **/
  @ApiModelProperty(value = "Contains key-value pairs that specify the actions that the legal entity can do in your platform.The key is a capability required for your integration. For example, **issueCard** for Issuing.The value is an object containing the settings for the capability.")

  public Map<String, LegalEntityCapability> getCapabilities() {
    return capabilities;
  }




  public LegalEntityInfo entityAssociations(List<LegalEntityAssociation> entityAssociations) {
    
    this.entityAssociations = entityAssociations;
    return this;
  }

  public LegalEntityInfo addEntityAssociationsItem(LegalEntityAssociation entityAssociationsItem) {
    if (this.entityAssociations == null) {
      this.entityAssociations = new ArrayList<>();
    }
    this.entityAssociations.add(entityAssociationsItem);
    return this;
  }

   /**
   * List of legal entities associated with the current legal entity. For example, ultimate beneficial owners associated with an organization through ownership or control, or as signatories.
   * @return entityAssociations
  **/
  @ApiModelProperty(value = "List of legal entities associated with the current legal entity. For example, ultimate beneficial owners associated with an organization through ownership or control, or as signatories.")

  public List<LegalEntityAssociation> getEntityAssociations() {
    return entityAssociations;
  }


  public void setEntityAssociations(List<LegalEntityAssociation> entityAssociations) {
    this.entityAssociations = entityAssociations;
  }


  public LegalEntityInfo individual(Individual individual) {
    
    this.individual = individual;
    return this;
  }

   /**
   * Get individual
   * @return individual
  **/
  @ApiModelProperty(value = "")

  public Individual getIndividual() {
    return individual;
  }


  public void setIndividual(Individual individual) {
    this.individual = individual;
  }


  public LegalEntityInfo organization(Organization organization) {
    
    this.organization = organization;
    return this;
  }

   /**
   * Get organization
   * @return organization
  **/
  @ApiModelProperty(value = "")

  public Organization getOrganization() {
    return organization;
  }


  public void setOrganization(Organization organization) {
    this.organization = organization;
  }


  public LegalEntityInfo reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * Your reference for the legal entity, maximum 150 characters.
   * @return reference
  **/
  @ApiModelProperty(value = "Your reference for the legal entity, maximum 150 characters.")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public LegalEntityInfo soleProprietorship(SoleProprietorship soleProprietorship) {
    
    this.soleProprietorship = soleProprietorship;
    return this;
  }

   /**
   * Get soleProprietorship
   * @return soleProprietorship
  **/
  @ApiModelProperty(value = "")

  public SoleProprietorship getSoleProprietorship() {
    return soleProprietorship;
  }


  public void setSoleProprietorship(SoleProprietorship soleProprietorship) {
    this.soleProprietorship = soleProprietorship;
  }


  public LegalEntityInfo type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of legal entity.   Possible values: **individual**, **organization**, or **soleProprietorship**.
   * @return type
  **/
  @ApiModelProperty(value = "The type of legal entity.   Possible values: **individual**, **organization**, or **soleProprietorship**.")

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LegalEntityInfo legalEntityInfo = (LegalEntityInfo) o;
    return Objects.equals(this.capabilities, legalEntityInfo.capabilities) &&
        Objects.equals(this.entityAssociations, legalEntityInfo.entityAssociations) &&
        Objects.equals(this.individual, legalEntityInfo.individual) &&
        Objects.equals(this.organization, legalEntityInfo.organization) &&
        Objects.equals(this.reference, legalEntityInfo.reference) &&
        Objects.equals(this.soleProprietorship, legalEntityInfo.soleProprietorship) &&
        Objects.equals(this.type, legalEntityInfo.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(capabilities, entityAssociations, individual, organization, reference, soleProprietorship, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LegalEntityInfo {\n");
    sb.append("    capabilities: ").append(toIndentedString(capabilities)).append("\n");
    sb.append("    entityAssociations: ").append(toIndentedString(entityAssociations)).append("\n");
    sb.append("    individual: ").append(toIndentedString(individual)).append("\n");
    sb.append("    organization: ").append(toIndentedString(organization)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    soleProprietorship: ").append(toIndentedString(soleProprietorship)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("capabilities");
    openapiFields.add("entityAssociations");
    openapiFields.add("individual");
    openapiFields.add("organization");
    openapiFields.add("reference");
    openapiFields.add("soleProprietorship");
    openapiFields.add("type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(LegalEntityInfo.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to LegalEntityInfo
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (LegalEntityInfo.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in LegalEntityInfo is not found in the empty JSON string", LegalEntityInfo.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!LegalEntityInfo.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `LegalEntityInfo` properties.", entry.getKey()));
        }
      }
      JsonArray jsonArrayentityAssociations = jsonObj.getAsJsonArray("entityAssociations");
      if (jsonArrayentityAssociations != null) {
        // ensure the json data is an array
        if (!jsonObj.get("entityAssociations").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `entityAssociations` to be an array in the JSON string but got `%s`", jsonObj.get("entityAssociations").toString()));
        }

        // validate the optional field `entityAssociations` (array)
        for (int i = 0; i < jsonArrayentityAssociations.size(); i++) {
          LegalEntityAssociation.validateJsonObject(jsonArrayentityAssociations.get(i).getAsJsonObject());
        }
      }
      // validate the optional field `individual`
      if (jsonObj.getAsJsonObject("individual") != null) {
        Individual.validateJsonObject(jsonObj.getAsJsonObject("individual"));
      }
      // validate the optional field `organization`
      if (jsonObj.getAsJsonObject("organization") != null) {
        Organization.validateJsonObject(jsonObj.getAsJsonObject("organization"));
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      // validate the optional field `soleProprietorship`
      if (jsonObj.getAsJsonObject("soleProprietorship") != null) {
        SoleProprietorship.validateJsonObject(jsonObj.getAsJsonObject("soleProprietorship"));
      }
      // ensure the field type can be parsed to an enum value
      if (jsonObj.get("type") != null) {
        if(!jsonObj.get("type").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
        }
        TypeEnum.fromValue(jsonObj.get("type").getAsString());
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!LegalEntityInfo.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'LegalEntityInfo' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<LegalEntityInfo> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(LegalEntityInfo.class));

       return (TypeAdapter<T>) new TypeAdapter<LegalEntityInfo>() {
           @Override
           public void write(JsonWriter out, LegalEntityInfo value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public LegalEntityInfo read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of LegalEntityInfo given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of LegalEntityInfo
  * @throws IOException if the JSON string is invalid with respect to LegalEntityInfo
  */
  public static LegalEntityInfo fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, LegalEntityInfo.class);
  }

 /**
  * Convert an instance of LegalEntityInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

