/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * PayPalInfo
 */

public class PayPalInfo {
  public static final String SERIALIZED_NAME_DIRECT_CAPTURE = "directCapture";
  @SerializedName(SERIALIZED_NAME_DIRECT_CAPTURE)
  private Boolean directCapture;

  public static final String SERIALIZED_NAME_PAYER_ID = "payerId";
  @SerializedName(SERIALIZED_NAME_PAYER_ID)
  private String payerId;

  public static final String SERIALIZED_NAME_SUBJECT = "subject";
  @SerializedName(SERIALIZED_NAME_SUBJECT)
  private String subject;

  public PayPalInfo() { 
  }

  public PayPalInfo directCapture(Boolean directCapture) {
    
    this.directCapture = directCapture;
    return this;
  }

   /**
   * Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.
   * @return directCapture
  **/
  @ApiModelProperty(value = "Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.")

  public Boolean getDirectCapture() {
    return directCapture;
  }


  public void setDirectCapture(Boolean directCapture) {
    this.directCapture = directCapture;
  }


  public PayPalInfo payerId(String payerId) {
    
    this.payerId = payerId;
    return this;
  }

   /**
   * PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.
   * @return payerId
  **/
  @ApiModelProperty(required = true, value = "PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.")

  public String getPayerId() {
    return payerId;
  }


  public void setPayerId(String payerId) {
    this.payerId = payerId;
  }


  public PayPalInfo subject(String subject) {
    
    this.subject = subject;
    return this;
  }

   /**
   * Your business email address.
   * @return subject
  **/
  @ApiModelProperty(required = true, value = "Your business email address.")

  public String getSubject() {
    return subject;
  }


  public void setSubject(String subject) {
    this.subject = subject;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayPalInfo payPalInfo = (PayPalInfo) o;
    return Objects.equals(this.directCapture, payPalInfo.directCapture) &&
        Objects.equals(this.payerId, payPalInfo.payerId) &&
        Objects.equals(this.subject, payPalInfo.subject);
  }

  @Override
  public int hashCode() {
    return Objects.hash(directCapture, payerId, subject);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayPalInfo {\n");
    sb.append("    directCapture: ").append(toIndentedString(directCapture)).append("\n");
    sb.append("    payerId: ").append(toIndentedString(payerId)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("directCapture");
    openapiFields.add("payerId");
    openapiFields.add("subject");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("payerId");
    openapiRequiredFields.add("subject");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(PayPalInfo.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PayPalInfo
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (PayPalInfo.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PayPalInfo is not found in the empty JSON string", PayPalInfo.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!PayPalInfo.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PayPalInfo` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : PayPalInfo.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field payerId
      if (jsonObj.get("payerId") != null && !jsonObj.get("payerId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `payerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("payerId").toString()));
      }
      // validate the optional field subject
      if (jsonObj.get("subject") != null && !jsonObj.get("subject").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `subject` to be a primitive type in the JSON string but got `%s`", jsonObj.get("subject").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PayPalInfo.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PayPalInfo' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PayPalInfo> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PayPalInfo.class));

       return (TypeAdapter<T>) new TypeAdapter<PayPalInfo>() {
           @Override
           public void write(JsonWriter out, PayPalInfo value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PayPalInfo read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PayPalInfo given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PayPalInfo
  * @throws IOException if the JSON string is invalid with respect to PayPalInfo
  */
  public static PayPalInfo fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PayPalInfo.class);
  }

 /**
  * Convert an instance of PayPalInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

