/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.management.Links;
import com.adyen.model.management.StoreLocation;
import com.adyen.model.management.StoreSplitConfiguration;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * Store
 */

public class Store {
  public static final String SERIALIZED_NAME_LINKS = "_links";
  @SerializedName(SERIALIZED_NAME_LINKS)
  private Links links;

  public static final String SERIALIZED_NAME_ADDRESS = "address";
  @SerializedName(SERIALIZED_NAME_ADDRESS)
  private StoreLocation address;

  public static final String SERIALIZED_NAME_BUSINESS_LINE_IDS = "businessLineIds";
  @SerializedName(SERIALIZED_NAME_BUSINESS_LINE_IDS)
  private List<String> businessLineIds = null;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_EXTERNAL_REFERENCE_ID = "externalReferenceId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID)
  private String externalReferenceId;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_MERCHANT_ID = "merchantId";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ID)
  private String merchantId;

  public static final String SERIALIZED_NAME_PHONE_NUMBER = "phoneNumber";
  @SerializedName(SERIALIZED_NAME_PHONE_NUMBER)
  private String phoneNumber;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
  @SerializedName(SERIALIZED_NAME_SHOPPER_STATEMENT)
  private String shopperStatement;

  public static final String SERIALIZED_NAME_SPLIT_CONFIGURATION = "splitConfiguration";
  @SerializedName(SERIALIZED_NAME_SPLIT_CONFIGURATION)
  private StoreSplitConfiguration splitConfiguration;

  /**
   * The status of the store. Possible values are:  - **active**. This value is assigned automatically when a store is created.  - **inactive**. The terminals under the store are blocked from accepting new transactions, but capturing outstanding transactions is still possible. - **closed**. This status is irreversible. The terminals under the store are reassigned to the merchant inventory.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    ACTIVE("active"),
    
    CLOSED("closed"),
    
    INACTIVE("inactive");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public Store() { 
  }

  public Store links(Links links) {
    
    this.links = links;
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @ApiModelProperty(value = "")

  public Links getLinks() {
    return links;
  }


  public void setLinks(Links links) {
    this.links = links;
  }


  public Store address(StoreLocation address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @ApiModelProperty(value = "")

  public StoreLocation getAddress() {
    return address;
  }


  public void setAddress(StoreLocation address) {
    this.address = address;
  }


  public Store businessLineIds(List<String> businessLineIds) {
    
    this.businessLineIds = businessLineIds;
    return this;
  }

  public Store addBusinessLineIdsItem(String businessLineIdsItem) {
    if (this.businessLineIds == null) {
      this.businessLineIds = new ArrayList<>();
    }
    this.businessLineIds.add(businessLineIdsItem);
    return this;
  }

   /**
   * The unique identifiers of the [business lines](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/businesslines__resParam_id) that the store is associated with.  If not specified, the business line of the merchant account is used. Required when there are multiple business lines under the merchant account.
   * @return businessLineIds
  **/
  @ApiModelProperty(value = "The unique identifiers of the [business lines](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/businesslines__resParam_id) that the store is associated with.  If not specified, the business line of the merchant account is used. Required when there are multiple business lines under the merchant account.")

  public List<String> getBusinessLineIds() {
    return businessLineIds;
  }


  public void setBusinessLineIds(List<String> businessLineIds) {
    this.businessLineIds = businessLineIds;
  }


  public Store description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The description of the store.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the store.")

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public Store externalReferenceId(String externalReferenceId) {
    
    this.externalReferenceId = externalReferenceId;
    return this;
  }

   /**
   * When using the Zip payment method: The location ID that Zip has assigned to your store.
   * @return externalReferenceId
  **/
  @ApiModelProperty(value = "When using the Zip payment method: The location ID that Zip has assigned to your store.")

  public String getExternalReferenceId() {
    return externalReferenceId;
  }


  public void setExternalReferenceId(String externalReferenceId) {
    this.externalReferenceId = externalReferenceId;
  }


  public Store id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the store. This value is generated by Adyen.
   * @return id
  **/
  @ApiModelProperty(value = "The unique identifier of the store. This value is generated by Adyen.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public Store merchantId(String merchantId) {
    
    this.merchantId = merchantId;
    return this;
  }

   /**
   * The unique identifier of the merchant account that the store belongs to.
   * @return merchantId
  **/
  @ApiModelProperty(value = "The unique identifier of the merchant account that the store belongs to.")

  public String getMerchantId() {
    return merchantId;
  }


  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }


  public Store phoneNumber(String phoneNumber) {
    
    this.phoneNumber = phoneNumber;
    return this;
  }

   /**
   * The phone number of the store, including &#39;+&#39; and country code.
   * @return phoneNumber
  **/
  @ApiModelProperty(value = "The phone number of the store, including '+' and country code.")

  public String getPhoneNumber() {
    return phoneNumber;
  }


  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }


  public Store reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * A reference to recognize the store by. Also known as the store code.  Allowed characters: Lowercase and uppercase letters without diacritics, numbers 0 through 9, hyphen (-), and underscore (_)
   * @return reference
  **/
  @ApiModelProperty(value = "A reference to recognize the store by. Also known as the store code.  Allowed characters: Lowercase and uppercase letters without diacritics, numbers 0 through 9, hyphen (-), and underscore (_)")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public Store shopperStatement(String shopperStatement) {
    
    this.shopperStatement = shopperStatement;
    return this;
  }

   /**
   * The store name shown on the shopper&#39;s bank or credit card statement and on the shopper receipt.
   * @return shopperStatement
  **/
  @ApiModelProperty(value = "The store name shown on the shopper's bank or credit card statement and on the shopper receipt.")

  public String getShopperStatement() {
    return shopperStatement;
  }


  public void setShopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
  }


  public Store splitConfiguration(StoreSplitConfiguration splitConfiguration) {
    
    this.splitConfiguration = splitConfiguration;
    return this;
  }

   /**
   * Get splitConfiguration
   * @return splitConfiguration
  **/
  @ApiModelProperty(value = "")

  public StoreSplitConfiguration getSplitConfiguration() {
    return splitConfiguration;
  }


  public void setSplitConfiguration(StoreSplitConfiguration splitConfiguration) {
    this.splitConfiguration = splitConfiguration;
  }


  public Store status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * The status of the store. Possible values are:  - **active**. This value is assigned automatically when a store is created.  - **inactive**. The terminals under the store are blocked from accepting new transactions, but capturing outstanding transactions is still possible. - **closed**. This status is irreversible. The terminals under the store are reassigned to the merchant inventory.
   * @return status
  **/
  @ApiModelProperty(value = "The status of the store. Possible values are:  - **active**. This value is assigned automatically when a store is created.  - **inactive**. The terminals under the store are blocked from accepting new transactions, but capturing outstanding transactions is still possible. - **closed**. This status is irreversible. The terminals under the store are reassigned to the merchant inventory.")

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Store store = (Store) o;
    return Objects.equals(this.links, store.links) &&
        Objects.equals(this.address, store.address) &&
        Objects.equals(this.businessLineIds, store.businessLineIds) &&
        Objects.equals(this.description, store.description) &&
        Objects.equals(this.externalReferenceId, store.externalReferenceId) &&
        Objects.equals(this.id, store.id) &&
        Objects.equals(this.merchantId, store.merchantId) &&
        Objects.equals(this.phoneNumber, store.phoneNumber) &&
        Objects.equals(this.reference, store.reference) &&
        Objects.equals(this.shopperStatement, store.shopperStatement) &&
        Objects.equals(this.splitConfiguration, store.splitConfiguration) &&
        Objects.equals(this.status, store.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, address, businessLineIds, description, externalReferenceId, id, merchantId, phoneNumber, reference, shopperStatement, splitConfiguration, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Store {\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    businessLineIds: ").append(toIndentedString(businessLineIds)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    externalReferenceId: ").append(toIndentedString(externalReferenceId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    merchantId: ").append(toIndentedString(merchantId)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    shopperStatement: ").append(toIndentedString(shopperStatement)).append("\n");
    sb.append("    splitConfiguration: ").append(toIndentedString(splitConfiguration)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("_links");
    openapiFields.add("address");
    openapiFields.add("businessLineIds");
    openapiFields.add("description");
    openapiFields.add("externalReferenceId");
    openapiFields.add("id");
    openapiFields.add("merchantId");
    openapiFields.add("phoneNumber");
    openapiFields.add("reference");
    openapiFields.add("shopperStatement");
    openapiFields.add("splitConfiguration");
    openapiFields.add("status");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(Store.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Store
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Store.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Store is not found in the empty JSON string", Store.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Store.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Store` properties.", entry.getKey()));
        }
      }
      // validate the optional field `_links`
      if (jsonObj.getAsJsonObject("_links") != null) {
        Links.validateJsonObject(jsonObj.getAsJsonObject("_links"));
      }
      // validate the optional field `address`
      if (jsonObj.getAsJsonObject("address") != null) {
        StoreLocation.validateJsonObject(jsonObj.getAsJsonObject("address"));
      }
      // ensure the json data is an array
      if (jsonObj.get("businessLineIds") != null && !jsonObj.get("businessLineIds").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `businessLineIds` to be an array in the JSON string but got `%s`", jsonObj.get("businessLineIds").toString()));
      }
      // validate the optional field description
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // validate the optional field externalReferenceId
      if (jsonObj.get("externalReferenceId") != null && !jsonObj.get("externalReferenceId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `externalReferenceId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("externalReferenceId").toString()));
      }
      // validate the optional field id
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the optional field merchantId
      if (jsonObj.get("merchantId") != null && !jsonObj.get("merchantId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantId").toString()));
      }
      // validate the optional field phoneNumber
      if (jsonObj.get("phoneNumber") != null && !jsonObj.get("phoneNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `phoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("phoneNumber").toString()));
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      // validate the optional field shopperStatement
      if (jsonObj.get("shopperStatement") != null && !jsonObj.get("shopperStatement").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperStatement` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperStatement").toString()));
      }
      // validate the optional field `splitConfiguration`
      if (jsonObj.getAsJsonObject("splitConfiguration") != null) {
        StoreSplitConfiguration.validateJsonObject(jsonObj.getAsJsonObject("splitConfiguration"));
      }
      // ensure the field status can be parsed to an enum value
      if (jsonObj.get("status") != null) {
        if(!jsonObj.get("status").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
        }
        StatusEnum.fromValue(jsonObj.get("status").getAsString());
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Store.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Store' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Store> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Store.class));

       return (TypeAdapter<T>) new TypeAdapter<Store>() {
           @Override
           public void write(JsonWriter out, Store value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Store read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Store given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Store
  * @throws IOException if the JSON string is invalid with respect to Store
  */
  public static Store fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Store.class);
  }

 /**
  * Convert an instance of Store to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

