/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.management.ModelConfiguration;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * Surcharge
 */

public class Surcharge {
  public static final String SERIALIZED_NAME_ASK_CONFIRMATION = "askConfirmation";
  @SerializedName(SERIALIZED_NAME_ASK_CONFIRMATION)
  private Boolean askConfirmation;

  public static final String SERIALIZED_NAME_CONFIGURATIONS = "configurations";
  @SerializedName(SERIALIZED_NAME_CONFIGURATIONS)
  private List<ModelConfiguration> configurations = null;

  public Surcharge() { 
  }

  public Surcharge askConfirmation(Boolean askConfirmation) {
    
    this.askConfirmation = askConfirmation;
    return this;
  }

   /**
   * Show the surcharge details on the terminal, so the shopper can confirm.
   * @return askConfirmation
  **/
  @ApiModelProperty(value = "Show the surcharge details on the terminal, so the shopper can confirm.")

  public Boolean getAskConfirmation() {
    return askConfirmation;
  }


  public void setAskConfirmation(Boolean askConfirmation) {
    this.askConfirmation = askConfirmation;
  }


  public Surcharge configurations(List<ModelConfiguration> configurations) {
    
    this.configurations = configurations;
    return this;
  }

  public Surcharge addConfigurationsItem(ModelConfiguration configurationsItem) {
    if (this.configurations == null) {
      this.configurations = new ArrayList<>();
    }
    this.configurations.add(configurationsItem);
    return this;
  }

   /**
   * Surcharge fees or percentages for specific payment methods, funding sources (credit or debit), and currencies.
   * @return configurations
  **/
  @ApiModelProperty(value = "Surcharge fees or percentages for specific payment methods, funding sources (credit or debit), and currencies.")

  public List<ModelConfiguration> getConfigurations() {
    return configurations;
  }


  public void setConfigurations(List<ModelConfiguration> configurations) {
    this.configurations = configurations;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Surcharge surcharge = (Surcharge) o;
    return Objects.equals(this.askConfirmation, surcharge.askConfirmation) &&
        Objects.equals(this.configurations, surcharge.configurations);
  }

  @Override
  public int hashCode() {
    return Objects.hash(askConfirmation, configurations);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Surcharge {\n");
    sb.append("    askConfirmation: ").append(toIndentedString(askConfirmation)).append("\n");
    sb.append("    configurations: ").append(toIndentedString(configurations)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("askConfirmation");
    openapiFields.add("configurations");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(Surcharge.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Surcharge
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Surcharge.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Surcharge is not found in the empty JSON string", Surcharge.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Surcharge.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Surcharge` properties.", entry.getKey()));
        }
      }
      JsonArray jsonArrayconfigurations = jsonObj.getAsJsonArray("configurations");
      if (jsonArrayconfigurations != null) {
        // ensure the json data is an array
        if (!jsonObj.get("configurations").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `configurations` to be an array in the JSON string but got `%s`", jsonObj.get("configurations").toString()));
        }

        // validate the optional field `configurations` (array)
        for (int i = 0; i < jsonArrayconfigurations.size(); i++) {
          ModelConfiguration.validateJsonObject(jsonArrayconfigurations.get(i).getAsJsonObject());
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Surcharge.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Surcharge' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Surcharge> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Surcharge.class));

       return (TypeAdapter<T>) new TypeAdapter<Surcharge>() {
           @Override
           public void write(JsonWriter out, Surcharge value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Surcharge read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Surcharge given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Surcharge
  * @throws IOException if the JSON string is invalid with respect to Surcharge
  */
  public static Surcharge fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Surcharge.class);
  }

 /**
  * Convert an instance of Surcharge to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

