/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.payment.JSON;

/**
 * AdditionalDataOpenInvoice
 */

public class AdditionalDataOpenInvoice {
  public static final String SERIALIZED_NAME_OPENINVOICEDATA_MERCHANT_DATA = "openinvoicedata.merchantData";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_MERCHANT_DATA)
  private String openinvoicedataMerchantData;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_NUMBER_OF_LINES = "openinvoicedata.numberOfLines";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_NUMBER_OF_LINES)
  private String openinvoicedataNumberOfLines;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_RECIPIENT_FIRST_NAME = "openinvoicedata.recipientFirstName";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_RECIPIENT_FIRST_NAME)
  private String openinvoicedataRecipientFirstName;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_RECIPIENT_LAST_NAME = "openinvoicedata.recipientLastName";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_RECIPIENT_LAST_NAME)
  private String openinvoicedataRecipientLastName;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_CURRENCY_CODE = "openinvoicedataLine[itemNr].currencyCode";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_CURRENCY_CODE)
  private String openinvoicedataLineItemNrCurrencyCode;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_DESCRIPTION = "openinvoicedataLine[itemNr].description";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_DESCRIPTION)
  private String openinvoicedataLineItemNrDescription;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_ITEM_AMOUNT = "openinvoicedataLine[itemNr].itemAmount";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_ITEM_AMOUNT)
  private String openinvoicedataLineItemNrItemAmount;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_ITEM_ID = "openinvoicedataLine[itemNr].itemId";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_ITEM_ID)
  private String openinvoicedataLineItemNrItemId;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_ITEM_VAT_AMOUNT = "openinvoicedataLine[itemNr].itemVatAmount";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_ITEM_VAT_AMOUNT)
  private String openinvoicedataLineItemNrItemVatAmount;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_ITEM_VAT_PERCENTAGE = "openinvoicedataLine[itemNr].itemVatPercentage";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_ITEM_VAT_PERCENTAGE)
  private String openinvoicedataLineItemNrItemVatPercentage;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_NUMBER_OF_ITEMS = "openinvoicedataLine[itemNr].numberOfItems";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_NUMBER_OF_ITEMS)
  private String openinvoicedataLineItemNrNumberOfItems;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_RETURN_SHIPPING_COMPANY = "openinvoicedataLine[itemNr].returnShippingCompany";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_RETURN_SHIPPING_COMPANY)
  private String openinvoicedataLineItemNrReturnShippingCompany;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_RETURN_TRACKING_NUMBER = "openinvoicedataLine[itemNr].returnTrackingNumber";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_RETURN_TRACKING_NUMBER)
  private String openinvoicedataLineItemNrReturnTrackingNumber;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_RETURN_TRACKING_URI = "openinvoicedataLine[itemNr].returnTrackingUri";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_RETURN_TRACKING_URI)
  private String openinvoicedataLineItemNrReturnTrackingUri;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_SHIPPING_COMPANY = "openinvoicedataLine[itemNr].shippingCompany";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_SHIPPING_COMPANY)
  private String openinvoicedataLineItemNrShippingCompany;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_SHIPPING_METHOD = "openinvoicedataLine[itemNr].shippingMethod";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_SHIPPING_METHOD)
  private String openinvoicedataLineItemNrShippingMethod;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_TRACKING_NUMBER = "openinvoicedataLine[itemNr].trackingNumber";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_TRACKING_NUMBER)
  private String openinvoicedataLineItemNrTrackingNumber;

  public static final String SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_TRACKING_URI = "openinvoicedataLine[itemNr].trackingUri";
  @SerializedName(SERIALIZED_NAME_OPENINVOICEDATA_LINE_ITEM_NR_TRACKING_URI)
  private String openinvoicedataLineItemNrTrackingUri;

  public AdditionalDataOpenInvoice() { 
  }

  public AdditionalDataOpenInvoice openinvoicedataMerchantData(String openinvoicedataMerchantData) {
    
    this.openinvoicedataMerchantData = openinvoicedataMerchantData;
    return this;
  }

   /**
   * Holds different merchant data points like product, purchase, customer, and so on. It takes data in a Base64 encoded string.  The &#x60;merchantData&#x60; parameter needs to be added to the &#x60;openinvoicedata&#x60; signature at the end.  Since the field is optional, if it&#39;s not included it does not impact computing the merchant signature.  Applies only to Klarna.  You can contact Klarna for the format and structure of the string.
   * @return openinvoicedataMerchantData
  **/
  @ApiModelProperty(value = "Holds different merchant data points like product, purchase, customer, and so on. It takes data in a Base64 encoded string.  The `merchantData` parameter needs to be added to the `openinvoicedata` signature at the end.  Since the field is optional, if it's not included it does not impact computing the merchant signature.  Applies only to Klarna.  You can contact Klarna for the format and structure of the string.")

  public String getOpeninvoicedataMerchantData() {
    return openinvoicedataMerchantData;
  }


  public void setOpeninvoicedataMerchantData(String openinvoicedataMerchantData) {
    this.openinvoicedataMerchantData = openinvoicedataMerchantData;
  }


  public AdditionalDataOpenInvoice openinvoicedataNumberOfLines(String openinvoicedataNumberOfLines) {
    
    this.openinvoicedataNumberOfLines = openinvoicedataNumberOfLines;
    return this;
  }

   /**
   * The number of invoice lines included in &#x60;openinvoicedata&#x60;.  There needs to be at least one line, so &#x60;numberOfLines&#x60; needs to be at least 1.
   * @return openinvoicedataNumberOfLines
  **/
  @ApiModelProperty(value = "The number of invoice lines included in `openinvoicedata`.  There needs to be at least one line, so `numberOfLines` needs to be at least 1.")

  public String getOpeninvoicedataNumberOfLines() {
    return openinvoicedataNumberOfLines;
  }


  public void setOpeninvoicedataNumberOfLines(String openinvoicedataNumberOfLines) {
    this.openinvoicedataNumberOfLines = openinvoicedataNumberOfLines;
  }


  public AdditionalDataOpenInvoice openinvoicedataRecipientFirstName(String openinvoicedataRecipientFirstName) {
    
    this.openinvoicedataRecipientFirstName = openinvoicedataRecipientFirstName;
    return this;
  }

   /**
   * First name of the recipient. If the delivery address and the billing address are different, specify the &#x60;recipientFirstName&#x60; and &#x60;recipientLastName&#x60; to share the delivery address with Klarna. Otherwise, only the billing address is shared with Klarna.
   * @return openinvoicedataRecipientFirstName
  **/
  @ApiModelProperty(value = "First name of the recipient. If the delivery address and the billing address are different, specify the `recipientFirstName` and `recipientLastName` to share the delivery address with Klarna. Otherwise, only the billing address is shared with Klarna.")

  public String getOpeninvoicedataRecipientFirstName() {
    return openinvoicedataRecipientFirstName;
  }


  public void setOpeninvoicedataRecipientFirstName(String openinvoicedataRecipientFirstName) {
    this.openinvoicedataRecipientFirstName = openinvoicedataRecipientFirstName;
  }


  public AdditionalDataOpenInvoice openinvoicedataRecipientLastName(String openinvoicedataRecipientLastName) {
    
    this.openinvoicedataRecipientLastName = openinvoicedataRecipientLastName;
    return this;
  }

   /**
   * Last name of the recipient. If the delivery address and the billing address are different, specify the &#x60;recipientFirstName&#x60; and &#x60;recipientLastName&#x60; to share the delivery address with Klarna. Otherwise, only the billing address is shared with Klarna.
   * @return openinvoicedataRecipientLastName
  **/
  @ApiModelProperty(value = "Last name of the recipient. If the delivery address and the billing address are different, specify the `recipientFirstName` and `recipientLastName` to share the delivery address with Klarna. Otherwise, only the billing address is shared with Klarna.")

  public String getOpeninvoicedataRecipientLastName() {
    return openinvoicedataRecipientLastName;
  }


  public void setOpeninvoicedataRecipientLastName(String openinvoicedataRecipientLastName) {
    this.openinvoicedataRecipientLastName = openinvoicedataRecipientLastName;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrCurrencyCode(String openinvoicedataLineItemNrCurrencyCode) {
    
    this.openinvoicedataLineItemNrCurrencyCode = openinvoicedataLineItemNrCurrencyCode;
    return this;
  }

   /**
   * The three-character ISO currency code.
   * @return openinvoicedataLineItemNrCurrencyCode
  **/
  @ApiModelProperty(value = "The three-character ISO currency code.")

  public String getOpeninvoicedataLineItemNrCurrencyCode() {
    return openinvoicedataLineItemNrCurrencyCode;
  }


  public void setOpeninvoicedataLineItemNrCurrencyCode(String openinvoicedataLineItemNrCurrencyCode) {
    this.openinvoicedataLineItemNrCurrencyCode = openinvoicedataLineItemNrCurrencyCode;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrDescription(String openinvoicedataLineItemNrDescription) {
    
    this.openinvoicedataLineItemNrDescription = openinvoicedataLineItemNrDescription;
    return this;
  }

   /**
   * A text description of the product the invoice line refers to.
   * @return openinvoicedataLineItemNrDescription
  **/
  @ApiModelProperty(value = "A text description of the product the invoice line refers to.")

  public String getOpeninvoicedataLineItemNrDescription() {
    return openinvoicedataLineItemNrDescription;
  }


  public void setOpeninvoicedataLineItemNrDescription(String openinvoicedataLineItemNrDescription) {
    this.openinvoicedataLineItemNrDescription = openinvoicedataLineItemNrDescription;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrItemAmount(String openinvoicedataLineItemNrItemAmount) {
    
    this.openinvoicedataLineItemNrItemAmount = openinvoicedataLineItemNrItemAmount;
    return this;
  }

   /**
   * The price for one item in the invoice line, represented in minor units.  The due amount for the item, VAT excluded.
   * @return openinvoicedataLineItemNrItemAmount
  **/
  @ApiModelProperty(value = "The price for one item in the invoice line, represented in minor units.  The due amount for the item, VAT excluded.")

  public String getOpeninvoicedataLineItemNrItemAmount() {
    return openinvoicedataLineItemNrItemAmount;
  }


  public void setOpeninvoicedataLineItemNrItemAmount(String openinvoicedataLineItemNrItemAmount) {
    this.openinvoicedataLineItemNrItemAmount = openinvoicedataLineItemNrItemAmount;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrItemId(String openinvoicedataLineItemNrItemId) {
    
    this.openinvoicedataLineItemNrItemId = openinvoicedataLineItemNrItemId;
    return this;
  }

   /**
   * A unique id for this item. Required for RatePay if the description of each item is not unique.
   * @return openinvoicedataLineItemNrItemId
  **/
  @ApiModelProperty(value = "A unique id for this item. Required for RatePay if the description of each item is not unique.")

  public String getOpeninvoicedataLineItemNrItemId() {
    return openinvoicedataLineItemNrItemId;
  }


  public void setOpeninvoicedataLineItemNrItemId(String openinvoicedataLineItemNrItemId) {
    this.openinvoicedataLineItemNrItemId = openinvoicedataLineItemNrItemId;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrItemVatAmount(String openinvoicedataLineItemNrItemVatAmount) {
    
    this.openinvoicedataLineItemNrItemVatAmount = openinvoicedataLineItemNrItemVatAmount;
    return this;
  }

   /**
   * The VAT due for one item in the invoice line, represented in minor units.
   * @return openinvoicedataLineItemNrItemVatAmount
  **/
  @ApiModelProperty(value = "The VAT due for one item in the invoice line, represented in minor units.")

  public String getOpeninvoicedataLineItemNrItemVatAmount() {
    return openinvoicedataLineItemNrItemVatAmount;
  }


  public void setOpeninvoicedataLineItemNrItemVatAmount(String openinvoicedataLineItemNrItemVatAmount) {
    this.openinvoicedataLineItemNrItemVatAmount = openinvoicedataLineItemNrItemVatAmount;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrItemVatPercentage(String openinvoicedataLineItemNrItemVatPercentage) {
    
    this.openinvoicedataLineItemNrItemVatPercentage = openinvoicedataLineItemNrItemVatPercentage;
    return this;
  }

   /**
   * The VAT percentage for one item in the invoice line, represented in minor units.  For example, 19% VAT is specified as 1900.
   * @return openinvoicedataLineItemNrItemVatPercentage
  **/
  @ApiModelProperty(value = "The VAT percentage for one item in the invoice line, represented in minor units.  For example, 19% VAT is specified as 1900.")

  public String getOpeninvoicedataLineItemNrItemVatPercentage() {
    return openinvoicedataLineItemNrItemVatPercentage;
  }


  public void setOpeninvoicedataLineItemNrItemVatPercentage(String openinvoicedataLineItemNrItemVatPercentage) {
    this.openinvoicedataLineItemNrItemVatPercentage = openinvoicedataLineItemNrItemVatPercentage;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrNumberOfItems(String openinvoicedataLineItemNrNumberOfItems) {
    
    this.openinvoicedataLineItemNrNumberOfItems = openinvoicedataLineItemNrNumberOfItems;
    return this;
  }

   /**
   * The number of units purchased of a specific product.
   * @return openinvoicedataLineItemNrNumberOfItems
  **/
  @ApiModelProperty(value = "The number of units purchased of a specific product.")

  public String getOpeninvoicedataLineItemNrNumberOfItems() {
    return openinvoicedataLineItemNrNumberOfItems;
  }


  public void setOpeninvoicedataLineItemNrNumberOfItems(String openinvoicedataLineItemNrNumberOfItems) {
    this.openinvoicedataLineItemNrNumberOfItems = openinvoicedataLineItemNrNumberOfItems;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrReturnShippingCompany(String openinvoicedataLineItemNrReturnShippingCompany) {
    
    this.openinvoicedataLineItemNrReturnShippingCompany = openinvoicedataLineItemNrReturnShippingCompany;
    return this;
  }

   /**
   * Name of the shipping company handling the the return shipment.
   * @return openinvoicedataLineItemNrReturnShippingCompany
  **/
  @ApiModelProperty(value = "Name of the shipping company handling the the return shipment.")

  public String getOpeninvoicedataLineItemNrReturnShippingCompany() {
    return openinvoicedataLineItemNrReturnShippingCompany;
  }


  public void setOpeninvoicedataLineItemNrReturnShippingCompany(String openinvoicedataLineItemNrReturnShippingCompany) {
    this.openinvoicedataLineItemNrReturnShippingCompany = openinvoicedataLineItemNrReturnShippingCompany;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrReturnTrackingNumber(String openinvoicedataLineItemNrReturnTrackingNumber) {
    
    this.openinvoicedataLineItemNrReturnTrackingNumber = openinvoicedataLineItemNrReturnTrackingNumber;
    return this;
  }

   /**
   * The tracking number for the return of the shipment.
   * @return openinvoicedataLineItemNrReturnTrackingNumber
  **/
  @ApiModelProperty(value = "The tracking number for the return of the shipment.")

  public String getOpeninvoicedataLineItemNrReturnTrackingNumber() {
    return openinvoicedataLineItemNrReturnTrackingNumber;
  }


  public void setOpeninvoicedataLineItemNrReturnTrackingNumber(String openinvoicedataLineItemNrReturnTrackingNumber) {
    this.openinvoicedataLineItemNrReturnTrackingNumber = openinvoicedataLineItemNrReturnTrackingNumber;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrReturnTrackingUri(String openinvoicedataLineItemNrReturnTrackingUri) {
    
    this.openinvoicedataLineItemNrReturnTrackingUri = openinvoicedataLineItemNrReturnTrackingUri;
    return this;
  }

   /**
   * URI where the customer can track the return of their shipment.
   * @return openinvoicedataLineItemNrReturnTrackingUri
  **/
  @ApiModelProperty(value = "URI where the customer can track the return of their shipment.")

  public String getOpeninvoicedataLineItemNrReturnTrackingUri() {
    return openinvoicedataLineItemNrReturnTrackingUri;
  }


  public void setOpeninvoicedataLineItemNrReturnTrackingUri(String openinvoicedataLineItemNrReturnTrackingUri) {
    this.openinvoicedataLineItemNrReturnTrackingUri = openinvoicedataLineItemNrReturnTrackingUri;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrShippingCompany(String openinvoicedataLineItemNrShippingCompany) {
    
    this.openinvoicedataLineItemNrShippingCompany = openinvoicedataLineItemNrShippingCompany;
    return this;
  }

   /**
   * Name of the shipping company handling the delivery.
   * @return openinvoicedataLineItemNrShippingCompany
  **/
  @ApiModelProperty(value = "Name of the shipping company handling the delivery.")

  public String getOpeninvoicedataLineItemNrShippingCompany() {
    return openinvoicedataLineItemNrShippingCompany;
  }


  public void setOpeninvoicedataLineItemNrShippingCompany(String openinvoicedataLineItemNrShippingCompany) {
    this.openinvoicedataLineItemNrShippingCompany = openinvoicedataLineItemNrShippingCompany;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrShippingMethod(String openinvoicedataLineItemNrShippingMethod) {
    
    this.openinvoicedataLineItemNrShippingMethod = openinvoicedataLineItemNrShippingMethod;
    return this;
  }

   /**
   * Shipping method.
   * @return openinvoicedataLineItemNrShippingMethod
  **/
  @ApiModelProperty(value = "Shipping method.")

  public String getOpeninvoicedataLineItemNrShippingMethod() {
    return openinvoicedataLineItemNrShippingMethod;
  }


  public void setOpeninvoicedataLineItemNrShippingMethod(String openinvoicedataLineItemNrShippingMethod) {
    this.openinvoicedataLineItemNrShippingMethod = openinvoicedataLineItemNrShippingMethod;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrTrackingNumber(String openinvoicedataLineItemNrTrackingNumber) {
    
    this.openinvoicedataLineItemNrTrackingNumber = openinvoicedataLineItemNrTrackingNumber;
    return this;
  }

   /**
   * The tracking number for the shipment.
   * @return openinvoicedataLineItemNrTrackingNumber
  **/
  @ApiModelProperty(value = "The tracking number for the shipment.")

  public String getOpeninvoicedataLineItemNrTrackingNumber() {
    return openinvoicedataLineItemNrTrackingNumber;
  }


  public void setOpeninvoicedataLineItemNrTrackingNumber(String openinvoicedataLineItemNrTrackingNumber) {
    this.openinvoicedataLineItemNrTrackingNumber = openinvoicedataLineItemNrTrackingNumber;
  }


  public AdditionalDataOpenInvoice openinvoicedataLineItemNrTrackingUri(String openinvoicedataLineItemNrTrackingUri) {
    
    this.openinvoicedataLineItemNrTrackingUri = openinvoicedataLineItemNrTrackingUri;
    return this;
  }

   /**
   * URI where the customer can track their shipment.
   * @return openinvoicedataLineItemNrTrackingUri
  **/
  @ApiModelProperty(value = "URI where the customer can track their shipment.")

  public String getOpeninvoicedataLineItemNrTrackingUri() {
    return openinvoicedataLineItemNrTrackingUri;
  }


  public void setOpeninvoicedataLineItemNrTrackingUri(String openinvoicedataLineItemNrTrackingUri) {
    this.openinvoicedataLineItemNrTrackingUri = openinvoicedataLineItemNrTrackingUri;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdditionalDataOpenInvoice additionalDataOpenInvoice = (AdditionalDataOpenInvoice) o;
    return Objects.equals(this.openinvoicedataMerchantData, additionalDataOpenInvoice.openinvoicedataMerchantData) &&
        Objects.equals(this.openinvoicedataNumberOfLines, additionalDataOpenInvoice.openinvoicedataNumberOfLines) &&
        Objects.equals(this.openinvoicedataRecipientFirstName, additionalDataOpenInvoice.openinvoicedataRecipientFirstName) &&
        Objects.equals(this.openinvoicedataRecipientLastName, additionalDataOpenInvoice.openinvoicedataRecipientLastName) &&
        Objects.equals(this.openinvoicedataLineItemNrCurrencyCode, additionalDataOpenInvoice.openinvoicedataLineItemNrCurrencyCode) &&
        Objects.equals(this.openinvoicedataLineItemNrDescription, additionalDataOpenInvoice.openinvoicedataLineItemNrDescription) &&
        Objects.equals(this.openinvoicedataLineItemNrItemAmount, additionalDataOpenInvoice.openinvoicedataLineItemNrItemAmount) &&
        Objects.equals(this.openinvoicedataLineItemNrItemId, additionalDataOpenInvoice.openinvoicedataLineItemNrItemId) &&
        Objects.equals(this.openinvoicedataLineItemNrItemVatAmount, additionalDataOpenInvoice.openinvoicedataLineItemNrItemVatAmount) &&
        Objects.equals(this.openinvoicedataLineItemNrItemVatPercentage, additionalDataOpenInvoice.openinvoicedataLineItemNrItemVatPercentage) &&
        Objects.equals(this.openinvoicedataLineItemNrNumberOfItems, additionalDataOpenInvoice.openinvoicedataLineItemNrNumberOfItems) &&
        Objects.equals(this.openinvoicedataLineItemNrReturnShippingCompany, additionalDataOpenInvoice.openinvoicedataLineItemNrReturnShippingCompany) &&
        Objects.equals(this.openinvoicedataLineItemNrReturnTrackingNumber, additionalDataOpenInvoice.openinvoicedataLineItemNrReturnTrackingNumber) &&
        Objects.equals(this.openinvoicedataLineItemNrReturnTrackingUri, additionalDataOpenInvoice.openinvoicedataLineItemNrReturnTrackingUri) &&
        Objects.equals(this.openinvoicedataLineItemNrShippingCompany, additionalDataOpenInvoice.openinvoicedataLineItemNrShippingCompany) &&
        Objects.equals(this.openinvoicedataLineItemNrShippingMethod, additionalDataOpenInvoice.openinvoicedataLineItemNrShippingMethod) &&
        Objects.equals(this.openinvoicedataLineItemNrTrackingNumber, additionalDataOpenInvoice.openinvoicedataLineItemNrTrackingNumber) &&
        Objects.equals(this.openinvoicedataLineItemNrTrackingUri, additionalDataOpenInvoice.openinvoicedataLineItemNrTrackingUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(openinvoicedataMerchantData, openinvoicedataNumberOfLines, openinvoicedataRecipientFirstName, openinvoicedataRecipientLastName, openinvoicedataLineItemNrCurrencyCode, openinvoicedataLineItemNrDescription, openinvoicedataLineItemNrItemAmount, openinvoicedataLineItemNrItemId, openinvoicedataLineItemNrItemVatAmount, openinvoicedataLineItemNrItemVatPercentage, openinvoicedataLineItemNrNumberOfItems, openinvoicedataLineItemNrReturnShippingCompany, openinvoicedataLineItemNrReturnTrackingNumber, openinvoicedataLineItemNrReturnTrackingUri, openinvoicedataLineItemNrShippingCompany, openinvoicedataLineItemNrShippingMethod, openinvoicedataLineItemNrTrackingNumber, openinvoicedataLineItemNrTrackingUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdditionalDataOpenInvoice {\n");
    sb.append("    openinvoicedataMerchantData: ").append(toIndentedString(openinvoicedataMerchantData)).append("\n");
    sb.append("    openinvoicedataNumberOfLines: ").append(toIndentedString(openinvoicedataNumberOfLines)).append("\n");
    sb.append("    openinvoicedataRecipientFirstName: ").append(toIndentedString(openinvoicedataRecipientFirstName)).append("\n");
    sb.append("    openinvoicedataRecipientLastName: ").append(toIndentedString(openinvoicedataRecipientLastName)).append("\n");
    sb.append("    openinvoicedataLineItemNrCurrencyCode: ").append(toIndentedString(openinvoicedataLineItemNrCurrencyCode)).append("\n");
    sb.append("    openinvoicedataLineItemNrDescription: ").append(toIndentedString(openinvoicedataLineItemNrDescription)).append("\n");
    sb.append("    openinvoicedataLineItemNrItemAmount: ").append(toIndentedString(openinvoicedataLineItemNrItemAmount)).append("\n");
    sb.append("    openinvoicedataLineItemNrItemId: ").append(toIndentedString(openinvoicedataLineItemNrItemId)).append("\n");
    sb.append("    openinvoicedataLineItemNrItemVatAmount: ").append(toIndentedString(openinvoicedataLineItemNrItemVatAmount)).append("\n");
    sb.append("    openinvoicedataLineItemNrItemVatPercentage: ").append(toIndentedString(openinvoicedataLineItemNrItemVatPercentage)).append("\n");
    sb.append("    openinvoicedataLineItemNrNumberOfItems: ").append(toIndentedString(openinvoicedataLineItemNrNumberOfItems)).append("\n");
    sb.append("    openinvoicedataLineItemNrReturnShippingCompany: ").append(toIndentedString(openinvoicedataLineItemNrReturnShippingCompany)).append("\n");
    sb.append("    openinvoicedataLineItemNrReturnTrackingNumber: ").append(toIndentedString(openinvoicedataLineItemNrReturnTrackingNumber)).append("\n");
    sb.append("    openinvoicedataLineItemNrReturnTrackingUri: ").append(toIndentedString(openinvoicedataLineItemNrReturnTrackingUri)).append("\n");
    sb.append("    openinvoicedataLineItemNrShippingCompany: ").append(toIndentedString(openinvoicedataLineItemNrShippingCompany)).append("\n");
    sb.append("    openinvoicedataLineItemNrShippingMethod: ").append(toIndentedString(openinvoicedataLineItemNrShippingMethod)).append("\n");
    sb.append("    openinvoicedataLineItemNrTrackingNumber: ").append(toIndentedString(openinvoicedataLineItemNrTrackingNumber)).append("\n");
    sb.append("    openinvoicedataLineItemNrTrackingUri: ").append(toIndentedString(openinvoicedataLineItemNrTrackingUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("openinvoicedata.merchantData");
    openapiFields.add("openinvoicedata.numberOfLines");
    openapiFields.add("openinvoicedata.recipientFirstName");
    openapiFields.add("openinvoicedata.recipientLastName");
    openapiFields.add("openinvoicedataLine[itemNr].currencyCode");
    openapiFields.add("openinvoicedataLine[itemNr].description");
    openapiFields.add("openinvoicedataLine[itemNr].itemAmount");
    openapiFields.add("openinvoicedataLine[itemNr].itemId");
    openapiFields.add("openinvoicedataLine[itemNr].itemVatAmount");
    openapiFields.add("openinvoicedataLine[itemNr].itemVatPercentage");
    openapiFields.add("openinvoicedataLine[itemNr].numberOfItems");
    openapiFields.add("openinvoicedataLine[itemNr].returnShippingCompany");
    openapiFields.add("openinvoicedataLine[itemNr].returnTrackingNumber");
    openapiFields.add("openinvoicedataLine[itemNr].returnTrackingUri");
    openapiFields.add("openinvoicedataLine[itemNr].shippingCompany");
    openapiFields.add("openinvoicedataLine[itemNr].shippingMethod");
    openapiFields.add("openinvoicedataLine[itemNr].trackingNumber");
    openapiFields.add("openinvoicedataLine[itemNr].trackingUri");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(AdditionalDataOpenInvoice.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to AdditionalDataOpenInvoice
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (AdditionalDataOpenInvoice.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in AdditionalDataOpenInvoice is not found in the empty JSON string", AdditionalDataOpenInvoice.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!AdditionalDataOpenInvoice.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `AdditionalDataOpenInvoice` properties.", entry.getKey()));
        }
      }
      // validate the optional field openinvoicedata.merchantData
      if (jsonObj.get("openinvoicedata.merchantData") != null && !jsonObj.get("openinvoicedata.merchantData").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedata.merchantData` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedata.merchantData").toString()));
      }
      // validate the optional field openinvoicedata.numberOfLines
      if (jsonObj.get("openinvoicedata.numberOfLines") != null && !jsonObj.get("openinvoicedata.numberOfLines").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedata.numberOfLines` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedata.numberOfLines").toString()));
      }
      // validate the optional field openinvoicedata.recipientFirstName
      if (jsonObj.get("openinvoicedata.recipientFirstName") != null && !jsonObj.get("openinvoicedata.recipientFirstName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedata.recipientFirstName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedata.recipientFirstName").toString()));
      }
      // validate the optional field openinvoicedata.recipientLastName
      if (jsonObj.get("openinvoicedata.recipientLastName") != null && !jsonObj.get("openinvoicedata.recipientLastName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedata.recipientLastName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedata.recipientLastName").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].currencyCode
      if (jsonObj.get("openinvoicedataLine[itemNr].currencyCode") != null && !jsonObj.get("openinvoicedataLine[itemNr].currencyCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].currencyCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].currencyCode").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].description
      if (jsonObj.get("openinvoicedataLine[itemNr].description") != null && !jsonObj.get("openinvoicedataLine[itemNr].description").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].description").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].itemAmount
      if (jsonObj.get("openinvoicedataLine[itemNr].itemAmount") != null && !jsonObj.get("openinvoicedataLine[itemNr].itemAmount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].itemAmount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].itemAmount").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].itemId
      if (jsonObj.get("openinvoicedataLine[itemNr].itemId") != null && !jsonObj.get("openinvoicedataLine[itemNr].itemId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].itemId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].itemId").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].itemVatAmount
      if (jsonObj.get("openinvoicedataLine[itemNr].itemVatAmount") != null && !jsonObj.get("openinvoicedataLine[itemNr].itemVatAmount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].itemVatAmount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].itemVatAmount").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].itemVatPercentage
      if (jsonObj.get("openinvoicedataLine[itemNr].itemVatPercentage") != null && !jsonObj.get("openinvoicedataLine[itemNr].itemVatPercentage").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].itemVatPercentage` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].itemVatPercentage").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].numberOfItems
      if (jsonObj.get("openinvoicedataLine[itemNr].numberOfItems") != null && !jsonObj.get("openinvoicedataLine[itemNr].numberOfItems").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].numberOfItems` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].numberOfItems").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].returnShippingCompany
      if (jsonObj.get("openinvoicedataLine[itemNr].returnShippingCompany") != null && !jsonObj.get("openinvoicedataLine[itemNr].returnShippingCompany").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].returnShippingCompany` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].returnShippingCompany").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].returnTrackingNumber
      if (jsonObj.get("openinvoicedataLine[itemNr].returnTrackingNumber") != null && !jsonObj.get("openinvoicedataLine[itemNr].returnTrackingNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].returnTrackingNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].returnTrackingNumber").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].returnTrackingUri
      if (jsonObj.get("openinvoicedataLine[itemNr].returnTrackingUri") != null && !jsonObj.get("openinvoicedataLine[itemNr].returnTrackingUri").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].returnTrackingUri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].returnTrackingUri").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].shippingCompany
      if (jsonObj.get("openinvoicedataLine[itemNr].shippingCompany") != null && !jsonObj.get("openinvoicedataLine[itemNr].shippingCompany").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].shippingCompany` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].shippingCompany").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].shippingMethod
      if (jsonObj.get("openinvoicedataLine[itemNr].shippingMethod") != null && !jsonObj.get("openinvoicedataLine[itemNr].shippingMethod").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].shippingMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].shippingMethod").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].trackingNumber
      if (jsonObj.get("openinvoicedataLine[itemNr].trackingNumber") != null && !jsonObj.get("openinvoicedataLine[itemNr].trackingNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].trackingNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].trackingNumber").toString()));
      }
      // validate the optional field openinvoicedataLine[itemNr].trackingUri
      if (jsonObj.get("openinvoicedataLine[itemNr].trackingUri") != null && !jsonObj.get("openinvoicedataLine[itemNr].trackingUri").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `openinvoicedataLine[itemNr].trackingUri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("openinvoicedataLine[itemNr].trackingUri").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AdditionalDataOpenInvoice.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AdditionalDataOpenInvoice' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AdditionalDataOpenInvoice> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AdditionalDataOpenInvoice.class));

       return (TypeAdapter<T>) new TypeAdapter<AdditionalDataOpenInvoice>() {
           @Override
           public void write(JsonWriter out, AdditionalDataOpenInvoice value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AdditionalDataOpenInvoice read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AdditionalDataOpenInvoice given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AdditionalDataOpenInvoice
  * @throws IOException if the JSON string is invalid with respect to AdditionalDataOpenInvoice
  */
  public static AdditionalDataOpenInvoice fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AdditionalDataOpenInvoice.class);
  }

 /**
  * Convert an instance of AdditionalDataOpenInvoice to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

