/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.payment.JSON;

/**
 * PlatformChargebackLogic
 */

public class PlatformChargebackLogic {
  /**
   * The method of handling the chargeback.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.
   */
  @JsonAdapter(BehaviorEnum.Adapter.class)
  public enum BehaviorEnum {
    DEDUCTACCORDINGTOSPLITRATIO("deductAccordingToSplitRatio"),
    
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    BehaviorEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BehaviorEnum fromValue(String value) {
      for (BehaviorEnum b : BehaviorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BehaviorEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BehaviorEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BehaviorEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BehaviorEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BEHAVIOR = "behavior";
  @SerializedName(SERIALIZED_NAME_BEHAVIOR)
  private BehaviorEnum behavior;

  public static final String SERIALIZED_NAME_COST_ALLOCATION_ACCOUNT = "costAllocationAccount";
  @SerializedName(SERIALIZED_NAME_COST_ALLOCATION_ACCOUNT)
  private String costAllocationAccount;

  public static final String SERIALIZED_NAME_TARGET_ACCOUNT = "targetAccount";
  @SerializedName(SERIALIZED_NAME_TARGET_ACCOUNT)
  private String targetAccount;

  public PlatformChargebackLogic() { 
  }

  public PlatformChargebackLogic behavior(BehaviorEnum behavior) {
    
    this.behavior = behavior;
    return this;
  }

   /**
   * The method of handling the chargeback.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.
   * @return behavior
  **/
  @ApiModelProperty(value = "The method of handling the chargeback.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.")

  public BehaviorEnum getBehavior() {
    return behavior;
  }


  public void setBehavior(BehaviorEnum behavior) {
    this.behavior = behavior;
  }


  public PlatformChargebackLogic costAllocationAccount(String costAllocationAccount) {
    
    this.costAllocationAccount = costAllocationAccount;
    return this;
  }

   /**
   * The unique identifier of the balance account to which the chargeback fees are booked. By default, the chargeback fees are booked to your liable balance account.
   * @return costAllocationAccount
  **/
  @ApiModelProperty(value = "The unique identifier of the balance account to which the chargeback fees are booked. By default, the chargeback fees are booked to your liable balance account.")

  public String getCostAllocationAccount() {
    return costAllocationAccount;
  }


  public void setCostAllocationAccount(String costAllocationAccount) {
    this.costAllocationAccount = costAllocationAccount;
  }


  public PlatformChargebackLogic targetAccount(String targetAccount) {
    
    this.targetAccount = targetAccount;
    return this;
  }

   /**
   * The unique identifier of the balance account against which the disputed amount is booked.  Required if &#x60;behavior&#x60; is **deductFromOneBalanceAccount**.
   * @return targetAccount
  **/
  @ApiModelProperty(value = "The unique identifier of the balance account against which the disputed amount is booked.  Required if `behavior` is **deductFromOneBalanceAccount**.")

  public String getTargetAccount() {
    return targetAccount;
  }


  public void setTargetAccount(String targetAccount) {
    this.targetAccount = targetAccount;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PlatformChargebackLogic platformChargebackLogic = (PlatformChargebackLogic) o;
    return Objects.equals(this.behavior, platformChargebackLogic.behavior) &&
        Objects.equals(this.costAllocationAccount, platformChargebackLogic.costAllocationAccount) &&
        Objects.equals(this.targetAccount, platformChargebackLogic.targetAccount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(behavior, costAllocationAccount, targetAccount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PlatformChargebackLogic {\n");
    sb.append("    behavior: ").append(toIndentedString(behavior)).append("\n");
    sb.append("    costAllocationAccount: ").append(toIndentedString(costAllocationAccount)).append("\n");
    sb.append("    targetAccount: ").append(toIndentedString(targetAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("behavior");
    openapiFields.add("costAllocationAccount");
    openapiFields.add("targetAccount");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(PlatformChargebackLogic.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PlatformChargebackLogic
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (PlatformChargebackLogic.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PlatformChargebackLogic is not found in the empty JSON string", PlatformChargebackLogic.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!PlatformChargebackLogic.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PlatformChargebackLogic` properties.", entry.getKey()));
        }
      }
      // ensure the field behavior can be parsed to an enum value
      if (jsonObj.get("behavior") != null) {
        if(!jsonObj.get("behavior").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `behavior` to be a primitive type in the JSON string but got `%s`", jsonObj.get("behavior").toString()));
        }
        BehaviorEnum.fromValue(jsonObj.get("behavior").getAsString());
      }
      // validate the optional field costAllocationAccount
      if (jsonObj.get("costAllocationAccount") != null && !jsonObj.get("costAllocationAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `costAllocationAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("costAllocationAccount").toString()));
      }
      // validate the optional field targetAccount
      if (jsonObj.get("targetAccount") != null && !jsonObj.get("targetAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `targetAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("targetAccount").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PlatformChargebackLogic.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PlatformChargebackLogic' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PlatformChargebackLogic> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PlatformChargebackLogic.class));

       return (TypeAdapter<T>) new TypeAdapter<PlatformChargebackLogic>() {
           @Override
           public void write(JsonWriter out, PlatformChargebackLogic value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PlatformChargebackLogic read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PlatformChargebackLogic given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PlatformChargebackLogic
  * @throws IOException if the JSON string is invalid with respect to PlatformChargebackLogic
  */
  public static PlatformChargebackLogic fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PlatformChargebackLogic.class);
  }

 /**
  * Convert an instance of PlatformChargebackLogic to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

