/*
 * POS Terminal Management API
 * This API provides endpoints for managing your point-of-sale (POS) payment terminals. You can use the API to obtain information about a specific terminal, retrieve overviews of your terminals and stores, and assign terminals to a merchant account or store.  For more information, refer to [Assign terminals](https://docs.adyen.com/point-of-sale/automating-terminal-management/assign-terminals-api).  ## Authentication Each request to the Terminal Management API must be signed with an API key. For this, obtain an API Key from your Customer Area, as described in [How to get the API key](https://docs.adyen.com/development-resources/api-credentials#generate-api-key). Then set this key to the `X-API-Key` header value, for example:  ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: Your_API_key\" \\ ... ``` Note that when going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning Terminal Management API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://postfmapi-test.adyen.com/postfmapi/terminal/v1/getTerminalsUnderAccount ``` When using versioned endpoints, Boolean response values are returned in string format: `\"true\"` or `\"false\"`. If you omit the version from the endpoint URL, Boolean response values are returned like this: `true` or `false`.
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.posterminalmanagement;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.posterminalmanagement.Store;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.posterminalmanagement.JSON;

/**
 * MerchantAccount
 */

public class MerchantAccount {
  public static final String SERIALIZED_NAME_IN_STORE_TERMINALS = "inStoreTerminals";
  @SerializedName(SERIALIZED_NAME_IN_STORE_TERMINALS)
  private List<String> inStoreTerminals = null;

  public static final String SERIALIZED_NAME_INVENTORY_TERMINALS = "inventoryTerminals";
  @SerializedName(SERIALIZED_NAME_INVENTORY_TERMINALS)
  private List<String> inventoryTerminals = null;

  public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ACCOUNT)
  private String merchantAccount;

  public static final String SERIALIZED_NAME_STORES = "stores";
  @SerializedName(SERIALIZED_NAME_STORES)
  private List<Store> stores = null;

  public MerchantAccount() { 
  }

  public MerchantAccount inStoreTerminals(List<String> inStoreTerminals) {
    
    this.inStoreTerminals = inStoreTerminals;
    return this;
  }

  public MerchantAccount addInStoreTerminalsItem(String inStoreTerminalsItem) {
    if (this.inStoreTerminals == null) {
      this.inStoreTerminals = new ArrayList<>();
    }
    this.inStoreTerminals.add(inStoreTerminalsItem);
    return this;
  }

   /**
   * List of terminals assigned to this merchant account as in-store terminals. This means that the terminal is ready to be boarded, or is already boarded.
   * @return inStoreTerminals
  **/
  @ApiModelProperty(value = "List of terminals assigned to this merchant account as in-store terminals. This means that the terminal is ready to be boarded, or is already boarded.")

  public List<String> getInStoreTerminals() {
    return inStoreTerminals;
  }


  public void setInStoreTerminals(List<String> inStoreTerminals) {
    this.inStoreTerminals = inStoreTerminals;
  }


  public MerchantAccount inventoryTerminals(List<String> inventoryTerminals) {
    
    this.inventoryTerminals = inventoryTerminals;
    return this;
  }

  public MerchantAccount addInventoryTerminalsItem(String inventoryTerminalsItem) {
    if (this.inventoryTerminals == null) {
      this.inventoryTerminals = new ArrayList<>();
    }
    this.inventoryTerminals.add(inventoryTerminalsItem);
    return this;
  }

   /**
   * List of terminals assigned to the inventory of this merchant account.
   * @return inventoryTerminals
  **/
  @ApiModelProperty(value = "List of terminals assigned to the inventory of this merchant account.")

  public List<String> getInventoryTerminals() {
    return inventoryTerminals;
  }


  public void setInventoryTerminals(List<String> inventoryTerminals) {
    this.inventoryTerminals = inventoryTerminals;
  }


  public MerchantAccount merchantAccount(String merchantAccount) {
    
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account.
   * @return merchantAccount
  **/
  @ApiModelProperty(required = true, value = "The merchant account.")

  public String getMerchantAccount() {
    return merchantAccount;
  }


  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public MerchantAccount stores(List<Store> stores) {
    
    this.stores = stores;
    return this;
  }

  public MerchantAccount addStoresItem(Store storesItem) {
    if (this.stores == null) {
      this.stores = new ArrayList<>();
    }
    this.stores.add(storesItem);
    return this;
  }

   /**
   * Array of stores under this merchant account.
   * @return stores
  **/
  @ApiModelProperty(value = "Array of stores under this merchant account.")

  public List<Store> getStores() {
    return stores;
  }


  public void setStores(List<Store> stores) {
    this.stores = stores;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantAccount merchantAccount = (MerchantAccount) o;
    return Objects.equals(this.inStoreTerminals, merchantAccount.inStoreTerminals) &&
        Objects.equals(this.inventoryTerminals, merchantAccount.inventoryTerminals) &&
        Objects.equals(this.merchantAccount, merchantAccount.merchantAccount) &&
        Objects.equals(this.stores, merchantAccount.stores);
  }

  @Override
  public int hashCode() {
    return Objects.hash(inStoreTerminals, inventoryTerminals, merchantAccount, stores);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantAccount {\n");
    sb.append("    inStoreTerminals: ").append(toIndentedString(inStoreTerminals)).append("\n");
    sb.append("    inventoryTerminals: ").append(toIndentedString(inventoryTerminals)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    stores: ").append(toIndentedString(stores)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("inStoreTerminals");
    openapiFields.add("inventoryTerminals");
    openapiFields.add("merchantAccount");
    openapiFields.add("stores");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("merchantAccount");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(MerchantAccount.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to MerchantAccount
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (MerchantAccount.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in MerchantAccount is not found in the empty JSON string", MerchantAccount.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!MerchantAccount.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `MerchantAccount` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : MerchantAccount.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // ensure the json data is an array
      if (jsonObj.get("inStoreTerminals") != null && !jsonObj.get("inStoreTerminals").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `inStoreTerminals` to be an array in the JSON string but got `%s`", jsonObj.get("inStoreTerminals").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("inventoryTerminals") != null && !jsonObj.get("inventoryTerminals").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `inventoryTerminals` to be an array in the JSON string but got `%s`", jsonObj.get("inventoryTerminals").toString()));
      }
      // validate the optional field merchantAccount
      if (jsonObj.get("merchantAccount") != null && !jsonObj.get("merchantAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantAccount").toString()));
      }
      JsonArray jsonArraystores = jsonObj.getAsJsonArray("stores");
      if (jsonArraystores != null) {
        // ensure the json data is an array
        if (!jsonObj.get("stores").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `stores` to be an array in the JSON string but got `%s`", jsonObj.get("stores").toString()));
        }

        // validate the optional field `stores` (array)
        for (int i = 0; i < jsonArraystores.size(); i++) {
          Store.validateJsonObject(jsonArraystores.get(i).getAsJsonObject());
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!MerchantAccount.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'MerchantAccount' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<MerchantAccount> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(MerchantAccount.class));

       return (TypeAdapter<T>) new TypeAdapter<MerchantAccount>() {
           @Override
           public void write(JsonWriter out, MerchantAccount value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public MerchantAccount read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of MerchantAccount given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of MerchantAccount
  * @throws IOException if the JSON string is invalid with respect to MerchantAccount
  */
  public static MerchantAccount fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, MerchantAccount.class);
  }

 /**
  * Convert an instance of MerchantAccount to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

