/*
 * Adyen Recurring API
 * The Recurring APIs allow you to manage and remove your tokens or saved payment details. Tokens should be created with validation during a payment request.  For more information, refer to our [Tokenization documentation](https://docs.adyen.com/online-payments/tokenization). ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Recurring API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Recurring/v68/disable ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Recurring/v68/disable ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.recurring;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.recurring.Amount;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.recurring.JSON;

/**
 * NotifyShopperRequest
 */

public class NotifyShopperRequest {
  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Amount amount;

  public static final String SERIALIZED_NAME_BILLING_DATE = "billingDate";
  @SerializedName(SERIALIZED_NAME_BILLING_DATE)
  private String billingDate;

  public static final String SERIALIZED_NAME_BILLING_SEQUENCE_NUMBER = "billingSequenceNumber";
  @SerializedName(SERIALIZED_NAME_BILLING_SEQUENCE_NUMBER)
  private String billingSequenceNumber;

  public static final String SERIALIZED_NAME_DISPLAYED_REFERENCE = "displayedReference";
  @SerializedName(SERIALIZED_NAME_DISPLAYED_REFERENCE)
  private String displayedReference;

  public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ACCOUNT)
  private String merchantAccount;

  public static final String SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
  @SerializedName(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE)
  private String recurringDetailReference;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
  @SerializedName(SERIALIZED_NAME_SHOPPER_REFERENCE)
  private String shopperReference;

  public static final String SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
  @SerializedName(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID)
  private String storedPaymentMethodId;

  public NotifyShopperRequest() { 
  }

  public NotifyShopperRequest amount(Amount amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "")

  public Amount getAmount() {
    return amount;
  }


  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public NotifyShopperRequest billingDate(String billingDate) {
    
    this.billingDate = billingDate;
    return this;
  }

   /**
   * Date on which the subscription amount will be debited from the shopper. In YYYY-MM-DD format
   * @return billingDate
  **/
  @ApiModelProperty(value = "Date on which the subscription amount will be debited from the shopper. In YYYY-MM-DD format")

  public String getBillingDate() {
    return billingDate;
  }


  public void setBillingDate(String billingDate) {
    this.billingDate = billingDate;
  }


  public NotifyShopperRequest billingSequenceNumber(String billingSequenceNumber) {
    
    this.billingSequenceNumber = billingSequenceNumber;
    return this;
  }

   /**
   * Sequence of the debit. Depends on Frequency and Billing Attempts Rule.
   * @return billingSequenceNumber
  **/
  @ApiModelProperty(value = "Sequence of the debit. Depends on Frequency and Billing Attempts Rule.")

  public String getBillingSequenceNumber() {
    return billingSequenceNumber;
  }


  public void setBillingSequenceNumber(String billingSequenceNumber) {
    this.billingSequenceNumber = billingSequenceNumber;
  }


  public NotifyShopperRequest displayedReference(String displayedReference) {
    
    this.displayedReference = displayedReference;
    return this;
  }

   /**
   * Reference of Pre-debit notification that is displayed to the shopper. Optional field. Maps to reference if missing
   * @return displayedReference
  **/
  @ApiModelProperty(value = "Reference of Pre-debit notification that is displayed to the shopper. Optional field. Maps to reference if missing")

  public String getDisplayedReference() {
    return displayedReference;
  }


  public void setDisplayedReference(String displayedReference) {
    this.displayedReference = displayedReference;
  }


  public NotifyShopperRequest merchantAccount(String merchantAccount) {
    
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account identifier with which you want to process the transaction.
   * @return merchantAccount
  **/
  @ApiModelProperty(required = true, value = "The merchant account identifier with which you want to process the transaction.")

  public String getMerchantAccount() {
    return merchantAccount;
  }


  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public NotifyShopperRequest recurringDetailReference(String recurringDetailReference) {
    
    this.recurringDetailReference = recurringDetailReference;
    return this;
  }

   /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   * @return recurringDetailReference
  **/
  @ApiModelProperty(value = "This is the `recurringDetailReference` returned in the response when you created the token.")

  public String getRecurringDetailReference() {
    return recurringDetailReference;
  }


  public void setRecurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
  }


  public NotifyShopperRequest reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * Pre-debit notification reference sent by the merchant. This is a mandatory field
   * @return reference
  **/
  @ApiModelProperty(required = true, value = "Pre-debit notification reference sent by the merchant. This is a mandatory field")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public NotifyShopperRequest shopperReference(String shopperReference) {
    
    this.shopperReference = shopperReference;
    return this;
  }

   /**
   * The ID that uniquely identifies the shopper.  This &#x60;shopperReference&#x60; must be the same as the &#x60;shopperReference&#x60; used in the initial payment.
   * @return shopperReference
  **/
  @ApiModelProperty(required = true, value = "The ID that uniquely identifies the shopper.  This `shopperReference` must be the same as the `shopperReference` used in the initial payment.")

  public String getShopperReference() {
    return shopperReference;
  }


  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }


  public NotifyShopperRequest storedPaymentMethodId(String storedPaymentMethodId) {
    
    this.storedPaymentMethodId = storedPaymentMethodId;
    return this;
  }

   /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   * @return storedPaymentMethodId
  **/
  @ApiModelProperty(value = "This is the `recurringDetailReference` returned in the response when you created the token.")

  public String getStoredPaymentMethodId() {
    return storedPaymentMethodId;
  }


  public void setStoredPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NotifyShopperRequest notifyShopperRequest = (NotifyShopperRequest) o;
    return Objects.equals(this.amount, notifyShopperRequest.amount) &&
        Objects.equals(this.billingDate, notifyShopperRequest.billingDate) &&
        Objects.equals(this.billingSequenceNumber, notifyShopperRequest.billingSequenceNumber) &&
        Objects.equals(this.displayedReference, notifyShopperRequest.displayedReference) &&
        Objects.equals(this.merchantAccount, notifyShopperRequest.merchantAccount) &&
        Objects.equals(this.recurringDetailReference, notifyShopperRequest.recurringDetailReference) &&
        Objects.equals(this.reference, notifyShopperRequest.reference) &&
        Objects.equals(this.shopperReference, notifyShopperRequest.shopperReference) &&
        Objects.equals(this.storedPaymentMethodId, notifyShopperRequest.storedPaymentMethodId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, billingDate, billingSequenceNumber, displayedReference, merchantAccount, recurringDetailReference, reference, shopperReference, storedPaymentMethodId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NotifyShopperRequest {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    billingDate: ").append(toIndentedString(billingDate)).append("\n");
    sb.append("    billingSequenceNumber: ").append(toIndentedString(billingSequenceNumber)).append("\n");
    sb.append("    displayedReference: ").append(toIndentedString(displayedReference)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    recurringDetailReference: ").append(toIndentedString(recurringDetailReference)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    storedPaymentMethodId: ").append(toIndentedString(storedPaymentMethodId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("amount");
    openapiFields.add("billingDate");
    openapiFields.add("billingSequenceNumber");
    openapiFields.add("displayedReference");
    openapiFields.add("merchantAccount");
    openapiFields.add("recurringDetailReference");
    openapiFields.add("reference");
    openapiFields.add("shopperReference");
    openapiFields.add("storedPaymentMethodId");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("amount");
    openapiRequiredFields.add("merchantAccount");
    openapiRequiredFields.add("reference");
    openapiRequiredFields.add("shopperReference");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(NotifyShopperRequest.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to NotifyShopperRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (NotifyShopperRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in NotifyShopperRequest is not found in the empty JSON string", NotifyShopperRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!NotifyShopperRequest.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `NotifyShopperRequest` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : NotifyShopperRequest.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field `amount`
      if (jsonObj.getAsJsonObject("amount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("amount"));
      }
      // validate the optional field billingDate
      if (jsonObj.get("billingDate") != null && !jsonObj.get("billingDate").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `billingDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("billingDate").toString()));
      }
      // validate the optional field billingSequenceNumber
      if (jsonObj.get("billingSequenceNumber") != null && !jsonObj.get("billingSequenceNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `billingSequenceNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("billingSequenceNumber").toString()));
      }
      // validate the optional field displayedReference
      if (jsonObj.get("displayedReference") != null && !jsonObj.get("displayedReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `displayedReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("displayedReference").toString()));
      }
      // validate the optional field merchantAccount
      if (jsonObj.get("merchantAccount") != null && !jsonObj.get("merchantAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantAccount").toString()));
      }
      // validate the optional field recurringDetailReference
      if (jsonObj.get("recurringDetailReference") != null && !jsonObj.get("recurringDetailReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurringDetailReference").toString()));
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      // validate the optional field shopperReference
      if (jsonObj.get("shopperReference") != null && !jsonObj.get("shopperReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperReference").toString()));
      }
      // validate the optional field storedPaymentMethodId
      if (jsonObj.get("storedPaymentMethodId") != null && !jsonObj.get("storedPaymentMethodId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `storedPaymentMethodId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("storedPaymentMethodId").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!NotifyShopperRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'NotifyShopperRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<NotifyShopperRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(NotifyShopperRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<NotifyShopperRequest>() {
           @Override
           public void write(JsonWriter out, NotifyShopperRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public NotifyShopperRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of NotifyShopperRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of NotifyShopperRequest
  * @throws IOException if the JSON string is invalid with respect to NotifyShopperRequest
  */
  public static NotifyShopperRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, NotifyShopperRequest.class);
  }

 /**
  * Convert an instance of NotifyShopperRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

