/*
 * Adyen Recurring API
 * The Recurring APIs allow you to manage and remove your tokens or saved payment details. Tokens should be created with validation during a payment request.  For more information, refer to our [Tokenization documentation](https://docs.adyen.com/online-payments/tokenization). ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Recurring API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Recurring/v68/disable ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Recurring/v68/disable ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.recurring;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.recurring.Address;
import com.adyen.model.recurring.BankAccount;
import com.adyen.model.recurring.Card;
import com.adyen.model.recurring.Name;
import com.adyen.model.recurring.TokenDetails;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.recurring.JSON;

/**
 * RecurringDetail
 */

public class RecurringDetail {
  public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
  @SerializedName(SERIALIZED_NAME_ADDITIONAL_DATA)
  private Map<String, String> additionalData = null;

  public static final String SERIALIZED_NAME_ALIAS = "alias";
  @SerializedName(SERIALIZED_NAME_ALIAS)
  private String alias;

  public static final String SERIALIZED_NAME_ALIAS_TYPE = "aliasType";
  @SerializedName(SERIALIZED_NAME_ALIAS_TYPE)
  private String aliasType;

  public static final String SERIALIZED_NAME_BANK = "bank";
  @SerializedName(SERIALIZED_NAME_BANK)
  private BankAccount bank;

  public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
  @SerializedName(SERIALIZED_NAME_BILLING_ADDRESS)
  private Address billingAddress;

  public static final String SERIALIZED_NAME_CARD = "card";
  @SerializedName(SERIALIZED_NAME_CARD)
  private Card card;

  public static final String SERIALIZED_NAME_CONTRACT_TYPES = "contractTypes";
  @SerializedName(SERIALIZED_NAME_CONTRACT_TYPES)
  private List<String> contractTypes = null;

  public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
  @SerializedName(SERIALIZED_NAME_CREATION_DATE)
  private OffsetDateTime creationDate;

  public static final String SERIALIZED_NAME_FIRST_PSP_REFERENCE = "firstPspReference";
  @SerializedName(SERIALIZED_NAME_FIRST_PSP_REFERENCE)
  private String firstPspReference;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NETWORK_TX_REFERENCE = "networkTxReference";
  @SerializedName(SERIALIZED_NAME_NETWORK_TX_REFERENCE)
  private String networkTxReference;

  public static final String SERIALIZED_NAME_PAYMENT_METHOD_VARIANT = "paymentMethodVariant";
  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD_VARIANT)
  private String paymentMethodVariant;

  public static final String SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
  @SerializedName(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE)
  private String recurringDetailReference;

  public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
  @SerializedName(SERIALIZED_NAME_SHOPPER_NAME)
  private Name shopperName;

  public static final String SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
  @SerializedName(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER)
  private String socialSecurityNumber;

  public static final String SERIALIZED_NAME_TOKEN_DETAILS = "tokenDetails";
  @SerializedName(SERIALIZED_NAME_TOKEN_DETAILS)
  private TokenDetails tokenDetails;

  public static final String SERIALIZED_NAME_VARIANT = "variant";
  @SerializedName(SERIALIZED_NAME_VARIANT)
  private String variant;

  public RecurringDetail() { 
  }

  public RecurringDetail additionalData(Map<String, String> additionalData) {
    
    this.additionalData = additionalData;
    return this;
  }

  public RecurringDetail putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

   /**
   * This field contains additional data, which may be returned in a particular response.  The additionalData object consists of entries, each of which includes the key and value.
   * @return additionalData
  **/
  @ApiModelProperty(value = "This field contains additional data, which may be returned in a particular response.  The additionalData object consists of entries, each of which includes the key and value.")

  public Map<String, String> getAdditionalData() {
    return additionalData;
  }


  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }


  public RecurringDetail alias(String alias) {
    
    this.alias = alias;
    return this;
  }

   /**
   * The alias of the credit card number.  Applies only to recurring contracts storing credit card details
   * @return alias
  **/
  @ApiModelProperty(value = "The alias of the credit card number.  Applies only to recurring contracts storing credit card details")

  public String getAlias() {
    return alias;
  }


  public void setAlias(String alias) {
    this.alias = alias;
  }


  public RecurringDetail aliasType(String aliasType) {
    
    this.aliasType = aliasType;
    return this;
  }

   /**
   * The alias type of the credit card number.  Applies only to recurring contracts storing credit card details.
   * @return aliasType
  **/
  @ApiModelProperty(value = "The alias type of the credit card number.  Applies only to recurring contracts storing credit card details.")

  public String getAliasType() {
    return aliasType;
  }


  public void setAliasType(String aliasType) {
    this.aliasType = aliasType;
  }


  public RecurringDetail bank(BankAccount bank) {
    
    this.bank = bank;
    return this;
  }

   /**
   * Get bank
   * @return bank
  **/
  @ApiModelProperty(value = "")

  public BankAccount getBank() {
    return bank;
  }


  public void setBank(BankAccount bank) {
    this.bank = bank;
  }


  public RecurringDetail billingAddress(Address billingAddress) {
    
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @ApiModelProperty(value = "")

  public Address getBillingAddress() {
    return billingAddress;
  }


  public void setBillingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
  }


  public RecurringDetail card(Card card) {
    
    this.card = card;
    return this;
  }

   /**
   * Get card
   * @return card
  **/
  @ApiModelProperty(value = "")

  public Card getCard() {
    return card;
  }


  public void setCard(Card card) {
    this.card = card;
  }


  public RecurringDetail contractTypes(List<String> contractTypes) {
    
    this.contractTypes = contractTypes;
    return this;
  }

  public RecurringDetail addContractTypesItem(String contractTypesItem) {
    if (this.contractTypes == null) {
      this.contractTypes = new ArrayList<>();
    }
    this.contractTypes.add(contractTypesItem);
    return this;
  }

   /**
   * Types of recurring contracts.
   * @return contractTypes
  **/
  @ApiModelProperty(value = "Types of recurring contracts.")

  public List<String> getContractTypes() {
    return contractTypes;
  }


  public void setContractTypes(List<String> contractTypes) {
    this.contractTypes = contractTypes;
  }


  public RecurringDetail creationDate(OffsetDateTime creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

   /**
   * The date when the recurring details were created.
   * @return creationDate
  **/
  @ApiModelProperty(value = "The date when the recurring details were created.")

  public OffsetDateTime getCreationDate() {
    return creationDate;
  }


  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }


  public RecurringDetail firstPspReference(String firstPspReference) {
    
    this.firstPspReference = firstPspReference;
    return this;
  }

   /**
   * The &#x60;pspReference&#x60; of the first recurring payment that created the recurring detail.
   * @return firstPspReference
  **/
  @ApiModelProperty(value = "The `pspReference` of the first recurring payment that created the recurring detail.")

  public String getFirstPspReference() {
    return firstPspReference;
  }


  public void setFirstPspReference(String firstPspReference) {
    this.firstPspReference = firstPspReference;
  }


  public RecurringDetail name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * An optional descriptive name for this recurring detail.
   * @return name
  **/
  @ApiModelProperty(value = "An optional descriptive name for this recurring detail.")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public RecurringDetail networkTxReference(String networkTxReference) {
    
    this.networkTxReference = networkTxReference;
    return this;
  }

   /**
   * Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.
   * @return networkTxReference
  **/
  @ApiModelProperty(value = "Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.")

  public String getNetworkTxReference() {
    return networkTxReference;
  }


  public void setNetworkTxReference(String networkTxReference) {
    this.networkTxReference = networkTxReference;
  }


  public RecurringDetail paymentMethodVariant(String paymentMethodVariant) {
    
    this.paymentMethodVariant = paymentMethodVariant;
    return this;
  }

   /**
   * The  type or sub-brand of a payment method used, e.g. Visa Debit, Visa Corporate, etc. For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).
   * @return paymentMethodVariant
  **/
  @ApiModelProperty(value = "The  type or sub-brand of a payment method used, e.g. Visa Debit, Visa Corporate, etc. For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).")

  public String getPaymentMethodVariant() {
    return paymentMethodVariant;
  }


  public void setPaymentMethodVariant(String paymentMethodVariant) {
    this.paymentMethodVariant = paymentMethodVariant;
  }


  public RecurringDetail recurringDetailReference(String recurringDetailReference) {
    
    this.recurringDetailReference = recurringDetailReference;
    return this;
  }

   /**
   * The reference that uniquely identifies the recurring detail.
   * @return recurringDetailReference
  **/
  @ApiModelProperty(required = true, value = "The reference that uniquely identifies the recurring detail.")

  public String getRecurringDetailReference() {
    return recurringDetailReference;
  }


  public void setRecurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
  }


  public RecurringDetail shopperName(Name shopperName) {
    
    this.shopperName = shopperName;
    return this;
  }

   /**
   * Get shopperName
   * @return shopperName
  **/
  @ApiModelProperty(value = "")

  public Name getShopperName() {
    return shopperName;
  }


  public void setShopperName(Name shopperName) {
    this.shopperName = shopperName;
  }


  public RecurringDetail socialSecurityNumber(String socialSecurityNumber) {
    
    this.socialSecurityNumber = socialSecurityNumber;
    return this;
  }

   /**
   * A shopper&#39;s social security number (only in countries where it is legal to collect).
   * @return socialSecurityNumber
  **/
  @ApiModelProperty(value = "A shopper's social security number (only in countries where it is legal to collect).")

  public String getSocialSecurityNumber() {
    return socialSecurityNumber;
  }


  public void setSocialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
  }


  public RecurringDetail tokenDetails(TokenDetails tokenDetails) {
    
    this.tokenDetails = tokenDetails;
    return this;
  }

   /**
   * Get tokenDetails
   * @return tokenDetails
  **/
  @ApiModelProperty(value = "")

  public TokenDetails getTokenDetails() {
    return tokenDetails;
  }


  public void setTokenDetails(TokenDetails tokenDetails) {
    this.tokenDetails = tokenDetails;
  }


  public RecurringDetail variant(String variant) {
    
    this.variant = variant;
    return this;
  }

   /**
   * The payment method, such as “mc\&quot;, \&quot;visa\&quot;, \&quot;ideal\&quot;, \&quot;paypal\&quot;.
   * @return variant
  **/
  @ApiModelProperty(required = true, value = "The payment method, such as “mc\", \"visa\", \"ideal\", \"paypal\".")

  public String getVariant() {
    return variant;
  }


  public void setVariant(String variant) {
    this.variant = variant;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RecurringDetail recurringDetail = (RecurringDetail) o;
    return Objects.equals(this.additionalData, recurringDetail.additionalData) &&
        Objects.equals(this.alias, recurringDetail.alias) &&
        Objects.equals(this.aliasType, recurringDetail.aliasType) &&
        Objects.equals(this.bank, recurringDetail.bank) &&
        Objects.equals(this.billingAddress, recurringDetail.billingAddress) &&
        Objects.equals(this.card, recurringDetail.card) &&
        Objects.equals(this.contractTypes, recurringDetail.contractTypes) &&
        Objects.equals(this.creationDate, recurringDetail.creationDate) &&
        Objects.equals(this.firstPspReference, recurringDetail.firstPspReference) &&
        Objects.equals(this.name, recurringDetail.name) &&
        Objects.equals(this.networkTxReference, recurringDetail.networkTxReference) &&
        Objects.equals(this.paymentMethodVariant, recurringDetail.paymentMethodVariant) &&
        Objects.equals(this.recurringDetailReference, recurringDetail.recurringDetailReference) &&
        Objects.equals(this.shopperName, recurringDetail.shopperName) &&
        Objects.equals(this.socialSecurityNumber, recurringDetail.socialSecurityNumber) &&
        Objects.equals(this.tokenDetails, recurringDetail.tokenDetails) &&
        Objects.equals(this.variant, recurringDetail.variant);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalData, alias, aliasType, bank, billingAddress, card, contractTypes, creationDate, firstPspReference, name, networkTxReference, paymentMethodVariant, recurringDetailReference, shopperName, socialSecurityNumber, tokenDetails, variant);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RecurringDetail {\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
    sb.append("    aliasType: ").append(toIndentedString(aliasType)).append("\n");
    sb.append("    bank: ").append(toIndentedString(bank)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("    contractTypes: ").append(toIndentedString(contractTypes)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    firstPspReference: ").append(toIndentedString(firstPspReference)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    networkTxReference: ").append(toIndentedString(networkTxReference)).append("\n");
    sb.append("    paymentMethodVariant: ").append(toIndentedString(paymentMethodVariant)).append("\n");
    sb.append("    recurringDetailReference: ").append(toIndentedString(recurringDetailReference)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    socialSecurityNumber: ").append(toIndentedString(socialSecurityNumber)).append("\n");
    sb.append("    tokenDetails: ").append(toIndentedString(tokenDetails)).append("\n");
    sb.append("    variant: ").append(toIndentedString(variant)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("additionalData");
    openapiFields.add("alias");
    openapiFields.add("aliasType");
    openapiFields.add("bank");
    openapiFields.add("billingAddress");
    openapiFields.add("card");
    openapiFields.add("contractTypes");
    openapiFields.add("creationDate");
    openapiFields.add("firstPspReference");
    openapiFields.add("name");
    openapiFields.add("networkTxReference");
    openapiFields.add("paymentMethodVariant");
    openapiFields.add("recurringDetailReference");
    openapiFields.add("shopperName");
    openapiFields.add("socialSecurityNumber");
    openapiFields.add("tokenDetails");
    openapiFields.add("variant");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("recurringDetailReference");
    openapiRequiredFields.add("variant");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(RecurringDetail.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to RecurringDetail
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (RecurringDetail.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in RecurringDetail is not found in the empty JSON string", RecurringDetail.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!RecurringDetail.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `RecurringDetail` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : RecurringDetail.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field alias
      if (jsonObj.get("alias") != null && !jsonObj.get("alias").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `alias` to be a primitive type in the JSON string but got `%s`", jsonObj.get("alias").toString()));
      }
      // validate the optional field aliasType
      if (jsonObj.get("aliasType") != null && !jsonObj.get("aliasType").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `aliasType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("aliasType").toString()));
      }
      // validate the optional field `bank`
      if (jsonObj.getAsJsonObject("bank") != null) {
        BankAccount.validateJsonObject(jsonObj.getAsJsonObject("bank"));
      }
      // validate the optional field `billingAddress`
      if (jsonObj.getAsJsonObject("billingAddress") != null) {
        Address.validateJsonObject(jsonObj.getAsJsonObject("billingAddress"));
      }
      // validate the optional field `card`
      if (jsonObj.getAsJsonObject("card") != null) {
        Card.validateJsonObject(jsonObj.getAsJsonObject("card"));
      }
      // ensure the json data is an array
      if (jsonObj.get("contractTypes") != null && !jsonObj.get("contractTypes").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `contractTypes` to be an array in the JSON string but got `%s`", jsonObj.get("contractTypes").toString()));
      }
      // validate the optional field firstPspReference
      if (jsonObj.get("firstPspReference") != null && !jsonObj.get("firstPspReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `firstPspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("firstPspReference").toString()));
      }
      // validate the optional field name
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // validate the optional field networkTxReference
      if (jsonObj.get("networkTxReference") != null && !jsonObj.get("networkTxReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `networkTxReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("networkTxReference").toString()));
      }
      // validate the optional field paymentMethodVariant
      if (jsonObj.get("paymentMethodVariant") != null && !jsonObj.get("paymentMethodVariant").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentMethodVariant` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentMethodVariant").toString()));
      }
      // validate the optional field recurringDetailReference
      if (jsonObj.get("recurringDetailReference") != null && !jsonObj.get("recurringDetailReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurringDetailReference").toString()));
      }
      // validate the optional field `shopperName`
      if (jsonObj.getAsJsonObject("shopperName") != null) {
        Name.validateJsonObject(jsonObj.getAsJsonObject("shopperName"));
      }
      // validate the optional field socialSecurityNumber
      if (jsonObj.get("socialSecurityNumber") != null && !jsonObj.get("socialSecurityNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `socialSecurityNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("socialSecurityNumber").toString()));
      }
      // validate the optional field `tokenDetails`
      if (jsonObj.getAsJsonObject("tokenDetails") != null) {
        TokenDetails.validateJsonObject(jsonObj.getAsJsonObject("tokenDetails"));
      }
      // validate the optional field variant
      if (jsonObj.get("variant") != null && !jsonObj.get("variant").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `variant` to be a primitive type in the JSON string but got `%s`", jsonObj.get("variant").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RecurringDetail.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RecurringDetail' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RecurringDetail> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RecurringDetail.class));

       return (TypeAdapter<T>) new TypeAdapter<RecurringDetail>() {
           @Override
           public void write(JsonWriter out, RecurringDetail value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RecurringDetail read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RecurringDetail given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RecurringDetail
  * @throws IOException if the JSON string is invalid with respect to RecurringDetail
  */
  public static RecurringDetail fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RecurringDetail.class);
  }

 /**
  * Convert an instance of RecurringDetail to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

