/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 3
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.transferwebhooks.TransactionEventViolation;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.transferwebhooks.JSON;

/**
 * TransactionRulesResult
 */

public class TransactionRulesResult {
  public static final String SERIALIZED_NAME_ADVICE = "advice";
  @SerializedName(SERIALIZED_NAME_ADVICE)
  private String advice;

  public static final String SERIALIZED_NAME_ALL_RULES_PASSED = "allRulesPassed";
  @SerializedName(SERIALIZED_NAME_ALL_RULES_PASSED)
  private Boolean allRulesPassed;

  public static final String SERIALIZED_NAME_FAILED_TRANSACTION_RULES = "failedTransactionRules";
  @SerializedName(SERIALIZED_NAME_FAILED_TRANSACTION_RULES)
  private List<TransactionEventViolation> failedTransactionRules = null;

  public static final String SERIALIZED_NAME_SCORE = "score";
  @SerializedName(SERIALIZED_NAME_SCORE)
  private Integer score;

  public TransactionRulesResult() { 
  }

  public TransactionRulesResult advice(String advice) {
    
    this.advice = advice;
    return this;
  }

   /**
   * The advice given by the Risk analysis.
   * @return advice
  **/
  @ApiModelProperty(value = "The advice given by the Risk analysis.")

  public String getAdvice() {
    return advice;
  }


  public void setAdvice(String advice) {
    this.advice = advice;
  }


  public TransactionRulesResult allRulesPassed(Boolean allRulesPassed) {
    
    this.allRulesPassed = allRulesPassed;
    return this;
  }

   /**
   * Indicates whether the transaction passed the evaluation for all transaction rules.
   * @return allRulesPassed
  **/
  @ApiModelProperty(value = "Indicates whether the transaction passed the evaluation for all transaction rules.")

  public Boolean getAllRulesPassed() {
    return allRulesPassed;
  }


  public void setAllRulesPassed(Boolean allRulesPassed) {
    this.allRulesPassed = allRulesPassed;
  }


  public TransactionRulesResult failedTransactionRules(List<TransactionEventViolation> failedTransactionRules) {
    
    this.failedTransactionRules = failedTransactionRules;
    return this;
  }

  public TransactionRulesResult addFailedTransactionRulesItem(TransactionEventViolation failedTransactionRulesItem) {
    if (this.failedTransactionRules == null) {
      this.failedTransactionRules = new ArrayList<>();
    }
    this.failedTransactionRules.add(failedTransactionRulesItem);
    return this;
  }

   /**
   * Array containing all the transaction rules that the transaction violated. This list is only sent when &#x60;allRulesPassed&#x60; is **false**.
   * @return failedTransactionRules
  **/
  @ApiModelProperty(value = "Array containing all the transaction rules that the transaction violated. This list is only sent when `allRulesPassed` is **false**.")

  public List<TransactionEventViolation> getFailedTransactionRules() {
    return failedTransactionRules;
  }


  public void setFailedTransactionRules(List<TransactionEventViolation> failedTransactionRules) {
    this.failedTransactionRules = failedTransactionRules;
  }


  public TransactionRulesResult score(Integer score) {
    
    this.score = score;
    return this;
  }

   /**
   * The score of the Risk analysis.
   * @return score
  **/
  @ApiModelProperty(value = "The score of the Risk analysis.")

  public Integer getScore() {
    return score;
  }


  public void setScore(Integer score) {
    this.score = score;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransactionRulesResult transactionRulesResult = (TransactionRulesResult) o;
    return Objects.equals(this.advice, transactionRulesResult.advice) &&
        Objects.equals(this.allRulesPassed, transactionRulesResult.allRulesPassed) &&
        Objects.equals(this.failedTransactionRules, transactionRulesResult.failedTransactionRules) &&
        Objects.equals(this.score, transactionRulesResult.score);
  }

  @Override
  public int hashCode() {
    return Objects.hash(advice, allRulesPassed, failedTransactionRules, score);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionRulesResult {\n");
    sb.append("    advice: ").append(toIndentedString(advice)).append("\n");
    sb.append("    allRulesPassed: ").append(toIndentedString(allRulesPassed)).append("\n");
    sb.append("    failedTransactionRules: ").append(toIndentedString(failedTransactionRules)).append("\n");
    sb.append("    score: ").append(toIndentedString(score)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("advice");
    openapiFields.add("allRulesPassed");
    openapiFields.add("failedTransactionRules");
    openapiFields.add("score");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(TransactionRulesResult.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TransactionRulesResult
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TransactionRulesResult.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TransactionRulesResult is not found in the empty JSON string", TransactionRulesResult.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!TransactionRulesResult.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TransactionRulesResult` properties.", entry.getKey()));
        }
      }
      // validate the optional field advice
      if (jsonObj.get("advice") != null && !jsonObj.get("advice").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `advice` to be a primitive type in the JSON string but got `%s`", jsonObj.get("advice").toString()));
      }
      JsonArray jsonArrayfailedTransactionRules = jsonObj.getAsJsonArray("failedTransactionRules");
      if (jsonArrayfailedTransactionRules != null) {
        // ensure the json data is an array
        if (!jsonObj.get("failedTransactionRules").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `failedTransactionRules` to be an array in the JSON string but got `%s`", jsonObj.get("failedTransactionRules").toString()));
        }

        // validate the optional field `failedTransactionRules` (array)
        for (int i = 0; i < jsonArrayfailedTransactionRules.size(); i++) {
          TransactionEventViolation.validateJsonObject(jsonArrayfailedTransactionRules.get(i).getAsJsonObject());
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TransactionRulesResult.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TransactionRulesResult' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TransactionRulesResult> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TransactionRulesResult.class));

       return (TypeAdapter<T>) new TypeAdapter<TransactionRulesResult>() {
           @Override
           public void write(JsonWriter out, TransactionRulesResult value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TransactionRulesResult read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TransactionRulesResult given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TransactionRulesResult
  * @throws IOException if the JSON string is invalid with respect to TransactionRulesResult
  */
  public static TransactionRulesResult fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TransactionRulesResult.class);
  }

 /**
  * Convert an instance of TransactionRulesResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

