/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 3
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.transferwebhooks.Amount;
import com.adyen.model.transferwebhooks.AmountAdjustment;
import com.adyen.model.transferwebhooks.BalanceMutation;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.transferwebhooks.JSON;

/**
 * TransferEvent
 */

public class TransferEvent {
  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Amount amount;

  public static final String SERIALIZED_NAME_AMOUNT_ADJUSTMENTS = "amountAdjustments";
  @SerializedName(SERIALIZED_NAME_AMOUNT_ADJUSTMENTS)
  private List<AmountAdjustment> amountAdjustments = null;

  public static final String SERIALIZED_NAME_BOOKING_DATE = "bookingDate";
  @SerializedName(SERIALIZED_NAME_BOOKING_DATE)
  private OffsetDateTime bookingDate;

  public static final String SERIALIZED_NAME_ESTIMATED_ARRIVAL_TIME = "estimatedArrivalTime";
  @SerializedName(SERIALIZED_NAME_ESTIMATED_ARRIVAL_TIME)
  private OffsetDateTime estimatedArrivalTime;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_MUTATIONS = "mutations";
  @SerializedName(SERIALIZED_NAME_MUTATIONS)
  private List<BalanceMutation> mutations = null;

  public static final String SERIALIZED_NAME_ORIGINAL_AMOUNT = "originalAmount";
  @SerializedName(SERIALIZED_NAME_ORIGINAL_AMOUNT)
  private Amount originalAmount;

  /**
   * The reason for the transfer status.
   */
  @JsonAdapter(ReasonEnum.Adapter.class)
  public enum ReasonEnum {
    AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
    
    APPROVED("approved"),
    
    COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
    
    COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
    
    COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
    
    COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
    
    COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
    
    COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
    
    ERROR("error"),
    
    NOTENOUGHBALANCE("notEnoughBalance"),
    
    REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
    
    ROUTENOTFOUND("routeNotFound"),
    
    UNKNOWN("unknown");

    private String value;

    ReasonEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ReasonEnum fromValue(String value) {
      for (ReasonEnum b : ReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ReasonEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ReasonEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ReasonEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ReasonEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_REASON = "reason";
  @SerializedName(SERIALIZED_NAME_REASON)
  private ReasonEnum reason;

  /**
   * The status of the transfer event.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    APPROVALPENDING("approvalPending"),
    
    ATMWITHDRAWAL("atmWithdrawal"),
    
    ATMWITHDRAWALREVERSALPENDING("atmWithdrawalReversalPending"),
    
    ATMWITHDRAWALREVERSED("atmWithdrawalReversed"),
    
    AUTHADJUSTMENTAUTHORISED("authAdjustmentAuthorised"),
    
    AUTHADJUSTMENTERROR("authAdjustmentError"),
    
    AUTHADJUSTMENTREFUSED("authAdjustmentRefused"),
    
    AUTHORISED("authorised"),
    
    BANKTRANSFER("bankTransfer"),
    
    BANKTRANSFERPENDING("bankTransferPending"),
    
    BOOKED("booked"),
    
    BOOKINGPENDING("bookingPending"),
    
    CANCELLED("cancelled"),
    
    CAPTUREPENDING("capturePending"),
    
    CAPTUREREVERSALPENDING("captureReversalPending"),
    
    CAPTUREREVERSED("captureReversed"),
    
    CAPTURED("captured"),
    
    CHARGEBACK("chargeback"),
    
    CHARGEBACKPENDING("chargebackPending"),
    
    CHARGEBACKREVERSALPENDING("chargebackReversalPending"),
    
    CHARGEBACKREVERSED("chargebackReversed"),
    
    CREDITED("credited"),
    
    DEPOSITCORRECTION("depositCorrection"),
    
    DEPOSITCORRECTIONPENDING("depositCorrectionPending"),
    
    DISPUTE("dispute"),
    
    DISPUTECLOSED("disputeClosed"),
    
    DISPUTEEXPIRED("disputeExpired"),
    
    DISPUTENEEDSREVIEW("disputeNeedsReview"),
    
    ERROR("error"),
    
    EXPIRED("expired"),
    
    FAILED("failed"),
    
    FEE("fee"),
    
    FEEPENDING("feePending"),
    
    INTERNALTRANSFER("internalTransfer"),
    
    INTERNALTRANSFERPENDING("internalTransferPending"),
    
    INVOICEDEDUCTION("invoiceDeduction"),
    
    INVOICEDEDUCTIONPENDING("invoiceDeductionPending"),
    
    MANUALCORRECTIONPENDING("manualCorrectionPending"),
    
    MANUALLYCORRECTED("manuallyCorrected"),
    
    MATCHEDSTATEMENT("matchedStatement"),
    
    MATCHEDSTATEMENTPENDING("matchedStatementPending"),
    
    MERCHANTPAYIN("merchantPayin"),
    
    MERCHANTPAYINPENDING("merchantPayinPending"),
    
    MERCHANTPAYINREVERSED("merchantPayinReversed"),
    
    MERCHANTPAYINREVERSEDPENDING("merchantPayinReversedPending"),
    
    MISCCOST("miscCost"),
    
    MISCCOSTPENDING("miscCostPending"),
    
    PAYMENTCOST("paymentCost"),
    
    PAYMENTCOSTPENDING("paymentCostPending"),
    
    RECEIVED("received"),
    
    REFUNDPENDING("refundPending"),
    
    REFUNDREVERSALPENDING("refundReversalPending"),
    
    REFUNDREVERSED("refundReversed"),
    
    REFUNDED("refunded"),
    
    REFUSED("refused"),
    
    RESERVEADJUSTMENT("reserveAdjustment"),
    
    RESERVEADJUSTMENTPENDING("reserveAdjustmentPending"),
    
    RETURNED("returned"),
    
    SECONDCHARGEBACK("secondChargeback"),
    
    SECONDCHARGEBACKPENDING("secondChargebackPending"),
    
    UNDEFINED("undefined");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_ID)
  private String transactionId;

  /**
   * The type of the transfer event. Possible values: **accounting**, **tracking**.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    ACCOUNTING("accounting"),
    
    TRACKING("tracking");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_UPDATE_DATE = "updateDate";
  @SerializedName(SERIALIZED_NAME_UPDATE_DATE)
  private OffsetDateTime updateDate;

  public static final String SERIALIZED_NAME_VALUE_DATE = "valueDate";
  @SerializedName(SERIALIZED_NAME_VALUE_DATE)
  private OffsetDateTime valueDate;

  public TransferEvent() { 
  }

  public TransferEvent amount(Amount amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(value = "")

  public Amount getAmount() {
    return amount;
  }


  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public TransferEvent amountAdjustments(List<AmountAdjustment> amountAdjustments) {
    
    this.amountAdjustments = amountAdjustments;
    return this;
  }

  public TransferEvent addAmountAdjustmentsItem(AmountAdjustment amountAdjustmentsItem) {
    if (this.amountAdjustments == null) {
      this.amountAdjustments = new ArrayList<>();
    }
    this.amountAdjustments.add(amountAdjustmentsItem);
    return this;
  }

   /**
   * The amount adjustments in this transfer.
   * @return amountAdjustments
  **/
  @ApiModelProperty(value = "The amount adjustments in this transfer.")

  public List<AmountAdjustment> getAmountAdjustments() {
    return amountAdjustments;
  }


  public void setAmountAdjustments(List<AmountAdjustment> amountAdjustments) {
    this.amountAdjustments = amountAdjustments;
  }


  public TransferEvent bookingDate(OffsetDateTime bookingDate) {
    
    this.bookingDate = bookingDate;
    return this;
  }

   /**
   * The date when the transfer request was sent.
   * @return bookingDate
  **/
  @ApiModelProperty(value = "The date when the transfer request was sent.")

  public OffsetDateTime getBookingDate() {
    return bookingDate;
  }


  public void setBookingDate(OffsetDateTime bookingDate) {
    this.bookingDate = bookingDate;
  }


  public TransferEvent estimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
    
    this.estimatedArrivalTime = estimatedArrivalTime;
    return this;
  }

   /**
   * The estimated time the beneficiary should have access to the funds.
   * @return estimatedArrivalTime
  **/
  @ApiModelProperty(value = "The estimated time the beneficiary should have access to the funds.")

  public OffsetDateTime getEstimatedArrivalTime() {
    return estimatedArrivalTime;
  }


  public void setEstimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
    this.estimatedArrivalTime = estimatedArrivalTime;
  }


  public TransferEvent id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the transfer event.
   * @return id
  **/
  @ApiModelProperty(value = "The unique identifier of the transfer event.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public TransferEvent mutations(List<BalanceMutation> mutations) {
    
    this.mutations = mutations;
    return this;
  }

  public TransferEvent addMutationsItem(BalanceMutation mutationsItem) {
    if (this.mutations == null) {
      this.mutations = new ArrayList<>();
    }
    this.mutations.add(mutationsItem);
    return this;
  }

   /**
   * The list of the balance mutation per event.
   * @return mutations
  **/
  @ApiModelProperty(value = "The list of the balance mutation per event.")

  public List<BalanceMutation> getMutations() {
    return mutations;
  }


  public void setMutations(List<BalanceMutation> mutations) {
    this.mutations = mutations;
  }


  public TransferEvent originalAmount(Amount originalAmount) {
    
    this.originalAmount = originalAmount;
    return this;
  }

   /**
   * Get originalAmount
   * @return originalAmount
  **/
  @ApiModelProperty(value = "")

  public Amount getOriginalAmount() {
    return originalAmount;
  }


  public void setOriginalAmount(Amount originalAmount) {
    this.originalAmount = originalAmount;
  }


  public TransferEvent reason(ReasonEnum reason) {
    
    this.reason = reason;
    return this;
  }

   /**
   * The reason for the transfer status.
   * @return reason
  **/
  @ApiModelProperty(value = "The reason for the transfer status.")

  public ReasonEnum getReason() {
    return reason;
  }


  public void setReason(ReasonEnum reason) {
    this.reason = reason;
  }


  public TransferEvent status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * The status of the transfer event.
   * @return status
  **/
  @ApiModelProperty(value = "The status of the transfer event.")

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public TransferEvent transactionId(String transactionId) {
    
    this.transactionId = transactionId;
    return this;
  }

   /**
   * The id of the transaction that is related to this accounting event. Only sent for events of type **accounting** where the balance changes.
   * @return transactionId
  **/
  @ApiModelProperty(value = "The id of the transaction that is related to this accounting event. Only sent for events of type **accounting** where the balance changes.")

  public String getTransactionId() {
    return transactionId;
  }


  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }


  public TransferEvent type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the transfer event. Possible values: **accounting**, **tracking**.
   * @return type
  **/
  @ApiModelProperty(value = "The type of the transfer event. Possible values: **accounting**, **tracking**.")

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }


  public TransferEvent updateDate(OffsetDateTime updateDate) {
    
    this.updateDate = updateDate;
    return this;
  }

   /**
   * The date when the tracking status was updated.
   * @return updateDate
  **/
  @ApiModelProperty(value = "The date when the tracking status was updated.")

  public OffsetDateTime getUpdateDate() {
    return updateDate;
  }


  public void setUpdateDate(OffsetDateTime updateDate) {
    this.updateDate = updateDate;
  }


  public TransferEvent valueDate(OffsetDateTime valueDate) {
    
    this.valueDate = valueDate;
    return this;
  }

   /**
   * A future date, when the funds are expected to be deducted from or credited to the balance account.
   * @return valueDate
  **/
  @ApiModelProperty(value = "A future date, when the funds are expected to be deducted from or credited to the balance account.")

  public OffsetDateTime getValueDate() {
    return valueDate;
  }


  public void setValueDate(OffsetDateTime valueDate) {
    this.valueDate = valueDate;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferEvent transferEvent = (TransferEvent) o;
    return Objects.equals(this.amount, transferEvent.amount) &&
        Objects.equals(this.amountAdjustments, transferEvent.amountAdjustments) &&
        Objects.equals(this.bookingDate, transferEvent.bookingDate) &&
        Objects.equals(this.estimatedArrivalTime, transferEvent.estimatedArrivalTime) &&
        Objects.equals(this.id, transferEvent.id) &&
        Objects.equals(this.mutations, transferEvent.mutations) &&
        Objects.equals(this.originalAmount, transferEvent.originalAmount) &&
        Objects.equals(this.reason, transferEvent.reason) &&
        Objects.equals(this.status, transferEvent.status) &&
        Objects.equals(this.transactionId, transferEvent.transactionId) &&
        Objects.equals(this.type, transferEvent.type) &&
        Objects.equals(this.updateDate, transferEvent.updateDate) &&
        Objects.equals(this.valueDate, transferEvent.valueDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, amountAdjustments, bookingDate, estimatedArrivalTime, id, mutations, originalAmount, reason, status, transactionId, type, updateDate, valueDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferEvent {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    amountAdjustments: ").append(toIndentedString(amountAdjustments)).append("\n");
    sb.append("    bookingDate: ").append(toIndentedString(bookingDate)).append("\n");
    sb.append("    estimatedArrivalTime: ").append(toIndentedString(estimatedArrivalTime)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    mutations: ").append(toIndentedString(mutations)).append("\n");
    sb.append("    originalAmount: ").append(toIndentedString(originalAmount)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    updateDate: ").append(toIndentedString(updateDate)).append("\n");
    sb.append("    valueDate: ").append(toIndentedString(valueDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("amount");
    openapiFields.add("amountAdjustments");
    openapiFields.add("bookingDate");
    openapiFields.add("estimatedArrivalTime");
    openapiFields.add("id");
    openapiFields.add("mutations");
    openapiFields.add("originalAmount");
    openapiFields.add("reason");
    openapiFields.add("status");
    openapiFields.add("transactionId");
    openapiFields.add("type");
    openapiFields.add("updateDate");
    openapiFields.add("valueDate");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(TransferEvent.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TransferEvent
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TransferEvent.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TransferEvent is not found in the empty JSON string", TransferEvent.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!TransferEvent.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TransferEvent` properties.", entry.getKey()));
        }
      }
      // validate the optional field `amount`
      if (jsonObj.getAsJsonObject("amount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("amount"));
      }
      JsonArray jsonArrayamountAdjustments = jsonObj.getAsJsonArray("amountAdjustments");
      if (jsonArrayamountAdjustments != null) {
        // ensure the json data is an array
        if (!jsonObj.get("amountAdjustments").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `amountAdjustments` to be an array in the JSON string but got `%s`", jsonObj.get("amountAdjustments").toString()));
        }

        // validate the optional field `amountAdjustments` (array)
        for (int i = 0; i < jsonArrayamountAdjustments.size(); i++) {
          AmountAdjustment.validateJsonObject(jsonArrayamountAdjustments.get(i).getAsJsonObject());
        }
      }
      // validate the optional field id
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      JsonArray jsonArraymutations = jsonObj.getAsJsonArray("mutations");
      if (jsonArraymutations != null) {
        // ensure the json data is an array
        if (!jsonObj.get("mutations").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `mutations` to be an array in the JSON string but got `%s`", jsonObj.get("mutations").toString()));
        }

        // validate the optional field `mutations` (array)
        for (int i = 0; i < jsonArraymutations.size(); i++) {
          BalanceMutation.validateJsonObject(jsonArraymutations.get(i).getAsJsonObject());
        }
      }
      // validate the optional field `originalAmount`
      if (jsonObj.getAsJsonObject("originalAmount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("originalAmount"));
      }
      // ensure the field reason can be parsed to an enum value
      if (jsonObj.get("reason") != null) {
        if(!jsonObj.get("reason").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reason").toString()));
        }
        ReasonEnum.fromValue(jsonObj.get("reason").getAsString());
      }
      // ensure the field status can be parsed to an enum value
      if (jsonObj.get("status") != null) {
        if(!jsonObj.get("status").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
        }
        StatusEnum.fromValue(jsonObj.get("status").getAsString());
      }
      // validate the optional field transactionId
      if (jsonObj.get("transactionId") != null && !jsonObj.get("transactionId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transactionId").toString()));
      }
      // ensure the field type can be parsed to an enum value
      if (jsonObj.get("type") != null) {
        if(!jsonObj.get("type").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
        }
        TypeEnum.fromValue(jsonObj.get("type").getAsString());
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TransferEvent.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TransferEvent' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TransferEvent> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TransferEvent.class));

       return (TypeAdapter<T>) new TypeAdapter<TransferEvent>() {
           @Override
           public void write(JsonWriter out, TransferEvent value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TransferEvent read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TransferEvent given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TransferEvent
  * @throws IOException if the JSON string is invalid with respect to TransferEvent
  */
  public static TransferEvent fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TransferEvent.class);
  }

 /**
  * Convert an instance of TransferEvent to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

