/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.checkout.PaymentSetupRequest;
import com.adyen.model.checkout.PaymentSetupResponse;
import com.adyen.model.checkout.PaymentVerificationRequest;
import com.adyen.model.checkout.PaymentVerificationResponse;
import com.adyen.model.checkout.ServiceError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ClassicCheckoutSdkApi extends Service {
    private final String baseURL;

    public ClassicCheckoutSdkApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://checkout-test.adyen.com/v70");
    }

    /**
    * Create a payment session
    *
    * @param paymentSetupRequest {@link PaymentSetupRequest }  (required)
    * @return {@link PaymentSetupResponse }
    * @throws ApiException if fails to make API call
    * @deprecated
    */
    @Deprecated
    public PaymentSetupResponse paymentSession(PaymentSetupRequest paymentSetupRequest) throws ApiException, IOException {
        return paymentSession(paymentSetupRequest, null);
    }

    /**
    * Create a payment session
    *
    * @param paymentSetupRequest {@link PaymentSetupRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentSetupResponse }
    * @throws ApiException if fails to make API call
    * @deprecated
    */
   @Deprecated
    public PaymentSetupResponse paymentSession(PaymentSetupRequest paymentSetupRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentSetupRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentSession", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentSetupResponse.fromJson(jsonResult);
    }

    /**
    * Verify a payment result
    *
    * @param paymentVerificationRequest {@link PaymentVerificationRequest }  (required)
    * @return {@link PaymentVerificationResponse }
    * @throws ApiException if fails to make API call
    * @deprecated
    */
    @Deprecated
    public PaymentVerificationResponse verifyPaymentResult(PaymentVerificationRequest paymentVerificationRequest) throws ApiException, IOException {
        return verifyPaymentResult(paymentVerificationRequest, null);
    }

    /**
    * Verify a payment result
    *
    * @param paymentVerificationRequest {@link PaymentVerificationRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentVerificationResponse }
    * @throws ApiException if fails to make API call
    * @deprecated
    */
   @Deprecated
    public PaymentVerificationResponse verifyPaymentResult(PaymentVerificationRequest paymentVerificationRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentVerificationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/payments/result", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentVerificationResponse.fromJson(jsonResult);
    }
}
