/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.checkout.CardDetailsRequest;
import com.adyen.model.checkout.CardDetailsResponse;
import com.adyen.model.checkout.CreateCheckoutSessionRequest;
import com.adyen.model.checkout.CreateCheckoutSessionResponse;
import com.adyen.model.checkout.DetailsRequest;
import com.adyen.model.checkout.DonationResponse;
import com.adyen.model.checkout.PaymentDetailsResponse;
import com.adyen.model.checkout.PaymentDonationRequest;
import com.adyen.model.checkout.PaymentMethodsRequest;
import com.adyen.model.checkout.PaymentMethodsResponse;
import com.adyen.model.checkout.PaymentRequest;
import com.adyen.model.checkout.PaymentResponse;
import com.adyen.model.checkout.ServiceError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PaymentsApi extends Service {
    private final String baseURL;

    public PaymentsApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://checkout-test.adyen.com/v70");
    }

    /**
    * Get the list of brands on the card
    *
    * @param cardDetailsRequest {@link CardDetailsRequest }  (required)
    * @return {@link CardDetailsResponse }
    * @throws ApiException if fails to make API call
    */
    public CardDetailsResponse cardDetails(CardDetailsRequest cardDetailsRequest) throws ApiException, IOException {
        return cardDetails(cardDetailsRequest, null);
    }

    /**
    * Get the list of brands on the card
    *
    * @param cardDetailsRequest {@link CardDetailsRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CardDetailsResponse }
    * @throws ApiException if fails to make API call
    */
    public CardDetailsResponse cardDetails(CardDetailsRequest cardDetailsRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = cardDetailsRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/cardDetails", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CardDetailsResponse.fromJson(jsonResult);
    }

    /**
    * Start a transaction for donations
    *
    * @param paymentDonationRequest {@link PaymentDonationRequest }  (required)
    * @return {@link DonationResponse }
    * @throws ApiException if fails to make API call
    */
    public DonationResponse donations(PaymentDonationRequest paymentDonationRequest) throws ApiException, IOException {
        return donations(paymentDonationRequest, null);
    }

    /**
    * Start a transaction for donations
    *
    * @param paymentDonationRequest {@link PaymentDonationRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link DonationResponse }
    * @throws ApiException if fails to make API call
    */
    public DonationResponse donations(PaymentDonationRequest paymentDonationRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentDonationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/donations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return DonationResponse.fromJson(jsonResult);
    }

    /**
    * Get a list of available payment methods
    *
    * @param paymentMethodsRequest {@link PaymentMethodsRequest }  (required)
    * @return {@link PaymentMethodsResponse }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethodsResponse paymentMethods(PaymentMethodsRequest paymentMethodsRequest) throws ApiException, IOException {
        return paymentMethods(paymentMethodsRequest, null);
    }

    /**
    * Get a list of available payment methods
    *
    * @param paymentMethodsRequest {@link PaymentMethodsRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentMethodsResponse }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethodsResponse paymentMethods(PaymentMethodsRequest paymentMethodsRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentMethodsRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentMethods", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentMethodsResponse.fromJson(jsonResult);
    }

    /**
    * Start a transaction
    *
    * @param paymentRequest {@link PaymentRequest }  (required)
    * @return {@link PaymentResponse }
    * @throws ApiException if fails to make API call
    */
    public PaymentResponse payments(PaymentRequest paymentRequest) throws ApiException, IOException {
        return payments(paymentRequest, null);
    }

    /**
    * Start a transaction
    *
    * @param paymentRequest {@link PaymentRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentResponse }
    * @throws ApiException if fails to make API call
    */
    public PaymentResponse payments(PaymentRequest paymentRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/payments", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResponse.fromJson(jsonResult);
    }

    /**
    * Submit details for a payment
    *
    * @param detailsRequest {@link DetailsRequest }  (required)
    * @return {@link PaymentDetailsResponse }
    * @throws ApiException if fails to make API call
    */
    public PaymentDetailsResponse paymentsDetails(DetailsRequest detailsRequest) throws ApiException, IOException {
        return paymentsDetails(detailsRequest, null);
    }

    /**
    * Submit details for a payment
    *
    * @param detailsRequest {@link DetailsRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentDetailsResponse }
    * @throws ApiException if fails to make API call
    */
    public PaymentDetailsResponse paymentsDetails(DetailsRequest detailsRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = detailsRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/payments/details", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentDetailsResponse.fromJson(jsonResult);
    }

    /**
    * Create a payment session
    *
    * @param createCheckoutSessionRequest {@link CreateCheckoutSessionRequest }  (required)
    * @return {@link CreateCheckoutSessionResponse }
    * @throws ApiException if fails to make API call
    */
    public CreateCheckoutSessionResponse sessions(CreateCheckoutSessionRequest createCheckoutSessionRequest) throws ApiException, IOException {
        return sessions(createCheckoutSessionRequest, null);
    }

    /**
    * Create a payment session
    *
    * @param createCheckoutSessionRequest {@link CreateCheckoutSessionRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CreateCheckoutSessionResponse }
    * @throws ApiException if fails to make API call
    */
    public CreateCheckoutSessionResponse sessions(CreateCheckoutSessionRequest createCheckoutSessionRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = createCheckoutSessionRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/sessions", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CreateCheckoutSessionResponse.fromJson(jsonResult);
    }
}
