/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.checkout.ListStoredPaymentMethodsResponse;
import com.adyen.model.checkout.StoredPaymentMethodResource;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RecurringApi extends Service {
    private final String baseURL;

    public RecurringApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://checkout-test.adyen.com/v70");
    }

    /**
    * Delete a token for stored payment details
    *
    * @param recurringId {@link String } The unique identifier of the token. (required)
    * @param shopperReference {@link String } Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address. (required)
    * @param merchantAccount {@link String } Your merchant account. (required)
    * @return {@link StoredPaymentMethodResource }
    * @throws ApiException if fails to make API call
    */
    public StoredPaymentMethodResource deleteTokenForStoredPaymentDetails(String recurringId, String shopperReference, String merchantAccount) throws ApiException, IOException {
        return deleteTokenForStoredPaymentDetails(recurringId, shopperReference,  merchantAccount,  null);
    }

    /**
    * Delete a token for stored payment details
    *
    * @param recurringId {@link String } The unique identifier of the token. (required)
    * @param shopperReference {@link String } Query: Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address. (required)
    * @param merchantAccount {@link String } Query: Your merchant account. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link StoredPaymentMethodResource }
    * @throws ApiException if fails to make API call
    */
    public StoredPaymentMethodResource deleteTokenForStoredPaymentDetails(String recurringId, String shopperReference, String merchantAccount, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (recurringId == null) {
            throw new IllegalArgumentException("Please provide the recurringId path parameter");
        }
        pathParams.put("recurringId", recurringId);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (shopperReference != null) {
        queryParams.put("shopperReference", shopperReference);
        }
        if (merchantAccount != null) {
        queryParams.put("merchantAccount", merchantAccount);
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/storedPaymentMethods/{recurringId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams, queryParams);
        return StoredPaymentMethodResource.fromJson(jsonResult);
    }

    /**
    * Get tokens for stored payment details
    *
    * @return {@link ListStoredPaymentMethodsResponse }
    * @throws ApiException if fails to make API call
    */
    public ListStoredPaymentMethodsResponse getTokensForStoredPaymentDetails() throws ApiException, IOException {
        return getTokensForStoredPaymentDetails(null,  null,  null);
    }

    /**
    * Get tokens for stored payment details
    *
    * @param shopperReference {@link String } Query: Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address. (optional)
    * @param merchantAccount {@link String } Query: Your merchant account. (optional)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ListStoredPaymentMethodsResponse }
    * @throws ApiException if fails to make API call
    */
    public ListStoredPaymentMethodsResponse getTokensForStoredPaymentDetails(String shopperReference, String merchantAccount, RequestOptions requestOptions) throws ApiException, IOException {
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (shopperReference != null) {
        queryParams.put("shopperReference", shopperReference);
        }
        if (merchantAccount != null) {
        queryParams.put("merchantAccount", merchantAccount);
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/storedPaymentMethods", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return ListStoredPaymentMethodsResponse.fromJson(jsonResult);
    }
}
