/*
 * Transfers API
 *
 * The version of the OpenAPI document: 3
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.transfers;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.transfers.RestServiceError;
import com.adyen.model.transfers.Transfer;
import com.adyen.model.transfers.TransferInfo;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TransfersApi extends Service {
    private final String baseURL;

    public TransfersApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://balanceplatform-api-test.adyen.com/btl/v3");
    }

    /**
    * Transfer funds
    *
    * @param transferInfo {@link TransferInfo }  (required)
    * @return {@link Transfer }
    * @throws ApiException if fails to make API call
    */
    public Transfer transferFunds(TransferInfo transferInfo) throws ApiException, IOException {
        return transferFunds(transferInfo, null);
    }

    /**
    * Transfer funds
    *
    * @param transferInfo {@link TransferInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Transfer }
    * @throws ApiException if fails to make API call
    */
    public Transfer transferFunds(TransferInfo transferInfo, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = transferInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transfers", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return Transfer.fromJson(jsonResult);
    }
}
