/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessingTypesRestriction {
    public static final String SERIALIZED_NAME_OPERATION = "operation";
    @SerializedName(value="operation")
    private String operation;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private List<ValueEnum> value = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ProcessingTypesRestriction operation(String operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines how the condition must be evaluated.")
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public ProcessingTypesRestriction value(List<ValueEnum> value) {
        this.value = value;
        return this;
    }

    public ProcessingTypesRestriction addValueItem(ValueEnum valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<ValueEnum>();
        }
        this.value.add(valueItem);
        return this;
    }

    @ApiModelProperty(value="List of processing types.  Possible values: **atmWithdraw**, **balanceInquiry**, **ecommerce**, **moto**, **pos**, **recurring**, **token**.  ")
    public List<ValueEnum> getValue() {
        return this.value;
    }

    public void setValue(List<ValueEnum> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessingTypesRestriction processingTypesRestriction = (ProcessingTypesRestriction)o;
        return Objects.equals(this.operation, processingTypesRestriction.operation) && Objects.equals(this.value, processingTypesRestriction.value);
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessingTypesRestriction {\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ProcessingTypesRestriction is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ProcessingTypesRestriction` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATION) != null && !jsonObj.get(SERIALIZED_NAME_OPERATION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `operation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `value` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUE).toString()));
        }
    }

    public static ProcessingTypesRestriction fromJson(String jsonString) throws IOException {
        return (ProcessingTypesRestriction)JSON.getGson().fromJson(jsonString, ProcessingTypesRestriction.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_OPERATION);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_OPERATION);
        log = Logger.getLogger(ProcessingTypesRestriction.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ProcessingTypesRestriction.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ProcessingTypesRestriction.class));
            return new TypeAdapter<ProcessingTypesRestriction>(){

                public void write(JsonWriter out, ProcessingTypesRestriction value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ProcessingTypesRestriction read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ProcessingTypesRestriction.validateJsonObject(jsonObj);
                    return (ProcessingTypesRestriction)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ValueEnum {
        ATMWITHDRAW("atmWithdraw"),
        BALANCEINQUIRY("balanceInquiry"),
        ECOMMERCE("ecommerce"),
        MOTO("moto"),
        POS("pos"),
        RECURRING("recurring"),
        TOKEN("token"),
        UNKNOWN("unknown");

        private String value;

        private ValueEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ValueEnum fromValue(String value) {
            for (ValueEnum b : ValueEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ValueEnum> {
            public void write(JsonWriter jsonWriter, ValueEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ValueEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ValueEnum.fromValue(value);
            }
        }
    }
}

