/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UKLocalAccountIdentification {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "accountNumber";
    @SerializedName(value="accountNumber")
    private String accountNumber;
    public static final String SERIALIZED_NAME_SORT_CODE = "sortCode";
    @SerializedName(value="sortCode")
    private String sortCode;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.UKLOCAL;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public UKLocalAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 8-digit bank account number, without separators or whitespace.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public UKLocalAccountIdentification sortCode(String sortCode) {
        this.sortCode = sortCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The 6-digit [sort code](https://en.wikipedia.org/wiki/Sort_code), without separators or whitespace.")
    public String getSortCode() {
        return this.sortCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public UKLocalAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**ukLocal**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UKLocalAccountIdentification ukLocalAccountIdentification = (UKLocalAccountIdentification)o;
        return Objects.equals(this.accountNumber, ukLocalAccountIdentification.accountNumber) && Objects.equals(this.sortCode, ukLocalAccountIdentification.sortCode) && Objects.equals((Object)this.type, (Object)ukLocalAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.sortCode, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UKLocalAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    sortCode: ").append(this.toIndentedString(this.sortCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UKLocalAccountIdentification is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `UKLocalAccountIdentification` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `accountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SORT_CODE) != null && !jsonObj.get(SERIALIZED_NAME_SORT_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `sortCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SORT_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static UKLocalAccountIdentification fromJson(String jsonString) throws IOException {
        return (UKLocalAccountIdentification)JSON.getGson().fromJson(jsonString, UKLocalAccountIdentification.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_SORT_CODE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_SORT_CODE);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        log = Logger.getLogger(UKLocalAccountIdentification.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UKLocalAccountIdentification.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UKLocalAccountIdentification.class));
            return new TypeAdapter<UKLocalAccountIdentification>(){

                public void write(JsonWriter out, UKLocalAccountIdentification value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UKLocalAccountIdentification read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UKLocalAccountIdentification.validateJsonObject(jsonObj);
                    return (UKLocalAccountIdentification)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        UKLOCAL("ukLocal");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

