/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.MinorUnitsMonetaryValue;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OfflineProcessing {
    public static final String SERIALIZED_NAME_CHIP_FLOOR_LIMIT = "chipFloorLimit";
    @SerializedName(value="chipFloorLimit")
    private Integer chipFloorLimit;
    public static final String SERIALIZED_NAME_OFFLINE_SWIPE_LIMITS = "offlineSwipeLimits";
    @SerializedName(value="offlineSwipeLimits")
    private List<MinorUnitsMonetaryValue> offlineSwipeLimits = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public OfflineProcessing chipFloorLimit(Integer chipFloorLimit) {
        this.chipFloorLimit = chipFloorLimit;
        return this;
    }

    @ApiModelProperty(value="The maximum offline transaction amount for chip cards, in the processing currency and specified in [minor units](https://docs.adyen.com/development-resources/currency-codes).")
    public Integer getChipFloorLimit() {
        return this.chipFloorLimit;
    }

    public void setChipFloorLimit(Integer chipFloorLimit) {
        this.chipFloorLimit = chipFloorLimit;
    }

    public OfflineProcessing offlineSwipeLimits(List<MinorUnitsMonetaryValue> offlineSwipeLimits) {
        this.offlineSwipeLimits = offlineSwipeLimits;
        return this;
    }

    public OfflineProcessing addOfflineSwipeLimitsItem(MinorUnitsMonetaryValue offlineSwipeLimitsItem) {
        if (this.offlineSwipeLimits == null) {
            this.offlineSwipeLimits = new ArrayList<MinorUnitsMonetaryValue>();
        }
        this.offlineSwipeLimits.add(offlineSwipeLimitsItem);
        return this;
    }

    @ApiModelProperty(value="The maximum offline transaction amount for swiped cards, in the specified currency.")
    public List<MinorUnitsMonetaryValue> getOfflineSwipeLimits() {
        return this.offlineSwipeLimits;
    }

    public void setOfflineSwipeLimits(List<MinorUnitsMonetaryValue> offlineSwipeLimits) {
        this.offlineSwipeLimits = offlineSwipeLimits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfflineProcessing offlineProcessing = (OfflineProcessing)o;
        return Objects.equals(this.chipFloorLimit, offlineProcessing.chipFloorLimit) && Objects.equals(this.offlineSwipeLimits, offlineProcessing.offlineSwipeLimits);
    }

    public int hashCode() {
        return Objects.hash(this.chipFloorLimit, this.offlineSwipeLimits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfflineProcessing {\n");
        sb.append("    chipFloorLimit: ").append(this.toIndentedString(this.chipFloorLimit)).append("\n");
        sb.append("    offlineSwipeLimits: ").append(this.toIndentedString(this.offlineSwipeLimits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in OfflineProcessing is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `OfflineProcessing` properties.", entry.getKey()));
        }
        JsonArray jsonArrayofflineSwipeLimits = jsonObj.getAsJsonArray(SERIALIZED_NAME_OFFLINE_SWIPE_LIMITS);
        if (jsonArrayofflineSwipeLimits != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OFFLINE_SWIPE_LIMITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `offlineSwipeLimits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OFFLINE_SWIPE_LIMITS).toString()));
            }
            for (int i = 0; i < jsonArrayofflineSwipeLimits.size(); ++i) {
                MinorUnitsMonetaryValue.validateJsonObject(jsonArrayofflineSwipeLimits.get(i).getAsJsonObject());
            }
        }
    }

    public static OfflineProcessing fromJson(String jsonString) throws IOException {
        return (OfflineProcessing)JSON.getGson().fromJson(jsonString, OfflineProcessing.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CHIP_FLOOR_LIMIT);
        openapiFields.add(SERIALIZED_NAME_OFFLINE_SWIPE_LIMITS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(OfflineProcessing.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OfflineProcessing.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OfflineProcessing.class));
            return new TypeAdapter<OfflineProcessing>(){

                public void write(JsonWriter out, OfflineProcessing value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OfflineProcessing read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    OfflineProcessing.validateJsonObject(jsonObj);
                    return (OfflineProcessing)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

