/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetTerminalsUnderAccountRequest {
    public static final String SERIALIZED_NAME_COMPANY_ACCOUNT = "companyAccount";
    @SerializedName(value="companyAccount")
    private String companyAccount;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_STORE = "store";
    @SerializedName(value="store")
    private String store;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public GetTerminalsUnderAccountRequest companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="Your company account. If you only specify this parameter, the response includes all terminals at all account levels.")
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public GetTerminalsUnderAccountRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="The merchant account. This is required if you are retrieving the terminals assigned to a store.If you don't specify a `store` the response includes the terminals assigned to the specified merchant account and the terminals assigned to the stores under this merchant account.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public GetTerminalsUnderAccountRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The store code of the store. With this parameter, the response only includes the terminals assigned to the specified store.")
    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTerminalsUnderAccountRequest getTerminalsUnderAccountRequest = (GetTerminalsUnderAccountRequest)o;
        return Objects.equals(this.companyAccount, getTerminalsUnderAccountRequest.companyAccount) && Objects.equals(this.merchantAccount, getTerminalsUnderAccountRequest.merchantAccount) && Objects.equals(this.store, getTerminalsUnderAccountRequest.store);
    }

    public int hashCode() {
        return Objects.hash(this.companyAccount, this.merchantAccount, this.store);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTerminalsUnderAccountRequest {\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GetTerminalsUnderAccountRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `GetTerminalsUnderAccountRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `companyAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE) != null && !jsonObj.get(SERIALIZED_NAME_STORE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE).toString()));
        }
    }

    public static GetTerminalsUnderAccountRequest fromJson(String jsonString) throws IOException {
        return (GetTerminalsUnderAccountRequest)JSON.getGson().fromJson(jsonString, GetTerminalsUnderAccountRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COMPANY_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_STORE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COMPANY_ACCOUNT);
        log = Logger.getLogger(GetTerminalsUnderAccountRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GetTerminalsUnderAccountRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GetTerminalsUnderAccountRequest.class));
            return new TypeAdapter<GetTerminalsUnderAccountRequest>(){

                public void write(JsonWriter out, GetTerminalsUnderAccountRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GetTerminalsUnderAccountRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GetTerminalsUnderAccountRequest.validateJsonObject(jsonObj);
                    return (GetTerminalsUnderAccountRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

