/*
 * Adyen Balance Control API
 * The Balance Control API lets you transfer funds between merchant accounts that belong to the same legal entity and are under the same company account.  ## Authentication To connect to the Balance Control API, you must authenticate your requests with an [API key or basic auth username and password](https://docs.adyen.com/development-resources/api-authentication). To learn how you can generate these, see [API credentials](https://docs.adyen.com/development-resources/api-credentials).Here is an example of authenticating a request with an API key:  ``` curl -H \"X-API-Key: Your_API_key\" \\ -H \"Content-Type: application/json\" \\ ... ``` Note that when going live, you need to generate API credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Balance Control API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example:  ``` https://pal-test.adyen.com/pal/servlet/BalanceControl/v1/balanceTransfer ``` 
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balancecontrol;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.balancecontrol.Amount;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.balancecontrol.JSON;

/**
 * BalanceTransferRequest
 */

public class BalanceTransferRequest {
  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Amount amount;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_FROM_MERCHANT = "fromMerchant";
  @SerializedName(SERIALIZED_NAME_FROM_MERCHANT)
  private String fromMerchant;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  public static final String SERIALIZED_NAME_TO_MERCHANT = "toMerchant";
  @SerializedName(SERIALIZED_NAME_TO_MERCHANT)
  private String toMerchant;

  /**
   * The type of balance transfer. Possible values: **tax**, **fee**, **terminalSale**, **credit**, **debit**, and **adjustment**.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    TAX("tax"),
    
    FEE("fee"),
    
    TERMINALSALE("terminalSale"),
    
    CREDIT("credit"),
    
    DEBIT("debit"),
    
    ADJUSTMENT("adjustment");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public BalanceTransferRequest() { 
  }

  public BalanceTransferRequest amount(Amount amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "")

  public Amount getAmount() {
    return amount;
  }


  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public BalanceTransferRequest description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A human-readable description for the transfer. You can use alphanumeric characters and hyphens. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.
   * @return description
  **/
  @ApiModelProperty(value = "A human-readable description for the transfer. You can use alphanumeric characters and hyphens. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.")

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public BalanceTransferRequest fromMerchant(String fromMerchant) {
    
    this.fromMerchant = fromMerchant;
    return this;
  }

   /**
   * The unique identifier of the source merchant account from which funds are deducted.
   * @return fromMerchant
  **/
  @ApiModelProperty(required = true, value = "The unique identifier of the source merchant account from which funds are deducted.")

  public String getFromMerchant() {
    return fromMerchant;
  }


  public void setFromMerchant(String fromMerchant) {
    this.fromMerchant = fromMerchant;
  }


  public BalanceTransferRequest reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * A reference for the balance transfer. If you don&#39;t provide this in the request, Adyen generates a unique reference. Maximum length: 80 characters.
   * @return reference
  **/
  @ApiModelProperty(value = "A reference for the balance transfer. If you don't provide this in the request, Adyen generates a unique reference. Maximum length: 80 characters.")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public BalanceTransferRequest toMerchant(String toMerchant) {
    
    this.toMerchant = toMerchant;
    return this;
  }

   /**
   * The unique identifier of the destination merchant account from which funds are transferred.
   * @return toMerchant
  **/
  @ApiModelProperty(required = true, value = "The unique identifier of the destination merchant account from which funds are transferred.")

  public String getToMerchant() {
    return toMerchant;
  }


  public void setToMerchant(String toMerchant) {
    this.toMerchant = toMerchant;
  }


  public BalanceTransferRequest type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of balance transfer. Possible values: **tax**, **fee**, **terminalSale**, **credit**, **debit**, and **adjustment**.
   * @return type
  **/
  @ApiModelProperty(required = true, value = "The type of balance transfer. Possible values: **tax**, **fee**, **terminalSale**, **credit**, **debit**, and **adjustment**.")

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceTransferRequest balanceTransferRequest = (BalanceTransferRequest) o;
    return Objects.equals(this.amount, balanceTransferRequest.amount) &&
        Objects.equals(this.description, balanceTransferRequest.description) &&
        Objects.equals(this.fromMerchant, balanceTransferRequest.fromMerchant) &&
        Objects.equals(this.reference, balanceTransferRequest.reference) &&
        Objects.equals(this.toMerchant, balanceTransferRequest.toMerchant) &&
        Objects.equals(this.type, balanceTransferRequest.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, description, fromMerchant, reference, toMerchant, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceTransferRequest {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    fromMerchant: ").append(toIndentedString(fromMerchant)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    toMerchant: ").append(toIndentedString(toMerchant)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("amount");
    openapiFields.add("description");
    openapiFields.add("fromMerchant");
    openapiFields.add("reference");
    openapiFields.add("toMerchant");
    openapiFields.add("type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("amount");
    openapiRequiredFields.add("fromMerchant");
    openapiRequiredFields.add("toMerchant");
    openapiRequiredFields.add("type");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(BalanceTransferRequest.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to BalanceTransferRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (BalanceTransferRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in BalanceTransferRequest is not found in the empty JSON string", BalanceTransferRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!BalanceTransferRequest.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BalanceTransferRequest` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : BalanceTransferRequest.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field `amount`
      if (jsonObj.getAsJsonObject("amount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("amount"));
      }
      // validate the optional field description
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // validate the optional field fromMerchant
      if (jsonObj.get("fromMerchant") != null && !jsonObj.get("fromMerchant").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `fromMerchant` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fromMerchant").toString()));
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      // validate the optional field toMerchant
      if (jsonObj.get("toMerchant") != null && !jsonObj.get("toMerchant").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `toMerchant` to be a primitive type in the JSON string but got `%s`", jsonObj.get("toMerchant").toString()));
      }
      // ensure the field type can be parsed to an enum value
      if (jsonObj.get("type") != null) {
        if(!jsonObj.get("type").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
        }
        TypeEnum.fromValue(jsonObj.get("type").getAsString());
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BalanceTransferRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BalanceTransferRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BalanceTransferRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BalanceTransferRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<BalanceTransferRequest>() {
           @Override
           public void write(JsonWriter out, BalanceTransferRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BalanceTransferRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BalanceTransferRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BalanceTransferRequest
  * @throws IOException if the JSON string is invalid with respect to BalanceTransferRequest
  */
  public static BalanceTransferRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BalanceTransferRequest.class);
  }

 /**
  * Convert an instance of BalanceTransferRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

