/*
 * Adyen BinLookup API
 * The BIN Lookup API provides endpoints for retrieving information, such as cost estimates, and 3D Secure supported version based on a given BIN.  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning The BinLookup API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/BinLookup/v54/get3dsAvailability ```## Going live  To authneticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/BinLookup/v54/get3dsAvailability ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 54
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.binlookup;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.binlookup.JSON;

/**
 * CardBin
 */

public class CardBin {
  public static final String SERIALIZED_NAME_BIN = "bin";
  @SerializedName(SERIALIZED_NAME_BIN)
  private String bin;

  public static final String SERIALIZED_NAME_COMMERCIAL = "commercial";
  @SerializedName(SERIALIZED_NAME_COMMERCIAL)
  private Boolean commercial;

  public static final String SERIALIZED_NAME_FUNDING_SOURCE = "fundingSource";
  @SerializedName(SERIALIZED_NAME_FUNDING_SOURCE)
  private String fundingSource;

  public static final String SERIALIZED_NAME_FUNDS_AVAILABILITY = "fundsAvailability";
  @SerializedName(SERIALIZED_NAME_FUNDS_AVAILABILITY)
  private String fundsAvailability;

  public static final String SERIALIZED_NAME_ISSUER_BIN = "issuerBin";
  @SerializedName(SERIALIZED_NAME_ISSUER_BIN)
  private String issuerBin;

  public static final String SERIALIZED_NAME_ISSUING_BANK = "issuingBank";
  @SerializedName(SERIALIZED_NAME_ISSUING_BANK)
  private String issuingBank;

  public static final String SERIALIZED_NAME_ISSUING_COUNTRY = "issuingCountry";
  @SerializedName(SERIALIZED_NAME_ISSUING_COUNTRY)
  private String issuingCountry;

  public static final String SERIALIZED_NAME_ISSUING_CURRENCY = "issuingCurrency";
  @SerializedName(SERIALIZED_NAME_ISSUING_CURRENCY)
  private String issuingCurrency;

  public static final String SERIALIZED_NAME_PAYMENT_METHOD = "paymentMethod";
  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD)
  private String paymentMethod;

  public static final String SERIALIZED_NAME_PAYOUT_ELIGIBLE = "payoutEligible";
  @SerializedName(SERIALIZED_NAME_PAYOUT_ELIGIBLE)
  private String payoutEligible;

  public static final String SERIALIZED_NAME_SUMMARY = "summary";
  @SerializedName(SERIALIZED_NAME_SUMMARY)
  private String summary;

  public CardBin() { 
  }

  public CardBin bin(String bin) {
    
    this.bin = bin;
    return this;
  }

   /**
   * The first 6 digit of the card number. Enable this field via merchant account settings.
   * @return bin
  **/
  @ApiModelProperty(value = "The first 6 digit of the card number. Enable this field via merchant account settings.")

  public String getBin() {
    return bin;
  }


  public void setBin(String bin) {
    this.bin = bin;
  }


  public CardBin commercial(Boolean commercial) {
    
    this.commercial = commercial;
    return this;
  }

   /**
   * If true, it indicates a commercial card. Enable this field via merchant account settings.
   * @return commercial
  **/
  @ApiModelProperty(value = "If true, it indicates a commercial card. Enable this field via merchant account settings.")

  public Boolean getCommercial() {
    return commercial;
  }


  public void setCommercial(Boolean commercial) {
    this.commercial = commercial;
  }


  public CardBin fundingSource(String fundingSource) {
    
    this.fundingSource = fundingSource;
    return this;
  }

   /**
   * The card funding source. Valid values are: * CHARGE * CREDIT * DEBIT * DEFERRED_DEBIT * PREPAID * PREPAID_RELOADABLE * PREPAID_NONRELOADABLE &gt; Enable this field via merchant account settings.
   * @return fundingSource
  **/
  @ApiModelProperty(value = "The card funding source. Valid values are: * CHARGE * CREDIT * DEBIT * DEFERRED_DEBIT * PREPAID * PREPAID_RELOADABLE * PREPAID_NONRELOADABLE > Enable this field via merchant account settings.")

  public String getFundingSource() {
    return fundingSource;
  }


  public void setFundingSource(String fundingSource) {
    this.fundingSource = fundingSource;
  }


  public CardBin fundsAvailability(String fundsAvailability) {
    
    this.fundsAvailability = fundsAvailability;
    return this;
  }

   /**
   * Indicates availability of funds.  Visa: * \&quot;I\&quot; (fast funds are supported) * \&quot;N\&quot; (otherwise)  Mastercard: * \&quot;I\&quot; (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \&quot;N\&quot; (otherwise) &gt; Returned when you verify a card BIN or estimate costs, and only if &#x60;payoutEligible&#x60; is different from \&quot;N\&quot; or \&quot;U\&quot;.
   * @return fundsAvailability
  **/
  @ApiModelProperty(value = "Indicates availability of funds.  Visa: * \"I\" (fast funds are supported) * \"N\" (otherwise)  Mastercard: * \"I\" (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \"N\" (otherwise) > Returned when you verify a card BIN or estimate costs, and only if `payoutEligible` is different from \"N\" or \"U\".")

  public String getFundsAvailability() {
    return fundsAvailability;
  }


  public void setFundsAvailability(String fundsAvailability) {
    this.fundsAvailability = fundsAvailability;
  }


  public CardBin issuerBin(String issuerBin) {
    
    this.issuerBin = issuerBin;
    return this;
  }

   /**
   * The first 8 digit of the card number. Enable this field via merchant account settings.
   * @return issuerBin
  **/
  @ApiModelProperty(value = "The first 8 digit of the card number. Enable this field via merchant account settings.")

  public String getIssuerBin() {
    return issuerBin;
  }


  public void setIssuerBin(String issuerBin) {
    this.issuerBin = issuerBin;
  }


  public CardBin issuingBank(String issuingBank) {
    
    this.issuingBank = issuingBank;
    return this;
  }

   /**
   * The issuing bank of the card.
   * @return issuingBank
  **/
  @ApiModelProperty(value = "The issuing bank of the card.")

  public String getIssuingBank() {
    return issuingBank;
  }


  public void setIssuingBank(String issuingBank) {
    this.issuingBank = issuingBank;
  }


  public CardBin issuingCountry(String issuingCountry) {
    
    this.issuingCountry = issuingCountry;
    return this;
  }

   /**
   * The country where the card was issued from.
   * @return issuingCountry
  **/
  @ApiModelProperty(value = "The country where the card was issued from.")

  public String getIssuingCountry() {
    return issuingCountry;
  }


  public void setIssuingCountry(String issuingCountry) {
    this.issuingCountry = issuingCountry;
  }


  public CardBin issuingCurrency(String issuingCurrency) {
    
    this.issuingCurrency = issuingCurrency;
    return this;
  }

   /**
   * The currency of the card.
   * @return issuingCurrency
  **/
  @ApiModelProperty(value = "The currency of the card.")

  public String getIssuingCurrency() {
    return issuingCurrency;
  }


  public void setIssuingCurrency(String issuingCurrency) {
    this.issuingCurrency = issuingCurrency;
  }


  public CardBin paymentMethod(String paymentMethod) {
    
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * The payment method associated with the card (e.g. visa, mc, or amex).
   * @return paymentMethod
  **/
  @ApiModelProperty(value = "The payment method associated with the card (e.g. visa, mc, or amex).")

  public String getPaymentMethod() {
    return paymentMethod;
  }


  public void setPaymentMethod(String paymentMethod) {
    this.paymentMethod = paymentMethod;
  }


  public CardBin payoutEligible(String payoutEligible) {
    
    this.payoutEligible = payoutEligible;
    return this;
  }

   /**
   * Indicates whether a payout is eligible or not for this card.  Visa: * \&quot;Y\&quot; * \&quot;N\&quot;  Mastercard: * \&quot;Y\&quot; (domestic and cross-border) * \&quot;D\&quot; (only domestic) * \&quot;N\&quot; (no MoneySend) * \&quot;U\&quot; (unknown) &gt; Returned when you verify a card BIN or estimate costs, and only if &#x60;payoutEligible&#x60; is different from \&quot;N\&quot; or \&quot;U\&quot;.
   * @return payoutEligible
  **/
  @ApiModelProperty(value = "Indicates whether a payout is eligible or not for this card.  Visa: * \"Y\" * \"N\"  Mastercard: * \"Y\" (domestic and cross-border) * \"D\" (only domestic) * \"N\" (no MoneySend) * \"U\" (unknown) > Returned when you verify a card BIN or estimate costs, and only if `payoutEligible` is different from \"N\" or \"U\".")

  public String getPayoutEligible() {
    return payoutEligible;
  }


  public void setPayoutEligible(String payoutEligible) {
    this.payoutEligible = payoutEligible;
  }


  public CardBin summary(String summary) {
    
    this.summary = summary;
    return this;
  }

   /**
   * The last four digits of the card number.
   * @return summary
  **/
  @ApiModelProperty(value = "The last four digits of the card number.")

  public String getSummary() {
    return summary;
  }


  public void setSummary(String summary) {
    this.summary = summary;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardBin cardBin = (CardBin) o;
    return Objects.equals(this.bin, cardBin.bin) &&
        Objects.equals(this.commercial, cardBin.commercial) &&
        Objects.equals(this.fundingSource, cardBin.fundingSource) &&
        Objects.equals(this.fundsAvailability, cardBin.fundsAvailability) &&
        Objects.equals(this.issuerBin, cardBin.issuerBin) &&
        Objects.equals(this.issuingBank, cardBin.issuingBank) &&
        Objects.equals(this.issuingCountry, cardBin.issuingCountry) &&
        Objects.equals(this.issuingCurrency, cardBin.issuingCurrency) &&
        Objects.equals(this.paymentMethod, cardBin.paymentMethod) &&
        Objects.equals(this.payoutEligible, cardBin.payoutEligible) &&
        Objects.equals(this.summary, cardBin.summary);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bin, commercial, fundingSource, fundsAvailability, issuerBin, issuingBank, issuingCountry, issuingCurrency, paymentMethod, payoutEligible, summary);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardBin {\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    commercial: ").append(toIndentedString(commercial)).append("\n");
    sb.append("    fundingSource: ").append(toIndentedString(fundingSource)).append("\n");
    sb.append("    fundsAvailability: ").append(toIndentedString(fundsAvailability)).append("\n");
    sb.append("    issuerBin: ").append(toIndentedString(issuerBin)).append("\n");
    sb.append("    issuingBank: ").append(toIndentedString(issuingBank)).append("\n");
    sb.append("    issuingCountry: ").append(toIndentedString(issuingCountry)).append("\n");
    sb.append("    issuingCurrency: ").append(toIndentedString(issuingCurrency)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    payoutEligible: ").append(toIndentedString(payoutEligible)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("bin");
    openapiFields.add("commercial");
    openapiFields.add("fundingSource");
    openapiFields.add("fundsAvailability");
    openapiFields.add("issuerBin");
    openapiFields.add("issuingBank");
    openapiFields.add("issuingCountry");
    openapiFields.add("issuingCurrency");
    openapiFields.add("paymentMethod");
    openapiFields.add("payoutEligible");
    openapiFields.add("summary");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(CardBin.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CardBin
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (CardBin.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in CardBin is not found in the empty JSON string", CardBin.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!CardBin.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CardBin` properties.", entry.getKey()));
        }
      }
      // validate the optional field bin
      if (jsonObj.get("bin") != null && !jsonObj.get("bin").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `bin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bin").toString()));
      }
      // validate the optional field fundingSource
      if (jsonObj.get("fundingSource") != null && !jsonObj.get("fundingSource").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `fundingSource` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fundingSource").toString()));
      }
      // validate the optional field fundsAvailability
      if (jsonObj.get("fundsAvailability") != null && !jsonObj.get("fundsAvailability").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `fundsAvailability` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fundsAvailability").toString()));
      }
      // validate the optional field issuerBin
      if (jsonObj.get("issuerBin") != null && !jsonObj.get("issuerBin").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `issuerBin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issuerBin").toString()));
      }
      // validate the optional field issuingBank
      if (jsonObj.get("issuingBank") != null && !jsonObj.get("issuingBank").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `issuingBank` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issuingBank").toString()));
      }
      // validate the optional field issuingCountry
      if (jsonObj.get("issuingCountry") != null && !jsonObj.get("issuingCountry").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `issuingCountry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issuingCountry").toString()));
      }
      // validate the optional field issuingCurrency
      if (jsonObj.get("issuingCurrency") != null && !jsonObj.get("issuingCurrency").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `issuingCurrency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issuingCurrency").toString()));
      }
      // validate the optional field paymentMethod
      if (jsonObj.get("paymentMethod") != null && !jsonObj.get("paymentMethod").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentMethod").toString()));
      }
      // validate the optional field payoutEligible
      if (jsonObj.get("payoutEligible") != null && !jsonObj.get("payoutEligible").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `payoutEligible` to be a primitive type in the JSON string but got `%s`", jsonObj.get("payoutEligible").toString()));
      }
      // validate the optional field summary
      if (jsonObj.get("summary") != null && !jsonObj.get("summary").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get("summary").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CardBin.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CardBin' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CardBin> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CardBin.class));

       return (TypeAdapter<T>) new TypeAdapter<CardBin>() {
           @Override
           public void write(JsonWriter out, CardBin value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CardBin read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CardBin given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CardBin
  * @throws IOException if the JSON string is invalid with respect to CardBin
  */
  public static CardBin fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CardBin.class);
  }

 /**
  * Convert an instance of CardBin to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

