/*
 * Adyen BinLookup API
 * The BIN Lookup API provides endpoints for retrieving information, such as cost estimates, and 3D Secure supported version based on a given BIN.  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning The BinLookup API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/BinLookup/v54/get3dsAvailability ```## Going live  To authneticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/BinLookup/v54/get3dsAvailability ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 54
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.binlookup;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.binlookup.JSON;

/**
 * DSPublicKeyDetail
 */

public class DSPublicKeyDetail {
  public static final String SERIALIZED_NAME_BRAND = "brand";
  @SerializedName(SERIALIZED_NAME_BRAND)
  private String brand;

  public static final String SERIALIZED_NAME_DIRECTORY_SERVER_ID = "directoryServerId";
  @SerializedName(SERIALIZED_NAME_DIRECTORY_SERVER_ID)
  private String directoryServerId;

  public static final String SERIALIZED_NAME_FROM_S_D_K_VERSION = "fromSDKVersion";
  @SerializedName(SERIALIZED_NAME_FROM_S_D_K_VERSION)
  private String fromSDKVersion;

  public static final String SERIALIZED_NAME_PUBLIC_KEY = "publicKey";
  @SerializedName(SERIALIZED_NAME_PUBLIC_KEY)
  private byte[] publicKey;

  public DSPublicKeyDetail() { 
  }

  public DSPublicKeyDetail brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Card brand.
   * @return brand
  **/
  @ApiModelProperty(value = "Card brand.")

  public String getBrand() {
    return brand;
  }


  public void setBrand(String brand) {
    this.brand = brand;
  }


  public DSPublicKeyDetail directoryServerId(String directoryServerId) {
    
    this.directoryServerId = directoryServerId;
    return this;
  }

   /**
   * Directory Server (DS) identifier.
   * @return directoryServerId
  **/
  @ApiModelProperty(value = "Directory Server (DS) identifier.")

  public String getDirectoryServerId() {
    return directoryServerId;
  }


  public void setDirectoryServerId(String directoryServerId) {
    this.directoryServerId = directoryServerId;
  }


  public DSPublicKeyDetail fromSDKVersion(String fromSDKVersion) {
    
    this.fromSDKVersion = fromSDKVersion;
    return this;
  }

   /**
   * The version of the mobile 3D Secure 2 SDK. For the possible values, refer to the versions in [Adyen 3DS2 Android](https://github.com/Adyen/adyen-3ds2-android/releases) and [Adyen 3DS2 iOS](https://github.com/Adyen/adyen-3ds2-ios/releases).
   * @return fromSDKVersion
  **/
  @ApiModelProperty(value = "The version of the mobile 3D Secure 2 SDK. For the possible values, refer to the versions in [Adyen 3DS2 Android](https://github.com/Adyen/adyen-3ds2-android/releases) and [Adyen 3DS2 iOS](https://github.com/Adyen/adyen-3ds2-ios/releases).")

  public String getFromSDKVersion() {
    return fromSDKVersion;
  }


  public void setFromSDKVersion(String fromSDKVersion) {
    this.fromSDKVersion = fromSDKVersion;
  }


  public DSPublicKeyDetail publicKey(byte[] publicKey) {
    
    this.publicKey = publicKey;
    return this;
  }

   /**
   * Public key. The 3D Secure 2 SDK encrypts the device information by using the DS public key.
   * @return publicKey
  **/
  @ApiModelProperty(value = "Public key. The 3D Secure 2 SDK encrypts the device information by using the DS public key.")

  public byte[] getPublicKey() {
    return publicKey;
  }


  public void setPublicKey(byte[] publicKey) {
    this.publicKey = publicKey;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DSPublicKeyDetail dsPublicKeyDetail = (DSPublicKeyDetail) o;
    return Objects.equals(this.brand, dsPublicKeyDetail.brand) &&
        Objects.equals(this.directoryServerId, dsPublicKeyDetail.directoryServerId) &&
        Objects.equals(this.fromSDKVersion, dsPublicKeyDetail.fromSDKVersion) &&
        Arrays.equals(this.publicKey, dsPublicKeyDetail.publicKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(brand, directoryServerId, fromSDKVersion, Arrays.hashCode(publicKey));
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DSPublicKeyDetail {\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    directoryServerId: ").append(toIndentedString(directoryServerId)).append("\n");
    sb.append("    fromSDKVersion: ").append(toIndentedString(fromSDKVersion)).append("\n");
    sb.append("    publicKey: ").append(toIndentedString(publicKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("brand");
    openapiFields.add("directoryServerId");
    openapiFields.add("fromSDKVersion");
    openapiFields.add("publicKey");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(DSPublicKeyDetail.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to DSPublicKeyDetail
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (DSPublicKeyDetail.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in DSPublicKeyDetail is not found in the empty JSON string", DSPublicKeyDetail.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!DSPublicKeyDetail.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `DSPublicKeyDetail` properties.", entry.getKey()));
        }
      }
      // validate the optional field brand
      if (jsonObj.get("brand") != null && !jsonObj.get("brand").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `brand` to be a primitive type in the JSON string but got `%s`", jsonObj.get("brand").toString()));
      }
      // validate the optional field directoryServerId
      if (jsonObj.get("directoryServerId") != null && !jsonObj.get("directoryServerId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `directoryServerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("directoryServerId").toString()));
      }
      // validate the optional field fromSDKVersion
      if (jsonObj.get("fromSDKVersion") != null && !jsonObj.get("fromSDKVersion").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `fromSDKVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fromSDKVersion").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!DSPublicKeyDetail.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'DSPublicKeyDetail' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<DSPublicKeyDetail> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(DSPublicKeyDetail.class));

       return (TypeAdapter<T>) new TypeAdapter<DSPublicKeyDetail>() {
           @Override
           public void write(JsonWriter out, DSPublicKeyDetail value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public DSPublicKeyDetail read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of DSPublicKeyDetail given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of DSPublicKeyDetail
  * @throws IOException if the JSON string is invalid with respect to DSPublicKeyDetail
  */
  public static DSPublicKeyDetail fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, DSPublicKeyDetail.class);
  }

 /**
  * Convert an instance of DSPublicKeyDetail to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

