/*
 * Capital API
 * Adyen Capital allows you to build an embedded financing offering for your users to serve their operational needs. Learn more about [Adyen Capital](https://docs.adyen.com/marketplaces-and-platforms/capital).  ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -H \"Content-Type: application/json\" \\ -U \"ws@BalancePlatform.YOUR_BALANCE_PLATFORM\":\"YOUR_WS_PASSWORD\" \\ ... ``` ## Roles and permissions To use the Capital API, you need an additional role for your API credential. Your Adyen contact will set up the roles and permissions for you. ## Versioning The Capital API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://balanceplatform-api-test.adyen.com/btl/v3/grants ``` ## Going live When going live, your Adyen contact will provide your API credential for the live environment. You can then use the username and password to send requests to `https://balanceplatform-api-live.adyen.com/btl/v3`.  
 *
 * The version of the OpenAPI document: 3
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.capital;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.capital.Amount;
import com.adyen.model.capital.CapitalBalance;
import com.adyen.model.capital.Counterparty;
import com.adyen.model.capital.Fee;
import com.adyen.model.capital.Repayment;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.capital.JSON;

/**
 * CapitalGrant
 */

public class CapitalGrant {
  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Amount amount;

  public static final String SERIALIZED_NAME_BALANCES = "balances";
  @SerializedName(SERIALIZED_NAME_BALANCES)
  private CapitalBalance balances;

  public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
  @SerializedName(SERIALIZED_NAME_COUNTERPARTY)
  private Counterparty counterparty;

  public static final String SERIALIZED_NAME_FEE = "fee";
  @SerializedName(SERIALIZED_NAME_FEE)
  private Fee fee;

  public static final String SERIALIZED_NAME_GRANT_ACCOUNT_ID = "grantAccountId";
  @SerializedName(SERIALIZED_NAME_GRANT_ACCOUNT_ID)
  private String grantAccountId;

  public static final String SERIALIZED_NAME_GRANT_OFFER_ID = "grantOfferId";
  @SerializedName(SERIALIZED_NAME_GRANT_OFFER_ID)
  private String grantOfferId;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_REPAYMENT = "repayment";
  @SerializedName(SERIALIZED_NAME_REPAYMENT)
  private Repayment repayment;

  /**
   * The current status of the grant. Possible values: **Pending**, **Active**, **Repaid**.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    PENDING("Pending"),
    
    ACTIVE("Active"),
    
    REPAID("Repaid");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public CapitalGrant() { 
  }

  public CapitalGrant amount(Amount amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(value = "")

  public Amount getAmount() {
    return amount;
  }


  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public CapitalGrant balances(CapitalBalance balances) {
    
    this.balances = balances;
    return this;
  }

   /**
   * Get balances
   * @return balances
  **/
  @ApiModelProperty(required = true, value = "")

  public CapitalBalance getBalances() {
    return balances;
  }


  public void setBalances(CapitalBalance balances) {
    this.balances = balances;
  }


  public CapitalGrant counterparty(Counterparty counterparty) {
    
    this.counterparty = counterparty;
    return this;
  }

   /**
   * Get counterparty
   * @return counterparty
  **/
  @ApiModelProperty(value = "")

  public Counterparty getCounterparty() {
    return counterparty;
  }


  public void setCounterparty(Counterparty counterparty) {
    this.counterparty = counterparty;
  }


  public CapitalGrant fee(Fee fee) {
    
    this.fee = fee;
    return this;
  }

   /**
   * Get fee
   * @return fee
  **/
  @ApiModelProperty(value = "")

  public Fee getFee() {
    return fee;
  }


  public void setFee(Fee fee) {
    this.fee = fee;
  }


  public CapitalGrant grantAccountId(String grantAccountId) {
    
    this.grantAccountId = grantAccountId;
    return this;
  }

   /**
   * The identifier of the grant account used for the grant.
   * @return grantAccountId
  **/
  @ApiModelProperty(required = true, value = "The identifier of the grant account used for the grant.")

  public String getGrantAccountId() {
    return grantAccountId;
  }


  public void setGrantAccountId(String grantAccountId) {
    this.grantAccountId = grantAccountId;
  }


  public CapitalGrant grantOfferId(String grantOfferId) {
    
    this.grantOfferId = grantOfferId;
    return this;
  }

   /**
   * The identifier of the grant offer that has been selected and from which the grant details will be used.
   * @return grantOfferId
  **/
  @ApiModelProperty(required = true, value = "The identifier of the grant offer that has been selected and from which the grant details will be used.")

  public String getGrantOfferId() {
    return grantOfferId;
  }


  public void setGrantOfferId(String grantOfferId) {
    this.grantOfferId = grantOfferId;
  }


  public CapitalGrant id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The identifier of the grant reference.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The identifier of the grant reference.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public CapitalGrant repayment(Repayment repayment) {
    
    this.repayment = repayment;
    return this;
  }

   /**
   * Get repayment
   * @return repayment
  **/
  @ApiModelProperty(value = "")

  public Repayment getRepayment() {
    return repayment;
  }


  public void setRepayment(Repayment repayment) {
    this.repayment = repayment;
  }


  public CapitalGrant status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * The current status of the grant. Possible values: **Pending**, **Active**, **Repaid**.
   * @return status
  **/
  @ApiModelProperty(required = true, value = "The current status of the grant. Possible values: **Pending**, **Active**, **Repaid**.")

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CapitalGrant capitalGrant = (CapitalGrant) o;
    return Objects.equals(this.amount, capitalGrant.amount) &&
        Objects.equals(this.balances, capitalGrant.balances) &&
        Objects.equals(this.counterparty, capitalGrant.counterparty) &&
        Objects.equals(this.fee, capitalGrant.fee) &&
        Objects.equals(this.grantAccountId, capitalGrant.grantAccountId) &&
        Objects.equals(this.grantOfferId, capitalGrant.grantOfferId) &&
        Objects.equals(this.id, capitalGrant.id) &&
        Objects.equals(this.repayment, capitalGrant.repayment) &&
        Objects.equals(this.status, capitalGrant.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, balances, counterparty, fee, grantAccountId, grantOfferId, id, repayment, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CapitalGrant {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balances: ").append(toIndentedString(balances)).append("\n");
    sb.append("    counterparty: ").append(toIndentedString(counterparty)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    grantAccountId: ").append(toIndentedString(grantAccountId)).append("\n");
    sb.append("    grantOfferId: ").append(toIndentedString(grantOfferId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    repayment: ").append(toIndentedString(repayment)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("amount");
    openapiFields.add("balances");
    openapiFields.add("counterparty");
    openapiFields.add("fee");
    openapiFields.add("grantAccountId");
    openapiFields.add("grantOfferId");
    openapiFields.add("id");
    openapiFields.add("repayment");
    openapiFields.add("status");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("balances");
    openapiRequiredFields.add("grantAccountId");
    openapiRequiredFields.add("grantOfferId");
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("status");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(CapitalGrant.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CapitalGrant
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (CapitalGrant.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in CapitalGrant is not found in the empty JSON string", CapitalGrant.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!CapitalGrant.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CapitalGrant` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CapitalGrant.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field `amount`
      if (jsonObj.getAsJsonObject("amount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("amount"));
      }
      // validate the optional field `balances`
      if (jsonObj.getAsJsonObject("balances") != null) {
        CapitalBalance.validateJsonObject(jsonObj.getAsJsonObject("balances"));
      }
      // validate the optional field `counterparty`
      if (jsonObj.getAsJsonObject("counterparty") != null) {
        Counterparty.validateJsonObject(jsonObj.getAsJsonObject("counterparty"));
      }
      // validate the optional field `fee`
      if (jsonObj.getAsJsonObject("fee") != null) {
        Fee.validateJsonObject(jsonObj.getAsJsonObject("fee"));
      }
      // validate the optional field grantAccountId
      if (jsonObj.get("grantAccountId") != null && !jsonObj.get("grantAccountId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `grantAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("grantAccountId").toString()));
      }
      // validate the optional field grantOfferId
      if (jsonObj.get("grantOfferId") != null && !jsonObj.get("grantOfferId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `grantOfferId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("grantOfferId").toString()));
      }
      // validate the optional field id
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the optional field `repayment`
      if (jsonObj.getAsJsonObject("repayment") != null) {
        Repayment.validateJsonObject(jsonObj.getAsJsonObject("repayment"));
      }
      // ensure the field status can be parsed to an enum value
      if (jsonObj.get("status") != null) {
        if(!jsonObj.get("status").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
        }
        StatusEnum.fromValue(jsonObj.get("status").getAsString());
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CapitalGrant.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CapitalGrant' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CapitalGrant> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CapitalGrant.class));

       return (TypeAdapter<T>) new TypeAdapter<CapitalGrant>() {
           @Override
           public void write(JsonWriter out, CapitalGrant value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CapitalGrant read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CapitalGrant given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CapitalGrant
  * @throws IOException if the JSON string is invalid with respect to CapitalGrant
  */
  public static CapitalGrant fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CapitalGrant.class);
  }

 /**
  * Convert an instance of CapitalGrant to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

