/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * AdditionalDataTemporaryServices
 */

public class AdditionalDataTemporaryServices {
  public static final String SERIALIZED_NAME_ENHANCED_SCHEME_DATA_CUSTOMER_REFERENCE = "enhancedSchemeData.customerReference";
  @SerializedName(SERIALIZED_NAME_ENHANCED_SCHEME_DATA_CUSTOMER_REFERENCE)
  private String enhancedSchemeDataCustomerReference;

  public static final String SERIALIZED_NAME_ENHANCED_SCHEME_DATA_EMPLOYEE_NAME = "enhancedSchemeData.employeeName";
  @SerializedName(SERIALIZED_NAME_ENHANCED_SCHEME_DATA_EMPLOYEE_NAME)
  private String enhancedSchemeDataEmployeeName;

  public static final String SERIALIZED_NAME_ENHANCED_SCHEME_DATA_JOB_DESCRIPTION = "enhancedSchemeData.jobDescription";
  @SerializedName(SERIALIZED_NAME_ENHANCED_SCHEME_DATA_JOB_DESCRIPTION)
  private String enhancedSchemeDataJobDescription;

  public static final String SERIALIZED_NAME_ENHANCED_SCHEME_DATA_REGULAR_HOURS_RATE = "enhancedSchemeData.regularHoursRate";
  @SerializedName(SERIALIZED_NAME_ENHANCED_SCHEME_DATA_REGULAR_HOURS_RATE)
  private String enhancedSchemeDataRegularHoursRate;

  public static final String SERIALIZED_NAME_ENHANCED_SCHEME_DATA_REGULAR_HOURS_WORKED = "enhancedSchemeData.regularHoursWorked";
  @SerializedName(SERIALIZED_NAME_ENHANCED_SCHEME_DATA_REGULAR_HOURS_WORKED)
  private String enhancedSchemeDataRegularHoursWorked;

  public static final String SERIALIZED_NAME_ENHANCED_SCHEME_DATA_REQUEST_NAME = "enhancedSchemeData.requestName";
  @SerializedName(SERIALIZED_NAME_ENHANCED_SCHEME_DATA_REQUEST_NAME)
  private String enhancedSchemeDataRequestName;

  public static final String SERIALIZED_NAME_ENHANCED_SCHEME_DATA_TEMP_START_DATE = "enhancedSchemeData.tempStartDate";
  @SerializedName(SERIALIZED_NAME_ENHANCED_SCHEME_DATA_TEMP_START_DATE)
  private String enhancedSchemeDataTempStartDate;

  public static final String SERIALIZED_NAME_ENHANCED_SCHEME_DATA_TEMP_WEEK_ENDING = "enhancedSchemeData.tempWeekEnding";
  @SerializedName(SERIALIZED_NAME_ENHANCED_SCHEME_DATA_TEMP_WEEK_ENDING)
  private String enhancedSchemeDataTempWeekEnding;

  public static final String SERIALIZED_NAME_ENHANCED_SCHEME_DATA_TOTAL_TAX_AMOUNT = "enhancedSchemeData.totalTaxAmount";
  @SerializedName(SERIALIZED_NAME_ENHANCED_SCHEME_DATA_TOTAL_TAX_AMOUNT)
  private String enhancedSchemeDataTotalTaxAmount;

  public AdditionalDataTemporaryServices() { 
  }

  public AdditionalDataTemporaryServices enhancedSchemeDataCustomerReference(String enhancedSchemeDataCustomerReference) {
    
    this.enhancedSchemeDataCustomerReference = enhancedSchemeDataCustomerReference;
    return this;
  }

   /**
   * The customer code, if supplied by a customer. * Encoding: ASCII * maxLength: 25
   * @return enhancedSchemeDataCustomerReference
  **/
  @ApiModelProperty(value = "The customer code, if supplied by a customer. * Encoding: ASCII * maxLength: 25")

  public String getEnhancedSchemeDataCustomerReference() {
    return enhancedSchemeDataCustomerReference;
  }


  public void setEnhancedSchemeDataCustomerReference(String enhancedSchemeDataCustomerReference) {
    this.enhancedSchemeDataCustomerReference = enhancedSchemeDataCustomerReference;
  }


  public AdditionalDataTemporaryServices enhancedSchemeDataEmployeeName(String enhancedSchemeDataEmployeeName) {
    
    this.enhancedSchemeDataEmployeeName = enhancedSchemeDataEmployeeName;
    return this;
  }

   /**
   * The name or ID of the person working in a temporary capacity. * maxLength: 40 * Must not be all zeros * Must not be all spaces
   * @return enhancedSchemeDataEmployeeName
  **/
  @ApiModelProperty(value = "The name or ID of the person working in a temporary capacity. * maxLength: 40 * Must not be all zeros * Must not be all spaces")

  public String getEnhancedSchemeDataEmployeeName() {
    return enhancedSchemeDataEmployeeName;
  }


  public void setEnhancedSchemeDataEmployeeName(String enhancedSchemeDataEmployeeName) {
    this.enhancedSchemeDataEmployeeName = enhancedSchemeDataEmployeeName;
  }


  public AdditionalDataTemporaryServices enhancedSchemeDataJobDescription(String enhancedSchemeDataJobDescription) {
    
    this.enhancedSchemeDataJobDescription = enhancedSchemeDataJobDescription;
    return this;
  }

   /**
   * The job description of the person working in a temporary capacity. * maxLength: 40 * Must not be all zeros * Must not be all spaces
   * @return enhancedSchemeDataJobDescription
  **/
  @ApiModelProperty(value = "The job description of the person working in a temporary capacity. * maxLength: 40 * Must not be all zeros * Must not be all spaces")

  public String getEnhancedSchemeDataJobDescription() {
    return enhancedSchemeDataJobDescription;
  }


  public void setEnhancedSchemeDataJobDescription(String enhancedSchemeDataJobDescription) {
    this.enhancedSchemeDataJobDescription = enhancedSchemeDataJobDescription;
  }


  public AdditionalDataTemporaryServices enhancedSchemeDataRegularHoursRate(String enhancedSchemeDataRegularHoursRate) {
    
    this.enhancedSchemeDataRegularHoursRate = enhancedSchemeDataRegularHoursRate;
    return this;
  }

   /**
   * The amount paid for regular hours worked, [minor units](https://docs.adyen.com/development-resources/currency-codes). * maxLength: 7 * Must not be empty * Can be all zeros
   * @return enhancedSchemeDataRegularHoursRate
  **/
  @ApiModelProperty(value = "The amount paid for regular hours worked, [minor units](https://docs.adyen.com/development-resources/currency-codes). * maxLength: 7 * Must not be empty * Can be all zeros")

  public String getEnhancedSchemeDataRegularHoursRate() {
    return enhancedSchemeDataRegularHoursRate;
  }


  public void setEnhancedSchemeDataRegularHoursRate(String enhancedSchemeDataRegularHoursRate) {
    this.enhancedSchemeDataRegularHoursRate = enhancedSchemeDataRegularHoursRate;
  }


  public AdditionalDataTemporaryServices enhancedSchemeDataRegularHoursWorked(String enhancedSchemeDataRegularHoursWorked) {
    
    this.enhancedSchemeDataRegularHoursWorked = enhancedSchemeDataRegularHoursWorked;
    return this;
  }

   /**
   * The hours worked. * maxLength: 7 * Must not be empty * Can be all zeros
   * @return enhancedSchemeDataRegularHoursWorked
  **/
  @ApiModelProperty(value = "The hours worked. * maxLength: 7 * Must not be empty * Can be all zeros")

  public String getEnhancedSchemeDataRegularHoursWorked() {
    return enhancedSchemeDataRegularHoursWorked;
  }


  public void setEnhancedSchemeDataRegularHoursWorked(String enhancedSchemeDataRegularHoursWorked) {
    this.enhancedSchemeDataRegularHoursWorked = enhancedSchemeDataRegularHoursWorked;
  }


  public AdditionalDataTemporaryServices enhancedSchemeDataRequestName(String enhancedSchemeDataRequestName) {
    
    this.enhancedSchemeDataRequestName = enhancedSchemeDataRequestName;
    return this;
  }

   /**
   * The name of the person requesting temporary services. * maxLength: 40 * Must not be all zeros * Must not be all spaces
   * @return enhancedSchemeDataRequestName
  **/
  @ApiModelProperty(value = "The name of the person requesting temporary services. * maxLength: 40 * Must not be all zeros * Must not be all spaces")

  public String getEnhancedSchemeDataRequestName() {
    return enhancedSchemeDataRequestName;
  }


  public void setEnhancedSchemeDataRequestName(String enhancedSchemeDataRequestName) {
    this.enhancedSchemeDataRequestName = enhancedSchemeDataRequestName;
  }


  public AdditionalDataTemporaryServices enhancedSchemeDataTempStartDate(String enhancedSchemeDataTempStartDate) {
    
    this.enhancedSchemeDataTempStartDate = enhancedSchemeDataTempStartDate;
    return this;
  }

   /**
   * The billing period start date. * Format: ddMMyy * maxLength: 6
   * @return enhancedSchemeDataTempStartDate
  **/
  @ApiModelProperty(value = "The billing period start date. * Format: ddMMyy * maxLength: 6")

  public String getEnhancedSchemeDataTempStartDate() {
    return enhancedSchemeDataTempStartDate;
  }


  public void setEnhancedSchemeDataTempStartDate(String enhancedSchemeDataTempStartDate) {
    this.enhancedSchemeDataTempStartDate = enhancedSchemeDataTempStartDate;
  }


  public AdditionalDataTemporaryServices enhancedSchemeDataTempWeekEnding(String enhancedSchemeDataTempWeekEnding) {
    
    this.enhancedSchemeDataTempWeekEnding = enhancedSchemeDataTempWeekEnding;
    return this;
  }

   /**
   * The billing period end date. * Format: ddMMyy * maxLength: 6
   * @return enhancedSchemeDataTempWeekEnding
  **/
  @ApiModelProperty(value = "The billing period end date. * Format: ddMMyy * maxLength: 6")

  public String getEnhancedSchemeDataTempWeekEnding() {
    return enhancedSchemeDataTempWeekEnding;
  }


  public void setEnhancedSchemeDataTempWeekEnding(String enhancedSchemeDataTempWeekEnding) {
    this.enhancedSchemeDataTempWeekEnding = enhancedSchemeDataTempWeekEnding;
  }


  public AdditionalDataTemporaryServices enhancedSchemeDataTotalTaxAmount(String enhancedSchemeDataTotalTaxAmount) {
    
    this.enhancedSchemeDataTotalTaxAmount = enhancedSchemeDataTotalTaxAmount;
    return this;
  }

   /**
   * The total tax amount, in [minor units](https://docs.adyen.com/development-resources/currency-codes). For example, 2000 means USD 20.00 * maxLength: 12
   * @return enhancedSchemeDataTotalTaxAmount
  **/
  @ApiModelProperty(value = "The total tax amount, in [minor units](https://docs.adyen.com/development-resources/currency-codes). For example, 2000 means USD 20.00 * maxLength: 12")

  public String getEnhancedSchemeDataTotalTaxAmount() {
    return enhancedSchemeDataTotalTaxAmount;
  }


  public void setEnhancedSchemeDataTotalTaxAmount(String enhancedSchemeDataTotalTaxAmount) {
    this.enhancedSchemeDataTotalTaxAmount = enhancedSchemeDataTotalTaxAmount;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdditionalDataTemporaryServices additionalDataTemporaryServices = (AdditionalDataTemporaryServices) o;
    return Objects.equals(this.enhancedSchemeDataCustomerReference, additionalDataTemporaryServices.enhancedSchemeDataCustomerReference) &&
        Objects.equals(this.enhancedSchemeDataEmployeeName, additionalDataTemporaryServices.enhancedSchemeDataEmployeeName) &&
        Objects.equals(this.enhancedSchemeDataJobDescription, additionalDataTemporaryServices.enhancedSchemeDataJobDescription) &&
        Objects.equals(this.enhancedSchemeDataRegularHoursRate, additionalDataTemporaryServices.enhancedSchemeDataRegularHoursRate) &&
        Objects.equals(this.enhancedSchemeDataRegularHoursWorked, additionalDataTemporaryServices.enhancedSchemeDataRegularHoursWorked) &&
        Objects.equals(this.enhancedSchemeDataRequestName, additionalDataTemporaryServices.enhancedSchemeDataRequestName) &&
        Objects.equals(this.enhancedSchemeDataTempStartDate, additionalDataTemporaryServices.enhancedSchemeDataTempStartDate) &&
        Objects.equals(this.enhancedSchemeDataTempWeekEnding, additionalDataTemporaryServices.enhancedSchemeDataTempWeekEnding) &&
        Objects.equals(this.enhancedSchemeDataTotalTaxAmount, additionalDataTemporaryServices.enhancedSchemeDataTotalTaxAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enhancedSchemeDataCustomerReference, enhancedSchemeDataEmployeeName, enhancedSchemeDataJobDescription, enhancedSchemeDataRegularHoursRate, enhancedSchemeDataRegularHoursWorked, enhancedSchemeDataRequestName, enhancedSchemeDataTempStartDate, enhancedSchemeDataTempWeekEnding, enhancedSchemeDataTotalTaxAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdditionalDataTemporaryServices {\n");
    sb.append("    enhancedSchemeDataCustomerReference: ").append(toIndentedString(enhancedSchemeDataCustomerReference)).append("\n");
    sb.append("    enhancedSchemeDataEmployeeName: ").append(toIndentedString(enhancedSchemeDataEmployeeName)).append("\n");
    sb.append("    enhancedSchemeDataJobDescription: ").append(toIndentedString(enhancedSchemeDataJobDescription)).append("\n");
    sb.append("    enhancedSchemeDataRegularHoursRate: ").append(toIndentedString(enhancedSchemeDataRegularHoursRate)).append("\n");
    sb.append("    enhancedSchemeDataRegularHoursWorked: ").append(toIndentedString(enhancedSchemeDataRegularHoursWorked)).append("\n");
    sb.append("    enhancedSchemeDataRequestName: ").append(toIndentedString(enhancedSchemeDataRequestName)).append("\n");
    sb.append("    enhancedSchemeDataTempStartDate: ").append(toIndentedString(enhancedSchemeDataTempStartDate)).append("\n");
    sb.append("    enhancedSchemeDataTempWeekEnding: ").append(toIndentedString(enhancedSchemeDataTempWeekEnding)).append("\n");
    sb.append("    enhancedSchemeDataTotalTaxAmount: ").append(toIndentedString(enhancedSchemeDataTotalTaxAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("enhancedSchemeData.customerReference");
    openapiFields.add("enhancedSchemeData.employeeName");
    openapiFields.add("enhancedSchemeData.jobDescription");
    openapiFields.add("enhancedSchemeData.regularHoursRate");
    openapiFields.add("enhancedSchemeData.regularHoursWorked");
    openapiFields.add("enhancedSchemeData.requestName");
    openapiFields.add("enhancedSchemeData.tempStartDate");
    openapiFields.add("enhancedSchemeData.tempWeekEnding");
    openapiFields.add("enhancedSchemeData.totalTaxAmount");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(AdditionalDataTemporaryServices.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to AdditionalDataTemporaryServices
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (AdditionalDataTemporaryServices.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in AdditionalDataTemporaryServices is not found in the empty JSON string", AdditionalDataTemporaryServices.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!AdditionalDataTemporaryServices.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `AdditionalDataTemporaryServices` properties.", entry.getKey()));
        }
      }
      // validate the optional field enhancedSchemeData.customerReference
      if (jsonObj.get("enhancedSchemeData.customerReference") != null && !jsonObj.get("enhancedSchemeData.customerReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `enhancedSchemeData.customerReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enhancedSchemeData.customerReference").toString()));
      }
      // validate the optional field enhancedSchemeData.employeeName
      if (jsonObj.get("enhancedSchemeData.employeeName") != null && !jsonObj.get("enhancedSchemeData.employeeName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `enhancedSchemeData.employeeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enhancedSchemeData.employeeName").toString()));
      }
      // validate the optional field enhancedSchemeData.jobDescription
      if (jsonObj.get("enhancedSchemeData.jobDescription") != null && !jsonObj.get("enhancedSchemeData.jobDescription").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `enhancedSchemeData.jobDescription` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enhancedSchemeData.jobDescription").toString()));
      }
      // validate the optional field enhancedSchemeData.regularHoursRate
      if (jsonObj.get("enhancedSchemeData.regularHoursRate") != null && !jsonObj.get("enhancedSchemeData.regularHoursRate").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `enhancedSchemeData.regularHoursRate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enhancedSchemeData.regularHoursRate").toString()));
      }
      // validate the optional field enhancedSchemeData.regularHoursWorked
      if (jsonObj.get("enhancedSchemeData.regularHoursWorked") != null && !jsonObj.get("enhancedSchemeData.regularHoursWorked").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `enhancedSchemeData.regularHoursWorked` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enhancedSchemeData.regularHoursWorked").toString()));
      }
      // validate the optional field enhancedSchemeData.requestName
      if (jsonObj.get("enhancedSchemeData.requestName") != null && !jsonObj.get("enhancedSchemeData.requestName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `enhancedSchemeData.requestName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enhancedSchemeData.requestName").toString()));
      }
      // validate the optional field enhancedSchemeData.tempStartDate
      if (jsonObj.get("enhancedSchemeData.tempStartDate") != null && !jsonObj.get("enhancedSchemeData.tempStartDate").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `enhancedSchemeData.tempStartDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enhancedSchemeData.tempStartDate").toString()));
      }
      // validate the optional field enhancedSchemeData.tempWeekEnding
      if (jsonObj.get("enhancedSchemeData.tempWeekEnding") != null && !jsonObj.get("enhancedSchemeData.tempWeekEnding").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `enhancedSchemeData.tempWeekEnding` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enhancedSchemeData.tempWeekEnding").toString()));
      }
      // validate the optional field enhancedSchemeData.totalTaxAmount
      if (jsonObj.get("enhancedSchemeData.totalTaxAmount") != null && !jsonObj.get("enhancedSchemeData.totalTaxAmount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `enhancedSchemeData.totalTaxAmount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enhancedSchemeData.totalTaxAmount").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AdditionalDataTemporaryServices.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AdditionalDataTemporaryServices' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AdditionalDataTemporaryServices> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AdditionalDataTemporaryServices.class));

       return (TypeAdapter<T>) new TypeAdapter<AdditionalDataTemporaryServices>() {
           @Override
           public void write(JsonWriter out, AdditionalDataTemporaryServices value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AdditionalDataTemporaryServices read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AdditionalDataTemporaryServices given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AdditionalDataTemporaryServices
  * @throws IOException if the JSON string is invalid with respect to AdditionalDataTemporaryServices
  */
  public static AdditionalDataTemporaryServices fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AdditionalDataTemporaryServices.class);
  }

 /**
  * Convert an instance of AdditionalDataTemporaryServices to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

