/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * Avs
 */

public class Avs {
  public static final String SERIALIZED_NAME_ADDRESS_EDITABLE = "addressEditable";
  @SerializedName(SERIALIZED_NAME_ADDRESS_EDITABLE)
  private Boolean addressEditable;

  /**
   * Specifies whether the shopper should enter their billing address during checkout.  Allowed values: * yes — Perform AVS checks for every card payment. * automatic — Perform AVS checks only when required to optimize the conversion rate. * no — Do not perform AVS checks.
   */
  @JsonAdapter(EnabledEnum.Adapter.class)
  public enum EnabledEnum {
    YES("yes"),
    
    NO("no"),
    
    AUTOMATIC("automatic");

    private String value;

    EnabledEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EnabledEnum fromValue(String value) {
      for (EnabledEnum b : EnabledEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<EnabledEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EnabledEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EnabledEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EnabledEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ENABLED = "enabled";
  @SerializedName(SERIALIZED_NAME_ENABLED)
  private EnabledEnum enabled;

  public Avs() { 
  }

  public Avs addressEditable(Boolean addressEditable) {
    
    this.addressEditable = addressEditable;
    return this;
  }

   /**
   * Indicates whether the shopper is allowed to modify the billing address for the current payment request.
   * @return addressEditable
  **/
  @ApiModelProperty(value = "Indicates whether the shopper is allowed to modify the billing address for the current payment request.")

  public Boolean getAddressEditable() {
    return addressEditable;
  }


  public void setAddressEditable(Boolean addressEditable) {
    this.addressEditable = addressEditable;
  }


  public Avs enabled(EnabledEnum enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Specifies whether the shopper should enter their billing address during checkout.  Allowed values: * yes — Perform AVS checks for every card payment. * automatic — Perform AVS checks only when required to optimize the conversion rate. * no — Do not perform AVS checks.
   * @return enabled
  **/
  @ApiModelProperty(value = "Specifies whether the shopper should enter their billing address during checkout.  Allowed values: * yes — Perform AVS checks for every card payment. * automatic — Perform AVS checks only when required to optimize the conversion rate. * no — Do not perform AVS checks.")

  public EnabledEnum getEnabled() {
    return enabled;
  }


  public void setEnabled(EnabledEnum enabled) {
    this.enabled = enabled;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Avs avs = (Avs) o;
    return Objects.equals(this.addressEditable, avs.addressEditable) &&
        Objects.equals(this.enabled, avs.enabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressEditable, enabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Avs {\n");
    sb.append("    addressEditable: ").append(toIndentedString(addressEditable)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("addressEditable");
    openapiFields.add("enabled");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(Avs.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Avs
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Avs.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Avs is not found in the empty JSON string", Avs.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Avs.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Avs` properties.", entry.getKey()));
        }
      }
      // ensure the field enabled can be parsed to an enum value
      if (jsonObj.get("enabled") != null) {
        if(!jsonObj.get("enabled").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `enabled` to be a primitive type in the JSON string but got `%s`", jsonObj.get("enabled").toString()));
        }
        EnabledEnum.fromValue(jsonObj.get("enabled").getAsString());
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Avs.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Avs' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Avs> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Avs.class));

       return (TypeAdapter<T>) new TypeAdapter<Avs>() {
           @Override
           public void write(JsonWriter out, Avs value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Avs read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Avs given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Avs
  * @throws IOException if the JSON string is invalid with respect to Avs
  */
  public static Avs fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Avs.class);
  }

 /**
  * Convert an instance of Avs to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

