/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * CheckoutUtilityResponse
 */

public class CheckoutUtilityResponse {
  public static final String SERIALIZED_NAME_ORIGIN_KEYS = "originKeys";
  @SerializedName(SERIALIZED_NAME_ORIGIN_KEYS)
  private Map<String, String> originKeys = null;

  public CheckoutUtilityResponse() { 
  }

  public CheckoutUtilityResponse originKeys(Map<String, String> originKeys) {
    
    this.originKeys = originKeys;
    return this;
  }

  public CheckoutUtilityResponse putOriginKeysItem(String key, String originKeysItem) {
    if (this.originKeys == null) {
      this.originKeys = new HashMap<>();
    }
    this.originKeys.put(key, originKeysItem);
    return this;
  }

   /**
   * The list of origin keys for all requested domains. For each list item, the key is the domain and the value is the origin key.
   * @return originKeys
  **/
  @ApiModelProperty(value = "The list of origin keys for all requested domains. For each list item, the key is the domain and the value is the origin key.")

  public Map<String, String> getOriginKeys() {
    return originKeys;
  }


  public void setOriginKeys(Map<String, String> originKeys) {
    this.originKeys = originKeys;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckoutUtilityResponse checkoutUtilityResponse = (CheckoutUtilityResponse) o;
    return Objects.equals(this.originKeys, checkoutUtilityResponse.originKeys);
  }

  @Override
  public int hashCode() {
    return Objects.hash(originKeys);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckoutUtilityResponse {\n");
    sb.append("    originKeys: ").append(toIndentedString(originKeys)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("originKeys");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(CheckoutUtilityResponse.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CheckoutUtilityResponse
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (CheckoutUtilityResponse.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in CheckoutUtilityResponse is not found in the empty JSON string", CheckoutUtilityResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!CheckoutUtilityResponse.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CheckoutUtilityResponse` properties.", entry.getKey()));
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CheckoutUtilityResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CheckoutUtilityResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CheckoutUtilityResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CheckoutUtilityResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<CheckoutUtilityResponse>() {
           @Override
           public void write(JsonWriter out, CheckoutUtilityResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CheckoutUtilityResponse read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CheckoutUtilityResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CheckoutUtilityResponse
  * @throws IOException if the JSON string is invalid with respect to CheckoutUtilityResponse
  */
  public static CheckoutUtilityResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CheckoutUtilityResponse.class);
  }

 /**
  * Convert an instance of CheckoutUtilityResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

