/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * ShopperInteractionDevice
 */

public class ShopperInteractionDevice {
  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_OS = "os";
  @SerializedName(SERIALIZED_NAME_OS)
  private String os;

  public static final String SERIALIZED_NAME_OS_VERSION = "osVersion";
  @SerializedName(SERIALIZED_NAME_OS_VERSION)
  private String osVersion;

  public ShopperInteractionDevice() { 
  }

  public ShopperInteractionDevice locale(String locale) {
    
    this.locale = locale;
    return this;
  }

   /**
   * Locale on the shopper interaction device.
   * @return locale
  **/
  @ApiModelProperty(value = "Locale on the shopper interaction device.")

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }


  public ShopperInteractionDevice os(String os) {
    
    this.os = os;
    return this;
  }

   /**
   * Operating system running on the shopper interaction device.
   * @return os
  **/
  @ApiModelProperty(value = "Operating system running on the shopper interaction device.")

  public String getOs() {
    return os;
  }


  public void setOs(String os) {
    this.os = os;
  }


  public ShopperInteractionDevice osVersion(String osVersion) {
    
    this.osVersion = osVersion;
    return this;
  }

   /**
   * Version of the operating system on the shopper interaction device.
   * @return osVersion
  **/
  @ApiModelProperty(value = "Version of the operating system on the shopper interaction device.")

  public String getOsVersion() {
    return osVersion;
  }


  public void setOsVersion(String osVersion) {
    this.osVersion = osVersion;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShopperInteractionDevice shopperInteractionDevice = (ShopperInteractionDevice) o;
    return Objects.equals(this.locale, shopperInteractionDevice.locale) &&
        Objects.equals(this.os, shopperInteractionDevice.os) &&
        Objects.equals(this.osVersion, shopperInteractionDevice.osVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(locale, os, osVersion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShopperInteractionDevice {\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    os: ").append(toIndentedString(os)).append("\n");
    sb.append("    osVersion: ").append(toIndentedString(osVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("locale");
    openapiFields.add("os");
    openapiFields.add("osVersion");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(ShopperInteractionDevice.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ShopperInteractionDevice
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ShopperInteractionDevice.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ShopperInteractionDevice is not found in the empty JSON string", ShopperInteractionDevice.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ShopperInteractionDevice.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ShopperInteractionDevice` properties.", entry.getKey()));
        }
      }
      // validate the optional field locale
      if (jsonObj.get("locale") != null && !jsonObj.get("locale").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `locale` to be a primitive type in the JSON string but got `%s`", jsonObj.get("locale").toString()));
      }
      // validate the optional field os
      if (jsonObj.get("os") != null && !jsonObj.get("os").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `os` to be a primitive type in the JSON string but got `%s`", jsonObj.get("os").toString()));
      }
      // validate the optional field osVersion
      if (jsonObj.get("osVersion") != null && !jsonObj.get("osVersion").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `osVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get("osVersion").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ShopperInteractionDevice.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ShopperInteractionDevice' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ShopperInteractionDevice> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ShopperInteractionDevice.class));

       return (TypeAdapter<T>) new TypeAdapter<ShopperInteractionDevice>() {
           @Override
           public void write(JsonWriter out, ShopperInteractionDevice value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ShopperInteractionDevice read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ShopperInteractionDevice given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ShopperInteractionDevice
  * @throws IOException if the JSON string is invalid with respect to ShopperInteractionDevice
  */
  public static ShopperInteractionDevice fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ShopperInteractionDevice.class);
  }

 /**
  * Convert an instance of ShopperInteractionDevice to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

