/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.legalentitymanagement.Amount;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.legalentitymanagement.JSON;

/**
 * CapabilitySettings
 */

public class CapabilitySettings {
  public static final String SERIALIZED_NAME_AMOUNT_PER_INDUSTRY = "amountPerIndustry";
  @SerializedName(SERIALIZED_NAME_AMOUNT_PER_INDUSTRY)
  private Map<String, Amount> amountPerIndustry = null;

  public static final String SERIALIZED_NAME_AUTHORIZED_CARD_USERS = "authorizedCardUsers";
  @SerializedName(SERIALIZED_NAME_AUTHORIZED_CARD_USERS)
  private Boolean authorizedCardUsers;

  /**
   * Gets or Sets fundingSource
   */
  @JsonAdapter(FundingSourceEnum.Adapter.class)
  public enum FundingSourceEnum {
    CREDIT("credit"),
    
    DEBIT("debit"),
    
    PREPAID("prepaid");

    private String value;

    FundingSourceEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static FundingSourceEnum fromValue(String value) {
      for (FundingSourceEnum b : FundingSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<FundingSourceEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FundingSourceEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public FundingSourceEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return FundingSourceEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_FUNDING_SOURCE = "fundingSource";
  @SerializedName(SERIALIZED_NAME_FUNDING_SOURCE)
  private List<FundingSourceEnum> fundingSource = null;

  /**
   * The period when the rule conditions apply.
   */
  @JsonAdapter(IntervalEnum.Adapter.class)
  public enum IntervalEnum {
    DAILY("daily"),
    
    MONTHLY("monthly"),
    
    WEEKLY("weekly");

    private String value;

    IntervalEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static IntervalEnum fromValue(String value) {
      for (IntervalEnum b : IntervalEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<IntervalEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final IntervalEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public IntervalEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return IntervalEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INTERVAL = "interval";
  @SerializedName(SERIALIZED_NAME_INTERVAL)
  private IntervalEnum interval;

  public static final String SERIALIZED_NAME_MAX_AMOUNT = "maxAmount";
  @SerializedName(SERIALIZED_NAME_MAX_AMOUNT)
  private Amount maxAmount;

  public CapabilitySettings() { 
  }

  public CapabilitySettings amountPerIndustry(Map<String, Amount> amountPerIndustry) {
    
    this.amountPerIndustry = amountPerIndustry;
    return this;
  }

  public CapabilitySettings putAmountPerIndustryItem(String key, Amount amountPerIndustryItem) {
    if (this.amountPerIndustry == null) {
      this.amountPerIndustry = new HashMap<>();
    }
    this.amountPerIndustry.put(key, amountPerIndustryItem);
    return this;
  }

   /**
   * The maximum amount a card holder can spend per industry.
   * @return amountPerIndustry
  **/
  @ApiModelProperty(value = "The maximum amount a card holder can spend per industry.")

  public Map<String, Amount> getAmountPerIndustry() {
    return amountPerIndustry;
  }


  public void setAmountPerIndustry(Map<String, Amount> amountPerIndustry) {
    this.amountPerIndustry = amountPerIndustry;
  }


  public CapabilitySettings authorizedCardUsers(Boolean authorizedCardUsers) {
    
    this.authorizedCardUsers = authorizedCardUsers;
    return this;
  }

   /**
   * The number of card holders who can use the card.
   * @return authorizedCardUsers
  **/
  @ApiModelProperty(value = "The number of card holders who can use the card.")

  public Boolean getAuthorizedCardUsers() {
    return authorizedCardUsers;
  }


  public void setAuthorizedCardUsers(Boolean authorizedCardUsers) {
    this.authorizedCardUsers = authorizedCardUsers;
  }


  public CapabilitySettings fundingSource(List<FundingSourceEnum> fundingSource) {
    
    this.fundingSource = fundingSource;
    return this;
  }

  public CapabilitySettings addFundingSourceItem(FundingSourceEnum fundingSourceItem) {
    if (this.fundingSource == null) {
      this.fundingSource = new ArrayList<>();
    }
    this.fundingSource.add(fundingSourceItem);
    return this;
  }

   /**
   * The funding source of the card, for example **debit**.
   * @return fundingSource
  **/
  @ApiModelProperty(value = "The funding source of the card, for example **debit**.")

  public List<FundingSourceEnum> getFundingSource() {
    return fundingSource;
  }


  public void setFundingSource(List<FundingSourceEnum> fundingSource) {
    this.fundingSource = fundingSource;
  }


  public CapabilitySettings interval(IntervalEnum interval) {
    
    this.interval = interval;
    return this;
  }

   /**
   * The period when the rule conditions apply.
   * @return interval
  **/
  @ApiModelProperty(value = "The period when the rule conditions apply.")

  public IntervalEnum getInterval() {
    return interval;
  }


  public void setInterval(IntervalEnum interval) {
    this.interval = interval;
  }


  public CapabilitySettings maxAmount(Amount maxAmount) {
    
    this.maxAmount = maxAmount;
    return this;
  }

   /**
   * Get maxAmount
   * @return maxAmount
  **/
  @ApiModelProperty(value = "")

  public Amount getMaxAmount() {
    return maxAmount;
  }


  public void setMaxAmount(Amount maxAmount) {
    this.maxAmount = maxAmount;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CapabilitySettings capabilitySettings = (CapabilitySettings) o;
    return Objects.equals(this.amountPerIndustry, capabilitySettings.amountPerIndustry) &&
        Objects.equals(this.authorizedCardUsers, capabilitySettings.authorizedCardUsers) &&
        Objects.equals(this.fundingSource, capabilitySettings.fundingSource) &&
        Objects.equals(this.interval, capabilitySettings.interval) &&
        Objects.equals(this.maxAmount, capabilitySettings.maxAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amountPerIndustry, authorizedCardUsers, fundingSource, interval, maxAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CapabilitySettings {\n");
    sb.append("    amountPerIndustry: ").append(toIndentedString(amountPerIndustry)).append("\n");
    sb.append("    authorizedCardUsers: ").append(toIndentedString(authorizedCardUsers)).append("\n");
    sb.append("    fundingSource: ").append(toIndentedString(fundingSource)).append("\n");
    sb.append("    interval: ").append(toIndentedString(interval)).append("\n");
    sb.append("    maxAmount: ").append(toIndentedString(maxAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("amountPerIndustry");
    openapiFields.add("authorizedCardUsers");
    openapiFields.add("fundingSource");
    openapiFields.add("interval");
    openapiFields.add("maxAmount");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(CapabilitySettings.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CapabilitySettings
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (CapabilitySettings.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in CapabilitySettings is not found in the empty JSON string", CapabilitySettings.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!CapabilitySettings.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CapabilitySettings` properties.", entry.getKey()));
        }
      }
      // ensure the json data is an array
      if (jsonObj.get("fundingSource") != null && !jsonObj.get("fundingSource").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `fundingSource` to be an array in the JSON string but got `%s`", jsonObj.get("fundingSource").toString()));
      }
      // ensure the field interval can be parsed to an enum value
      if (jsonObj.get("interval") != null) {
        if(!jsonObj.get("interval").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `interval` to be a primitive type in the JSON string but got `%s`", jsonObj.get("interval").toString()));
        }
        IntervalEnum.fromValue(jsonObj.get("interval").getAsString());
      }
      // validate the optional field `maxAmount`
      if (jsonObj.getAsJsonObject("maxAmount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("maxAmount"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CapabilitySettings.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CapabilitySettings' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CapabilitySettings> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CapabilitySettings.class));

       return (TypeAdapter<T>) new TypeAdapter<CapabilitySettings>() {
           @Override
           public void write(JsonWriter out, CapabilitySettings value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CapabilitySettings read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CapabilitySettings given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CapabilitySettings
  * @throws IOException if the JSON string is invalid with respect to CapabilitySettings
  */
  public static CapabilitySettings fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CapabilitySettings.class);
  }

 /**
  * Convert an instance of CapabilitySettings to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

