/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonElement;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.TypeSelector;

import org.apache.commons.codec.binary.Base64;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.HashMap;

/*
 * A JSON utility class
 *
 * NOTE: in the future, this class may be converted to static, which may break
 *       backward-compatibility
 */
public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson = false;
    private static DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private static SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private static LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
    private static ByteArrayAdapter byteArrayAdapter = new ByteArrayAdapter();

    @SuppressWarnings("unchecked")
    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder()
        ;
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    /**
     * Returns the Java class that implements the OpenAPI schema for the specified discriminator value.
     *
     * @param classByDiscriminatorValue The map of discriminator values to Java classes.
     * @param discriminatorValue The value of the OpenAPI discriminator in the input data.
     * @return The Java class that implements the OpenAPI schema
     */
    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class) classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    static {
        GsonBuilder gsonBuilder = createGson();
        gsonBuilder.registerTypeAdapter(Date.class, dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.AULocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.AcceptTermsOfServiceRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.AcceptTermsOfServiceResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.AdditionalBankIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.Address.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.Amount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.Attachment.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.BankAccountInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.BankAccountInfoAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.BirthData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.BusinessLine.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.BusinessLineInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.BusinessLineInfoUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.BusinessLines.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.CALocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.CZLocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.CapabilityProblem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.CapabilityProblemEntity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.CapabilityProblemEntityRecursive.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.CapabilitySettings.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.DKLocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.Document.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.DocumentReference.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.EntityReference.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.GeneratePciDescriptionRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.GeneratePciDescriptionResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.GetPciQuestionnaireInfosResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.GetPciQuestionnaireResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.GetTermsOfServiceAcceptanceInfosResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.GetTermsOfServiceDocumentRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.GetTermsOfServiceDocumentResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.HULocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.IbanAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.IdentificationData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.Individual.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.LegalEntity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.LegalEntityAssociation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.LegalEntityCapability.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.LegalEntityInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.LegalEntityInfoRequiredType.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.NOLocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.Name.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.NumberAndBicAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.OnboardingLink.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.OnboardingLinkInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.OnboardingTheme.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.OnboardingThemes.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.Organization.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.OwnerEntity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.PLLocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.PciDocumentInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.PciSigningRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.PciSigningResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.PhoneNumber.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.RemediatingAction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.SELocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.ServiceError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.SoleProprietorship.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.SourceOfFunds.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.StockData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.SupportingEntityCapability.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.TaxInformation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.TaxReportingClassification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.TermsOfServiceAcceptanceInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.TransferInstrument.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.TransferInstrumentInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.TransferInstrumentReference.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.UKLocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.USLocalAccountIdentification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.VerificationError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.VerificationErrorRecursive.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.VerificationErrors.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.WebData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.adyen.model.legalentitymanagement.WebDataExemption.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    /**
     * Get Gson.
     *
     * @return Gson
     */
    public static Gson getGson() {
        return gson;
    }

    /**
     * Set Gson.
     *
     * @param gson Gson
     */
    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    /**
     * Serialize the given Java object into JSON string.
     *
     * @param obj Object
     * @return String representation of the JSON
     */
    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    /**
     * Deserialize the given JSON string to Java object.
     *
     * @param <T>        Type
     * @param body       The JSON string
     * @param returnType The type to deserialize into
     * @return The deserialized Java object
     */
    @SuppressWarnings("unchecked")
    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                // see https://google-gson.googlecode.com/svn/trunk/gson/docs/javadocs/com/google/gson/stream/JsonReader.html#setLenient(boolean)
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            } else {
                return gson.fromJson(body, returnType);
            }
        } catch (JsonParseException e) {
            // Fallback processing when failed to parse JSON form response body:
            // return the response body string directly for the String return type;
            if (returnType.equals(String.class)) {
                return (T) body;
            } else {
                throw (e);
            }
        }
    }

    /**
     * Gson TypeAdapter for Byte Array type
     */
    public static class ByteArrayAdapter extends TypeAdapter<byte[]> {

        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(new String(value));
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String bytesAsBase64 = in.nextString();
                    return Base64.decodeBase64(bytesAsBase64);
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 OffsetDateTime type
     */
    public static class OffsetDateTimeTypeAdapter extends TypeAdapter<OffsetDateTime> {

        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    if (date.endsWith("+0000")) {
                        date = date.substring(0, date.length()-5) + "Z";
                    }
                    return OffsetDateTime.parse(date, formatter);
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 LocalDate type
     */
    public static class LocalDateTypeAdapter extends TypeAdapter<LocalDate> {

        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    return LocalDate.parse(date, formatter);
            }
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    /**
     * Gson TypeAdapter for java.sql.Date type
     * If the dateFormat is null, a simple "yyyy-MM-dd" format will be used
     * (more efficient than SimpleDateFormat).
     */
    public static class SqlDateTypeAdapter extends TypeAdapter<java.sql.Date> {

        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {}

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toString();
                }
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    try {
                        if (dateFormat != null) {
                            return new java.sql.Date(dateFormat.parse(date).getTime());
                        }
                        return new java.sql.Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
                    } catch (ParseException e) {
                        throw new JsonParseException(e);
                    }
            }
        }
    }

    /**
     * Gson TypeAdapter for java.util.Date type
     * If the dateFormat is null, ISO8601Utils will be used.
     */
    public static class DateTypeAdapter extends TypeAdapter<Date> {

        private DateFormat dateFormat;

        public DateTypeAdapter() {}

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = ISO8601Utils.format(date, true);
                }
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL:
                        in.nextNull();
                        return null;
                    default:
                        String date = in.nextString();
                        try {
                            if (dateFormat != null) {
                                return dateFormat.parse(date);
                            }
                            return ISO8601Utils.parse(date, new ParsePosition(0));
                        } catch (ParseException e) {
                            throw new JsonParseException(e);
                        }
                }
            } catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }
}
