/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.legalentitymanagement.OnboardingTheme;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.legalentitymanagement.JSON;

/**
 * OnboardingThemes
 */

public class OnboardingThemes {
  public static final String SERIALIZED_NAME_NEXT = "next";
  @SerializedName(SERIALIZED_NAME_NEXT)
  private String next;

  public static final String SERIALIZED_NAME_PREVIOUS = "previous";
  @SerializedName(SERIALIZED_NAME_PREVIOUS)
  private String previous;

  public static final String SERIALIZED_NAME_THEMES = "themes";
  @SerializedName(SERIALIZED_NAME_THEMES)
  private List<OnboardingTheme> themes = new ArrayList<>();

  public OnboardingThemes() { 
  }

  public OnboardingThemes next(String next) {
    
    this.next = next;
    return this;
  }

   /**
   * The next page. Only present if there is a next page.
   * @return next
  **/
  @ApiModelProperty(value = "The next page. Only present if there is a next page.")

  public String getNext() {
    return next;
  }


  public void setNext(String next) {
    this.next = next;
  }


  public OnboardingThemes previous(String previous) {
    
    this.previous = previous;
    return this;
  }

   /**
   * The previous page. Only present if there is a previous page.
   * @return previous
  **/
  @ApiModelProperty(value = "The previous page. Only present if there is a previous page.")

  public String getPrevious() {
    return previous;
  }


  public void setPrevious(String previous) {
    this.previous = previous;
  }


  public OnboardingThemes themes(List<OnboardingTheme> themes) {
    
    this.themes = themes;
    return this;
  }

  public OnboardingThemes addThemesItem(OnboardingTheme themesItem) {
    this.themes.add(themesItem);
    return this;
  }

   /**
   * List of onboarding themes.
   * @return themes
  **/
  @ApiModelProperty(required = true, value = "List of onboarding themes.")

  public List<OnboardingTheme> getThemes() {
    return themes;
  }


  public void setThemes(List<OnboardingTheme> themes) {
    this.themes = themes;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OnboardingThemes onboardingThemes = (OnboardingThemes) o;
    return Objects.equals(this.next, onboardingThemes.next) &&
        Objects.equals(this.previous, onboardingThemes.previous) &&
        Objects.equals(this.themes, onboardingThemes.themes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(next, previous, themes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OnboardingThemes {\n");
    sb.append("    next: ").append(toIndentedString(next)).append("\n");
    sb.append("    previous: ").append(toIndentedString(previous)).append("\n");
    sb.append("    themes: ").append(toIndentedString(themes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("next");
    openapiFields.add("previous");
    openapiFields.add("themes");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("themes");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(OnboardingThemes.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to OnboardingThemes
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (OnboardingThemes.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in OnboardingThemes is not found in the empty JSON string", OnboardingThemes.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!OnboardingThemes.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `OnboardingThemes` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : OnboardingThemes.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field next
      if (jsonObj.get("next") != null && !jsonObj.get("next").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `next` to be a primitive type in the JSON string but got `%s`", jsonObj.get("next").toString()));
      }
      // validate the optional field previous
      if (jsonObj.get("previous") != null && !jsonObj.get("previous").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `previous` to be a primitive type in the JSON string but got `%s`", jsonObj.get("previous").toString()));
      }
      JsonArray jsonArraythemes = jsonObj.getAsJsonArray("themes");
      if (jsonArraythemes != null) {
        // ensure the json data is an array
        if (!jsonObj.get("themes").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `themes` to be an array in the JSON string but got `%s`", jsonObj.get("themes").toString()));
        }

        // validate the optional field `themes` (array)
        for (int i = 0; i < jsonArraythemes.size(); i++) {
          OnboardingTheme.validateJsonObject(jsonArraythemes.get(i).getAsJsonObject());
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!OnboardingThemes.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'OnboardingThemes' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<OnboardingThemes> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(OnboardingThemes.class));

       return (TypeAdapter<T>) new TypeAdapter<OnboardingThemes>() {
           @Override
           public void write(JsonWriter out, OnboardingThemes value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public OnboardingThemes read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of OnboardingThemes given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of OnboardingThemes
  * @throws IOException if the JSON string is invalid with respect to OnboardingThemes
  */
  public static OnboardingThemes fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, OnboardingThemes.class);
  }

 /**
  * Convert an instance of OnboardingThemes to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

