/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * Settings
 */

public class Settings {
  public static final String SERIALIZED_NAME_BAND = "band";
  @SerializedName(SERIALIZED_NAME_BAND)
  private String band;

  public static final String SERIALIZED_NAME_ROAMING = "roaming";
  @SerializedName(SERIALIZED_NAME_ROAMING)
  private Boolean roaming;

  public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
  @SerializedName(SERIALIZED_NAME_TIMEOUT)
  private Integer timeout;

  public Settings() { 
  }

  public Settings band(String band) {
    
    this.band = band;
    return this;
  }

   /**
   * The preferred Wi-Fi band, for use if the terminals support multiple bands. Possible values: All, 2.4GHz, 5GHz.
   * @return band
  **/
  @ApiModelProperty(value = "The preferred Wi-Fi band, for use if the terminals support multiple bands. Possible values: All, 2.4GHz, 5GHz.")

  public String getBand() {
    return band;
  }


  public void setBand(String band) {
    this.band = band;
  }


  public Settings roaming(Boolean roaming) {
    
    this.roaming = roaming;
    return this;
  }

   /**
   * Indicates whether roaming is enabled on the terminals.
   * @return roaming
  **/
  @ApiModelProperty(value = "Indicates whether roaming is enabled on the terminals.")

  public Boolean getRoaming() {
    return roaming;
  }


  public void setRoaming(Boolean roaming) {
    this.roaming = roaming;
  }


  public Settings timeout(Integer timeout) {
    
    this.timeout = timeout;
    return this;
  }

   /**
   * The connection time-out in seconds. Minimum value: 0.
   * @return timeout
  **/
  @ApiModelProperty(value = "The connection time-out in seconds. Minimum value: 0.")

  public Integer getTimeout() {
    return timeout;
  }


  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Settings settings = (Settings) o;
    return Objects.equals(this.band, settings.band) &&
        Objects.equals(this.roaming, settings.roaming) &&
        Objects.equals(this.timeout, settings.timeout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(band, roaming, timeout);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Settings {\n");
    sb.append("    band: ").append(toIndentedString(band)).append("\n");
    sb.append("    roaming: ").append(toIndentedString(roaming)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("band");
    openapiFields.add("roaming");
    openapiFields.add("timeout");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(Settings.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Settings
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Settings.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Settings is not found in the empty JSON string", Settings.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Settings.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Settings` properties.", entry.getKey()));
        }
      }
      // validate the optional field band
      if (jsonObj.get("band") != null && !jsonObj.get("band").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `band` to be a primitive type in the JSON string but got `%s`", jsonObj.get("band").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Settings.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Settings' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Settings> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Settings.class));

       return (TypeAdapter<T>) new TypeAdapter<Settings>() {
           @Override
           public void write(JsonWriter out, Settings value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Settings read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Settings given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Settings
  * @throws IOException if the JSON string is invalid with respect to Settings
  */
  public static Settings fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Settings.class);
  }

 /**
  * Convert an instance of Settings to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

