/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * Signature
 */

public class Signature {
  public static final String SERIALIZED_NAME_ASK_SIGNATURE_ON_SCREEN = "askSignatureOnScreen";
  @SerializedName(SERIALIZED_NAME_ASK_SIGNATURE_ON_SCREEN)
  private Boolean askSignatureOnScreen;

  public static final String SERIALIZED_NAME_DEVICE_NAME = "deviceName";
  @SerializedName(SERIALIZED_NAME_DEVICE_NAME)
  private String deviceName;

  public static final String SERIALIZED_NAME_DEVICE_SLOGAN = "deviceSlogan";
  @SerializedName(SERIALIZED_NAME_DEVICE_SLOGAN)
  private String deviceSlogan;

  public static final String SERIALIZED_NAME_SKIP_SIGNATURE = "skipSignature";
  @SerializedName(SERIALIZED_NAME_SKIP_SIGNATURE)
  private Boolean skipSignature;

  public Signature() { 
  }

  public Signature askSignatureOnScreen(Boolean askSignatureOnScreen) {
    
    this.askSignatureOnScreen = askSignatureOnScreen;
    return this;
  }

   /**
   * If &#x60;skipSignature&#x60; is false, indicates whether the shopper should provide a signature on the display (**true**) or on the merchant receipt (**false**).
   * @return askSignatureOnScreen
  **/
  @ApiModelProperty(value = "If `skipSignature` is false, indicates whether the shopper should provide a signature on the display (**true**) or on the merchant receipt (**false**).")

  public Boolean getAskSignatureOnScreen() {
    return askSignatureOnScreen;
  }


  public void setAskSignatureOnScreen(Boolean askSignatureOnScreen) {
    this.askSignatureOnScreen = askSignatureOnScreen;
  }


  public Signature deviceName(String deviceName) {
    
    this.deviceName = deviceName;
    return this;
  }

   /**
   * Name that identifies the terminal.
   * @return deviceName
  **/
  @ApiModelProperty(value = "Name that identifies the terminal.")

  public String getDeviceName() {
    return deviceName;
  }


  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }


  public Signature deviceSlogan(String deviceSlogan) {
    
    this.deviceSlogan = deviceSlogan;
    return this;
  }

   /**
   * Slogan shown on the start screen of the device.
   * @return deviceSlogan
  **/
  @ApiModelProperty(value = "Slogan shown on the start screen of the device.")

  public String getDeviceSlogan() {
    return deviceSlogan;
  }


  public void setDeviceSlogan(String deviceSlogan) {
    this.deviceSlogan = deviceSlogan;
  }


  public Signature skipSignature(Boolean skipSignature) {
    
    this.skipSignature = skipSignature;
    return this;
  }

   /**
   * Skip asking for a signature. This is possible because all global card schemes (American Express, Diners, Discover, JCB, MasterCard, VISA, and UnionPay) regard a signature as optional.
   * @return skipSignature
  **/
  @ApiModelProperty(value = "Skip asking for a signature. This is possible because all global card schemes (American Express, Diners, Discover, JCB, MasterCard, VISA, and UnionPay) regard a signature as optional.")

  public Boolean getSkipSignature() {
    return skipSignature;
  }


  public void setSkipSignature(Boolean skipSignature) {
    this.skipSignature = skipSignature;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Signature signature = (Signature) o;
    return Objects.equals(this.askSignatureOnScreen, signature.askSignatureOnScreen) &&
        Objects.equals(this.deviceName, signature.deviceName) &&
        Objects.equals(this.deviceSlogan, signature.deviceSlogan) &&
        Objects.equals(this.skipSignature, signature.skipSignature);
  }

  @Override
  public int hashCode() {
    return Objects.hash(askSignatureOnScreen, deviceName, deviceSlogan, skipSignature);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Signature {\n");
    sb.append("    askSignatureOnScreen: ").append(toIndentedString(askSignatureOnScreen)).append("\n");
    sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
    sb.append("    deviceSlogan: ").append(toIndentedString(deviceSlogan)).append("\n");
    sb.append("    skipSignature: ").append(toIndentedString(skipSignature)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("askSignatureOnScreen");
    openapiFields.add("deviceName");
    openapiFields.add("deviceSlogan");
    openapiFields.add("skipSignature");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(Signature.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Signature
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Signature.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Signature is not found in the empty JSON string", Signature.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Signature.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Signature` properties.", entry.getKey()));
        }
      }
      // validate the optional field deviceName
      if (jsonObj.get("deviceName") != null && !jsonObj.get("deviceName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `deviceName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("deviceName").toString()));
      }
      // validate the optional field deviceSlogan
      if (jsonObj.get("deviceSlogan") != null && !jsonObj.get("deviceSlogan").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `deviceSlogan` to be a primitive type in the JSON string but got `%s`", jsonObj.get("deviceSlogan").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Signature.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Signature' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Signature> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Signature.class));

       return (TypeAdapter<T>) new TypeAdapter<Signature>() {
           @Override
           public void write(JsonWriter out, Signature value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Signature read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Signature given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Signature
  * @throws IOException if the JSON string is invalid with respect to Signature
  */
  public static Signature fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Signature.class);
  }

 /**
  * Convert an instance of Signature to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

