/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.management.OrderItem;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * TerminalOrderRequest
 */

public class TerminalOrderRequest {
  public static final String SERIALIZED_NAME_BILLING_ENTITY_ID = "billingEntityId";
  @SerializedName(SERIALIZED_NAME_BILLING_ENTITY_ID)
  private String billingEntityId;

  public static final String SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE = "customerOrderReference";
  @SerializedName(SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE)
  private String customerOrderReference;

  public static final String SERIALIZED_NAME_ITEMS = "items";
  @SerializedName(SERIALIZED_NAME_ITEMS)
  private List<OrderItem> items = null;

  public static final String SERIALIZED_NAME_ORDER_TYPE = "orderType";
  @SerializedName(SERIALIZED_NAME_ORDER_TYPE)
  private String orderType;

  public static final String SERIALIZED_NAME_SHIPPING_LOCATION_ID = "shippingLocationId";
  @SerializedName(SERIALIZED_NAME_SHIPPING_LOCATION_ID)
  private String shippingLocationId;

  public static final String SERIALIZED_NAME_TAX_ID = "taxId";
  @SerializedName(SERIALIZED_NAME_TAX_ID)
  private String taxId;

  public TerminalOrderRequest() { 
  }

  public TerminalOrderRequest billingEntityId(String billingEntityId) {
    
    this.billingEntityId = billingEntityId;
    return this;
  }

   /**
   * The identification of the billing entity to use for the order.
   * @return billingEntityId
  **/
  @ApiModelProperty(value = "The identification of the billing entity to use for the order.")

  public String getBillingEntityId() {
    return billingEntityId;
  }


  public void setBillingEntityId(String billingEntityId) {
    this.billingEntityId = billingEntityId;
  }


  public TerminalOrderRequest customerOrderReference(String customerOrderReference) {
    
    this.customerOrderReference = customerOrderReference;
    return this;
  }

   /**
   * The merchant-defined purchase order reference.
   * @return customerOrderReference
  **/
  @ApiModelProperty(value = "The merchant-defined purchase order reference.")

  public String getCustomerOrderReference() {
    return customerOrderReference;
  }


  public void setCustomerOrderReference(String customerOrderReference) {
    this.customerOrderReference = customerOrderReference;
  }


  public TerminalOrderRequest items(List<OrderItem> items) {
    
    this.items = items;
    return this;
  }

  public TerminalOrderRequest addItemsItem(OrderItem itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

   /**
   * The products included in the order.
   * @return items
  **/
  @ApiModelProperty(value = "The products included in the order.")

  public List<OrderItem> getItems() {
    return items;
  }


  public void setItems(List<OrderItem> items) {
    this.items = items;
  }


  public TerminalOrderRequest orderType(String orderType) {
    
    this.orderType = orderType;
    return this;
  }

   /**
   * Type of order
   * @return orderType
  **/
  @ApiModelProperty(value = "Type of order")

  public String getOrderType() {
    return orderType;
  }


  public void setOrderType(String orderType) {
    this.orderType = orderType;
  }


  public TerminalOrderRequest shippingLocationId(String shippingLocationId) {
    
    this.shippingLocationId = shippingLocationId;
    return this;
  }

   /**
   * The identification of the shipping location to use for the order.
   * @return shippingLocationId
  **/
  @ApiModelProperty(value = "The identification of the shipping location to use for the order.")

  public String getShippingLocationId() {
    return shippingLocationId;
  }


  public void setShippingLocationId(String shippingLocationId) {
    this.shippingLocationId = shippingLocationId;
  }


  public TerminalOrderRequest taxId(String taxId) {
    
    this.taxId = taxId;
    return this;
  }

   /**
   * The tax number of the billing entity.
   * @return taxId
  **/
  @ApiModelProperty(value = "The tax number of the billing entity.")

  public String getTaxId() {
    return taxId;
  }


  public void setTaxId(String taxId) {
    this.taxId = taxId;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalOrderRequest terminalOrderRequest = (TerminalOrderRequest) o;
    return Objects.equals(this.billingEntityId, terminalOrderRequest.billingEntityId) &&
        Objects.equals(this.customerOrderReference, terminalOrderRequest.customerOrderReference) &&
        Objects.equals(this.items, terminalOrderRequest.items) &&
        Objects.equals(this.orderType, terminalOrderRequest.orderType) &&
        Objects.equals(this.shippingLocationId, terminalOrderRequest.shippingLocationId) &&
        Objects.equals(this.taxId, terminalOrderRequest.taxId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billingEntityId, customerOrderReference, items, orderType, shippingLocationId, taxId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalOrderRequest {\n");
    sb.append("    billingEntityId: ").append(toIndentedString(billingEntityId)).append("\n");
    sb.append("    customerOrderReference: ").append(toIndentedString(customerOrderReference)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    orderType: ").append(toIndentedString(orderType)).append("\n");
    sb.append("    shippingLocationId: ").append(toIndentedString(shippingLocationId)).append("\n");
    sb.append("    taxId: ").append(toIndentedString(taxId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("billingEntityId");
    openapiFields.add("customerOrderReference");
    openapiFields.add("items");
    openapiFields.add("orderType");
    openapiFields.add("shippingLocationId");
    openapiFields.add("taxId");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(TerminalOrderRequest.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TerminalOrderRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TerminalOrderRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TerminalOrderRequest is not found in the empty JSON string", TerminalOrderRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!TerminalOrderRequest.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TerminalOrderRequest` properties.", entry.getKey()));
        }
      }
      // validate the optional field billingEntityId
      if (jsonObj.get("billingEntityId") != null && !jsonObj.get("billingEntityId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `billingEntityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("billingEntityId").toString()));
      }
      // validate the optional field customerOrderReference
      if (jsonObj.get("customerOrderReference") != null && !jsonObj.get("customerOrderReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `customerOrderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("customerOrderReference").toString()));
      }
      JsonArray jsonArrayitems = jsonObj.getAsJsonArray("items");
      if (jsonArrayitems != null) {
        // ensure the json data is an array
        if (!jsonObj.get("items").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get("items").toString()));
        }

        // validate the optional field `items` (array)
        for (int i = 0; i < jsonArrayitems.size(); i++) {
          OrderItem.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
        }
      }
      // validate the optional field orderType
      if (jsonObj.get("orderType") != null && !jsonObj.get("orderType").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `orderType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("orderType").toString()));
      }
      // validate the optional field shippingLocationId
      if (jsonObj.get("shippingLocationId") != null && !jsonObj.get("shippingLocationId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shippingLocationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shippingLocationId").toString()));
      }
      // validate the optional field taxId
      if (jsonObj.get("taxId") != null && !jsonObj.get("taxId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `taxId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("taxId").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TerminalOrderRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TerminalOrderRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TerminalOrderRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TerminalOrderRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<TerminalOrderRequest>() {
           @Override
           public void write(JsonWriter out, TerminalOrderRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TerminalOrderRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TerminalOrderRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TerminalOrderRequest
  * @throws IOException if the JSON string is invalid with respect to TerminalOrderRequest
  */
  public static TerminalOrderRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TerminalOrderRequest.class);
  }

 /**
  * Convert an instance of TerminalOrderRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

