/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.management.Profile;
import com.adyen.model.management.Settings;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * WifiProfiles
 */

public class WifiProfiles {
  public static final String SERIALIZED_NAME_PROFILES = "profiles";
  @SerializedName(SERIALIZED_NAME_PROFILES)
  private List<Profile> profiles = null;

  public static final String SERIALIZED_NAME_SETTINGS = "settings";
  @SerializedName(SERIALIZED_NAME_SETTINGS)
  private Settings settings;

  public WifiProfiles() { 
  }

  public WifiProfiles profiles(List<Profile> profiles) {
    
    this.profiles = profiles;
    return this;
  }

  public WifiProfiles addProfilesItem(Profile profilesItem) {
    if (this.profiles == null) {
      this.profiles = new ArrayList<>();
    }
    this.profiles.add(profilesItem);
    return this;
  }

   /**
   * List of remote Wi-Fi profiles.
   * @return profiles
  **/
  @ApiModelProperty(value = "List of remote Wi-Fi profiles.")

  public List<Profile> getProfiles() {
    return profiles;
  }


  public void setProfiles(List<Profile> profiles) {
    this.profiles = profiles;
  }


  public WifiProfiles settings(Settings settings) {
    
    this.settings = settings;
    return this;
  }

   /**
   * Get settings
   * @return settings
  **/
  @ApiModelProperty(value = "")

  public Settings getSettings() {
    return settings;
  }


  public void setSettings(Settings settings) {
    this.settings = settings;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WifiProfiles wifiProfiles = (WifiProfiles) o;
    return Objects.equals(this.profiles, wifiProfiles.profiles) &&
        Objects.equals(this.settings, wifiProfiles.settings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(profiles, settings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WifiProfiles {\n");
    sb.append("    profiles: ").append(toIndentedString(profiles)).append("\n");
    sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("profiles");
    openapiFields.add("settings");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(WifiProfiles.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WifiProfiles
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WifiProfiles.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WifiProfiles is not found in the empty JSON string", WifiProfiles.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!WifiProfiles.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `WifiProfiles` properties.", entry.getKey()));
        }
      }
      JsonArray jsonArrayprofiles = jsonObj.getAsJsonArray("profiles");
      if (jsonArrayprofiles != null) {
        // ensure the json data is an array
        if (!jsonObj.get("profiles").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `profiles` to be an array in the JSON string but got `%s`", jsonObj.get("profiles").toString()));
        }

        // validate the optional field `profiles` (array)
        for (int i = 0; i < jsonArrayprofiles.size(); i++) {
          Profile.validateJsonObject(jsonArrayprofiles.get(i).getAsJsonObject());
        }
      }
      // validate the optional field `settings`
      if (jsonObj.getAsJsonObject("settings") != null) {
        Settings.validateJsonObject(jsonObj.getAsJsonObject("settings"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WifiProfiles.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WifiProfiles' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WifiProfiles> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WifiProfiles.class));

       return (TypeAdapter<T>) new TypeAdapter<WifiProfiles>() {
           @Override
           public void write(JsonWriter out, WifiProfiles value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public WifiProfiles read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WifiProfiles given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WifiProfiles
  * @throws IOException if the JSON string is invalid with respect to WifiProfiles
  */
  public static WifiProfiles fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WifiProfiles.class);
  }

 /**
  * Convert an instance of WifiProfiles to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

