/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.payment.Amount;
import com.adyen.model.payment.PlatformChargebackLogic;
import com.adyen.model.payment.Split;
import com.adyen.model.payment.ThreeDSecureData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.payment.JSON;

/**
 * CaptureRequest
 */

public class CaptureRequest {
  public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
  @SerializedName(SERIALIZED_NAME_ADDITIONAL_DATA)
  private Map<String, String> additionalData = null;

  public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ACCOUNT)
  private String merchantAccount;

  public static final String SERIALIZED_NAME_MODIFICATION_AMOUNT = "modificationAmount";
  @SerializedName(SERIALIZED_NAME_MODIFICATION_AMOUNT)
  private Amount modificationAmount;

  public static final String SERIALIZED_NAME_MPI_DATA = "mpiData";
  @SerializedName(SERIALIZED_NAME_MPI_DATA)
  private ThreeDSecureData mpiData;

  public static final String SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE = "originalMerchantReference";
  @SerializedName(SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE)
  private String originalMerchantReference;

  public static final String SERIALIZED_NAME_ORIGINAL_REFERENCE = "originalReference";
  @SerializedName(SERIALIZED_NAME_ORIGINAL_REFERENCE)
  private String originalReference;

  public static final String SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
  @SerializedName(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC)
  private PlatformChargebackLogic platformChargebackLogic;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  public static final String SERIALIZED_NAME_SPLITS = "splits";
  @SerializedName(SERIALIZED_NAME_SPLITS)
  private List<Split> splits = null;

  public static final String SERIALIZED_NAME_TENDER_REFERENCE = "tenderReference";
  @SerializedName(SERIALIZED_NAME_TENDER_REFERENCE)
  private String tenderReference;

  public static final String SERIALIZED_NAME_UNIQUE_TERMINAL_ID = "uniqueTerminalId";
  @SerializedName(SERIALIZED_NAME_UNIQUE_TERMINAL_ID)
  private String uniqueTerminalId;

  public CaptureRequest() { 
  }

  public CaptureRequest additionalData(Map<String, String> additionalData) {
    
    this.additionalData = additionalData;
    return this;
  }

  public CaptureRequest putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

   /**
   * This field contains additional data, which may be required for a particular modification request.  The additionalData object consists of entries, each of which includes the key and value.
   * @return additionalData
  **/
  @ApiModelProperty(value = "This field contains additional data, which may be required for a particular modification request.  The additionalData object consists of entries, each of which includes the key and value.")

  public Map<String, String> getAdditionalData() {
    return additionalData;
  }


  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }


  public CaptureRequest merchantAccount(String merchantAccount) {
    
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account that is used to process the payment.
   * @return merchantAccount
  **/
  @ApiModelProperty(required = true, value = "The merchant account that is used to process the payment.")

  public String getMerchantAccount() {
    return merchantAccount;
  }


  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public CaptureRequest modificationAmount(Amount modificationAmount) {
    
    this.modificationAmount = modificationAmount;
    return this;
  }

   /**
   * Get modificationAmount
   * @return modificationAmount
  **/
  @ApiModelProperty(required = true, value = "")

  public Amount getModificationAmount() {
    return modificationAmount;
  }


  public void setModificationAmount(Amount modificationAmount) {
    this.modificationAmount = modificationAmount;
  }


  public CaptureRequest mpiData(ThreeDSecureData mpiData) {
    
    this.mpiData = mpiData;
    return this;
  }

   /**
   * Get mpiData
   * @return mpiData
  **/
  @ApiModelProperty(value = "")

  public ThreeDSecureData getMpiData() {
    return mpiData;
  }


  public void setMpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
  }


  public CaptureRequest originalMerchantReference(String originalMerchantReference) {
    
    this.originalMerchantReference = originalMerchantReference;
    return this;
  }

   /**
   * The original merchant reference to cancel.
   * @return originalMerchantReference
  **/
  @ApiModelProperty(value = "The original merchant reference to cancel.")

  public String getOriginalMerchantReference() {
    return originalMerchantReference;
  }


  public void setOriginalMerchantReference(String originalMerchantReference) {
    this.originalMerchantReference = originalMerchantReference;
  }


  public CaptureRequest originalReference(String originalReference) {
    
    this.originalReference = originalReference;
    return this;
  }

   /**
   * The original pspReference of the payment to modify. This reference is returned in: * authorisation response * authorisation notification  
   * @return originalReference
  **/
  @ApiModelProperty(required = true, value = "The original pspReference of the payment to modify. This reference is returned in: * authorisation response * authorisation notification  ")

  public String getOriginalReference() {
    return originalReference;
  }


  public void setOriginalReference(String originalReference) {
    this.originalReference = originalReference;
  }


  public CaptureRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    
    this.platformChargebackLogic = platformChargebackLogic;
    return this;
  }

   /**
   * Get platformChargebackLogic
   * @return platformChargebackLogic
  **/
  @ApiModelProperty(value = "")

  public PlatformChargebackLogic getPlatformChargebackLogic() {
    return platformChargebackLogic;
  }


  public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
  }


  public CaptureRequest reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.
   * @return reference
  **/
  @ApiModelProperty(value = "Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public CaptureRequest splits(List<Split> splits) {
    
    this.splits = splits;
    return this;
  }

  public CaptureRequest addSplitsItem(Split splitsItem) {
    if (this.splits == null) {
      this.splits = new ArrayList<>();
    }
    this.splits.add(splitsItem);
    return this;
  }

   /**
   * An array of objects specifying how the amount should be split between accounts when using Adyen for Platforms. For details, refer to [Providing split information](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information).
   * @return splits
  **/
  @ApiModelProperty(value = "An array of objects specifying how the amount should be split between accounts when using Adyen for Platforms. For details, refer to [Providing split information](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information).")

  public List<Split> getSplits() {
    return splits;
  }


  public void setSplits(List<Split> splits) {
    this.splits = splits;
  }


  public CaptureRequest tenderReference(String tenderReference) {
    
    this.tenderReference = tenderReference;
    return this;
  }

   /**
   * The transaction reference provided by the PED. For point-of-sale integrations only.
   * @return tenderReference
  **/
  @ApiModelProperty(value = "The transaction reference provided by the PED. For point-of-sale integrations only.")

  public String getTenderReference() {
    return tenderReference;
  }


  public void setTenderReference(String tenderReference) {
    this.tenderReference = tenderReference;
  }


  public CaptureRequest uniqueTerminalId(String uniqueTerminalId) {
    
    this.uniqueTerminalId = uniqueTerminalId;
    return this;
  }

   /**
   * Unique terminal ID for the PED that originally processed the request. For point-of-sale integrations only.
   * @return uniqueTerminalId
  **/
  @ApiModelProperty(value = "Unique terminal ID for the PED that originally processed the request. For point-of-sale integrations only.")

  public String getUniqueTerminalId() {
    return uniqueTerminalId;
  }


  public void setUniqueTerminalId(String uniqueTerminalId) {
    this.uniqueTerminalId = uniqueTerminalId;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CaptureRequest captureRequest = (CaptureRequest) o;
    return Objects.equals(this.additionalData, captureRequest.additionalData) &&
        Objects.equals(this.merchantAccount, captureRequest.merchantAccount) &&
        Objects.equals(this.modificationAmount, captureRequest.modificationAmount) &&
        Objects.equals(this.mpiData, captureRequest.mpiData) &&
        Objects.equals(this.originalMerchantReference, captureRequest.originalMerchantReference) &&
        Objects.equals(this.originalReference, captureRequest.originalReference) &&
        Objects.equals(this.platformChargebackLogic, captureRequest.platformChargebackLogic) &&
        Objects.equals(this.reference, captureRequest.reference) &&
        Objects.equals(this.splits, captureRequest.splits) &&
        Objects.equals(this.tenderReference, captureRequest.tenderReference) &&
        Objects.equals(this.uniqueTerminalId, captureRequest.uniqueTerminalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalData, merchantAccount, modificationAmount, mpiData, originalMerchantReference, originalReference, platformChargebackLogic, reference, splits, tenderReference, uniqueTerminalId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CaptureRequest {\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    modificationAmount: ").append(toIndentedString(modificationAmount)).append("\n");
    sb.append("    mpiData: ").append(toIndentedString(mpiData)).append("\n");
    sb.append("    originalMerchantReference: ").append(toIndentedString(originalMerchantReference)).append("\n");
    sb.append("    originalReference: ").append(toIndentedString(originalReference)).append("\n");
    sb.append("    platformChargebackLogic: ").append(toIndentedString(platformChargebackLogic)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    splits: ").append(toIndentedString(splits)).append("\n");
    sb.append("    tenderReference: ").append(toIndentedString(tenderReference)).append("\n");
    sb.append("    uniqueTerminalId: ").append(toIndentedString(uniqueTerminalId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("additionalData");
    openapiFields.add("merchantAccount");
    openapiFields.add("modificationAmount");
    openapiFields.add("mpiData");
    openapiFields.add("originalMerchantReference");
    openapiFields.add("originalReference");
    openapiFields.add("platformChargebackLogic");
    openapiFields.add("reference");
    openapiFields.add("splits");
    openapiFields.add("tenderReference");
    openapiFields.add("uniqueTerminalId");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("merchantAccount");
    openapiRequiredFields.add("modificationAmount");
    openapiRequiredFields.add("originalReference");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(CaptureRequest.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CaptureRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (CaptureRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in CaptureRequest is not found in the empty JSON string", CaptureRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!CaptureRequest.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CaptureRequest` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CaptureRequest.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field merchantAccount
      if (jsonObj.get("merchantAccount") != null && !jsonObj.get("merchantAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantAccount").toString()));
      }
      // validate the optional field `modificationAmount`
      if (jsonObj.getAsJsonObject("modificationAmount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("modificationAmount"));
      }
      // validate the optional field `mpiData`
      if (jsonObj.getAsJsonObject("mpiData") != null) {
        ThreeDSecureData.validateJsonObject(jsonObj.getAsJsonObject("mpiData"));
      }
      // validate the optional field originalMerchantReference
      if (jsonObj.get("originalMerchantReference") != null && !jsonObj.get("originalMerchantReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `originalMerchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("originalMerchantReference").toString()));
      }
      // validate the optional field originalReference
      if (jsonObj.get("originalReference") != null && !jsonObj.get("originalReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `originalReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("originalReference").toString()));
      }
      // validate the optional field `platformChargebackLogic`
      if (jsonObj.getAsJsonObject("platformChargebackLogic") != null) {
        PlatformChargebackLogic.validateJsonObject(jsonObj.getAsJsonObject("platformChargebackLogic"));
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      JsonArray jsonArraysplits = jsonObj.getAsJsonArray("splits");
      if (jsonArraysplits != null) {
        // ensure the json data is an array
        if (!jsonObj.get("splits").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `splits` to be an array in the JSON string but got `%s`", jsonObj.get("splits").toString()));
        }

        // validate the optional field `splits` (array)
        for (int i = 0; i < jsonArraysplits.size(); i++) {
          Split.validateJsonObject(jsonArraysplits.get(i).getAsJsonObject());
        }
      }
      // validate the optional field tenderReference
      if (jsonObj.get("tenderReference") != null && !jsonObj.get("tenderReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `tenderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("tenderReference").toString()));
      }
      // validate the optional field uniqueTerminalId
      if (jsonObj.get("uniqueTerminalId") != null && !jsonObj.get("uniqueTerminalId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `uniqueTerminalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("uniqueTerminalId").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CaptureRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CaptureRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CaptureRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CaptureRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<CaptureRequest>() {
           @Override
           public void write(JsonWriter out, CaptureRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CaptureRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CaptureRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CaptureRequest
  * @throws IOException if the JSON string is invalid with respect to CaptureRequest
  */
  public static CaptureRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CaptureRequest.class);
  }

 /**
  * Convert an instance of CaptureRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

