/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.payment.JSON;

/**
 * ResponseAdditionalDataCommon
 */

public class ResponseAdditionalDataCommon {
  public static final String SERIALIZED_NAME_ACQUIRER_ACCOUNT_CODE = "acquirerAccountCode";
  @SerializedName(SERIALIZED_NAME_ACQUIRER_ACCOUNT_CODE)
  private String acquirerAccountCode;

  public static final String SERIALIZED_NAME_ACQUIRER_CODE = "acquirerCode";
  @SerializedName(SERIALIZED_NAME_ACQUIRER_CODE)
  private String acquirerCode;

  public static final String SERIALIZED_NAME_ACQUIRER_REFERENCE = "acquirerReference";
  @SerializedName(SERIALIZED_NAME_ACQUIRER_REFERENCE)
  private String acquirerReference;

  public static final String SERIALIZED_NAME_ALIAS = "alias";
  @SerializedName(SERIALIZED_NAME_ALIAS)
  private String alias;

  public static final String SERIALIZED_NAME_ALIAS_TYPE = "aliasType";
  @SerializedName(SERIALIZED_NAME_ALIAS_TYPE)
  private String aliasType;

  public static final String SERIALIZED_NAME_AUTH_CODE = "authCode";
  @SerializedName(SERIALIZED_NAME_AUTH_CODE)
  private String authCode;

  public static final String SERIALIZED_NAME_AUTHORISATION_MID = "authorisationMid";
  @SerializedName(SERIALIZED_NAME_AUTHORISATION_MID)
  private String authorisationMid;

  public static final String SERIALIZED_NAME_AUTHORISED_AMOUNT_CURRENCY = "authorisedAmountCurrency";
  @SerializedName(SERIALIZED_NAME_AUTHORISED_AMOUNT_CURRENCY)
  private String authorisedAmountCurrency;

  public static final String SERIALIZED_NAME_AUTHORISED_AMOUNT_VALUE = "authorisedAmountValue";
  @SerializedName(SERIALIZED_NAME_AUTHORISED_AMOUNT_VALUE)
  private String authorisedAmountValue;

  public static final String SERIALIZED_NAME_AVS_RESULT = "avsResult";
  @SerializedName(SERIALIZED_NAME_AVS_RESULT)
  private String avsResult;

  public static final String SERIALIZED_NAME_AVS_RESULT_RAW = "avsResultRaw";
  @SerializedName(SERIALIZED_NAME_AVS_RESULT_RAW)
  private String avsResultRaw;

  public static final String SERIALIZED_NAME_BIC = "bic";
  @SerializedName(SERIALIZED_NAME_BIC)
  private String bic;

  public static final String SERIALIZED_NAME_CO_BRANDED_WITH = "coBrandedWith";
  @SerializedName(SERIALIZED_NAME_CO_BRANDED_WITH)
  private String coBrandedWith;

  public static final String SERIALIZED_NAME_CVC_RESULT = "cvcResult";
  @SerializedName(SERIALIZED_NAME_CVC_RESULT)
  private String cvcResult;

  public static final String SERIALIZED_NAME_CVC_RESULT_RAW = "cvcResultRaw";
  @SerializedName(SERIALIZED_NAME_CVC_RESULT_RAW)
  private String cvcResultRaw;

  public static final String SERIALIZED_NAME_DS_TRANS_I_D = "dsTransID";
  @SerializedName(SERIALIZED_NAME_DS_TRANS_I_D)
  private String dsTransID;

  public static final String SERIALIZED_NAME_ECI = "eci";
  @SerializedName(SERIALIZED_NAME_ECI)
  private String eci;

  public static final String SERIALIZED_NAME_EXPIRY_DATE = "expiryDate";
  @SerializedName(SERIALIZED_NAME_EXPIRY_DATE)
  private String expiryDate;

  public static final String SERIALIZED_NAME_EXTRA_COSTS_CURRENCY = "extraCostsCurrency";
  @SerializedName(SERIALIZED_NAME_EXTRA_COSTS_CURRENCY)
  private String extraCostsCurrency;

  public static final String SERIALIZED_NAME_EXTRA_COSTS_VALUE = "extraCostsValue";
  @SerializedName(SERIALIZED_NAME_EXTRA_COSTS_VALUE)
  private String extraCostsValue;

  public static final String SERIALIZED_NAME_FRAUD_CHECK_ITEM_NR_FRAUD_CHECKNAME = "fraudCheck-[itemNr]-[FraudCheckname]";
  @SerializedName(SERIALIZED_NAME_FRAUD_CHECK_ITEM_NR_FRAUD_CHECKNAME)
  private String fraudCheckItemNrFraudCheckname;

  public static final String SERIALIZED_NAME_FRAUD_MANUAL_REVIEW = "fraudManualReview";
  @SerializedName(SERIALIZED_NAME_FRAUD_MANUAL_REVIEW)
  private String fraudManualReview;

  /**
   * The fraud result properties of the payment.
   */
  @JsonAdapter(FraudResultTypeEnum.Adapter.class)
  public enum FraudResultTypeEnum {
    GREEN("GREEN"),
    
    FRAUD("FRAUD");

    private String value;

    FraudResultTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static FraudResultTypeEnum fromValue(String value) {
      for (FraudResultTypeEnum b : FraudResultTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<FraudResultTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FraudResultTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public FraudResultTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return FraudResultTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_FRAUD_RESULT_TYPE = "fraudResultType";
  @SerializedName(SERIALIZED_NAME_FRAUD_RESULT_TYPE)
  private FraudResultTypeEnum fraudResultType;

  public static final String SERIALIZED_NAME_FUNDING_SOURCE = "fundingSource";
  @SerializedName(SERIALIZED_NAME_FUNDING_SOURCE)
  private String fundingSource;

  public static final String SERIALIZED_NAME_FUNDS_AVAILABILITY = "fundsAvailability";
  @SerializedName(SERIALIZED_NAME_FUNDS_AVAILABILITY)
  private String fundsAvailability;

  public static final String SERIALIZED_NAME_INFERRED_REFUSAL_REASON = "inferredRefusalReason";
  @SerializedName(SERIALIZED_NAME_INFERRED_REFUSAL_REASON)
  private String inferredRefusalReason;

  public static final String SERIALIZED_NAME_IS_CARD_COMMERCIAL = "isCardCommercial";
  @SerializedName(SERIALIZED_NAME_IS_CARD_COMMERCIAL)
  private String isCardCommercial;

  public static final String SERIALIZED_NAME_ISSUER_COUNTRY = "issuerCountry";
  @SerializedName(SERIALIZED_NAME_ISSUER_COUNTRY)
  private String issuerCountry;

  public static final String SERIALIZED_NAME_LIABILITY_SHIFT = "liabilityShift";
  @SerializedName(SERIALIZED_NAME_LIABILITY_SHIFT)
  private String liabilityShift;

  public static final String SERIALIZED_NAME_MC_BANK_NET_REFERENCE_NUMBER = "mcBankNetReferenceNumber";
  @SerializedName(SERIALIZED_NAME_MC_BANK_NET_REFERENCE_NUMBER)
  private String mcBankNetReferenceNumber;

  public static final String SERIALIZED_NAME_MERCHANT_ADVICE_CODE = "merchantAdviceCode";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ADVICE_CODE)
  private String merchantAdviceCode;

  public static final String SERIALIZED_NAME_MERCHANT_REFERENCE = "merchantReference";
  @SerializedName(SERIALIZED_NAME_MERCHANT_REFERENCE)
  private String merchantReference;

  public static final String SERIALIZED_NAME_NETWORK_TX_REFERENCE = "networkTxReference";
  @SerializedName(SERIALIZED_NAME_NETWORK_TX_REFERENCE)
  private String networkTxReference;

  public static final String SERIALIZED_NAME_OWNER_NAME = "ownerName";
  @SerializedName(SERIALIZED_NAME_OWNER_NAME)
  private String ownerName;

  public static final String SERIALIZED_NAME_PAYMENT_ACCOUNT_REFERENCE = "paymentAccountReference";
  @SerializedName(SERIALIZED_NAME_PAYMENT_ACCOUNT_REFERENCE)
  private String paymentAccountReference;

  public static final String SERIALIZED_NAME_PAYMENT_METHOD = "paymentMethod";
  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD)
  private String paymentMethod;

  public static final String SERIALIZED_NAME_PAYMENT_METHOD_VARIANT = "paymentMethodVariant";
  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD_VARIANT)
  private String paymentMethodVariant;

  public static final String SERIALIZED_NAME_PAYOUT_ELIGIBLE = "payoutEligible";
  @SerializedName(SERIALIZED_NAME_PAYOUT_ELIGIBLE)
  private String payoutEligible;

  public static final String SERIALIZED_NAME_REALTIME_ACCOUNT_UPDATER_STATUS = "realtimeAccountUpdaterStatus";
  @SerializedName(SERIALIZED_NAME_REALTIME_ACCOUNT_UPDATER_STATUS)
  private String realtimeAccountUpdaterStatus;

  public static final String SERIALIZED_NAME_RECEIPT_FREE_TEXT = "receiptFreeText";
  @SerializedName(SERIALIZED_NAME_RECEIPT_FREE_TEXT)
  private String receiptFreeText;

  public static final String SERIALIZED_NAME_RECURRING_CONTRACT_TYPES = "recurring.contractTypes";
  @SerializedName(SERIALIZED_NAME_RECURRING_CONTRACT_TYPES)
  private String recurringContractTypes;

  public static final String SERIALIZED_NAME_RECURRING_FIRST_PSP_REFERENCE = "recurring.firstPspReference";
  @SerializedName(SERIALIZED_NAME_RECURRING_FIRST_PSP_REFERENCE)
  private String recurringFirstPspReference;

  public static final String SERIALIZED_NAME_RECURRING_RECURRING_DETAIL_REFERENCE = "recurring.recurringDetailReference";
  @SerializedName(SERIALIZED_NAME_RECURRING_RECURRING_DETAIL_REFERENCE)
  private String recurringRecurringDetailReference;

  public static final String SERIALIZED_NAME_RECURRING_SHOPPER_REFERENCE = "recurring.shopperReference";
  @SerializedName(SERIALIZED_NAME_RECURRING_SHOPPER_REFERENCE)
  private String recurringShopperReference;

  /**
   * The processing model used for the recurring transaction.
   */
  @JsonAdapter(RecurringProcessingModelEnum.Adapter.class)
  public enum RecurringProcessingModelEnum {
    CARDONFILE("CardOnFile"),
    
    SUBSCRIPTION("Subscription"),
    
    UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RecurringProcessingModelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RecurringProcessingModelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RecurringProcessingModelEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RecurringProcessingModelEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  @SerializedName(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL)
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String SERIALIZED_NAME_REFERRED = "referred";
  @SerializedName(SERIALIZED_NAME_REFERRED)
  private String referred;

  public static final String SERIALIZED_NAME_REFUSAL_REASON_RAW = "refusalReasonRaw";
  @SerializedName(SERIALIZED_NAME_REFUSAL_REASON_RAW)
  private String refusalReasonRaw;

  public static final String SERIALIZED_NAME_REQUEST_AMOUNT = "requestAmount";
  @SerializedName(SERIALIZED_NAME_REQUEST_AMOUNT)
  private String requestAmount;

  public static final String SERIALIZED_NAME_REQUEST_CURRENCY_CODE = "requestCurrencyCode";
  @SerializedName(SERIALIZED_NAME_REQUEST_CURRENCY_CODE)
  private String requestCurrencyCode;

  public static final String SERIALIZED_NAME_SHOPPER_INTERACTION = "shopperInteraction";
  @SerializedName(SERIALIZED_NAME_SHOPPER_INTERACTION)
  private String shopperInteraction;

  public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
  @SerializedName(SERIALIZED_NAME_SHOPPER_REFERENCE)
  private String shopperReference;

  public static final String SERIALIZED_NAME_TERMINAL_ID = "terminalId";
  @SerializedName(SERIALIZED_NAME_TERMINAL_ID)
  private String terminalId;

  public static final String SERIALIZED_NAME_THREE_D_AUTHENTICATED = "threeDAuthenticated";
  @SerializedName(SERIALIZED_NAME_THREE_D_AUTHENTICATED)
  private String threeDAuthenticated;

  public static final String SERIALIZED_NAME_THREE_D_AUTHENTICATED_RESPONSE = "threeDAuthenticatedResponse";
  @SerializedName(SERIALIZED_NAME_THREE_D_AUTHENTICATED_RESPONSE)
  private String threeDAuthenticatedResponse;

  public static final String SERIALIZED_NAME_THREE_D_OFFERED = "threeDOffered";
  @SerializedName(SERIALIZED_NAME_THREE_D_OFFERED)
  private String threeDOffered;

  public static final String SERIALIZED_NAME_THREE_D_OFFERED_RESPONSE = "threeDOfferedResponse";
  @SerializedName(SERIALIZED_NAME_THREE_D_OFFERED_RESPONSE)
  private String threeDOfferedResponse;

  public static final String SERIALIZED_NAME_THREE_D_S_VERSION = "threeDSVersion";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_VERSION)
  private String threeDSVersion;

  public static final String SERIALIZED_NAME_VISA_TRANSACTION_ID = "visaTransactionId";
  @SerializedName(SERIALIZED_NAME_VISA_TRANSACTION_ID)
  private String visaTransactionId;

  public static final String SERIALIZED_NAME_XID = "xid";
  @SerializedName(SERIALIZED_NAME_XID)
  private String xid;

  public ResponseAdditionalDataCommon() { 
  }

  public ResponseAdditionalDataCommon acquirerAccountCode(String acquirerAccountCode) {
    
    this.acquirerAccountCode = acquirerAccountCode;
    return this;
  }

   /**
   * The name of the Adyen acquirer account.  Example: PayPalSandbox_TestAcquirer  &gt; Only relevant for PayPal transactions.
   * @return acquirerAccountCode
  **/
  @ApiModelProperty(value = "The name of the Adyen acquirer account.  Example: PayPalSandbox_TestAcquirer  > Only relevant for PayPal transactions.")

  public String getAcquirerAccountCode() {
    return acquirerAccountCode;
  }


  public void setAcquirerAccountCode(String acquirerAccountCode) {
    this.acquirerAccountCode = acquirerAccountCode;
  }


  public ResponseAdditionalDataCommon acquirerCode(String acquirerCode) {
    
    this.acquirerCode = acquirerCode;
    return this;
  }

   /**
   * The name of the acquirer processing the payment request.  Example: TestPmmAcquirer
   * @return acquirerCode
  **/
  @ApiModelProperty(value = "The name of the acquirer processing the payment request.  Example: TestPmmAcquirer")

  public String getAcquirerCode() {
    return acquirerCode;
  }


  public void setAcquirerCode(String acquirerCode) {
    this.acquirerCode = acquirerCode;
  }


  public ResponseAdditionalDataCommon acquirerReference(String acquirerReference) {
    
    this.acquirerReference = acquirerReference;
    return this;
  }

   /**
   * The reference number that can be used for reconciliation in case a non-Adyen acquirer is used for settlement.  Example: 7C9N3FNBKT9
   * @return acquirerReference
  **/
  @ApiModelProperty(value = "The reference number that can be used for reconciliation in case a non-Adyen acquirer is used for settlement.  Example: 7C9N3FNBKT9")

  public String getAcquirerReference() {
    return acquirerReference;
  }


  public void setAcquirerReference(String acquirerReference) {
    this.acquirerReference = acquirerReference;
  }


  public ResponseAdditionalDataCommon alias(String alias) {
    
    this.alias = alias;
    return this;
  }

   /**
   * The Adyen alias of the card.  Example: H167852639363479
   * @return alias
  **/
  @ApiModelProperty(value = "The Adyen alias of the card.  Example: H167852639363479")

  public String getAlias() {
    return alias;
  }


  public void setAlias(String alias) {
    this.alias = alias;
  }


  public ResponseAdditionalDataCommon aliasType(String aliasType) {
    
    this.aliasType = aliasType;
    return this;
  }

   /**
   * The type of the card alias.  Example: Default
   * @return aliasType
  **/
  @ApiModelProperty(value = "The type of the card alias.  Example: Default")

  public String getAliasType() {
    return aliasType;
  }


  public void setAliasType(String aliasType) {
    this.aliasType = aliasType;
  }


  public ResponseAdditionalDataCommon authCode(String authCode) {
    
    this.authCode = authCode;
    return this;
  }

   /**
   * Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.  Example: 58747
   * @return authCode
  **/
  @ApiModelProperty(value = "Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.  Example: 58747")

  public String getAuthCode() {
    return authCode;
  }


  public void setAuthCode(String authCode) {
    this.authCode = authCode;
  }


  public ResponseAdditionalDataCommon authorisationMid(String authorisationMid) {
    
    this.authorisationMid = authorisationMid;
    return this;
  }

   /**
   * Merchant ID known by the acquirer.
   * @return authorisationMid
  **/
  @ApiModelProperty(value = "Merchant ID known by the acquirer.")

  public String getAuthorisationMid() {
    return authorisationMid;
  }


  public void setAuthorisationMid(String authorisationMid) {
    this.authorisationMid = authorisationMid;
  }


  public ResponseAdditionalDataCommon authorisedAmountCurrency(String authorisedAmountCurrency) {
    
    this.authorisedAmountCurrency = authorisedAmountCurrency;
    return this;
  }

   /**
   * The currency of the authorised amount, as a three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).
   * @return authorisedAmountCurrency
  **/
  @ApiModelProperty(value = "The currency of the authorised amount, as a three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).")

  public String getAuthorisedAmountCurrency() {
    return authorisedAmountCurrency;
  }


  public void setAuthorisedAmountCurrency(String authorisedAmountCurrency) {
    this.authorisedAmountCurrency = authorisedAmountCurrency;
  }


  public ResponseAdditionalDataCommon authorisedAmountValue(String authorisedAmountValue) {
    
    this.authorisedAmountValue = authorisedAmountValue;
    return this;
  }

   /**
   * Value of the amount authorised.  This amount is represented in minor units according to the [following table](https://docs.adyen.com/development-resources/currency-codes).
   * @return authorisedAmountValue
  **/
  @ApiModelProperty(value = "Value of the amount authorised.  This amount is represented in minor units according to the [following table](https://docs.adyen.com/development-resources/currency-codes).")

  public String getAuthorisedAmountValue() {
    return authorisedAmountValue;
  }


  public void setAuthorisedAmountValue(String authorisedAmountValue) {
    this.authorisedAmountValue = authorisedAmountValue;
  }


  public ResponseAdditionalDataCommon avsResult(String avsResult) {
    
    this.avsResult = avsResult;
    return this;
  }

   /**
   * The AVS result code of the payment, which provides information about the outcome of the AVS check.  For possible values, see [AVS](https://docs.adyen.com/risk-management/configure-standard-risk-rules/consistency-rules#billing-address-does-not-match-cardholder-address-avs).
   * @return avsResult
  **/
  @ApiModelProperty(value = "The AVS result code of the payment, which provides information about the outcome of the AVS check.  For possible values, see [AVS](https://docs.adyen.com/risk-management/configure-standard-risk-rules/consistency-rules#billing-address-does-not-match-cardholder-address-avs).")

  public String getAvsResult() {
    return avsResult;
  }


  public void setAvsResult(String avsResult) {
    this.avsResult = avsResult;
  }


  public ResponseAdditionalDataCommon avsResultRaw(String avsResultRaw) {
    
    this.avsResultRaw = avsResultRaw;
    return this;
  }

   /**
   * Raw AVS result received from the acquirer, where available.  Example: D
   * @return avsResultRaw
  **/
  @ApiModelProperty(value = "Raw AVS result received from the acquirer, where available.  Example: D")

  public String getAvsResultRaw() {
    return avsResultRaw;
  }


  public void setAvsResultRaw(String avsResultRaw) {
    this.avsResultRaw = avsResultRaw;
  }


  public ResponseAdditionalDataCommon bic(String bic) {
    
    this.bic = bic;
    return this;
  }

   /**
   * BIC of a bank account.  Example: TESTNL01  &gt; Only relevant for SEPA Direct Debit transactions.
   * @return bic
  **/
  @ApiModelProperty(value = "BIC of a bank account.  Example: TESTNL01  > Only relevant for SEPA Direct Debit transactions.")

  public String getBic() {
    return bic;
  }


  public void setBic(String bic) {
    this.bic = bic;
  }


  public ResponseAdditionalDataCommon coBrandedWith(String coBrandedWith) {
    
    this.coBrandedWith = coBrandedWith;
    return this;
  }

   /**
   * Includes the co-branded card information.
   * @return coBrandedWith
  **/
  @ApiModelProperty(value = "Includes the co-branded card information.")

  public String getCoBrandedWith() {
    return coBrandedWith;
  }


  public void setCoBrandedWith(String coBrandedWith) {
    this.coBrandedWith = coBrandedWith;
  }


  public ResponseAdditionalDataCommon cvcResult(String cvcResult) {
    
    this.cvcResult = cvcResult;
    return this;
  }

   /**
   * The result of CVC verification.
   * @return cvcResult
  **/
  @ApiModelProperty(example = "1 Matches", value = "The result of CVC verification.")

  public String getCvcResult() {
    return cvcResult;
  }


  public void setCvcResult(String cvcResult) {
    this.cvcResult = cvcResult;
  }


  public ResponseAdditionalDataCommon cvcResultRaw(String cvcResultRaw) {
    
    this.cvcResultRaw = cvcResultRaw;
    return this;
  }

   /**
   * The raw result of CVC verification.
   * @return cvcResultRaw
  **/
  @ApiModelProperty(example = "M", value = "The raw result of CVC verification.")

  public String getCvcResultRaw() {
    return cvcResultRaw;
  }


  public void setCvcResultRaw(String cvcResultRaw) {
    this.cvcResultRaw = cvcResultRaw;
  }


  public ResponseAdditionalDataCommon dsTransID(String dsTransID) {
    
    this.dsTransID = dsTransID;
    return this;
  }

   /**
   * Supported for 3D Secure 2. The unique transaction identifier assigned by the DS to identify a single transaction.
   * @return dsTransID
  **/
  @ApiModelProperty(value = "Supported for 3D Secure 2. The unique transaction identifier assigned by the DS to identify a single transaction.")

  public String getDsTransID() {
    return dsTransID;
  }


  public void setDsTransID(String dsTransID) {
    this.dsTransID = dsTransID;
  }


  public ResponseAdditionalDataCommon eci(String eci) {
    
    this.eci = eci;
    return this;
  }

   /**
   * The Electronic Commerce Indicator returned from the schemes for the 3DS payment session.  Example: 02
   * @return eci
  **/
  @ApiModelProperty(value = "The Electronic Commerce Indicator returned from the schemes for the 3DS payment session.  Example: 02")

  public String getEci() {
    return eci;
  }


  public void setEci(String eci) {
    this.eci = eci;
  }


  public ResponseAdditionalDataCommon expiryDate(String expiryDate) {
    
    this.expiryDate = expiryDate;
    return this;
  }

   /**
   * The expiry date on the card.  Example: 6/2016  &gt; Returned only in case of a card payment.
   * @return expiryDate
  **/
  @ApiModelProperty(value = "The expiry date on the card.  Example: 6/2016  > Returned only in case of a card payment.")

  public String getExpiryDate() {
    return expiryDate;
  }


  public void setExpiryDate(String expiryDate) {
    this.expiryDate = expiryDate;
  }


  public ResponseAdditionalDataCommon extraCostsCurrency(String extraCostsCurrency) {
    
    this.extraCostsCurrency = extraCostsCurrency;
    return this;
  }

   /**
   * The currency of the extra amount charged due to additional amounts set in the skin used in the HPP payment request.  Example: EUR
   * @return extraCostsCurrency
  **/
  @ApiModelProperty(value = "The currency of the extra amount charged due to additional amounts set in the skin used in the HPP payment request.  Example: EUR")

  public String getExtraCostsCurrency() {
    return extraCostsCurrency;
  }


  public void setExtraCostsCurrency(String extraCostsCurrency) {
    this.extraCostsCurrency = extraCostsCurrency;
  }


  public ResponseAdditionalDataCommon extraCostsValue(String extraCostsValue) {
    
    this.extraCostsValue = extraCostsValue;
    return this;
  }

   /**
   * The value of the extra amount charged due to additional amounts set in the skin used in the HPP payment request. The amount is in minor units.
   * @return extraCostsValue
  **/
  @ApiModelProperty(value = "The value of the extra amount charged due to additional amounts set in the skin used in the HPP payment request. The amount is in minor units.")

  public String getExtraCostsValue() {
    return extraCostsValue;
  }


  public void setExtraCostsValue(String extraCostsValue) {
    this.extraCostsValue = extraCostsValue;
  }


  public ResponseAdditionalDataCommon fraudCheckItemNrFraudCheckname(String fraudCheckItemNrFraudCheckname) {
    
    this.fraudCheckItemNrFraudCheckname = fraudCheckItemNrFraudCheckname;
    return this;
  }

   /**
   * The fraud score due to a particular fraud check. The fraud check name is found in the key of the key-value pair.
   * @return fraudCheckItemNrFraudCheckname
  **/
  @ApiModelProperty(value = "The fraud score due to a particular fraud check. The fraud check name is found in the key of the key-value pair.")

  public String getFraudCheckItemNrFraudCheckname() {
    return fraudCheckItemNrFraudCheckname;
  }


  public void setFraudCheckItemNrFraudCheckname(String fraudCheckItemNrFraudCheckname) {
    this.fraudCheckItemNrFraudCheckname = fraudCheckItemNrFraudCheckname;
  }


  public ResponseAdditionalDataCommon fraudManualReview(String fraudManualReview) {
    
    this.fraudManualReview = fraudManualReview;
    return this;
  }

   /**
   * Indicates if the payment is sent to manual review.
   * @return fraudManualReview
  **/
  @ApiModelProperty(value = "Indicates if the payment is sent to manual review.")

  public String getFraudManualReview() {
    return fraudManualReview;
  }


  public void setFraudManualReview(String fraudManualReview) {
    this.fraudManualReview = fraudManualReview;
  }


  public ResponseAdditionalDataCommon fraudResultType(FraudResultTypeEnum fraudResultType) {
    
    this.fraudResultType = fraudResultType;
    return this;
  }

   /**
   * The fraud result properties of the payment.
   * @return fraudResultType
  **/
  @ApiModelProperty(value = "The fraud result properties of the payment.")

  public FraudResultTypeEnum getFraudResultType() {
    return fraudResultType;
  }


  public void setFraudResultType(FraudResultTypeEnum fraudResultType) {
    this.fraudResultType = fraudResultType;
  }


  public ResponseAdditionalDataCommon fundingSource(String fundingSource) {
    
    this.fundingSource = fundingSource;
    return this;
  }

   /**
   * Information regarding the funding type of the card. The possible return values are: * CHARGE * CREDIT * DEBIT * PREPAID * PREPAID_RELOADABLE  * PREPAID_NONRELOADABLE * DEFFERED_DEBIT  &gt; This functionality requires additional configuration on Adyen&#39;s end. To enable it, contact the Support Team.  For receiving this field in the notification, enable **Include Funding Source** in **Notifications** &gt; **Additional settings**.
   * @return fundingSource
  **/
  @ApiModelProperty(value = "Information regarding the funding type of the card. The possible return values are: * CHARGE * CREDIT * DEBIT * PREPAID * PREPAID_RELOADABLE  * PREPAID_NONRELOADABLE * DEFFERED_DEBIT  > This functionality requires additional configuration on Adyen's end. To enable it, contact the Support Team.  For receiving this field in the notification, enable **Include Funding Source** in **Notifications** > **Additional settings**.")

  public String getFundingSource() {
    return fundingSource;
  }


  public void setFundingSource(String fundingSource) {
    this.fundingSource = fundingSource;
  }


  public ResponseAdditionalDataCommon fundsAvailability(String fundsAvailability) {
    
    this.fundsAvailability = fundsAvailability;
    return this;
  }

   /**
   * Indicates availability of funds.  Visa: * \&quot;I\&quot; (fast funds are supported) * \&quot;N\&quot; (otherwise)  Mastercard: * \&quot;I\&quot; (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \&quot;N\&quot; (otherwise)  &gt; Returned when you verify a card BIN or estimate costs, and only if payoutEligible is \&quot;Y\&quot; or \&quot;D\&quot;.
   * @return fundsAvailability
  **/
  @ApiModelProperty(value = "Indicates availability of funds.  Visa: * \"I\" (fast funds are supported) * \"N\" (otherwise)  Mastercard: * \"I\" (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \"N\" (otherwise)  > Returned when you verify a card BIN or estimate costs, and only if payoutEligible is \"Y\" or \"D\".")

  public String getFundsAvailability() {
    return fundsAvailability;
  }


  public void setFundsAvailability(String fundsAvailability) {
    this.fundsAvailability = fundsAvailability;
  }


  public ResponseAdditionalDataCommon inferredRefusalReason(String inferredRefusalReason) {
    
    this.inferredRefusalReason = inferredRefusalReason;
    return this;
  }

   /**
   * Provides the more granular indication of why a transaction was refused. When a transaction fails with either \&quot;Refused\&quot;, \&quot;Restricted Card\&quot;, \&quot;Transaction Not Permitted\&quot;, \&quot;Not supported\&quot; or \&quot;DeclinedNon Generic\&quot; refusalReason from the issuer, Adyen cross references its PSP-wide data for extra insight into the refusal reason. If an inferred refusal reason is available, the &#x60;inferredRefusalReason&#x60;, field is populated and the &#x60;refusalReason&#x60;, is set to \&quot;Not Supported\&quot;.  Possible values:  * 3D Secure Mandated * Closed Account * ContAuth Not Supported * CVC Mandated * Ecommerce Not Allowed * Crossborder Not Supported * Card Updated  * Low Authrate Bin * Non-reloadable prepaid card
   * @return inferredRefusalReason
  **/
  @ApiModelProperty(value = "Provides the more granular indication of why a transaction was refused. When a transaction fails with either \"Refused\", \"Restricted Card\", \"Transaction Not Permitted\", \"Not supported\" or \"DeclinedNon Generic\" refusalReason from the issuer, Adyen cross references its PSP-wide data for extra insight into the refusal reason. If an inferred refusal reason is available, the `inferredRefusalReason`, field is populated and the `refusalReason`, is set to \"Not Supported\".  Possible values:  * 3D Secure Mandated * Closed Account * ContAuth Not Supported * CVC Mandated * Ecommerce Not Allowed * Crossborder Not Supported * Card Updated  * Low Authrate Bin * Non-reloadable prepaid card")

  public String getInferredRefusalReason() {
    return inferredRefusalReason;
  }


  public void setInferredRefusalReason(String inferredRefusalReason) {
    this.inferredRefusalReason = inferredRefusalReason;
  }


  public ResponseAdditionalDataCommon isCardCommercial(String isCardCommercial) {
    
    this.isCardCommercial = isCardCommercial;
    return this;
  }

   /**
   * Indicates if the card is used for business purposes only.
   * @return isCardCommercial
  **/
  @ApiModelProperty(value = "Indicates if the card is used for business purposes only.")

  public String getIsCardCommercial() {
    return isCardCommercial;
  }


  public void setIsCardCommercial(String isCardCommercial) {
    this.isCardCommercial = isCardCommercial;
  }


  public ResponseAdditionalDataCommon issuerCountry(String issuerCountry) {
    
    this.issuerCountry = issuerCountry;
    return this;
  }

   /**
   * The issuing country of the card based on the BIN list that Adyen maintains.  Example: JP
   * @return issuerCountry
  **/
  @ApiModelProperty(value = "The issuing country of the card based on the BIN list that Adyen maintains.  Example: JP")

  public String getIssuerCountry() {
    return issuerCountry;
  }


  public void setIssuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
  }


  public ResponseAdditionalDataCommon liabilityShift(String liabilityShift) {
    
    this.liabilityShift = liabilityShift;
    return this;
  }

   /**
   * A Boolean value indicating whether a liability shift was offered for this payment.
   * @return liabilityShift
  **/
  @ApiModelProperty(value = "A Boolean value indicating whether a liability shift was offered for this payment.")

  public String getLiabilityShift() {
    return liabilityShift;
  }


  public void setLiabilityShift(String liabilityShift) {
    this.liabilityShift = liabilityShift;
  }


  public ResponseAdditionalDataCommon mcBankNetReferenceNumber(String mcBankNetReferenceNumber) {
    
    this.mcBankNetReferenceNumber = mcBankNetReferenceNumber;
    return this;
  }

   /**
   * The &#x60;mcBankNetReferenceNumber&#x60;, is a minimum of six characters and a maximum of nine characters long.  &gt; Contact Support Team to enable this field.
   * @return mcBankNetReferenceNumber
  **/
  @ApiModelProperty(value = "The `mcBankNetReferenceNumber`, is a minimum of six characters and a maximum of nine characters long.  > Contact Support Team to enable this field.")

  public String getMcBankNetReferenceNumber() {
    return mcBankNetReferenceNumber;
  }


  public void setMcBankNetReferenceNumber(String mcBankNetReferenceNumber) {
    this.mcBankNetReferenceNumber = mcBankNetReferenceNumber;
  }


  public ResponseAdditionalDataCommon merchantAdviceCode(String merchantAdviceCode) {
    
    this.merchantAdviceCode = merchantAdviceCode;
    return this;
  }

   /**
   * The Merchant Advice Code (MAC) can be returned by Mastercard issuers for refused payments. If present, the MAC contains information about why the payment failed, and whether it can be retried.  For more information see [Mastercard Merchant Advice Codes](https://docs.adyen.com/development-resources/raw-acquirer-responses#mastercard-merchant-advice-codes).
   * @return merchantAdviceCode
  **/
  @ApiModelProperty(value = "The Merchant Advice Code (MAC) can be returned by Mastercard issuers for refused payments. If present, the MAC contains information about why the payment failed, and whether it can be retried.  For more information see [Mastercard Merchant Advice Codes](https://docs.adyen.com/development-resources/raw-acquirer-responses#mastercard-merchant-advice-codes).")

  public String getMerchantAdviceCode() {
    return merchantAdviceCode;
  }


  public void setMerchantAdviceCode(String merchantAdviceCode) {
    this.merchantAdviceCode = merchantAdviceCode;
  }


  public ResponseAdditionalDataCommon merchantReference(String merchantReference) {
    
    this.merchantReference = merchantReference;
    return this;
  }

   /**
   * The reference provided for the transaction.
   * @return merchantReference
  **/
  @ApiModelProperty(value = "The reference provided for the transaction.")

  public String getMerchantReference() {
    return merchantReference;
  }


  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }


  public ResponseAdditionalDataCommon networkTxReference(String networkTxReference) {
    
    this.networkTxReference = networkTxReference;
    return this;
  }

   /**
   * Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.
   * @return networkTxReference
  **/
  @ApiModelProperty(value = "Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.")

  public String getNetworkTxReference() {
    return networkTxReference;
  }


  public void setNetworkTxReference(String networkTxReference) {
    this.networkTxReference = networkTxReference;
  }


  public ResponseAdditionalDataCommon ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * The owner name of a bank account.  Only relevant for SEPA Direct Debit transactions.
   * @return ownerName
  **/
  @ApiModelProperty(value = "The owner name of a bank account.  Only relevant for SEPA Direct Debit transactions.")

  public String getOwnerName() {
    return ownerName;
  }


  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public ResponseAdditionalDataCommon paymentAccountReference(String paymentAccountReference) {
    
    this.paymentAccountReference = paymentAccountReference;
    return this;
  }

   /**
   * The Payment Account Reference (PAR) value links a network token with the underlying primary account number (PAN). The PAR value consists of 29 uppercase alphanumeric characters.
   * @return paymentAccountReference
  **/
  @ApiModelProperty(value = "The Payment Account Reference (PAR) value links a network token with the underlying primary account number (PAN). The PAR value consists of 29 uppercase alphanumeric characters.")

  public String getPaymentAccountReference() {
    return paymentAccountReference;
  }


  public void setPaymentAccountReference(String paymentAccountReference) {
    this.paymentAccountReference = paymentAccountReference;
  }


  public ResponseAdditionalDataCommon paymentMethod(String paymentMethod) {
    
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * The payment method used in the transaction.
   * @return paymentMethod
  **/
  @ApiModelProperty(value = "The payment method used in the transaction.")

  public String getPaymentMethod() {
    return paymentMethod;
  }


  public void setPaymentMethod(String paymentMethod) {
    this.paymentMethod = paymentMethod;
  }


  public ResponseAdditionalDataCommon paymentMethodVariant(String paymentMethodVariant) {
    
    this.paymentMethodVariant = paymentMethodVariant;
    return this;
  }

   /**
   * The Adyen sub-variant of the payment method used for the payment request.  For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).  Example: mcpro
   * @return paymentMethodVariant
  **/
  @ApiModelProperty(value = "The Adyen sub-variant of the payment method used for the payment request.  For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).  Example: mcpro")

  public String getPaymentMethodVariant() {
    return paymentMethodVariant;
  }


  public void setPaymentMethodVariant(String paymentMethodVariant) {
    this.paymentMethodVariant = paymentMethodVariant;
  }


  public ResponseAdditionalDataCommon payoutEligible(String payoutEligible) {
    
    this.payoutEligible = payoutEligible;
    return this;
  }

   /**
   * Indicates whether a payout is eligible or not for this card.  Visa: * \&quot;Y\&quot; * \&quot;N\&quot;  Mastercard: * \&quot;Y\&quot; (domestic and cross-border)  * \&quot;D\&quot; (only domestic) * \&quot;N\&quot; (no MoneySend) * \&quot;U\&quot; (unknown)
   * @return payoutEligible
  **/
  @ApiModelProperty(value = "Indicates whether a payout is eligible or not for this card.  Visa: * \"Y\" * \"N\"  Mastercard: * \"Y\" (domestic and cross-border)  * \"D\" (only domestic) * \"N\" (no MoneySend) * \"U\" (unknown)")

  public String getPayoutEligible() {
    return payoutEligible;
  }


  public void setPayoutEligible(String payoutEligible) {
    this.payoutEligible = payoutEligible;
  }


  public ResponseAdditionalDataCommon realtimeAccountUpdaterStatus(String realtimeAccountUpdaterStatus) {
    
    this.realtimeAccountUpdaterStatus = realtimeAccountUpdaterStatus;
    return this;
  }

   /**
   * The response code from the Real Time Account Updater service.  Possible return values are: * CardChanged * CardExpiryChanged * CloseAccount  * ContactCardAccountHolder
   * @return realtimeAccountUpdaterStatus
  **/
  @ApiModelProperty(value = "The response code from the Real Time Account Updater service.  Possible return values are: * CardChanged * CardExpiryChanged * CloseAccount  * ContactCardAccountHolder")

  public String getRealtimeAccountUpdaterStatus() {
    return realtimeAccountUpdaterStatus;
  }


  public void setRealtimeAccountUpdaterStatus(String realtimeAccountUpdaterStatus) {
    this.realtimeAccountUpdaterStatus = realtimeAccountUpdaterStatus;
  }


  public ResponseAdditionalDataCommon receiptFreeText(String receiptFreeText) {
    
    this.receiptFreeText = receiptFreeText;
    return this;
  }

   /**
   * Message to be displayed on the terminal.
   * @return receiptFreeText
  **/
  @ApiModelProperty(value = "Message to be displayed on the terminal.")

  public String getReceiptFreeText() {
    return receiptFreeText;
  }


  public void setReceiptFreeText(String receiptFreeText) {
    this.receiptFreeText = receiptFreeText;
  }


  public ResponseAdditionalDataCommon recurringContractTypes(String recurringContractTypes) {
    
    this.recurringContractTypes = recurringContractTypes;
    return this;
  }

   /**
   * The recurring contract types applicable to the transaction.
   * @return recurringContractTypes
  **/
  @ApiModelProperty(value = "The recurring contract types applicable to the transaction.")

  public String getRecurringContractTypes() {
    return recurringContractTypes;
  }


  public void setRecurringContractTypes(String recurringContractTypes) {
    this.recurringContractTypes = recurringContractTypes;
  }


  public ResponseAdditionalDataCommon recurringFirstPspReference(String recurringFirstPspReference) {
    
    this.recurringFirstPspReference = recurringFirstPspReference;
    return this;
  }

   /**
   * The &#x60;pspReference&#x60;, of the first recurring payment that created the recurring detail.  This functionality requires additional configuration on Adyen&#39;s end. To enable it, contact the Support Team.
   * @return recurringFirstPspReference
  **/
  @ApiModelProperty(value = "The `pspReference`, of the first recurring payment that created the recurring detail.  This functionality requires additional configuration on Adyen's end. To enable it, contact the Support Team.")

  public String getRecurringFirstPspReference() {
    return recurringFirstPspReference;
  }


  public void setRecurringFirstPspReference(String recurringFirstPspReference) {
    this.recurringFirstPspReference = recurringFirstPspReference;
  }


  public ResponseAdditionalDataCommon recurringRecurringDetailReference(String recurringRecurringDetailReference) {
    
    this.recurringRecurringDetailReference = recurringRecurringDetailReference;
    return this;
  }

   /**
   * The reference that uniquely identifies the recurring transaction.
   * @return recurringRecurringDetailReference
  **/
  @ApiModelProperty(value = "The reference that uniquely identifies the recurring transaction.")

  public String getRecurringRecurringDetailReference() {
    return recurringRecurringDetailReference;
  }


  public void setRecurringRecurringDetailReference(String recurringRecurringDetailReference) {
    this.recurringRecurringDetailReference = recurringRecurringDetailReference;
  }


  public ResponseAdditionalDataCommon recurringShopperReference(String recurringShopperReference) {
    
    this.recurringShopperReference = recurringShopperReference;
    return this;
  }

   /**
   * The provided reference of the shopper for a recurring transaction.
   * @return recurringShopperReference
  **/
  @ApiModelProperty(value = "The provided reference of the shopper for a recurring transaction.")

  public String getRecurringShopperReference() {
    return recurringShopperReference;
  }


  public void setRecurringShopperReference(String recurringShopperReference) {
    this.recurringShopperReference = recurringShopperReference;
  }


  public ResponseAdditionalDataCommon recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

   /**
   * The processing model used for the recurring transaction.
   * @return recurringProcessingModel
  **/
  @ApiModelProperty(value = "The processing model used for the recurring transaction.")

  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }


  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }


  public ResponseAdditionalDataCommon referred(String referred) {
    
    this.referred = referred;
    return this;
  }

   /**
   * If the payment is referred, this field is set to true.  This field is unavailable if the payment is referred and is usually not returned with ecommerce transactions.  Example: true
   * @return referred
  **/
  @ApiModelProperty(value = "If the payment is referred, this field is set to true.  This field is unavailable if the payment is referred and is usually not returned with ecommerce transactions.  Example: true")

  public String getReferred() {
    return referred;
  }


  public void setReferred(String referred) {
    this.referred = referred;
  }


  public ResponseAdditionalDataCommon refusalReasonRaw(String refusalReasonRaw) {
    
    this.refusalReasonRaw = refusalReasonRaw;
    return this;
  }

   /**
   * Raw refusal reason received from the acquirer, where available.  Example: AUTHORISED
   * @return refusalReasonRaw
  **/
  @ApiModelProperty(value = "Raw refusal reason received from the acquirer, where available.  Example: AUTHORISED")

  public String getRefusalReasonRaw() {
    return refusalReasonRaw;
  }


  public void setRefusalReasonRaw(String refusalReasonRaw) {
    this.refusalReasonRaw = refusalReasonRaw;
  }


  public ResponseAdditionalDataCommon requestAmount(String requestAmount) {
    
    this.requestAmount = requestAmount;
    return this;
  }

   /**
   * The amount of the payment request.
   * @return requestAmount
  **/
  @ApiModelProperty(value = "The amount of the payment request.")

  public String getRequestAmount() {
    return requestAmount;
  }


  public void setRequestAmount(String requestAmount) {
    this.requestAmount = requestAmount;
  }


  public ResponseAdditionalDataCommon requestCurrencyCode(String requestCurrencyCode) {
    
    this.requestCurrencyCode = requestCurrencyCode;
    return this;
  }

   /**
   * The currency of the payment request.
   * @return requestCurrencyCode
  **/
  @ApiModelProperty(value = "The currency of the payment request.")

  public String getRequestCurrencyCode() {
    return requestCurrencyCode;
  }


  public void setRequestCurrencyCode(String requestCurrencyCode) {
    this.requestCurrencyCode = requestCurrencyCode;
  }


  public ResponseAdditionalDataCommon shopperInteraction(String shopperInteraction) {
    
    this.shopperInteraction = shopperInteraction;
    return this;
  }

   /**
   * The shopper interaction type of the payment request.  Example: Ecommerce
   * @return shopperInteraction
  **/
  @ApiModelProperty(value = "The shopper interaction type of the payment request.  Example: Ecommerce")

  public String getShopperInteraction() {
    return shopperInteraction;
  }


  public void setShopperInteraction(String shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }


  public ResponseAdditionalDataCommon shopperReference(String shopperReference) {
    
    this.shopperReference = shopperReference;
    return this;
  }

   /**
   * The shopperReference passed in the payment request.  Example: AdyenTestShopperXX
   * @return shopperReference
  **/
  @ApiModelProperty(value = "The shopperReference passed in the payment request.  Example: AdyenTestShopperXX")

  public String getShopperReference() {
    return shopperReference;
  }


  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }


  public ResponseAdditionalDataCommon terminalId(String terminalId) {
    
    this.terminalId = terminalId;
    return this;
  }

   /**
   * The terminal ID used in a point-of-sale payment.  Example: 06022622
   * @return terminalId
  **/
  @ApiModelProperty(value = "The terminal ID used in a point-of-sale payment.  Example: 06022622")

  public String getTerminalId() {
    return terminalId;
  }


  public void setTerminalId(String terminalId) {
    this.terminalId = terminalId;
  }


  public ResponseAdditionalDataCommon threeDAuthenticated(String threeDAuthenticated) {
    
    this.threeDAuthenticated = threeDAuthenticated;
    return this;
  }

   /**
   * A Boolean value indicating whether 3DS authentication was completed on this payment.  Example: true
   * @return threeDAuthenticated
  **/
  @ApiModelProperty(value = "A Boolean value indicating whether 3DS authentication was completed on this payment.  Example: true")

  public String getThreeDAuthenticated() {
    return threeDAuthenticated;
  }


  public void setThreeDAuthenticated(String threeDAuthenticated) {
    this.threeDAuthenticated = threeDAuthenticated;
  }


  public ResponseAdditionalDataCommon threeDAuthenticatedResponse(String threeDAuthenticatedResponse) {
    
    this.threeDAuthenticatedResponse = threeDAuthenticatedResponse;
    return this;
  }

   /**
   * The raw 3DS authentication result from the card issuer.  Example: N
   * @return threeDAuthenticatedResponse
  **/
  @ApiModelProperty(value = "The raw 3DS authentication result from the card issuer.  Example: N")

  public String getThreeDAuthenticatedResponse() {
    return threeDAuthenticatedResponse;
  }


  public void setThreeDAuthenticatedResponse(String threeDAuthenticatedResponse) {
    this.threeDAuthenticatedResponse = threeDAuthenticatedResponse;
  }


  public ResponseAdditionalDataCommon threeDOffered(String threeDOffered) {
    
    this.threeDOffered = threeDOffered;
    return this;
  }

   /**
   * A Boolean value indicating whether 3DS was offered for this payment.  Example: true
   * @return threeDOffered
  **/
  @ApiModelProperty(value = "A Boolean value indicating whether 3DS was offered for this payment.  Example: true")

  public String getThreeDOffered() {
    return threeDOffered;
  }


  public void setThreeDOffered(String threeDOffered) {
    this.threeDOffered = threeDOffered;
  }


  public ResponseAdditionalDataCommon threeDOfferedResponse(String threeDOfferedResponse) {
    
    this.threeDOfferedResponse = threeDOfferedResponse;
    return this;
  }

   /**
   * The raw enrollment result from the 3DS directory services of the card schemes.  Example: Y
   * @return threeDOfferedResponse
  **/
  @ApiModelProperty(value = "The raw enrollment result from the 3DS directory services of the card schemes.  Example: Y")

  public String getThreeDOfferedResponse() {
    return threeDOfferedResponse;
  }


  public void setThreeDOfferedResponse(String threeDOfferedResponse) {
    this.threeDOfferedResponse = threeDOfferedResponse;
  }


  public ResponseAdditionalDataCommon threeDSVersion(String threeDSVersion) {
    
    this.threeDSVersion = threeDSVersion;
    return this;
  }

   /**
   * The 3D Secure 2 version.
   * @return threeDSVersion
  **/
  @ApiModelProperty(value = "The 3D Secure 2 version.")

  public String getThreeDSVersion() {
    return threeDSVersion;
  }


  public void setThreeDSVersion(String threeDSVersion) {
    this.threeDSVersion = threeDSVersion;
  }


  public ResponseAdditionalDataCommon visaTransactionId(String visaTransactionId) {
    
    this.visaTransactionId = visaTransactionId;
    return this;
  }

   /**
   * The &#x60;visaTransactionId&#x60;, has a fixed length of 15 numeric characters.  &gt; Contact Support Team to enable this field.
   * @return visaTransactionId
  **/
  @ApiModelProperty(value = "The `visaTransactionId`, has a fixed length of 15 numeric characters.  > Contact Support Team to enable this field.")

  public String getVisaTransactionId() {
    return visaTransactionId;
  }


  public void setVisaTransactionId(String visaTransactionId) {
    this.visaTransactionId = visaTransactionId;
  }


  public ResponseAdditionalDataCommon xid(String xid) {
    
    this.xid = xid;
    return this;
  }

   /**
   * The 3DS transaction ID of the 3DS session sent in notifications. The value is Base64-encoded and is returned for transactions with directoryResponse &#39;N&#39; or &#39;Y&#39;. If you want to submit the xid in your 3D Secure 1 request, use the &#x60;mpiData.xid&#x60;, field.  Example: ODgxNDc2MDg2MDExODk5MAAAAAA&#x3D;
   * @return xid
  **/
  @ApiModelProperty(value = "The 3DS transaction ID of the 3DS session sent in notifications. The value is Base64-encoded and is returned for transactions with directoryResponse 'N' or 'Y'. If you want to submit the xid in your 3D Secure 1 request, use the `mpiData.xid`, field.  Example: ODgxNDc2MDg2MDExODk5MAAAAAA=")

  public String getXid() {
    return xid;
  }


  public void setXid(String xid) {
    this.xid = xid;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResponseAdditionalDataCommon responseAdditionalDataCommon = (ResponseAdditionalDataCommon) o;
    return Objects.equals(this.acquirerAccountCode, responseAdditionalDataCommon.acquirerAccountCode) &&
        Objects.equals(this.acquirerCode, responseAdditionalDataCommon.acquirerCode) &&
        Objects.equals(this.acquirerReference, responseAdditionalDataCommon.acquirerReference) &&
        Objects.equals(this.alias, responseAdditionalDataCommon.alias) &&
        Objects.equals(this.aliasType, responseAdditionalDataCommon.aliasType) &&
        Objects.equals(this.authCode, responseAdditionalDataCommon.authCode) &&
        Objects.equals(this.authorisationMid, responseAdditionalDataCommon.authorisationMid) &&
        Objects.equals(this.authorisedAmountCurrency, responseAdditionalDataCommon.authorisedAmountCurrency) &&
        Objects.equals(this.authorisedAmountValue, responseAdditionalDataCommon.authorisedAmountValue) &&
        Objects.equals(this.avsResult, responseAdditionalDataCommon.avsResult) &&
        Objects.equals(this.avsResultRaw, responseAdditionalDataCommon.avsResultRaw) &&
        Objects.equals(this.bic, responseAdditionalDataCommon.bic) &&
        Objects.equals(this.coBrandedWith, responseAdditionalDataCommon.coBrandedWith) &&
        Objects.equals(this.cvcResult, responseAdditionalDataCommon.cvcResult) &&
        Objects.equals(this.cvcResultRaw, responseAdditionalDataCommon.cvcResultRaw) &&
        Objects.equals(this.dsTransID, responseAdditionalDataCommon.dsTransID) &&
        Objects.equals(this.eci, responseAdditionalDataCommon.eci) &&
        Objects.equals(this.expiryDate, responseAdditionalDataCommon.expiryDate) &&
        Objects.equals(this.extraCostsCurrency, responseAdditionalDataCommon.extraCostsCurrency) &&
        Objects.equals(this.extraCostsValue, responseAdditionalDataCommon.extraCostsValue) &&
        Objects.equals(this.fraudCheckItemNrFraudCheckname, responseAdditionalDataCommon.fraudCheckItemNrFraudCheckname) &&
        Objects.equals(this.fraudManualReview, responseAdditionalDataCommon.fraudManualReview) &&
        Objects.equals(this.fraudResultType, responseAdditionalDataCommon.fraudResultType) &&
        Objects.equals(this.fundingSource, responseAdditionalDataCommon.fundingSource) &&
        Objects.equals(this.fundsAvailability, responseAdditionalDataCommon.fundsAvailability) &&
        Objects.equals(this.inferredRefusalReason, responseAdditionalDataCommon.inferredRefusalReason) &&
        Objects.equals(this.isCardCommercial, responseAdditionalDataCommon.isCardCommercial) &&
        Objects.equals(this.issuerCountry, responseAdditionalDataCommon.issuerCountry) &&
        Objects.equals(this.liabilityShift, responseAdditionalDataCommon.liabilityShift) &&
        Objects.equals(this.mcBankNetReferenceNumber, responseAdditionalDataCommon.mcBankNetReferenceNumber) &&
        Objects.equals(this.merchantAdviceCode, responseAdditionalDataCommon.merchantAdviceCode) &&
        Objects.equals(this.merchantReference, responseAdditionalDataCommon.merchantReference) &&
        Objects.equals(this.networkTxReference, responseAdditionalDataCommon.networkTxReference) &&
        Objects.equals(this.ownerName, responseAdditionalDataCommon.ownerName) &&
        Objects.equals(this.paymentAccountReference, responseAdditionalDataCommon.paymentAccountReference) &&
        Objects.equals(this.paymentMethod, responseAdditionalDataCommon.paymentMethod) &&
        Objects.equals(this.paymentMethodVariant, responseAdditionalDataCommon.paymentMethodVariant) &&
        Objects.equals(this.payoutEligible, responseAdditionalDataCommon.payoutEligible) &&
        Objects.equals(this.realtimeAccountUpdaterStatus, responseAdditionalDataCommon.realtimeAccountUpdaterStatus) &&
        Objects.equals(this.receiptFreeText, responseAdditionalDataCommon.receiptFreeText) &&
        Objects.equals(this.recurringContractTypes, responseAdditionalDataCommon.recurringContractTypes) &&
        Objects.equals(this.recurringFirstPspReference, responseAdditionalDataCommon.recurringFirstPspReference) &&
        Objects.equals(this.recurringRecurringDetailReference, responseAdditionalDataCommon.recurringRecurringDetailReference) &&
        Objects.equals(this.recurringShopperReference, responseAdditionalDataCommon.recurringShopperReference) &&
        Objects.equals(this.recurringProcessingModel, responseAdditionalDataCommon.recurringProcessingModel) &&
        Objects.equals(this.referred, responseAdditionalDataCommon.referred) &&
        Objects.equals(this.refusalReasonRaw, responseAdditionalDataCommon.refusalReasonRaw) &&
        Objects.equals(this.requestAmount, responseAdditionalDataCommon.requestAmount) &&
        Objects.equals(this.requestCurrencyCode, responseAdditionalDataCommon.requestCurrencyCode) &&
        Objects.equals(this.shopperInteraction, responseAdditionalDataCommon.shopperInteraction) &&
        Objects.equals(this.shopperReference, responseAdditionalDataCommon.shopperReference) &&
        Objects.equals(this.terminalId, responseAdditionalDataCommon.terminalId) &&
        Objects.equals(this.threeDAuthenticated, responseAdditionalDataCommon.threeDAuthenticated) &&
        Objects.equals(this.threeDAuthenticatedResponse, responseAdditionalDataCommon.threeDAuthenticatedResponse) &&
        Objects.equals(this.threeDOffered, responseAdditionalDataCommon.threeDOffered) &&
        Objects.equals(this.threeDOfferedResponse, responseAdditionalDataCommon.threeDOfferedResponse) &&
        Objects.equals(this.threeDSVersion, responseAdditionalDataCommon.threeDSVersion) &&
        Objects.equals(this.visaTransactionId, responseAdditionalDataCommon.visaTransactionId) &&
        Objects.equals(this.xid, responseAdditionalDataCommon.xid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerAccountCode, acquirerCode, acquirerReference, alias, aliasType, authCode, authorisationMid, authorisedAmountCurrency, authorisedAmountValue, avsResult, avsResultRaw, bic, coBrandedWith, cvcResult, cvcResultRaw, dsTransID, eci, expiryDate, extraCostsCurrency, extraCostsValue, fraudCheckItemNrFraudCheckname, fraudManualReview, fraudResultType, fundingSource, fundsAvailability, inferredRefusalReason, isCardCommercial, issuerCountry, liabilityShift, mcBankNetReferenceNumber, merchantAdviceCode, merchantReference, networkTxReference, ownerName, paymentAccountReference, paymentMethod, paymentMethodVariant, payoutEligible, realtimeAccountUpdaterStatus, receiptFreeText, recurringContractTypes, recurringFirstPspReference, recurringRecurringDetailReference, recurringShopperReference, recurringProcessingModel, referred, refusalReasonRaw, requestAmount, requestCurrencyCode, shopperInteraction, shopperReference, terminalId, threeDAuthenticated, threeDAuthenticatedResponse, threeDOffered, threeDOfferedResponse, threeDSVersion, visaTransactionId, xid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResponseAdditionalDataCommon {\n");
    sb.append("    acquirerAccountCode: ").append(toIndentedString(acquirerAccountCode)).append("\n");
    sb.append("    acquirerCode: ").append(toIndentedString(acquirerCode)).append("\n");
    sb.append("    acquirerReference: ").append(toIndentedString(acquirerReference)).append("\n");
    sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
    sb.append("    aliasType: ").append(toIndentedString(aliasType)).append("\n");
    sb.append("    authCode: ").append(toIndentedString(authCode)).append("\n");
    sb.append("    authorisationMid: ").append(toIndentedString(authorisationMid)).append("\n");
    sb.append("    authorisedAmountCurrency: ").append(toIndentedString(authorisedAmountCurrency)).append("\n");
    sb.append("    authorisedAmountValue: ").append(toIndentedString(authorisedAmountValue)).append("\n");
    sb.append("    avsResult: ").append(toIndentedString(avsResult)).append("\n");
    sb.append("    avsResultRaw: ").append(toIndentedString(avsResultRaw)).append("\n");
    sb.append("    bic: ").append(toIndentedString(bic)).append("\n");
    sb.append("    coBrandedWith: ").append(toIndentedString(coBrandedWith)).append("\n");
    sb.append("    cvcResult: ").append(toIndentedString(cvcResult)).append("\n");
    sb.append("    cvcResultRaw: ").append(toIndentedString(cvcResultRaw)).append("\n");
    sb.append("    dsTransID: ").append(toIndentedString(dsTransID)).append("\n");
    sb.append("    eci: ").append(toIndentedString(eci)).append("\n");
    sb.append("    expiryDate: ").append(toIndentedString(expiryDate)).append("\n");
    sb.append("    extraCostsCurrency: ").append(toIndentedString(extraCostsCurrency)).append("\n");
    sb.append("    extraCostsValue: ").append(toIndentedString(extraCostsValue)).append("\n");
    sb.append("    fraudCheckItemNrFraudCheckname: ").append(toIndentedString(fraudCheckItemNrFraudCheckname)).append("\n");
    sb.append("    fraudManualReview: ").append(toIndentedString(fraudManualReview)).append("\n");
    sb.append("    fraudResultType: ").append(toIndentedString(fraudResultType)).append("\n");
    sb.append("    fundingSource: ").append(toIndentedString(fundingSource)).append("\n");
    sb.append("    fundsAvailability: ").append(toIndentedString(fundsAvailability)).append("\n");
    sb.append("    inferredRefusalReason: ").append(toIndentedString(inferredRefusalReason)).append("\n");
    sb.append("    isCardCommercial: ").append(toIndentedString(isCardCommercial)).append("\n");
    sb.append("    issuerCountry: ").append(toIndentedString(issuerCountry)).append("\n");
    sb.append("    liabilityShift: ").append(toIndentedString(liabilityShift)).append("\n");
    sb.append("    mcBankNetReferenceNumber: ").append(toIndentedString(mcBankNetReferenceNumber)).append("\n");
    sb.append("    merchantAdviceCode: ").append(toIndentedString(merchantAdviceCode)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    networkTxReference: ").append(toIndentedString(networkTxReference)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    paymentAccountReference: ").append(toIndentedString(paymentAccountReference)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    paymentMethodVariant: ").append(toIndentedString(paymentMethodVariant)).append("\n");
    sb.append("    payoutEligible: ").append(toIndentedString(payoutEligible)).append("\n");
    sb.append("    realtimeAccountUpdaterStatus: ").append(toIndentedString(realtimeAccountUpdaterStatus)).append("\n");
    sb.append("    receiptFreeText: ").append(toIndentedString(receiptFreeText)).append("\n");
    sb.append("    recurringContractTypes: ").append(toIndentedString(recurringContractTypes)).append("\n");
    sb.append("    recurringFirstPspReference: ").append(toIndentedString(recurringFirstPspReference)).append("\n");
    sb.append("    recurringRecurringDetailReference: ").append(toIndentedString(recurringRecurringDetailReference)).append("\n");
    sb.append("    recurringShopperReference: ").append(toIndentedString(recurringShopperReference)).append("\n");
    sb.append("    recurringProcessingModel: ").append(toIndentedString(recurringProcessingModel)).append("\n");
    sb.append("    referred: ").append(toIndentedString(referred)).append("\n");
    sb.append("    refusalReasonRaw: ").append(toIndentedString(refusalReasonRaw)).append("\n");
    sb.append("    requestAmount: ").append(toIndentedString(requestAmount)).append("\n");
    sb.append("    requestCurrencyCode: ").append(toIndentedString(requestCurrencyCode)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    threeDAuthenticated: ").append(toIndentedString(threeDAuthenticated)).append("\n");
    sb.append("    threeDAuthenticatedResponse: ").append(toIndentedString(threeDAuthenticatedResponse)).append("\n");
    sb.append("    threeDOffered: ").append(toIndentedString(threeDOffered)).append("\n");
    sb.append("    threeDOfferedResponse: ").append(toIndentedString(threeDOfferedResponse)).append("\n");
    sb.append("    threeDSVersion: ").append(toIndentedString(threeDSVersion)).append("\n");
    sb.append("    visaTransactionId: ").append(toIndentedString(visaTransactionId)).append("\n");
    sb.append("    xid: ").append(toIndentedString(xid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("acquirerAccountCode");
    openapiFields.add("acquirerCode");
    openapiFields.add("acquirerReference");
    openapiFields.add("alias");
    openapiFields.add("aliasType");
    openapiFields.add("authCode");
    openapiFields.add("authorisationMid");
    openapiFields.add("authorisedAmountCurrency");
    openapiFields.add("authorisedAmountValue");
    openapiFields.add("avsResult");
    openapiFields.add("avsResultRaw");
    openapiFields.add("bic");
    openapiFields.add("coBrandedWith");
    openapiFields.add("cvcResult");
    openapiFields.add("cvcResultRaw");
    openapiFields.add("dsTransID");
    openapiFields.add("eci");
    openapiFields.add("expiryDate");
    openapiFields.add("extraCostsCurrency");
    openapiFields.add("extraCostsValue");
    openapiFields.add("fraudCheck-[itemNr]-[FraudCheckname]");
    openapiFields.add("fraudManualReview");
    openapiFields.add("fraudResultType");
    openapiFields.add("fundingSource");
    openapiFields.add("fundsAvailability");
    openapiFields.add("inferredRefusalReason");
    openapiFields.add("isCardCommercial");
    openapiFields.add("issuerCountry");
    openapiFields.add("liabilityShift");
    openapiFields.add("mcBankNetReferenceNumber");
    openapiFields.add("merchantAdviceCode");
    openapiFields.add("merchantReference");
    openapiFields.add("networkTxReference");
    openapiFields.add("ownerName");
    openapiFields.add("paymentAccountReference");
    openapiFields.add("paymentMethod");
    openapiFields.add("paymentMethodVariant");
    openapiFields.add("payoutEligible");
    openapiFields.add("realtimeAccountUpdaterStatus");
    openapiFields.add("receiptFreeText");
    openapiFields.add("recurring.contractTypes");
    openapiFields.add("recurring.firstPspReference");
    openapiFields.add("recurring.recurringDetailReference");
    openapiFields.add("recurring.shopperReference");
    openapiFields.add("recurringProcessingModel");
    openapiFields.add("referred");
    openapiFields.add("refusalReasonRaw");
    openapiFields.add("requestAmount");
    openapiFields.add("requestCurrencyCode");
    openapiFields.add("shopperInteraction");
    openapiFields.add("shopperReference");
    openapiFields.add("terminalId");
    openapiFields.add("threeDAuthenticated");
    openapiFields.add("threeDAuthenticatedResponse");
    openapiFields.add("threeDOffered");
    openapiFields.add("threeDOfferedResponse");
    openapiFields.add("threeDSVersion");
    openapiFields.add("visaTransactionId");
    openapiFields.add("xid");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(ResponseAdditionalDataCommon.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ResponseAdditionalDataCommon
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ResponseAdditionalDataCommon.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ResponseAdditionalDataCommon is not found in the empty JSON string", ResponseAdditionalDataCommon.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ResponseAdditionalDataCommon.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ResponseAdditionalDataCommon` properties.", entry.getKey()));
        }
      }
      // validate the optional field acquirerAccountCode
      if (jsonObj.get("acquirerAccountCode") != null && !jsonObj.get("acquirerAccountCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `acquirerAccountCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("acquirerAccountCode").toString()));
      }
      // validate the optional field acquirerCode
      if (jsonObj.get("acquirerCode") != null && !jsonObj.get("acquirerCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `acquirerCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("acquirerCode").toString()));
      }
      // validate the optional field acquirerReference
      if (jsonObj.get("acquirerReference") != null && !jsonObj.get("acquirerReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `acquirerReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("acquirerReference").toString()));
      }
      // validate the optional field alias
      if (jsonObj.get("alias") != null && !jsonObj.get("alias").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `alias` to be a primitive type in the JSON string but got `%s`", jsonObj.get("alias").toString()));
      }
      // validate the optional field aliasType
      if (jsonObj.get("aliasType") != null && !jsonObj.get("aliasType").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `aliasType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("aliasType").toString()));
      }
      // validate the optional field authCode
      if (jsonObj.get("authCode") != null && !jsonObj.get("authCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `authCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("authCode").toString()));
      }
      // validate the optional field authorisationMid
      if (jsonObj.get("authorisationMid") != null && !jsonObj.get("authorisationMid").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `authorisationMid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("authorisationMid").toString()));
      }
      // validate the optional field authorisedAmountCurrency
      if (jsonObj.get("authorisedAmountCurrency") != null && !jsonObj.get("authorisedAmountCurrency").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `authorisedAmountCurrency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("authorisedAmountCurrency").toString()));
      }
      // validate the optional field authorisedAmountValue
      if (jsonObj.get("authorisedAmountValue") != null && !jsonObj.get("authorisedAmountValue").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `authorisedAmountValue` to be a primitive type in the JSON string but got `%s`", jsonObj.get("authorisedAmountValue").toString()));
      }
      // validate the optional field avsResult
      if (jsonObj.get("avsResult") != null && !jsonObj.get("avsResult").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `avsResult` to be a primitive type in the JSON string but got `%s`", jsonObj.get("avsResult").toString()));
      }
      // validate the optional field avsResultRaw
      if (jsonObj.get("avsResultRaw") != null && !jsonObj.get("avsResultRaw").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `avsResultRaw` to be a primitive type in the JSON string but got `%s`", jsonObj.get("avsResultRaw").toString()));
      }
      // validate the optional field bic
      if (jsonObj.get("bic") != null && !jsonObj.get("bic").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `bic` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bic").toString()));
      }
      // validate the optional field coBrandedWith
      if (jsonObj.get("coBrandedWith") != null && !jsonObj.get("coBrandedWith").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `coBrandedWith` to be a primitive type in the JSON string but got `%s`", jsonObj.get("coBrandedWith").toString()));
      }
      // validate the optional field cvcResult
      if (jsonObj.get("cvcResult") != null && !jsonObj.get("cvcResult").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `cvcResult` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cvcResult").toString()));
      }
      // validate the optional field cvcResultRaw
      if (jsonObj.get("cvcResultRaw") != null && !jsonObj.get("cvcResultRaw").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `cvcResultRaw` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cvcResultRaw").toString()));
      }
      // validate the optional field dsTransID
      if (jsonObj.get("dsTransID") != null && !jsonObj.get("dsTransID").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `dsTransID` to be a primitive type in the JSON string but got `%s`", jsonObj.get("dsTransID").toString()));
      }
      // validate the optional field eci
      if (jsonObj.get("eci") != null && !jsonObj.get("eci").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `eci` to be a primitive type in the JSON string but got `%s`", jsonObj.get("eci").toString()));
      }
      // validate the optional field expiryDate
      if (jsonObj.get("expiryDate") != null && !jsonObj.get("expiryDate").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `expiryDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("expiryDate").toString()));
      }
      // validate the optional field extraCostsCurrency
      if (jsonObj.get("extraCostsCurrency") != null && !jsonObj.get("extraCostsCurrency").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `extraCostsCurrency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("extraCostsCurrency").toString()));
      }
      // validate the optional field extraCostsValue
      if (jsonObj.get("extraCostsValue") != null && !jsonObj.get("extraCostsValue").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `extraCostsValue` to be a primitive type in the JSON string but got `%s`", jsonObj.get("extraCostsValue").toString()));
      }
      // validate the optional field fraudCheck-[itemNr]-[FraudCheckname]
      if (jsonObj.get("fraudCheck-[itemNr]-[FraudCheckname]") != null && !jsonObj.get("fraudCheck-[itemNr]-[FraudCheckname]").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `fraudCheck-[itemNr]-[FraudCheckname]` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fraudCheck-[itemNr]-[FraudCheckname]").toString()));
      }
      // validate the optional field fraudManualReview
      if (jsonObj.get("fraudManualReview") != null && !jsonObj.get("fraudManualReview").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `fraudManualReview` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fraudManualReview").toString()));
      }
      // ensure the field fraudResultType can be parsed to an enum value
      if (jsonObj.get("fraudResultType") != null) {
        if(!jsonObj.get("fraudResultType").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `fraudResultType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fraudResultType").toString()));
        }
        FraudResultTypeEnum.fromValue(jsonObj.get("fraudResultType").getAsString());
      }
      // validate the optional field fundingSource
      if (jsonObj.get("fundingSource") != null && !jsonObj.get("fundingSource").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `fundingSource` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fundingSource").toString()));
      }
      // validate the optional field fundsAvailability
      if (jsonObj.get("fundsAvailability") != null && !jsonObj.get("fundsAvailability").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `fundsAvailability` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fundsAvailability").toString()));
      }
      // validate the optional field inferredRefusalReason
      if (jsonObj.get("inferredRefusalReason") != null && !jsonObj.get("inferredRefusalReason").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `inferredRefusalReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("inferredRefusalReason").toString()));
      }
      // validate the optional field isCardCommercial
      if (jsonObj.get("isCardCommercial") != null && !jsonObj.get("isCardCommercial").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `isCardCommercial` to be a primitive type in the JSON string but got `%s`", jsonObj.get("isCardCommercial").toString()));
      }
      // validate the optional field issuerCountry
      if (jsonObj.get("issuerCountry") != null && !jsonObj.get("issuerCountry").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `issuerCountry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issuerCountry").toString()));
      }
      // validate the optional field liabilityShift
      if (jsonObj.get("liabilityShift") != null && !jsonObj.get("liabilityShift").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `liabilityShift` to be a primitive type in the JSON string but got `%s`", jsonObj.get("liabilityShift").toString()));
      }
      // validate the optional field mcBankNetReferenceNumber
      if (jsonObj.get("mcBankNetReferenceNumber") != null && !jsonObj.get("mcBankNetReferenceNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `mcBankNetReferenceNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("mcBankNetReferenceNumber").toString()));
      }
      // validate the optional field merchantAdviceCode
      if (jsonObj.get("merchantAdviceCode") != null && !jsonObj.get("merchantAdviceCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantAdviceCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantAdviceCode").toString()));
      }
      // validate the optional field merchantReference
      if (jsonObj.get("merchantReference") != null && !jsonObj.get("merchantReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantReference").toString()));
      }
      // validate the optional field networkTxReference
      if (jsonObj.get("networkTxReference") != null && !jsonObj.get("networkTxReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `networkTxReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("networkTxReference").toString()));
      }
      // validate the optional field ownerName
      if (jsonObj.get("ownerName") != null && !jsonObj.get("ownerName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `ownerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ownerName").toString()));
      }
      // validate the optional field paymentAccountReference
      if (jsonObj.get("paymentAccountReference") != null && !jsonObj.get("paymentAccountReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentAccountReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentAccountReference").toString()));
      }
      // validate the optional field paymentMethod
      if (jsonObj.get("paymentMethod") != null && !jsonObj.get("paymentMethod").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentMethod").toString()));
      }
      // validate the optional field paymentMethodVariant
      if (jsonObj.get("paymentMethodVariant") != null && !jsonObj.get("paymentMethodVariant").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentMethodVariant` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentMethodVariant").toString()));
      }
      // validate the optional field payoutEligible
      if (jsonObj.get("payoutEligible") != null && !jsonObj.get("payoutEligible").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `payoutEligible` to be a primitive type in the JSON string but got `%s`", jsonObj.get("payoutEligible").toString()));
      }
      // validate the optional field realtimeAccountUpdaterStatus
      if (jsonObj.get("realtimeAccountUpdaterStatus") != null && !jsonObj.get("realtimeAccountUpdaterStatus").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `realtimeAccountUpdaterStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get("realtimeAccountUpdaterStatus").toString()));
      }
      // validate the optional field receiptFreeText
      if (jsonObj.get("receiptFreeText") != null && !jsonObj.get("receiptFreeText").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `receiptFreeText` to be a primitive type in the JSON string but got `%s`", jsonObj.get("receiptFreeText").toString()));
      }
      // validate the optional field recurring.contractTypes
      if (jsonObj.get("recurring.contractTypes") != null && !jsonObj.get("recurring.contractTypes").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurring.contractTypes` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurring.contractTypes").toString()));
      }
      // validate the optional field recurring.firstPspReference
      if (jsonObj.get("recurring.firstPspReference") != null && !jsonObj.get("recurring.firstPspReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurring.firstPspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurring.firstPspReference").toString()));
      }
      // validate the optional field recurring.recurringDetailReference
      if (jsonObj.get("recurring.recurringDetailReference") != null && !jsonObj.get("recurring.recurringDetailReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurring.recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurring.recurringDetailReference").toString()));
      }
      // validate the optional field recurring.shopperReference
      if (jsonObj.get("recurring.shopperReference") != null && !jsonObj.get("recurring.shopperReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurring.shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurring.shopperReference").toString()));
      }
      // ensure the field recurringProcessingModel can be parsed to an enum value
      if (jsonObj.get("recurringProcessingModel") != null) {
        if(!jsonObj.get("recurringProcessingModel").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `recurringProcessingModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurringProcessingModel").toString()));
        }
        RecurringProcessingModelEnum.fromValue(jsonObj.get("recurringProcessingModel").getAsString());
      }
      // validate the optional field referred
      if (jsonObj.get("referred") != null && !jsonObj.get("referred").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `referred` to be a primitive type in the JSON string but got `%s`", jsonObj.get("referred").toString()));
      }
      // validate the optional field refusalReasonRaw
      if (jsonObj.get("refusalReasonRaw") != null && !jsonObj.get("refusalReasonRaw").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `refusalReasonRaw` to be a primitive type in the JSON string but got `%s`", jsonObj.get("refusalReasonRaw").toString()));
      }
      // validate the optional field requestAmount
      if (jsonObj.get("requestAmount") != null && !jsonObj.get("requestAmount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `requestAmount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("requestAmount").toString()));
      }
      // validate the optional field requestCurrencyCode
      if (jsonObj.get("requestCurrencyCode") != null && !jsonObj.get("requestCurrencyCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `requestCurrencyCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("requestCurrencyCode").toString()));
      }
      // validate the optional field shopperInteraction
      if (jsonObj.get("shopperInteraction") != null && !jsonObj.get("shopperInteraction").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperInteraction` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperInteraction").toString()));
      }
      // validate the optional field shopperReference
      if (jsonObj.get("shopperReference") != null && !jsonObj.get("shopperReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperReference").toString()));
      }
      // validate the optional field terminalId
      if (jsonObj.get("terminalId") != null && !jsonObj.get("terminalId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `terminalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("terminalId").toString()));
      }
      // validate the optional field threeDAuthenticated
      if (jsonObj.get("threeDAuthenticated") != null && !jsonObj.get("threeDAuthenticated").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDAuthenticated` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDAuthenticated").toString()));
      }
      // validate the optional field threeDAuthenticatedResponse
      if (jsonObj.get("threeDAuthenticatedResponse") != null && !jsonObj.get("threeDAuthenticatedResponse").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDAuthenticatedResponse` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDAuthenticatedResponse").toString()));
      }
      // validate the optional field threeDOffered
      if (jsonObj.get("threeDOffered") != null && !jsonObj.get("threeDOffered").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDOffered` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDOffered").toString()));
      }
      // validate the optional field threeDOfferedResponse
      if (jsonObj.get("threeDOfferedResponse") != null && !jsonObj.get("threeDOfferedResponse").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDOfferedResponse` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDOfferedResponse").toString()));
      }
      // validate the optional field threeDSVersion
      if (jsonObj.get("threeDSVersion") != null && !jsonObj.get("threeDSVersion").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDSVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDSVersion").toString()));
      }
      // validate the optional field visaTransactionId
      if (jsonObj.get("visaTransactionId") != null && !jsonObj.get("visaTransactionId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `visaTransactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("visaTransactionId").toString()));
      }
      // validate the optional field xid
      if (jsonObj.get("xid") != null && !jsonObj.get("xid").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `xid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("xid").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ResponseAdditionalDataCommon.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ResponseAdditionalDataCommon' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ResponseAdditionalDataCommon> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ResponseAdditionalDataCommon.class));

       return (TypeAdapter<T>) new TypeAdapter<ResponseAdditionalDataCommon>() {
           @Override
           public void write(JsonWriter out, ResponseAdditionalDataCommon value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ResponseAdditionalDataCommon read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ResponseAdditionalDataCommon given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ResponseAdditionalDataCommon
  * @throws IOException if the JSON string is invalid with respect to ResponseAdditionalDataCommon
  */
  public static ResponseAdditionalDataCommon fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ResponseAdditionalDataCommon.class);
  }

 /**
  * Convert an instance of ResponseAdditionalDataCommon to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

