/*
 * Adyen Recurring API
 * The Recurring APIs allow you to manage and remove your tokens or saved payment details. Tokens should be created with validation during a payment request.  For more information, refer to our [Tokenization documentation](https://docs.adyen.com/online-payments/tokenization). ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Recurring API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Recurring/v68/disable ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Recurring/v68/disable ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.recurring;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.recurring.JSON;

/**
 * NotifyShopperResult
 */

public class NotifyShopperResult {
  public static final String SERIALIZED_NAME_DISPLAYED_REFERENCE = "displayedReference";
  @SerializedName(SERIALIZED_NAME_DISPLAYED_REFERENCE)
  private String displayedReference;

  public static final String SERIALIZED_NAME_MESSAGE = "message";
  @SerializedName(SERIALIZED_NAME_MESSAGE)
  private String message;

  public static final String SERIALIZED_NAME_PSP_REFERENCE = "pspReference";
  @SerializedName(SERIALIZED_NAME_PSP_REFERENCE)
  private String pspReference;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  public static final String SERIALIZED_NAME_RESULT_CODE = "resultCode";
  @SerializedName(SERIALIZED_NAME_RESULT_CODE)
  private String resultCode;

  public static final String SERIALIZED_NAME_SHOPPER_NOTIFICATION_REFERENCE = "shopperNotificationReference";
  @SerializedName(SERIALIZED_NAME_SHOPPER_NOTIFICATION_REFERENCE)
  private String shopperNotificationReference;

  public static final String SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
  @SerializedName(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID)
  private String storedPaymentMethodId;

  public NotifyShopperResult() { 
  }

  public NotifyShopperResult displayedReference(String displayedReference) {
    
    this.displayedReference = displayedReference;
    return this;
  }

   /**
   * Reference of Pre-debit notification that is displayed to the shopper
   * @return displayedReference
  **/
  @ApiModelProperty(value = "Reference of Pre-debit notification that is displayed to the shopper")

  public String getDisplayedReference() {
    return displayedReference;
  }


  public void setDisplayedReference(String displayedReference) {
    this.displayedReference = displayedReference;
  }


  public NotifyShopperResult message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * A simple description of the &#x60;resultCode&#x60;.
   * @return message
  **/
  @ApiModelProperty(value = "A simple description of the `resultCode`.")

  public String getMessage() {
    return message;
  }


  public void setMessage(String message) {
    this.message = message;
  }


  public NotifyShopperResult pspReference(String pspReference) {
    
    this.pspReference = pspReference;
    return this;
  }

   /**
   * The unique reference that is associated with the request.
   * @return pspReference
  **/
  @ApiModelProperty(value = "The unique reference that is associated with the request.")

  public String getPspReference() {
    return pspReference;
  }


  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }


  public NotifyShopperResult reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * Reference of Pre-debit notification sent in my the merchant
   * @return reference
  **/
  @ApiModelProperty(value = "Reference of Pre-debit notification sent in my the merchant")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public NotifyShopperResult resultCode(String resultCode) {
    
    this.resultCode = resultCode;
    return this;
  }

   /**
   * The code indicating the status of notification.
   * @return resultCode
  **/
  @ApiModelProperty(value = "The code indicating the status of notification.")

  public String getResultCode() {
    return resultCode;
  }


  public void setResultCode(String resultCode) {
    this.resultCode = resultCode;
  }


  public NotifyShopperResult shopperNotificationReference(String shopperNotificationReference) {
    
    this.shopperNotificationReference = shopperNotificationReference;
    return this;
  }

   /**
   * The unique reference for the request sent downstream.
   * @return shopperNotificationReference
  **/
  @ApiModelProperty(value = "The unique reference for the request sent downstream.")

  public String getShopperNotificationReference() {
    return shopperNotificationReference;
  }


  public void setShopperNotificationReference(String shopperNotificationReference) {
    this.shopperNotificationReference = shopperNotificationReference;
  }


  public NotifyShopperResult storedPaymentMethodId(String storedPaymentMethodId) {
    
    this.storedPaymentMethodId = storedPaymentMethodId;
    return this;
  }

   /**
   * This is the recurringDetailReference returned in the response when token was created
   * @return storedPaymentMethodId
  **/
  @ApiModelProperty(value = "This is the recurringDetailReference returned in the response when token was created")

  public String getStoredPaymentMethodId() {
    return storedPaymentMethodId;
  }


  public void setStoredPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NotifyShopperResult notifyShopperResult = (NotifyShopperResult) o;
    return Objects.equals(this.displayedReference, notifyShopperResult.displayedReference) &&
        Objects.equals(this.message, notifyShopperResult.message) &&
        Objects.equals(this.pspReference, notifyShopperResult.pspReference) &&
        Objects.equals(this.reference, notifyShopperResult.reference) &&
        Objects.equals(this.resultCode, notifyShopperResult.resultCode) &&
        Objects.equals(this.shopperNotificationReference, notifyShopperResult.shopperNotificationReference) &&
        Objects.equals(this.storedPaymentMethodId, notifyShopperResult.storedPaymentMethodId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(displayedReference, message, pspReference, reference, resultCode, shopperNotificationReference, storedPaymentMethodId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NotifyShopperResult {\n");
    sb.append("    displayedReference: ").append(toIndentedString(displayedReference)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("    shopperNotificationReference: ").append(toIndentedString(shopperNotificationReference)).append("\n");
    sb.append("    storedPaymentMethodId: ").append(toIndentedString(storedPaymentMethodId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("displayedReference");
    openapiFields.add("message");
    openapiFields.add("pspReference");
    openapiFields.add("reference");
    openapiFields.add("resultCode");
    openapiFields.add("shopperNotificationReference");
    openapiFields.add("storedPaymentMethodId");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(NotifyShopperResult.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to NotifyShopperResult
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (NotifyShopperResult.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in NotifyShopperResult is not found in the empty JSON string", NotifyShopperResult.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!NotifyShopperResult.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `NotifyShopperResult` properties.", entry.getKey()));
        }
      }
      // validate the optional field displayedReference
      if (jsonObj.get("displayedReference") != null && !jsonObj.get("displayedReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `displayedReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("displayedReference").toString()));
      }
      // validate the optional field message
      if (jsonObj.get("message") != null && !jsonObj.get("message").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get("message").toString()));
      }
      // validate the optional field pspReference
      if (jsonObj.get("pspReference") != null && !jsonObj.get("pspReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `pspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("pspReference").toString()));
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      // validate the optional field resultCode
      if (jsonObj.get("resultCode") != null && !jsonObj.get("resultCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `resultCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("resultCode").toString()));
      }
      // validate the optional field shopperNotificationReference
      if (jsonObj.get("shopperNotificationReference") != null && !jsonObj.get("shopperNotificationReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperNotificationReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperNotificationReference").toString()));
      }
      // validate the optional field storedPaymentMethodId
      if (jsonObj.get("storedPaymentMethodId") != null && !jsonObj.get("storedPaymentMethodId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `storedPaymentMethodId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("storedPaymentMethodId").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!NotifyShopperResult.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'NotifyShopperResult' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<NotifyShopperResult> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(NotifyShopperResult.class));

       return (TypeAdapter<T>) new TypeAdapter<NotifyShopperResult>() {
           @Override
           public void write(JsonWriter out, NotifyShopperResult value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public NotifyShopperResult read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of NotifyShopperResult given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of NotifyShopperResult
  * @throws IOException if the JSON string is invalid with respect to NotifyShopperResult
  */
  public static NotifyShopperResult fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, NotifyShopperResult.class);
  }

 /**
  * Convert an instance of NotifyShopperResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

