/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 3
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.transferwebhooks.NameLocation;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.transferwebhooks.JSON;

/**
 * MerchantData
 */

public class MerchantData {
  public static final String SERIALIZED_NAME_MCC = "mcc";
  @SerializedName(SERIALIZED_NAME_MCC)
  private String mcc;

  public static final String SERIALIZED_NAME_MERCHANT_ID = "merchantId";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ID)
  private String merchantId;

  public static final String SERIALIZED_NAME_NAME_LOCATION = "nameLocation";
  @SerializedName(SERIALIZED_NAME_NAME_LOCATION)
  private NameLocation nameLocation;

  public static final String SERIALIZED_NAME_POSTAL_CODE = "postalCode";
  @SerializedName(SERIALIZED_NAME_POSTAL_CODE)
  private String postalCode;

  public MerchantData() { 
  }

  public MerchantData mcc(String mcc) {
    
    this.mcc = mcc;
    return this;
  }

   /**
   * The merchant category code.
   * @return mcc
  **/
  @ApiModelProperty(value = "The merchant category code.")

  public String getMcc() {
    return mcc;
  }


  public void setMcc(String mcc) {
    this.mcc = mcc;
  }


  public MerchantData merchantId(String merchantId) {
    
    this.merchantId = merchantId;
    return this;
  }

   /**
   * The merchant identifier.
   * @return merchantId
  **/
  @ApiModelProperty(value = "The merchant identifier.")

  public String getMerchantId() {
    return merchantId;
  }


  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }


  public MerchantData nameLocation(NameLocation nameLocation) {
    
    this.nameLocation = nameLocation;
    return this;
  }

   /**
   * Get nameLocation
   * @return nameLocation
  **/
  @ApiModelProperty(value = "")

  public NameLocation getNameLocation() {
    return nameLocation;
  }


  public void setNameLocation(NameLocation nameLocation) {
    this.nameLocation = nameLocation;
  }


  public MerchantData postalCode(String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

   /**
   * The merchant postal code.
   * @return postalCode
  **/
  @ApiModelProperty(value = "The merchant postal code.")

  public String getPostalCode() {
    return postalCode;
  }


  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantData merchantData = (MerchantData) o;
    return Objects.equals(this.mcc, merchantData.mcc) &&
        Objects.equals(this.merchantId, merchantData.merchantId) &&
        Objects.equals(this.nameLocation, merchantData.nameLocation) &&
        Objects.equals(this.postalCode, merchantData.postalCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mcc, merchantId, nameLocation, postalCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantData {\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantId: ").append(toIndentedString(merchantId)).append("\n");
    sb.append("    nameLocation: ").append(toIndentedString(nameLocation)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("mcc");
    openapiFields.add("merchantId");
    openapiFields.add("nameLocation");
    openapiFields.add("postalCode");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(MerchantData.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to MerchantData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (MerchantData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in MerchantData is not found in the empty JSON string", MerchantData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!MerchantData.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `MerchantData` properties.", entry.getKey()));
        }
      }
      // validate the optional field mcc
      if (jsonObj.get("mcc") != null && !jsonObj.get("mcc").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("mcc").toString()));
      }
      // validate the optional field merchantId
      if (jsonObj.get("merchantId") != null && !jsonObj.get("merchantId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantId").toString()));
      }
      // validate the optional field `nameLocation`
      if (jsonObj.getAsJsonObject("nameLocation") != null) {
        NameLocation.validateJsonObject(jsonObj.getAsJsonObject("nameLocation"));
      }
      // validate the optional field postalCode
      if (jsonObj.get("postalCode") != null && !jsonObj.get("postalCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `postalCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("postalCode").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!MerchantData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'MerchantData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<MerchantData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(MerchantData.class));

       return (TypeAdapter<T>) new TypeAdapter<MerchantData>() {
           @Override
           public void write(JsonWriter out, MerchantData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public MerchantData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of MerchantData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of MerchantData
  * @throws IOException if the JSON string is invalid with respect to MerchantData
  */
  public static MerchantData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, MerchantData.class);
  }

 /**
  * Convert an instance of MerchantData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

